// Code generated from _gen/*Ops.go using 'go generate'; DO NOT EDIT.

package ssa

import (
	"cmd/internal/obj"
	"cmd/internal/obj/arm"
	"cmd/internal/obj/arm64"
	"cmd/internal/obj/loong64"
	"cmd/internal/obj/mips"
	"cmd/internal/obj/ppc64"
	"cmd/internal/obj/riscv"
	"cmd/internal/obj/s390x"
	"cmd/internal/obj/wasm"
	"cmd/internal/obj/x86"
)

const (
	BlockInvalid BlockKind = iota

	Block386EQ
	Block386NE
	Block386LT
	Block386LE
	Block386GT
	Block386GE
	Block386OS
	Block386OC
	Block386ULT
	Block386ULE
	Block386UGT
	Block386UGE
	Block386EQF
	Block386NEF
	Block386ORD
	Block386NAN

	BlockAMD64EQ
	BlockAMD64NE
	BlockAMD64LT
	BlockAMD64LE
	BlockAMD64GT
	BlockAMD64GE
	BlockAMD64OS
	BlockAMD64OC
	BlockAMD64ULT
	BlockAMD64ULE
	BlockAMD64UGT
	BlockAMD64UGE
	BlockAMD64EQF
	BlockAMD64NEF
	BlockAMD64ORD
	BlockAMD64NAN
	BlockAMD64JUMPTABLE

	BlockARMEQ
	BlockARMNE
	BlockARMLT
	BlockARMLE
	BlockARMGT
	BlockARMGE
	BlockARMULT
	BlockARMULE
	BlockARMUGT
	BlockARMUGE
	BlockARMLTnoov
	BlockARMLEnoov
	BlockARMGTnoov
	BlockARMGEnoov

	BlockARM64EQ
	BlockARM64NE
	BlockARM64LT
	BlockARM64LE
	BlockARM64GT
	BlockARM64GE
	BlockARM64ULT
	BlockARM64ULE
	BlockARM64UGT
	BlockARM64UGE
	BlockARM64Z
	BlockARM64NZ
	BlockARM64ZW
	BlockARM64NZW
	BlockARM64TBZ
	BlockARM64TBNZ
	BlockARM64FLT
	BlockARM64FLE
	BlockARM64FGT
	BlockARM64FGE
	BlockARM64LTnoov
	BlockARM64LEnoov
	BlockARM64GTnoov
	BlockARM64GEnoov
	BlockARM64JUMPTABLE

	BlockLOONG64EQZ
	BlockLOONG64NEZ
	BlockLOONG64LTZ
	BlockLOONG64LEZ
	BlockLOONG64GTZ
	BlockLOONG64GEZ
	BlockLOONG64FPT
	BlockLOONG64FPF
	BlockLOONG64BEQ
	BlockLOONG64BNE
	BlockLOONG64BGE
	BlockLOONG64BLT
	BlockLOONG64BGEU
	BlockLOONG64BLTU
	BlockLOONG64JUMPTABLE

	BlockMIPSEQ
	BlockMIPSNE
	BlockMIPSLTZ
	BlockMIPSLEZ
	BlockMIPSGTZ
	BlockMIPSGEZ
	BlockMIPSFPT
	BlockMIPSFPF

	BlockMIPS64EQ
	BlockMIPS64NE
	BlockMIPS64LTZ
	BlockMIPS64LEZ
	BlockMIPS64GTZ
	BlockMIPS64GEZ
	BlockMIPS64FPT
	BlockMIPS64FPF

	BlockPPC64EQ
	BlockPPC64NE
	BlockPPC64LT
	BlockPPC64LE
	BlockPPC64GT
	BlockPPC64GE
	BlockPPC64FLT
	BlockPPC64FLE
	BlockPPC64FGT
	BlockPPC64FGE

	BlockRISCV64BEQ
	BlockRISCV64BNE
	BlockRISCV64BLT
	BlockRISCV64BGE
	BlockRISCV64BLTU
	BlockRISCV64BGEU
	BlockRISCV64BEQZ
	BlockRISCV64BNEZ
	BlockRISCV64BLEZ
	BlockRISCV64BGEZ
	BlockRISCV64BLTZ
	BlockRISCV64BGTZ

	BlockS390XBRC
	BlockS390XCRJ
	BlockS390XCGRJ
	BlockS390XCLRJ
	BlockS390XCLGRJ
	BlockS390XCIJ
	BlockS390XCGIJ
	BlockS390XCLIJ
	BlockS390XCLGIJ

	BlockPlain
	BlockIf
	BlockDefer
	BlockRet
	BlockRetJmp
	BlockExit
	BlockJumpTable
	BlockFirst
)

var blockString = [...]string{
	BlockInvalid: "BlockInvalid",

	Block386EQ:  "EQ",
	Block386NE:  "NE",
	Block386LT:  "LT",
	Block386LE:  "LE",
	Block386GT:  "GT",
	Block386GE:  "GE",
	Block386OS:  "OS",
	Block386OC:  "OC",
	Block386ULT: "ULT",
	Block386ULE: "ULE",
	Block386UGT: "UGT",
	Block386UGE: "UGE",
	Block386EQF: "EQF",
	Block386NEF: "NEF",
	Block386ORD: "ORD",
	Block386NAN: "NAN",

	BlockAMD64EQ:        "EQ",
	BlockAMD64NE:        "NE",
	BlockAMD64LT:        "LT",
	BlockAMD64LE:        "LE",
	BlockAMD64GT:        "GT",
	BlockAMD64GE:        "GE",
	BlockAMD64OS:        "OS",
	BlockAMD64OC:        "OC",
	BlockAMD64ULT:       "ULT",
	BlockAMD64ULE:       "ULE",
	BlockAMD64UGT:       "UGT",
	BlockAMD64UGE:       "UGE",
	BlockAMD64EQF:       "EQF",
	BlockAMD64NEF:       "NEF",
	BlockAMD64ORD:       "ORD",
	BlockAMD64NAN:       "NAN",
	BlockAMD64JUMPTABLE: "JUMPTABLE",

	BlockARMEQ:     "EQ",
	BlockARMNE:     "NE",
	BlockARMLT:     "LT",
	BlockARMLE:     "LE",
	BlockARMGT:     "GT",
	BlockARMGE:     "GE",
	BlockARMULT:    "ULT",
	BlockARMULE:    "ULE",
	BlockARMUGT:    "UGT",
	BlockARMUGE:    "UGE",
	BlockARMLTnoov: "LTnoov",
	BlockARMLEnoov: "LEnoov",
	BlockARMGTnoov: "GTnoov",
	BlockARMGEnoov: "GEnoov",

	BlockARM64EQ:        "EQ",
	BlockARM64NE:        "NE",
	BlockARM64LT:        "LT",
	BlockARM64LE:        "LE",
	BlockARM64GT:        "GT",
	BlockARM64GE:        "GE",
	BlockARM64ULT:       "ULT",
	BlockARM64ULE:       "ULE",
	BlockARM64UGT:       "UGT",
	BlockARM64UGE:       "UGE",
	BlockARM64Z:         "Z",
	BlockARM64NZ:        "NZ",
	BlockARM64ZW:        "ZW",
	BlockARM64NZW:       "NZW",
	BlockARM64TBZ:       "TBZ",
	BlockARM64TBNZ:      "TBNZ",
	BlockARM64FLT:       "FLT",
	BlockARM64FLE:       "FLE",
	BlockARM64FGT:       "FGT",
	BlockARM64FGE:       "FGE",
	BlockARM64LTnoov:    "LTnoov",
	BlockARM64LEnoov:    "LEnoov",
	BlockARM64GTnoov:    "GTnoov",
	BlockARM64GEnoov:    "GEnoov",
	BlockARM64JUMPTABLE: "JUMPTABLE",

	BlockLOONG64EQZ:       "EQZ",
	BlockLOONG64NEZ:       "NEZ",
	BlockLOONG64LTZ:       "LTZ",
	BlockLOONG64LEZ:       "LEZ",
	BlockLOONG64GTZ:       "GTZ",
	BlockLOONG64GEZ:       "GEZ",
	BlockLOONG64FPT:       "FPT",
	BlockLOONG64FPF:       "FPF",
	BlockLOONG64BEQ:       "BEQ",
	BlockLOONG64BNE:       "BNE",
	BlockLOONG64BGE:       "BGE",
	BlockLOONG64BLT:       "BLT",
	BlockLOONG64BGEU:      "BGEU",
	BlockLOONG64BLTU:      "BLTU",
	BlockLOONG64JUMPTABLE: "JUMPTABLE",

	BlockMIPSEQ:  "EQ",
	BlockMIPSNE:  "NE",
	BlockMIPSLTZ: "LTZ",
	BlockMIPSLEZ: "LEZ",
	BlockMIPSGTZ: "GTZ",
	BlockMIPSGEZ: "GEZ",
	BlockMIPSFPT: "FPT",
	BlockMIPSFPF: "FPF",

	BlockMIPS64EQ:  "EQ",
	BlockMIPS64NE:  "NE",
	BlockMIPS64LTZ: "LTZ",
	BlockMIPS64LEZ: "LEZ",
	BlockMIPS64GTZ: "GTZ",
	BlockMIPS64GEZ: "GEZ",
	BlockMIPS64FPT: "FPT",
	BlockMIPS64FPF: "FPF",

	BlockPPC64EQ:  "EQ",
	BlockPPC64NE:  "NE",
	BlockPPC64LT:  "LT",
	BlockPPC64LE:  "LE",
	BlockPPC64GT:  "GT",
	BlockPPC64GE:  "GE",
	BlockPPC64FLT: "FLT",
	BlockPPC64FLE: "FLE",
	BlockPPC64FGT: "FGT",
	BlockPPC64FGE: "FGE",

	BlockRISCV64BEQ:  "BEQ",
	BlockRISCV64BNE:  "BNE",
	BlockRISCV64BLT:  "BLT",
	BlockRISCV64BGE:  "BGE",
	BlockRISCV64BLTU: "BLTU",
	BlockRISCV64BGEU: "BGEU",
	BlockRISCV64BEQZ: "BEQZ",
	BlockRISCV64BNEZ: "BNEZ",
	BlockRISCV64BLEZ: "BLEZ",
	BlockRISCV64BGEZ: "BGEZ",
	BlockRISCV64BLTZ: "BLTZ",
	BlockRISCV64BGTZ: "BGTZ",

	BlockS390XBRC:   "BRC",
	BlockS390XCRJ:   "CRJ",
	BlockS390XCGRJ:  "CGRJ",
	BlockS390XCLRJ:  "CLRJ",
	BlockS390XCLGRJ: "CLGRJ",
	BlockS390XCIJ:   "CIJ",
	BlockS390XCGIJ:  "CGIJ",
	BlockS390XCLIJ:  "CLIJ",
	BlockS390XCLGIJ: "CLGIJ",

	BlockPlain:     "Plain",
	BlockIf:        "If",
	BlockDefer:     "Defer",
	BlockRet:       "Ret",
	BlockRetJmp:    "RetJmp",
	BlockExit:      "Exit",
	BlockJumpTable: "JumpTable",
	BlockFirst:     "First",
}

func (k BlockKind) String() string { return blockString[k] }
func (k BlockKind) AuxIntType() string {
	switch k {
	case BlockARM64TBZ:
		return "int64"
	case BlockARM64TBNZ:
		return "int64"
	case BlockS390XCIJ:
		return "int8"
	case BlockS390XCGIJ:
		return "int8"
	case BlockS390XCLIJ:
		return "uint8"
	case BlockS390XCLGIJ:
		return "uint8"
	}
	return ""
}

const (
	OpInvalid Op = iota

	Op386ADDSS
	Op386ADDSD
	Op386SUBSS
	Op386SUBSD
	Op386MULSS
	Op386MULSD
	Op386DIVSS
	Op386DIVSD
	Op386MOVSSload
	Op386MOVSDload
	Op386MOVSSconst
	Op386MOVSDconst
	Op386MOVSSloadidx1
	Op386MOVSSloadidx4
	Op386MOVSDloadidx1
	Op386MOVSDloadidx8
	Op386MOVSSstore
	Op386MOVSDstore
	Op386MOVSSstoreidx1
	Op386MOVSSstoreidx4
	Op386MOVSDstoreidx1
	Op386MOVSDstoreidx8
	Op386ADDSSload
	Op386ADDSDload
	Op386SUBSSload
	Op386SUBSDload
	Op386MULSSload
	Op386MULSDload
	Op386DIVSSload
	Op386DIVSDload
	Op386ADDL
	Op386ADDLconst
	Op386ADDLcarry
	Op386ADDLconstcarry
	Op386ADCL
	Op386ADCLcarry
	Op386ADCLconst
	Op386SUBL
	Op386SUBLconst
	Op386SUBLcarry
	Op386SUBLconstcarry
	Op386SBBL
	Op386SBBLconst
	Op386MULL
	Op386MULLconst
	Op386MULLU
	Op386HMULL
	Op386HMULLU
	Op386MULLQU
	Op386AVGLU
	Op386DIVL
	Op386DIVW
	Op386DIVLU
	Op386DIVWU
	Op386MODL
	Op386MODW
	Op386MODLU
	Op386MODWU
	Op386ANDL
	Op386ANDLconst
	Op386ORL
	Op386ORLconst
	Op386XORL
	Op386XORLconst
	Op386CMPL
	Op386CMPW
	Op386CMPB
	Op386CMPLconst
	Op386CMPWconst
	Op386CMPBconst
	Op386CMPLload
	Op386CMPWload
	Op386CMPBload
	Op386CMPLconstload
	Op386CMPWconstload
	Op386CMPBconstload
	Op386UCOMISS
	Op386UCOMISD
	Op386TESTL
	Op386TESTW
	Op386TESTB
	Op386TESTLconst
	Op386TESTWconst
	Op386TESTBconst
	Op386SHLL
	Op386SHLLconst
	Op386SHRL
	Op386SHRW
	Op386SHRB
	Op386SHRLconst
	Op386SHRWconst
	Op386SHRBconst
	Op386SARL
	Op386SARW
	Op386SARB
	Op386SARLconst
	Op386SARWconst
	Op386SARBconst
	Op386ROLL
	Op386ROLW
	Op386ROLB
	Op386ROLLconst
	Op386ROLWconst
	Op386ROLBconst
	Op386ADDLload
	Op386SUBLload
	Op386MULLload
	Op386ANDLload
	Op386ORLload
	Op386XORLload
	Op386ADDLloadidx4
	Op386SUBLloadidx4
	Op386MULLloadidx4
	Op386ANDLloadidx4
	Op386ORLloadidx4
	Op386XORLloadidx4
	Op386NEGL
	Op386NOTL
	Op386BSFL
	Op386BSFW
	Op386LoweredCtz32
	Op386LoweredCtz64
	Op386BSRL
	Op386BSRW
	Op386BSWAPL
	Op386SQRTSD
	Op386SQRTSS
	Op386SBBLcarrymask
	Op386SETEQ
	Op386SETNE
	Op386SETL
	Op386SETLE
	Op386SETG
	Op386SETGE
	Op386SETB
	Op386SETBE
	Op386SETA
	Op386SETAE
	Op386SETO
	Op386SETEQF
	Op386SETNEF
	Op386SETORD
	Op386SETNAN
	Op386SETGF
	Op386SETGEF
	Op386MOVBLSX
	Op386MOVBLZX
	Op386MOVWLSX
	Op386MOVWLZX
	Op386MOVLconst
	Op386CVTTSD2SL
	Op386CVTTSS2SL
	Op386CVTSL2SS
	Op386CVTSL2SD
	Op386CVTSD2SS
	Op386CVTSS2SD
	Op386PXOR
	Op386LEAL
	Op386LEAL1
	Op386LEAL2
	Op386LEAL4
	Op386LEAL8
	Op386MOVBload
	Op386MOVBLSXload
	Op386MOVWload
	Op386MOVWLSXload
	Op386MOVLload
	Op386MOVBstore
	Op386MOVWstore
	Op386MOVLstore
	Op386ADDLmodify
	Op386SUBLmodify
	Op386ANDLmodify
	Op386ORLmodify
	Op386XORLmodify
	Op386ADDLmodifyidx4
	Op386SUBLmodifyidx4
	Op386ANDLmodifyidx4
	Op386ORLmodifyidx4
	Op386XORLmodifyidx4
	Op386ADDLconstmodify
	Op386ANDLconstmodify
	Op386ORLconstmodify
	Op386XORLconstmodify
	Op386ADDLconstmodifyidx4
	Op386ANDLconstmodifyidx4
	Op386ORLconstmodifyidx4
	Op386XORLconstmodifyidx4
	Op386MOVBloadidx1
	Op386MOVWloadidx1
	Op386MOVWloadidx2
	Op386MOVLloadidx1
	Op386MOVLloadidx4
	Op386MOVBstoreidx1
	Op386MOVWstoreidx1
	Op386MOVWstoreidx2
	Op386MOVLstoreidx1
	Op386MOVLstoreidx4
	Op386MOVBstoreconst
	Op386MOVWstoreconst
	Op386MOVLstoreconst
	Op386MOVBstoreconstidx1
	Op386MOVWstoreconstidx1
	Op386MOVWstoreconstidx2
	Op386MOVLstoreconstidx1
	Op386MOVLstoreconstidx4
	Op386DUFFZERO
	Op386REPSTOSL
	Op386CALLstatic
	Op386CALLtail
	Op386CALLclosure
	Op386CALLinter
	Op386DUFFCOPY
	Op386REPMOVSL
	Op386InvertFlags
	Op386LoweredGetG
	Op386LoweredGetClosurePtr
	Op386LoweredGetCallerPC
	Op386LoweredGetCallerSP
	Op386LoweredNilCheck
	Op386LoweredWB
	Op386LoweredPanicBoundsRR
	Op386LoweredPanicBoundsRC
	Op386LoweredPanicBoundsCR
	Op386LoweredPanicBoundsCC
	Op386LoweredPanicExtendRR
	Op386LoweredPanicExtendRC
	Op386FlagEQ
	Op386FlagLT_ULT
	Op386FlagLT_UGT
	Op386FlagGT_UGT
	Op386FlagGT_ULT
	Op386MOVSSconst1
	Op386MOVSDconst1
	Op386MOVSSconst2
	Op386MOVSDconst2

	OpAMD64ADDSS
	OpAMD64ADDSD
	OpAMD64SUBSS
	OpAMD64SUBSD
	OpAMD64MULSS
	OpAMD64MULSD
	OpAMD64DIVSS
	OpAMD64DIVSD
	OpAMD64MOVSSload
	OpAMD64MOVSDload
	OpAMD64MOVSSconst
	OpAMD64MOVSDconst
	OpAMD64MOVSSloadidx1
	OpAMD64MOVSSloadidx4
	OpAMD64MOVSDloadidx1
	OpAMD64MOVSDloadidx8
	OpAMD64MOVSSstore
	OpAMD64MOVSDstore
	OpAMD64MOVSSstoreidx1
	OpAMD64MOVSSstoreidx4
	OpAMD64MOVSDstoreidx1
	OpAMD64MOVSDstoreidx8
	OpAMD64ADDSSload
	OpAMD64ADDSDload
	OpAMD64SUBSSload
	OpAMD64SUBSDload
	OpAMD64MULSSload
	OpAMD64MULSDload
	OpAMD64DIVSSload
	OpAMD64DIVSDload
	OpAMD64ADDSSloadidx1
	OpAMD64ADDSSloadidx4
	OpAMD64ADDSDloadidx1
	OpAMD64ADDSDloadidx8
	OpAMD64SUBSSloadidx1
	OpAMD64SUBSSloadidx4
	OpAMD64SUBSDloadidx1
	OpAMD64SUBSDloadidx8
	OpAMD64MULSSloadidx1
	OpAMD64MULSSloadidx4
	OpAMD64MULSDloadidx1
	OpAMD64MULSDloadidx8
	OpAMD64DIVSSloadidx1
	OpAMD64DIVSSloadidx4
	OpAMD64DIVSDloadidx1
	OpAMD64DIVSDloadidx8
	OpAMD64ADDQ
	OpAMD64ADDL
	OpAMD64ADDQconst
	OpAMD64ADDLconst
	OpAMD64ADDQconstmodify
	OpAMD64ADDLconstmodify
	OpAMD64SUBQ
	OpAMD64SUBL
	OpAMD64SUBQconst
	OpAMD64SUBLconst
	OpAMD64MULQ
	OpAMD64MULL
	OpAMD64MULQconst
	OpAMD64MULLconst
	OpAMD64MULLU
	OpAMD64MULQU
	OpAMD64HMULQ
	OpAMD64HMULL
	OpAMD64HMULQU
	OpAMD64HMULLU
	OpAMD64AVGQU
	OpAMD64DIVQ
	OpAMD64DIVL
	OpAMD64DIVW
	OpAMD64DIVQU
	OpAMD64DIVLU
	OpAMD64DIVWU
	OpAMD64NEGLflags
	OpAMD64ADDQconstflags
	OpAMD64ADDLconstflags
	OpAMD64ADDQcarry
	OpAMD64ADCQ
	OpAMD64ADDQconstcarry
	OpAMD64ADCQconst
	OpAMD64SUBQborrow
	OpAMD64SBBQ
	OpAMD64SUBQconstborrow
	OpAMD64SBBQconst
	OpAMD64MULQU2
	OpAMD64DIVQU2
	OpAMD64ANDQ
	OpAMD64ANDL
	OpAMD64ANDQconst
	OpAMD64ANDLconst
	OpAMD64ANDQconstmodify
	OpAMD64ANDLconstmodify
	OpAMD64ORQ
	OpAMD64ORL
	OpAMD64ORQconst
	OpAMD64ORLconst
	OpAMD64ORQconstmodify
	OpAMD64ORLconstmodify
	OpAMD64XORQ
	OpAMD64XORL
	OpAMD64XORQconst
	OpAMD64XORLconst
	OpAMD64XORQconstmodify
	OpAMD64XORLconstmodify
	OpAMD64CMPQ
	OpAMD64CMPL
	OpAMD64CMPW
	OpAMD64CMPB
	OpAMD64CMPQconst
	OpAMD64CMPLconst
	OpAMD64CMPWconst
	OpAMD64CMPBconst
	OpAMD64CMPQload
	OpAMD64CMPLload
	OpAMD64CMPWload
	OpAMD64CMPBload
	OpAMD64CMPQconstload
	OpAMD64CMPLconstload
	OpAMD64CMPWconstload
	OpAMD64CMPBconstload
	OpAMD64CMPQloadidx8
	OpAMD64CMPQloadidx1
	OpAMD64CMPLloadidx4
	OpAMD64CMPLloadidx1
	OpAMD64CMPWloadidx2
	OpAMD64CMPWloadidx1
	OpAMD64CMPBloadidx1
	OpAMD64CMPQconstloadidx8
	OpAMD64CMPQconstloadidx1
	OpAMD64CMPLconstloadidx4
	OpAMD64CMPLconstloadidx1
	OpAMD64CMPWconstloadidx2
	OpAMD64CMPWconstloadidx1
	OpAMD64CMPBconstloadidx1
	OpAMD64UCOMISS
	OpAMD64UCOMISD
	OpAMD64BTL
	OpAMD64BTQ
	OpAMD64BTCL
	OpAMD64BTCQ
	OpAMD64BTRL
	OpAMD64BTRQ
	OpAMD64BTSL
	OpAMD64BTSQ
	OpAMD64BTLconst
	OpAMD64BTQconst
	OpAMD64BTCQconst
	OpAMD64BTRQconst
	OpAMD64BTSQconst
	OpAMD64BTSQconstmodify
	OpAMD64BTRQconstmodify
	OpAMD64BTCQconstmodify
	OpAMD64TESTQ
	OpAMD64TESTL
	OpAMD64TESTW
	OpAMD64TESTB
	OpAMD64TESTQconst
	OpAMD64TESTLconst
	OpAMD64TESTWconst
	OpAMD64TESTBconst
	OpAMD64SHLQ
	OpAMD64SHLL
	OpAMD64SHLQconst
	OpAMD64SHLLconst
	OpAMD64SHRQ
	OpAMD64SHRL
	OpAMD64SHRW
	OpAMD64SHRB
	OpAMD64SHRQconst
	OpAMD64SHRLconst
	OpAMD64SHRWconst
	OpAMD64SHRBconst
	OpAMD64SARQ
	OpAMD64SARL
	OpAMD64SARW
	OpAMD64SARB
	OpAMD64SARQconst
	OpAMD64SARLconst
	OpAMD64SARWconst
	OpAMD64SARBconst
	OpAMD64SHRDQ
	OpAMD64SHLDQ
	OpAMD64ROLQ
	OpAMD64ROLL
	OpAMD64ROLW
	OpAMD64ROLB
	OpAMD64RORQ
	OpAMD64RORL
	OpAMD64RORW
	OpAMD64RORB
	OpAMD64ROLQconst
	OpAMD64ROLLconst
	OpAMD64ROLWconst
	OpAMD64ROLBconst
	OpAMD64ADDLload
	OpAMD64ADDQload
	OpAMD64SUBQload
	OpAMD64SUBLload
	OpAMD64ANDLload
	OpAMD64ANDQload
	OpAMD64ORQload
	OpAMD64ORLload
	OpAMD64XORQload
	OpAMD64XORLload
	OpAMD64ADDLloadidx1
	OpAMD64ADDLloadidx4
	OpAMD64ADDLloadidx8
	OpAMD64ADDQloadidx1
	OpAMD64ADDQloadidx8
	OpAMD64SUBLloadidx1
	OpAMD64SUBLloadidx4
	OpAMD64SUBLloadidx8
	OpAMD64SUBQloadidx1
	OpAMD64SUBQloadidx8
	OpAMD64ANDLloadidx1
	OpAMD64ANDLloadidx4
	OpAMD64ANDLloadidx8
	OpAMD64ANDQloadidx1
	OpAMD64ANDQloadidx8
	OpAMD64ORLloadidx1
	OpAMD64ORLloadidx4
	OpAMD64ORLloadidx8
	OpAMD64ORQloadidx1
	OpAMD64ORQloadidx8
	OpAMD64XORLloadidx1
	OpAMD64XORLloadidx4
	OpAMD64XORLloadidx8
	OpAMD64XORQloadidx1
	OpAMD64XORQloadidx8
	OpAMD64ADDQmodify
	OpAMD64SUBQmodify
	OpAMD64ANDQmodify
	OpAMD64ORQmodify
	OpAMD64XORQmodify
	OpAMD64ADDLmodify
	OpAMD64SUBLmodify
	OpAMD64ANDLmodify
	OpAMD64ORLmodify
	OpAMD64XORLmodify
	OpAMD64ADDQmodifyidx1
	OpAMD64ADDQmodifyidx8
	OpAMD64SUBQmodifyidx1
	OpAMD64SUBQmodifyidx8
	OpAMD64ANDQmodifyidx1
	OpAMD64ANDQmodifyidx8
	OpAMD64ORQmodifyidx1
	OpAMD64ORQmodifyidx8
	OpAMD64XORQmodifyidx1
	OpAMD64XORQmodifyidx8
	OpAMD64ADDLmodifyidx1
	OpAMD64ADDLmodifyidx4
	OpAMD64ADDLmodifyidx8
	OpAMD64SUBLmodifyidx1
	OpAMD64SUBLmodifyidx4
	OpAMD64SUBLmodifyidx8
	OpAMD64ANDLmodifyidx1
	OpAMD64ANDLmodifyidx4
	OpAMD64ANDLmodifyidx8
	OpAMD64ORLmodifyidx1
	OpAMD64ORLmodifyidx4
	OpAMD64ORLmodifyidx8
	OpAMD64XORLmodifyidx1
	OpAMD64XORLmodifyidx4
	OpAMD64XORLmodifyidx8
	OpAMD64ADDQconstmodifyidx1
	OpAMD64ADDQconstmodifyidx8
	OpAMD64ANDQconstmodifyidx1
	OpAMD64ANDQconstmodifyidx8
	OpAMD64ORQconstmodifyidx1
	OpAMD64ORQconstmodifyidx8
	OpAMD64XORQconstmodifyidx1
	OpAMD64XORQconstmodifyidx8
	OpAMD64ADDLconstmodifyidx1
	OpAMD64ADDLconstmodifyidx4
	OpAMD64ADDLconstmodifyidx8
	OpAMD64ANDLconstmodifyidx1
	OpAMD64ANDLconstmodifyidx4
	OpAMD64ANDLconstmodifyidx8
	OpAMD64ORLconstmodifyidx1
	OpAMD64ORLconstmodifyidx4
	OpAMD64ORLconstmodifyidx8
	OpAMD64XORLconstmodifyidx1
	OpAMD64XORLconstmodifyidx4
	OpAMD64XORLconstmodifyidx8
	OpAMD64NEGQ
	OpAMD64NEGL
	OpAMD64NOTQ
	OpAMD64NOTL
	OpAMD64BSFQ
	OpAMD64BSFL
	OpAMD64BSRQ
	OpAMD64BSRL
	OpAMD64CMOVQEQ
	OpAMD64CMOVQNE
	OpAMD64CMOVQLT
	OpAMD64CMOVQGT
	OpAMD64CMOVQLE
	OpAMD64CMOVQGE
	OpAMD64CMOVQLS
	OpAMD64CMOVQHI
	OpAMD64CMOVQCC
	OpAMD64CMOVQCS
	OpAMD64CMOVLEQ
	OpAMD64CMOVLNE
	OpAMD64CMOVLLT
	OpAMD64CMOVLGT
	OpAMD64CMOVLLE
	OpAMD64CMOVLGE
	OpAMD64CMOVLLS
	OpAMD64CMOVLHI
	OpAMD64CMOVLCC
	OpAMD64CMOVLCS
	OpAMD64CMOVWEQ
	OpAMD64CMOVWNE
	OpAMD64CMOVWLT
	OpAMD64CMOVWGT
	OpAMD64CMOVWLE
	OpAMD64CMOVWGE
	OpAMD64CMOVWLS
	OpAMD64CMOVWHI
	OpAMD64CMOVWCC
	OpAMD64CMOVWCS
	OpAMD64CMOVQEQF
	OpAMD64CMOVQNEF
	OpAMD64CMOVQGTF
	OpAMD64CMOVQGEF
	OpAMD64CMOVLEQF
	OpAMD64CMOVLNEF
	OpAMD64CMOVLGTF
	OpAMD64CMOVLGEF
	OpAMD64CMOVWEQF
	OpAMD64CMOVWNEF
	OpAMD64CMOVWGTF
	OpAMD64CMOVWGEF
	OpAMD64BSWAPQ
	OpAMD64BSWAPL
	OpAMD64POPCNTQ
	OpAMD64POPCNTL
	OpAMD64SQRTSD
	OpAMD64SQRTSS
	OpAMD64ROUNDSD
	OpAMD64LoweredRound32F
	OpAMD64LoweredRound64F
	OpAMD64VFMADD231SS
	OpAMD64VFMADD231SD
	OpAMD64MINSD
	OpAMD64MINSS
	OpAMD64SBBQcarrymask
	OpAMD64SBBLcarrymask
	OpAMD64SETEQ
	OpAMD64SETNE
	OpAMD64SETL
	OpAMD64SETLE
	OpAMD64SETG
	OpAMD64SETGE
	OpAMD64SETB
	OpAMD64SETBE
	OpAMD64SETA
	OpAMD64SETAE
	OpAMD64SETO
	OpAMD64SETEQstore
	OpAMD64SETNEstore
	OpAMD64SETLstore
	OpAMD64SETLEstore
	OpAMD64SETGstore
	OpAMD64SETGEstore
	OpAMD64SETBstore
	OpAMD64SETBEstore
	OpAMD64SETAstore
	OpAMD64SETAEstore
	OpAMD64SETEQstoreidx1
	OpAMD64SETNEstoreidx1
	OpAMD64SETLstoreidx1
	OpAMD64SETLEstoreidx1
	OpAMD64SETGstoreidx1
	OpAMD64SETGEstoreidx1
	OpAMD64SETBstoreidx1
	OpAMD64SETBEstoreidx1
	OpAMD64SETAstoreidx1
	OpAMD64SETAEstoreidx1
	OpAMD64SETEQF
	OpAMD64SETNEF
	OpAMD64SETORD
	OpAMD64SETNAN
	OpAMD64SETGF
	OpAMD64SETGEF
	OpAMD64MOVBQSX
	OpAMD64MOVBQZX
	OpAMD64MOVWQSX
	OpAMD64MOVWQZX
	OpAMD64MOVLQSX
	OpAMD64MOVLQZX
	OpAMD64MOVLconst
	OpAMD64MOVQconst
	OpAMD64CVTTSD2SL
	OpAMD64CVTTSD2SQ
	OpAMD64CVTTSS2SL
	OpAMD64CVTTSS2SQ
	OpAMD64CVTSL2SS
	OpAMD64CVTSL2SD
	OpAMD64CVTSQ2SS
	OpAMD64CVTSQ2SD
	OpAMD64CVTSD2SS
	OpAMD64CVTSS2SD
	OpAMD64MOVQi2f
	OpAMD64MOVQf2i
	OpAMD64MOVLi2f
	OpAMD64MOVLf2i
	OpAMD64PXOR
	OpAMD64POR
	OpAMD64LEAQ
	OpAMD64LEAL
	OpAMD64LEAW
	OpAMD64LEAQ1
	OpAMD64LEAL1
	OpAMD64LEAW1
	OpAMD64LEAQ2
	OpAMD64LEAL2
	OpAMD64LEAW2
	OpAMD64LEAQ4
	OpAMD64LEAL4
	OpAMD64LEAW4
	OpAMD64LEAQ8
	OpAMD64LEAL8
	OpAMD64LEAW8
	OpAMD64MOVBload
	OpAMD64MOVBQSXload
	OpAMD64MOVWload
	OpAMD64MOVWQSXload
	OpAMD64MOVLload
	OpAMD64MOVLQSXload
	OpAMD64MOVQload
	OpAMD64MOVBstore
	OpAMD64MOVWstore
	OpAMD64MOVLstore
	OpAMD64MOVQstore
	OpAMD64MOVOload
	OpAMD64MOVOstore
	OpAMD64MOVBloadidx1
	OpAMD64MOVWloadidx1
	OpAMD64MOVWloadidx2
	OpAMD64MOVLloadidx1
	OpAMD64MOVLloadidx4
	OpAMD64MOVLloadidx8
	OpAMD64MOVQloadidx1
	OpAMD64MOVQloadidx8
	OpAMD64MOVBstoreidx1
	OpAMD64MOVWstoreidx1
	OpAMD64MOVWstoreidx2
	OpAMD64MOVLstoreidx1
	OpAMD64MOVLstoreidx4
	OpAMD64MOVLstoreidx8
	OpAMD64MOVQstoreidx1
	OpAMD64MOVQstoreidx8
	OpAMD64MOVBstoreconst
	OpAMD64MOVWstoreconst
	OpAMD64MOVLstoreconst
	OpAMD64MOVQstoreconst
	OpAMD64MOVOstoreconst
	OpAMD64MOVBstoreconstidx1
	OpAMD64MOVWstoreconstidx1
	OpAMD64MOVWstoreconstidx2
	OpAMD64MOVLstoreconstidx1
	OpAMD64MOVLstoreconstidx4
	OpAMD64MOVQstoreconstidx1
	OpAMD64MOVQstoreconstidx8
	OpAMD64LoweredZero
	OpAMD64LoweredZeroLoop
	OpAMD64REPSTOSQ
	OpAMD64CALLstatic
	OpAMD64CALLtail
	OpAMD64CALLclosure
	OpAMD64CALLinter
	OpAMD64LoweredMove
	OpAMD64LoweredMoveLoop
	OpAMD64REPMOVSQ
	OpAMD64InvertFlags
	OpAMD64LoweredGetG
	OpAMD64LoweredGetClosurePtr
	OpAMD64LoweredGetCallerPC
	OpAMD64LoweredGetCallerSP
	OpAMD64LoweredNilCheck
	OpAMD64LoweredWB
	OpAMD64LoweredHasCPUFeature
	OpAMD64LoweredPanicBoundsRR
	OpAMD64LoweredPanicBoundsRC
	OpAMD64LoweredPanicBoundsCR
	OpAMD64LoweredPanicBoundsCC
	OpAMD64FlagEQ
	OpAMD64FlagLT_ULT
	OpAMD64FlagLT_UGT
	OpAMD64FlagGT_UGT
	OpAMD64FlagGT_ULT
	OpAMD64MOVBatomicload
	OpAMD64MOVLatomicload
	OpAMD64MOVQatomicload
	OpAMD64XCHGB
	OpAMD64XCHGL
	OpAMD64XCHGQ
	OpAMD64XADDLlock
	OpAMD64XADDQlock
	OpAMD64AddTupleFirst32
	OpAMD64AddTupleFirst64
	OpAMD64CMPXCHGLlock
	OpAMD64CMPXCHGQlock
	OpAMD64ANDBlock
	OpAMD64ANDLlock
	OpAMD64ANDQlock
	OpAMD64ORBlock
	OpAMD64ORLlock
	OpAMD64ORQlock
	OpAMD64LoweredAtomicAnd64
	OpAMD64LoweredAtomicAnd32
	OpAMD64LoweredAtomicOr64
	OpAMD64LoweredAtomicOr32
	OpAMD64PrefetchT0
	OpAMD64PrefetchNTA
	OpAMD64ANDNQ
	OpAMD64ANDNL
	OpAMD64BLSIQ
	OpAMD64BLSIL
	OpAMD64BLSMSKQ
	OpAMD64BLSMSKL
	OpAMD64BLSRQ
	OpAMD64BLSRL
	OpAMD64TZCNTQ
	OpAMD64TZCNTL
	OpAMD64LZCNTQ
	OpAMD64LZCNTL
	OpAMD64MOVBEWstore
	OpAMD64MOVBELload
	OpAMD64MOVBELstore
	OpAMD64MOVBEQload
	OpAMD64MOVBEQstore
	OpAMD64MOVBELloadidx1
	OpAMD64MOVBELloadidx4
	OpAMD64MOVBELloadidx8
	OpAMD64MOVBEQloadidx1
	OpAMD64MOVBEQloadidx8
	OpAMD64MOVBEWstoreidx1
	OpAMD64MOVBEWstoreidx2
	OpAMD64MOVBELstoreidx1
	OpAMD64MOVBELstoreidx4
	OpAMD64MOVBELstoreidx8
	OpAMD64MOVBEQstoreidx1
	OpAMD64MOVBEQstoreidx8
	OpAMD64SARXQ
	OpAMD64SARXL
	OpAMD64SHLXQ
	OpAMD64SHLXL
	OpAMD64SHRXQ
	OpAMD64SHRXL
	OpAMD64SARXLload
	OpAMD64SARXQload
	OpAMD64SHLXLload
	OpAMD64SHLXQload
	OpAMD64SHRXLload
	OpAMD64SHRXQload
	OpAMD64SARXLloadidx1
	OpAMD64SARXLloadidx4
	OpAMD64SARXLloadidx8
	OpAMD64SARXQloadidx1
	OpAMD64SARXQloadidx8
	OpAMD64SHLXLloadidx1
	OpAMD64SHLXLloadidx4
	OpAMD64SHLXLloadidx8
	OpAMD64SHLXQloadidx1
	OpAMD64SHLXQloadidx8
	OpAMD64SHRXLloadidx1
	OpAMD64SHRXLloadidx4
	OpAMD64SHRXLloadidx8
	OpAMD64SHRXQloadidx1
	OpAMD64SHRXQloadidx8
	OpAMD64PUNPCKLBW
	OpAMD64PSHUFLW
	OpAMD64PSHUFBbroadcast
	OpAMD64VPBROADCASTB
	OpAMD64PSIGNB
	OpAMD64PCMPEQB
	OpAMD64PMOVMSKB
	OpAMD64VMOVDQUload128
	OpAMD64VMOVDQUstore128
	OpAMD64VMOVDQUload256
	OpAMD64VMOVDQUstore256
	OpAMD64VMOVDQUload512
	OpAMD64VMOVDQUstore512
	OpAMD64VPMASK32load128
	OpAMD64VPMASK32store128
	OpAMD64VPMASK64load128
	OpAMD64VPMASK64store128
	OpAMD64VPMASK32load256
	OpAMD64VPMASK32store256
	OpAMD64VPMASK64load256
	OpAMD64VPMASK64store256
	OpAMD64VPMASK8load512
	OpAMD64VPMASK8store512
	OpAMD64VPMASK16load512
	OpAMD64VPMASK16store512
	OpAMD64VPMASK32load512
	OpAMD64VPMASK32store512
	OpAMD64VPMASK64load512
	OpAMD64VPMASK64store512
	OpAMD64VPMOVMToVec8x16
	OpAMD64VPMOVMToVec8x32
	OpAMD64VPMOVMToVec8x64
	OpAMD64VPMOVMToVec16x8
	OpAMD64VPMOVMToVec16x16
	OpAMD64VPMOVMToVec16x32
	OpAMD64VPMOVMToVec32x4
	OpAMD64VPMOVMToVec32x8
	OpAMD64VPMOVMToVec32x16
	OpAMD64VPMOVMToVec64x2
	OpAMD64VPMOVMToVec64x4
	OpAMD64VPMOVMToVec64x8
	OpAMD64VPMOVVec8x16ToM
	OpAMD64VPMOVVec8x32ToM
	OpAMD64VPMOVVec8x64ToM
	OpAMD64VPMOVVec16x8ToM
	OpAMD64VPMOVVec16x16ToM
	OpAMD64VPMOVVec16x32ToM
	OpAMD64VPMOVVec32x4ToM
	OpAMD64VPMOVVec32x8ToM
	OpAMD64VPMOVVec32x16ToM
	OpAMD64VPMOVVec64x2ToM
	OpAMD64VPMOVVec64x4ToM
	OpAMD64VPMOVVec64x8ToM
	OpAMD64VPMOVMSKB128
	OpAMD64VPMOVMSKB256
	OpAMD64VMOVMSKPS128
	OpAMD64VMOVMSKPS256
	OpAMD64VMOVMSKPD128
	OpAMD64VMOVMSKPD256
	OpAMD64Zero128
	OpAMD64Zero256
	OpAMD64Zero512
	OpAMD64VMOVSDf2v
	OpAMD64VMOVSSf2v
	OpAMD64VMOVQ
	OpAMD64VMOVD
	OpAMD64VMOVQload
	OpAMD64VMOVDload
	OpAMD64VMOVSSload
	OpAMD64VMOVSDload
	OpAMD64VMOVSSconst
	OpAMD64VMOVSDconst
	OpAMD64VZEROUPPER
	OpAMD64VZEROALL
	OpAMD64KMOVBload
	OpAMD64KMOVWload
	OpAMD64KMOVDload
	OpAMD64KMOVQload
	OpAMD64KMOVBstore
	OpAMD64KMOVWstore
	OpAMD64KMOVDstore
	OpAMD64KMOVQstore
	OpAMD64KMOVQk
	OpAMD64KMOVDk
	OpAMD64KMOVWk
	OpAMD64KMOVBk
	OpAMD64KMOVQi
	OpAMD64KMOVDi
	OpAMD64KMOVWi
	OpAMD64KMOVBi
	OpAMD64VPTEST
	OpAMD64SHA1MSG1128
	OpAMD64SHA1MSG2128
	OpAMD64SHA1NEXTE128
	OpAMD64SHA256MSG1128
	OpAMD64SHA256MSG2128
	OpAMD64SHA256RNDS2128
	OpAMD64VADDPD128
	OpAMD64VADDPD256
	OpAMD64VADDPD512
	OpAMD64VADDPDMasked128
	OpAMD64VADDPDMasked256
	OpAMD64VADDPDMasked512
	OpAMD64VADDPS128
	OpAMD64VADDPS256
	OpAMD64VADDPS512
	OpAMD64VADDPSMasked128
	OpAMD64VADDPSMasked256
	OpAMD64VADDPSMasked512
	OpAMD64VADDSUBPD128
	OpAMD64VADDSUBPD256
	OpAMD64VADDSUBPS128
	OpAMD64VADDSUBPS256
	OpAMD64VAESDEC128
	OpAMD64VAESDEC256
	OpAMD64VAESDEC512
	OpAMD64VAESDECLAST128
	OpAMD64VAESDECLAST256
	OpAMD64VAESDECLAST512
	OpAMD64VAESENC128
	OpAMD64VAESENC256
	OpAMD64VAESENC512
	OpAMD64VAESENCLAST128
	OpAMD64VAESENCLAST256
	OpAMD64VAESENCLAST512
	OpAMD64VAESIMC128
	OpAMD64VBROADCASTSD256
	OpAMD64VBROADCASTSD512
	OpAMD64VBROADCASTSDMasked256
	OpAMD64VBROADCASTSDMasked512
	OpAMD64VBROADCASTSS128
	OpAMD64VBROADCASTSS256
	OpAMD64VBROADCASTSS512
	OpAMD64VBROADCASTSSMasked128
	OpAMD64VBROADCASTSSMasked256
	OpAMD64VBROADCASTSSMasked512
	OpAMD64VCOMPRESSPDMasked128
	OpAMD64VCOMPRESSPDMasked256
	OpAMD64VCOMPRESSPDMasked512
	OpAMD64VCOMPRESSPSMasked128
	OpAMD64VCOMPRESSPSMasked256
	OpAMD64VCOMPRESSPSMasked512
	OpAMD64VCVTDQ2PD256
	OpAMD64VCVTDQ2PD512
	OpAMD64VCVTDQ2PDMasked256
	OpAMD64VCVTDQ2PDMasked512
	OpAMD64VCVTDQ2PS128
	OpAMD64VCVTDQ2PS256
	OpAMD64VCVTDQ2PS512
	OpAMD64VCVTDQ2PSMasked128
	OpAMD64VCVTDQ2PSMasked256
	OpAMD64VCVTDQ2PSMasked512
	OpAMD64VCVTPD2PS256
	OpAMD64VCVTPD2PSMasked256
	OpAMD64VCVTPD2PSX128
	OpAMD64VCVTPD2PSXMasked128
	OpAMD64VCVTPD2PSY128
	OpAMD64VCVTPD2PSYMasked128
	OpAMD64VCVTPS2PD256
	OpAMD64VCVTPS2PD512
	OpAMD64VCVTPS2PDMasked256
	OpAMD64VCVTPS2PDMasked512
	OpAMD64VCVTQQ2PD128
	OpAMD64VCVTQQ2PD256
	OpAMD64VCVTQQ2PD512
	OpAMD64VCVTQQ2PDMasked128
	OpAMD64VCVTQQ2PDMasked256
	OpAMD64VCVTQQ2PDMasked512
	OpAMD64VCVTQQ2PS256
	OpAMD64VCVTQQ2PSMasked256
	OpAMD64VCVTQQ2PSX128
	OpAMD64VCVTQQ2PSXMasked128
	OpAMD64VCVTQQ2PSY128
	OpAMD64VCVTQQ2PSYMasked128
	OpAMD64VCVTTPD2DQ256
	OpAMD64VCVTTPD2DQMasked256
	OpAMD64VCVTTPD2DQX128
	OpAMD64VCVTTPD2DQXMasked128
	OpAMD64VCVTTPD2DQY128
	OpAMD64VCVTTPD2DQYMasked128
	OpAMD64VCVTTPD2QQ128
	OpAMD64VCVTTPD2QQ256
	OpAMD64VCVTTPD2QQ512
	OpAMD64VCVTTPD2QQMasked128
	OpAMD64VCVTTPD2QQMasked256
	OpAMD64VCVTTPD2QQMasked512
	OpAMD64VCVTTPD2UDQ256
	OpAMD64VCVTTPD2UDQMasked256
	OpAMD64VCVTTPD2UDQX128
	OpAMD64VCVTTPD2UDQXMasked128
	OpAMD64VCVTTPD2UDQY128
	OpAMD64VCVTTPD2UDQYMasked128
	OpAMD64VCVTTPD2UQQ128
	OpAMD64VCVTTPD2UQQ256
	OpAMD64VCVTTPD2UQQ512
	OpAMD64VCVTTPD2UQQMasked128
	OpAMD64VCVTTPD2UQQMasked256
	OpAMD64VCVTTPD2UQQMasked512
	OpAMD64VCVTTPS2DQ128
	OpAMD64VCVTTPS2DQ256
	OpAMD64VCVTTPS2DQ512
	OpAMD64VCVTTPS2DQMasked128
	OpAMD64VCVTTPS2DQMasked256
	OpAMD64VCVTTPS2DQMasked512
	OpAMD64VCVTTPS2QQ256
	OpAMD64VCVTTPS2QQ512
	OpAMD64VCVTTPS2QQMasked256
	OpAMD64VCVTTPS2QQMasked512
	OpAMD64VCVTTPS2UDQ128
	OpAMD64VCVTTPS2UDQ256
	OpAMD64VCVTTPS2UDQ512
	OpAMD64VCVTTPS2UDQMasked128
	OpAMD64VCVTTPS2UDQMasked256
	OpAMD64VCVTTPS2UDQMasked512
	OpAMD64VCVTTPS2UQQ256
	OpAMD64VCVTTPS2UQQ512
	OpAMD64VCVTTPS2UQQMasked256
	OpAMD64VCVTTPS2UQQMasked512
	OpAMD64VCVTUDQ2PD256
	OpAMD64VCVTUDQ2PD512
	OpAMD64VCVTUDQ2PDMasked256
	OpAMD64VCVTUDQ2PDMasked512
	OpAMD64VCVTUDQ2PS128
	OpAMD64VCVTUDQ2PS256
	OpAMD64VCVTUDQ2PS512
	OpAMD64VCVTUDQ2PSMasked128
	OpAMD64VCVTUDQ2PSMasked256
	OpAMD64VCVTUDQ2PSMasked512
	OpAMD64VCVTUQQ2PD128
	OpAMD64VCVTUQQ2PD256
	OpAMD64VCVTUQQ2PD512
	OpAMD64VCVTUQQ2PDMasked128
	OpAMD64VCVTUQQ2PDMasked256
	OpAMD64VCVTUQQ2PDMasked512
	OpAMD64VCVTUQQ2PS256
	OpAMD64VCVTUQQ2PSMasked256
	OpAMD64VCVTUQQ2PSX128
	OpAMD64VCVTUQQ2PSXMasked128
	OpAMD64VCVTUQQ2PSY128
	OpAMD64VCVTUQQ2PSYMasked128
	OpAMD64VDIVPD128
	OpAMD64VDIVPD256
	OpAMD64VDIVPD512
	OpAMD64VDIVPDMasked128
	OpAMD64VDIVPDMasked256
	OpAMD64VDIVPDMasked512
	OpAMD64VDIVPS128
	OpAMD64VDIVPS256
	OpAMD64VDIVPS512
	OpAMD64VDIVPSMasked128
	OpAMD64VDIVPSMasked256
	OpAMD64VDIVPSMasked512
	OpAMD64VEXPANDPDMasked128
	OpAMD64VEXPANDPDMasked256
	OpAMD64VEXPANDPDMasked512
	OpAMD64VEXPANDPSMasked128
	OpAMD64VEXPANDPSMasked256
	OpAMD64VEXPANDPSMasked512
	OpAMD64VFMADD213PD128
	OpAMD64VFMADD213PD256
	OpAMD64VFMADD213PD512
	OpAMD64VFMADD213PDMasked128
	OpAMD64VFMADD213PDMasked256
	OpAMD64VFMADD213PDMasked512
	OpAMD64VFMADD213PS128
	OpAMD64VFMADD213PS256
	OpAMD64VFMADD213PS512
	OpAMD64VFMADD213PSMasked128
	OpAMD64VFMADD213PSMasked256
	OpAMD64VFMADD213PSMasked512
	OpAMD64VFMADDSUB213PD128
	OpAMD64VFMADDSUB213PD256
	OpAMD64VFMADDSUB213PD512
	OpAMD64VFMADDSUB213PDMasked128
	OpAMD64VFMADDSUB213PDMasked256
	OpAMD64VFMADDSUB213PDMasked512
	OpAMD64VFMADDSUB213PS128
	OpAMD64VFMADDSUB213PS256
	OpAMD64VFMADDSUB213PS512
	OpAMD64VFMADDSUB213PSMasked128
	OpAMD64VFMADDSUB213PSMasked256
	OpAMD64VFMADDSUB213PSMasked512
	OpAMD64VFMSUBADD213PD128
	OpAMD64VFMSUBADD213PD256
	OpAMD64VFMSUBADD213PD512
	OpAMD64VFMSUBADD213PDMasked128
	OpAMD64VFMSUBADD213PDMasked256
	OpAMD64VFMSUBADD213PDMasked512
	OpAMD64VFMSUBADD213PS128
	OpAMD64VFMSUBADD213PS256
	OpAMD64VFMSUBADD213PS512
	OpAMD64VFMSUBADD213PSMasked128
	OpAMD64VFMSUBADD213PSMasked256
	OpAMD64VFMSUBADD213PSMasked512
	OpAMD64VGF2P8MULB128
	OpAMD64VGF2P8MULB256
	OpAMD64VGF2P8MULB512
	OpAMD64VGF2P8MULBMasked128
	OpAMD64VGF2P8MULBMasked256
	OpAMD64VGF2P8MULBMasked512
	OpAMD64VHADDPD128
	OpAMD64VHADDPD256
	OpAMD64VHADDPS128
	OpAMD64VHADDPS256
	OpAMD64VHSUBPD128
	OpAMD64VHSUBPD256
	OpAMD64VHSUBPS128
	OpAMD64VHSUBPS256
	OpAMD64VMAXPD128
	OpAMD64VMAXPD256
	OpAMD64VMAXPD512
	OpAMD64VMAXPDMasked128
	OpAMD64VMAXPDMasked256
	OpAMD64VMAXPDMasked512
	OpAMD64VMAXPS128
	OpAMD64VMAXPS256
	OpAMD64VMAXPS512
	OpAMD64VMAXPSMasked128
	OpAMD64VMAXPSMasked256
	OpAMD64VMAXPSMasked512
	OpAMD64VMINPD128
	OpAMD64VMINPD256
	OpAMD64VMINPD512
	OpAMD64VMINPDMasked128
	OpAMD64VMINPDMasked256
	OpAMD64VMINPDMasked512
	OpAMD64VMINPS128
	OpAMD64VMINPS256
	OpAMD64VMINPS512
	OpAMD64VMINPSMasked128
	OpAMD64VMINPSMasked256
	OpAMD64VMINPSMasked512
	OpAMD64VMOVDQU8Masked128
	OpAMD64VMOVDQU8Masked256
	OpAMD64VMOVDQU8Masked512
	OpAMD64VMOVDQU16Masked128
	OpAMD64VMOVDQU16Masked256
	OpAMD64VMOVDQU16Masked512
	OpAMD64VMOVDQU32Masked128
	OpAMD64VMOVDQU32Masked256
	OpAMD64VMOVDQU32Masked512
	OpAMD64VMOVDQU64Masked128
	OpAMD64VMOVDQU64Masked256
	OpAMD64VMOVDQU64Masked512
	OpAMD64VMULPD128
	OpAMD64VMULPD256
	OpAMD64VMULPD512
	OpAMD64VMULPDMasked128
	OpAMD64VMULPDMasked256
	OpAMD64VMULPDMasked512
	OpAMD64VMULPS128
	OpAMD64VMULPS256
	OpAMD64VMULPS512
	OpAMD64VMULPSMasked128
	OpAMD64VMULPSMasked256
	OpAMD64VMULPSMasked512
	OpAMD64VPABSB128
	OpAMD64VPABSB256
	OpAMD64VPABSB512
	OpAMD64VPABSBMasked128
	OpAMD64VPABSBMasked256
	OpAMD64VPABSBMasked512
	OpAMD64VPABSD128
	OpAMD64VPABSD256
	OpAMD64VPABSD512
	OpAMD64VPABSDMasked128
	OpAMD64VPABSDMasked256
	OpAMD64VPABSDMasked512
	OpAMD64VPABSQ128
	OpAMD64VPABSQ256
	OpAMD64VPABSQ512
	OpAMD64VPABSQMasked128
	OpAMD64VPABSQMasked256
	OpAMD64VPABSQMasked512
	OpAMD64VPABSW128
	OpAMD64VPABSW256
	OpAMD64VPABSW512
	OpAMD64VPABSWMasked128
	OpAMD64VPABSWMasked256
	OpAMD64VPABSWMasked512
	OpAMD64VPACKSSDW128
	OpAMD64VPACKSSDW256
	OpAMD64VPACKSSDW512
	OpAMD64VPACKSSDWMasked128
	OpAMD64VPACKSSDWMasked256
	OpAMD64VPACKSSDWMasked512
	OpAMD64VPACKUSDW128
	OpAMD64VPACKUSDW256
	OpAMD64VPACKUSDW512
	OpAMD64VPACKUSDWMasked128
	OpAMD64VPACKUSDWMasked256
	OpAMD64VPACKUSDWMasked512
	OpAMD64VPADDB128
	OpAMD64VPADDB256
	OpAMD64VPADDB512
	OpAMD64VPADDBMasked128
	OpAMD64VPADDBMasked256
	OpAMD64VPADDBMasked512
	OpAMD64VPADDD128
	OpAMD64VPADDD256
	OpAMD64VPADDD512
	OpAMD64VPADDDMasked128
	OpAMD64VPADDDMasked256
	OpAMD64VPADDDMasked512
	OpAMD64VPADDQ128
	OpAMD64VPADDQ256
	OpAMD64VPADDQ512
	OpAMD64VPADDQMasked128
	OpAMD64VPADDQMasked256
	OpAMD64VPADDQMasked512
	OpAMD64VPADDSB128
	OpAMD64VPADDSB256
	OpAMD64VPADDSB512
	OpAMD64VPADDSBMasked128
	OpAMD64VPADDSBMasked256
	OpAMD64VPADDSBMasked512
	OpAMD64VPADDSW128
	OpAMD64VPADDSW256
	OpAMD64VPADDSW512
	OpAMD64VPADDSWMasked128
	OpAMD64VPADDSWMasked256
	OpAMD64VPADDSWMasked512
	OpAMD64VPADDUSB128
	OpAMD64VPADDUSB256
	OpAMD64VPADDUSB512
	OpAMD64VPADDUSBMasked128
	OpAMD64VPADDUSBMasked256
	OpAMD64VPADDUSBMasked512
	OpAMD64VPADDUSW128
	OpAMD64VPADDUSW256
	OpAMD64VPADDUSW512
	OpAMD64VPADDUSWMasked128
	OpAMD64VPADDUSWMasked256
	OpAMD64VPADDUSWMasked512
	OpAMD64VPADDW128
	OpAMD64VPADDW256
	OpAMD64VPADDW512
	OpAMD64VPADDWMasked128
	OpAMD64VPADDWMasked256
	OpAMD64VPADDWMasked512
	OpAMD64VPAND128
	OpAMD64VPAND256
	OpAMD64VPANDD512
	OpAMD64VPANDDMasked128
	OpAMD64VPANDDMasked256
	OpAMD64VPANDDMasked512
	OpAMD64VPANDN128
	OpAMD64VPANDN256
	OpAMD64VPANDND512
	OpAMD64VPANDNDMasked128
	OpAMD64VPANDNDMasked256
	OpAMD64VPANDNDMasked512
	OpAMD64VPANDNQ512
	OpAMD64VPANDNQMasked128
	OpAMD64VPANDNQMasked256
	OpAMD64VPANDNQMasked512
	OpAMD64VPANDQ512
	OpAMD64VPANDQMasked128
	OpAMD64VPANDQMasked256
	OpAMD64VPANDQMasked512
	OpAMD64VPAVGB128
	OpAMD64VPAVGB256
	OpAMD64VPAVGB512
	OpAMD64VPAVGBMasked128
	OpAMD64VPAVGBMasked256
	OpAMD64VPAVGBMasked512
	OpAMD64VPAVGW128
	OpAMD64VPAVGW256
	OpAMD64VPAVGW512
	OpAMD64VPAVGWMasked128
	OpAMD64VPAVGWMasked256
	OpAMD64VPAVGWMasked512
	OpAMD64VPBLENDMBMasked512
	OpAMD64VPBLENDMDMasked512
	OpAMD64VPBLENDMQMasked512
	OpAMD64VPBLENDMWMasked512
	OpAMD64VPBLENDVB128
	OpAMD64VPBLENDVB256
	OpAMD64VPBROADCASTB128
	OpAMD64VPBROADCASTB256
	OpAMD64VPBROADCASTB512
	OpAMD64VPBROADCASTBMasked128
	OpAMD64VPBROADCASTBMasked256
	OpAMD64VPBROADCASTBMasked512
	OpAMD64VPBROADCASTD128
	OpAMD64VPBROADCASTD256
	OpAMD64VPBROADCASTD512
	OpAMD64VPBROADCASTDMasked128
	OpAMD64VPBROADCASTDMasked256
	OpAMD64VPBROADCASTDMasked512
	OpAMD64VPBROADCASTQ128
	OpAMD64VPBROADCASTQ256
	OpAMD64VPBROADCASTQ512
	OpAMD64VPBROADCASTQMasked128
	OpAMD64VPBROADCASTQMasked256
	OpAMD64VPBROADCASTQMasked512
	OpAMD64VPBROADCASTW128
	OpAMD64VPBROADCASTW256
	OpAMD64VPBROADCASTW512
	OpAMD64VPBROADCASTWMasked128
	OpAMD64VPBROADCASTWMasked256
	OpAMD64VPBROADCASTWMasked512
	OpAMD64VPCMPEQB128
	OpAMD64VPCMPEQB256
	OpAMD64VPCMPEQB512
	OpAMD64VPCMPEQD128
	OpAMD64VPCMPEQD256
	OpAMD64VPCMPEQD512
	OpAMD64VPCMPEQQ128
	OpAMD64VPCMPEQQ256
	OpAMD64VPCMPEQQ512
	OpAMD64VPCMPEQW128
	OpAMD64VPCMPEQW256
	OpAMD64VPCMPEQW512
	OpAMD64VPCMPGTB128
	OpAMD64VPCMPGTB256
	OpAMD64VPCMPGTB512
	OpAMD64VPCMPGTD128
	OpAMD64VPCMPGTD256
	OpAMD64VPCMPGTD512
	OpAMD64VPCMPGTQ128
	OpAMD64VPCMPGTQ256
	OpAMD64VPCMPGTQ512
	OpAMD64VPCMPGTW128
	OpAMD64VPCMPGTW256
	OpAMD64VPCMPGTW512
	OpAMD64VPCOMPRESSBMasked128
	OpAMD64VPCOMPRESSBMasked256
	OpAMD64VPCOMPRESSBMasked512
	OpAMD64VPCOMPRESSDMasked128
	OpAMD64VPCOMPRESSDMasked256
	OpAMD64VPCOMPRESSDMasked512
	OpAMD64VPCOMPRESSQMasked128
	OpAMD64VPCOMPRESSQMasked256
	OpAMD64VPCOMPRESSQMasked512
	OpAMD64VPCOMPRESSWMasked128
	OpAMD64VPCOMPRESSWMasked256
	OpAMD64VPCOMPRESSWMasked512
	OpAMD64VPDPWSSD128
	OpAMD64VPDPWSSD256
	OpAMD64VPDPWSSD512
	OpAMD64VPDPWSSDMasked128
	OpAMD64VPDPWSSDMasked256
	OpAMD64VPDPWSSDMasked512
	OpAMD64VPERMB128
	OpAMD64VPERMB256
	OpAMD64VPERMB512
	OpAMD64VPERMBMasked128
	OpAMD64VPERMBMasked256
	OpAMD64VPERMBMasked512
	OpAMD64VPERMD256
	OpAMD64VPERMD512
	OpAMD64VPERMDMasked256
	OpAMD64VPERMDMasked512
	OpAMD64VPERMI2B128
	OpAMD64VPERMI2B256
	OpAMD64VPERMI2B512
	OpAMD64VPERMI2BMasked128
	OpAMD64VPERMI2BMasked256
	OpAMD64VPERMI2BMasked512
	OpAMD64VPERMI2D128
	OpAMD64VPERMI2D256
	OpAMD64VPERMI2D512
	OpAMD64VPERMI2DMasked128
	OpAMD64VPERMI2DMasked256
	OpAMD64VPERMI2DMasked512
	OpAMD64VPERMI2PD128
	OpAMD64VPERMI2PD256
	OpAMD64VPERMI2PD512
	OpAMD64VPERMI2PDMasked128
	OpAMD64VPERMI2PDMasked256
	OpAMD64VPERMI2PDMasked512
	OpAMD64VPERMI2PS128
	OpAMD64VPERMI2PS256
	OpAMD64VPERMI2PS512
	OpAMD64VPERMI2PSMasked128
	OpAMD64VPERMI2PSMasked256
	OpAMD64VPERMI2PSMasked512
	OpAMD64VPERMI2Q128
	OpAMD64VPERMI2Q256
	OpAMD64VPERMI2Q512
	OpAMD64VPERMI2QMasked128
	OpAMD64VPERMI2QMasked256
	OpAMD64VPERMI2QMasked512
	OpAMD64VPERMI2W128
	OpAMD64VPERMI2W256
	OpAMD64VPERMI2W512
	OpAMD64VPERMI2WMasked128
	OpAMD64VPERMI2WMasked256
	OpAMD64VPERMI2WMasked512
	OpAMD64VPERMPD256
	OpAMD64VPERMPD512
	OpAMD64VPERMPDMasked256
	OpAMD64VPERMPDMasked512
	OpAMD64VPERMPS256
	OpAMD64VPERMPS512
	OpAMD64VPERMPSMasked256
	OpAMD64VPERMPSMasked512
	OpAMD64VPERMQ256
	OpAMD64VPERMQ512
	OpAMD64VPERMQMasked256
	OpAMD64VPERMQMasked512
	OpAMD64VPERMW128
	OpAMD64VPERMW256
	OpAMD64VPERMW512
	OpAMD64VPERMWMasked128
	OpAMD64VPERMWMasked256
	OpAMD64VPERMWMasked512
	OpAMD64VPEXPANDBMasked128
	OpAMD64VPEXPANDBMasked256
	OpAMD64VPEXPANDBMasked512
	OpAMD64VPEXPANDDMasked128
	OpAMD64VPEXPANDDMasked256
	OpAMD64VPEXPANDDMasked512
	OpAMD64VPEXPANDQMasked128
	OpAMD64VPEXPANDQMasked256
	OpAMD64VPEXPANDQMasked512
	OpAMD64VPEXPANDWMasked128
	OpAMD64VPEXPANDWMasked256
	OpAMD64VPEXPANDWMasked512
	OpAMD64VPHADDD128
	OpAMD64VPHADDD256
	OpAMD64VPHADDSW128
	OpAMD64VPHADDSW256
	OpAMD64VPHADDW128
	OpAMD64VPHADDW256
	OpAMD64VPHSUBD128
	OpAMD64VPHSUBD256
	OpAMD64VPHSUBSW128
	OpAMD64VPHSUBSW256
	OpAMD64VPHSUBW128
	OpAMD64VPHSUBW256
	OpAMD64VPLZCNTD128
	OpAMD64VPLZCNTD256
	OpAMD64VPLZCNTD512
	OpAMD64VPLZCNTDMasked128
	OpAMD64VPLZCNTDMasked256
	OpAMD64VPLZCNTDMasked512
	OpAMD64VPLZCNTQ128
	OpAMD64VPLZCNTQ256
	OpAMD64VPLZCNTQ512
	OpAMD64VPLZCNTQMasked128
	OpAMD64VPLZCNTQMasked256
	OpAMD64VPLZCNTQMasked512
	OpAMD64VPMADDUBSW128
	OpAMD64VPMADDUBSW256
	OpAMD64VPMADDUBSW512
	OpAMD64VPMADDUBSWMasked128
	OpAMD64VPMADDUBSWMasked256
	OpAMD64VPMADDUBSWMasked512
	OpAMD64VPMADDWD128
	OpAMD64VPMADDWD256
	OpAMD64VPMADDWD512
	OpAMD64VPMADDWDMasked128
	OpAMD64VPMADDWDMasked256
	OpAMD64VPMADDWDMasked512
	OpAMD64VPMAXSB128
	OpAMD64VPMAXSB256
	OpAMD64VPMAXSB512
	OpAMD64VPMAXSBMasked128
	OpAMD64VPMAXSBMasked256
	OpAMD64VPMAXSBMasked512
	OpAMD64VPMAXSD128
	OpAMD64VPMAXSD256
	OpAMD64VPMAXSD512
	OpAMD64VPMAXSDMasked128
	OpAMD64VPMAXSDMasked256
	OpAMD64VPMAXSDMasked512
	OpAMD64VPMAXSQ128
	OpAMD64VPMAXSQ256
	OpAMD64VPMAXSQ512
	OpAMD64VPMAXSQMasked128
	OpAMD64VPMAXSQMasked256
	OpAMD64VPMAXSQMasked512
	OpAMD64VPMAXSW128
	OpAMD64VPMAXSW256
	OpAMD64VPMAXSW512
	OpAMD64VPMAXSWMasked128
	OpAMD64VPMAXSWMasked256
	OpAMD64VPMAXSWMasked512
	OpAMD64VPMAXUB128
	OpAMD64VPMAXUB256
	OpAMD64VPMAXUB512
	OpAMD64VPMAXUBMasked128
	OpAMD64VPMAXUBMasked256
	OpAMD64VPMAXUBMasked512
	OpAMD64VPMAXUD128
	OpAMD64VPMAXUD256
	OpAMD64VPMAXUD512
	OpAMD64VPMAXUDMasked128
	OpAMD64VPMAXUDMasked256
	OpAMD64VPMAXUDMasked512
	OpAMD64VPMAXUQ128
	OpAMD64VPMAXUQ256
	OpAMD64VPMAXUQ512
	OpAMD64VPMAXUQMasked128
	OpAMD64VPMAXUQMasked256
	OpAMD64VPMAXUQMasked512
	OpAMD64VPMAXUW128
	OpAMD64VPMAXUW256
	OpAMD64VPMAXUW512
	OpAMD64VPMAXUWMasked128
	OpAMD64VPMAXUWMasked256
	OpAMD64VPMAXUWMasked512
	OpAMD64VPMINSB128
	OpAMD64VPMINSB256
	OpAMD64VPMINSB512
	OpAMD64VPMINSBMasked128
	OpAMD64VPMINSBMasked256
	OpAMD64VPMINSBMasked512
	OpAMD64VPMINSD128
	OpAMD64VPMINSD256
	OpAMD64VPMINSD512
	OpAMD64VPMINSDMasked128
	OpAMD64VPMINSDMasked256
	OpAMD64VPMINSDMasked512
	OpAMD64VPMINSQ128
	OpAMD64VPMINSQ256
	OpAMD64VPMINSQ512
	OpAMD64VPMINSQMasked128
	OpAMD64VPMINSQMasked256
	OpAMD64VPMINSQMasked512
	OpAMD64VPMINSW128
	OpAMD64VPMINSW256
	OpAMD64VPMINSW512
	OpAMD64VPMINSWMasked128
	OpAMD64VPMINSWMasked256
	OpAMD64VPMINSWMasked512
	OpAMD64VPMINUB128
	OpAMD64VPMINUB256
	OpAMD64VPMINUB512
	OpAMD64VPMINUBMasked128
	OpAMD64VPMINUBMasked256
	OpAMD64VPMINUBMasked512
	OpAMD64VPMINUD128
	OpAMD64VPMINUD256
	OpAMD64VPMINUD512
	OpAMD64VPMINUDMasked128
	OpAMD64VPMINUDMasked256
	OpAMD64VPMINUDMasked512
	OpAMD64VPMINUQ128
	OpAMD64VPMINUQ256
	OpAMD64VPMINUQ512
	OpAMD64VPMINUQMasked128
	OpAMD64VPMINUQMasked256
	OpAMD64VPMINUQMasked512
	OpAMD64VPMINUW128
	OpAMD64VPMINUW256
	OpAMD64VPMINUW512
	OpAMD64VPMINUWMasked128
	OpAMD64VPMINUWMasked256
	OpAMD64VPMINUWMasked512
	OpAMD64VPMOVDB128_128
	OpAMD64VPMOVDB128_256
	OpAMD64VPMOVDB128_512
	OpAMD64VPMOVDBMasked128_128
	OpAMD64VPMOVDBMasked128_256
	OpAMD64VPMOVDBMasked128_512
	OpAMD64VPMOVDW128_128
	OpAMD64VPMOVDW128_256
	OpAMD64VPMOVDW256
	OpAMD64VPMOVDWMasked128_128
	OpAMD64VPMOVDWMasked128_256
	OpAMD64VPMOVDWMasked256
	OpAMD64VPMOVQB128_128
	OpAMD64VPMOVQB128_256
	OpAMD64VPMOVQB128_512
	OpAMD64VPMOVQBMasked128_128
	OpAMD64VPMOVQBMasked128_256
	OpAMD64VPMOVQBMasked128_512
	OpAMD64VPMOVQD128_128
	OpAMD64VPMOVQD128_256
	OpAMD64VPMOVQD256
	OpAMD64VPMOVQDMasked128_128
	OpAMD64VPMOVQDMasked128_256
	OpAMD64VPMOVQDMasked256
	OpAMD64VPMOVQW128_128
	OpAMD64VPMOVQW128_256
	OpAMD64VPMOVQW128_512
	OpAMD64VPMOVQWMasked128_128
	OpAMD64VPMOVQWMasked128_256
	OpAMD64VPMOVQWMasked128_512
	OpAMD64VPMOVSDB128_128
	OpAMD64VPMOVSDB128_256
	OpAMD64VPMOVSDB128_512
	OpAMD64VPMOVSDBMasked128_128
	OpAMD64VPMOVSDBMasked128_256
	OpAMD64VPMOVSDBMasked128_512
	OpAMD64VPMOVSDW128_128
	OpAMD64VPMOVSDW128_256
	OpAMD64VPMOVSDW256
	OpAMD64VPMOVSDWMasked128_128
	OpAMD64VPMOVSDWMasked128_256
	OpAMD64VPMOVSDWMasked256
	OpAMD64VPMOVSQB128_128
	OpAMD64VPMOVSQB128_256
	OpAMD64VPMOVSQB128_512
	OpAMD64VPMOVSQBMasked128_128
	OpAMD64VPMOVSQBMasked128_256
	OpAMD64VPMOVSQBMasked128_512
	OpAMD64VPMOVSQD128_128
	OpAMD64VPMOVSQD128_256
	OpAMD64VPMOVSQD256
	OpAMD64VPMOVSQDMasked128_128
	OpAMD64VPMOVSQDMasked128_256
	OpAMD64VPMOVSQDMasked256
	OpAMD64VPMOVSQW128_128
	OpAMD64VPMOVSQW128_256
	OpAMD64VPMOVSQW128_512
	OpAMD64VPMOVSQWMasked128_128
	OpAMD64VPMOVSQWMasked128_256
	OpAMD64VPMOVSQWMasked128_512
	OpAMD64VPMOVSWB128_128
	OpAMD64VPMOVSWB128_256
	OpAMD64VPMOVSWB256
	OpAMD64VPMOVSWBMasked128_128
	OpAMD64VPMOVSWBMasked128_256
	OpAMD64VPMOVSWBMasked256
	OpAMD64VPMOVSXBD128
	OpAMD64VPMOVSXBD256
	OpAMD64VPMOVSXBD512
	OpAMD64VPMOVSXBDMasked128
	OpAMD64VPMOVSXBDMasked256
	OpAMD64VPMOVSXBDMasked512
	OpAMD64VPMOVSXBQ128
	OpAMD64VPMOVSXBQ256
	OpAMD64VPMOVSXBQ512
	OpAMD64VPMOVSXBQMasked128
	OpAMD64VPMOVSXBQMasked256
	OpAMD64VPMOVSXBQMasked512
	OpAMD64VPMOVSXBW128
	OpAMD64VPMOVSXBW256
	OpAMD64VPMOVSXBW512
	OpAMD64VPMOVSXBWMasked128
	OpAMD64VPMOVSXBWMasked256
	OpAMD64VPMOVSXBWMasked512
	OpAMD64VPMOVSXDQ128
	OpAMD64VPMOVSXDQ256
	OpAMD64VPMOVSXDQ512
	OpAMD64VPMOVSXDQMasked128
	OpAMD64VPMOVSXDQMasked256
	OpAMD64VPMOVSXDQMasked512
	OpAMD64VPMOVSXWD128
	OpAMD64VPMOVSXWD256
	OpAMD64VPMOVSXWD512
	OpAMD64VPMOVSXWDMasked128
	OpAMD64VPMOVSXWDMasked256
	OpAMD64VPMOVSXWDMasked512
	OpAMD64VPMOVSXWQ128
	OpAMD64VPMOVSXWQ256
	OpAMD64VPMOVSXWQ512
	OpAMD64VPMOVSXWQMasked128
	OpAMD64VPMOVSXWQMasked256
	OpAMD64VPMOVSXWQMasked512
	OpAMD64VPMOVUSDB128_128
	OpAMD64VPMOVUSDB128_256
	OpAMD64VPMOVUSDB128_512
	OpAMD64VPMOVUSDBMasked128_128
	OpAMD64VPMOVUSDBMasked128_256
	OpAMD64VPMOVUSDBMasked128_512
	OpAMD64VPMOVUSDW128_128
	OpAMD64VPMOVUSDW128_256
	OpAMD64VPMOVUSDW256
	OpAMD64VPMOVUSDWMasked128_128
	OpAMD64VPMOVUSDWMasked128_256
	OpAMD64VPMOVUSDWMasked256
	OpAMD64VPMOVUSQB128_128
	OpAMD64VPMOVUSQB128_256
	OpAMD64VPMOVUSQB128_512
	OpAMD64VPMOVUSQBMasked128_128
	OpAMD64VPMOVUSQBMasked128_256
	OpAMD64VPMOVUSQBMasked128_512
	OpAMD64VPMOVUSQD128_128
	OpAMD64VPMOVUSQD128_256
	OpAMD64VPMOVUSQD256
	OpAMD64VPMOVUSQDMasked128_128
	OpAMD64VPMOVUSQDMasked128_256
	OpAMD64VPMOVUSQDMasked256
	OpAMD64VPMOVUSQW128_128
	OpAMD64VPMOVUSQW128_256
	OpAMD64VPMOVUSQW128_512
	OpAMD64VPMOVUSQWMasked128_128
	OpAMD64VPMOVUSQWMasked128_256
	OpAMD64VPMOVUSQWMasked128_512
	OpAMD64VPMOVUSWB128_128
	OpAMD64VPMOVUSWB128_256
	OpAMD64VPMOVUSWB256
	OpAMD64VPMOVUSWBMasked128_128
	OpAMD64VPMOVUSWBMasked128_256
	OpAMD64VPMOVUSWBMasked256
	OpAMD64VPMOVWB128_128
	OpAMD64VPMOVWB128_256
	OpAMD64VPMOVWB256
	OpAMD64VPMOVWBMasked128_128
	OpAMD64VPMOVWBMasked128_256
	OpAMD64VPMOVWBMasked256
	OpAMD64VPMOVZXBD128
	OpAMD64VPMOVZXBD256
	OpAMD64VPMOVZXBD512
	OpAMD64VPMOVZXBDMasked128
	OpAMD64VPMOVZXBDMasked256
	OpAMD64VPMOVZXBDMasked512
	OpAMD64VPMOVZXBQ128
	OpAMD64VPMOVZXBQ256
	OpAMD64VPMOVZXBQ512
	OpAMD64VPMOVZXBQMasked128
	OpAMD64VPMOVZXBQMasked256
	OpAMD64VPMOVZXBQMasked512
	OpAMD64VPMOVZXBW128
	OpAMD64VPMOVZXBW256
	OpAMD64VPMOVZXBW512
	OpAMD64VPMOVZXBWMasked128
	OpAMD64VPMOVZXBWMasked256
	OpAMD64VPMOVZXBWMasked512
	OpAMD64VPMOVZXDQ128
	OpAMD64VPMOVZXDQ256
	OpAMD64VPMOVZXDQ512
	OpAMD64VPMOVZXDQMasked128
	OpAMD64VPMOVZXDQMasked256
	OpAMD64VPMOVZXDQMasked512
	OpAMD64VPMOVZXWD128
	OpAMD64VPMOVZXWD256
	OpAMD64VPMOVZXWD512
	OpAMD64VPMOVZXWDMasked128
	OpAMD64VPMOVZXWDMasked256
	OpAMD64VPMOVZXWDMasked512
	OpAMD64VPMOVZXWQ128
	OpAMD64VPMOVZXWQ256
	OpAMD64VPMOVZXWQ512
	OpAMD64VPMOVZXWQMasked128
	OpAMD64VPMOVZXWQMasked256
	OpAMD64VPMOVZXWQMasked512
	OpAMD64VPMULDQ128
	OpAMD64VPMULDQ256
	OpAMD64VPMULHUW128
	OpAMD64VPMULHUW256
	OpAMD64VPMULHUW512
	OpAMD64VPMULHUWMasked128
	OpAMD64VPMULHUWMasked256
	OpAMD64VPMULHUWMasked512
	OpAMD64VPMULHW128
	OpAMD64VPMULHW256
	OpAMD64VPMULHW512
	OpAMD64VPMULHWMasked128
	OpAMD64VPMULHWMasked256
	OpAMD64VPMULHWMasked512
	OpAMD64VPMULLD128
	OpAMD64VPMULLD256
	OpAMD64VPMULLD512
	OpAMD64VPMULLDMasked128
	OpAMD64VPMULLDMasked256
	OpAMD64VPMULLDMasked512
	OpAMD64VPMULLQ128
	OpAMD64VPMULLQ256
	OpAMD64VPMULLQ512
	OpAMD64VPMULLQMasked128
	OpAMD64VPMULLQMasked256
	OpAMD64VPMULLQMasked512
	OpAMD64VPMULLW128
	OpAMD64VPMULLW256
	OpAMD64VPMULLW512
	OpAMD64VPMULLWMasked128
	OpAMD64VPMULLWMasked256
	OpAMD64VPMULLWMasked512
	OpAMD64VPMULUDQ128
	OpAMD64VPMULUDQ256
	OpAMD64VPOPCNTB128
	OpAMD64VPOPCNTB256
	OpAMD64VPOPCNTB512
	OpAMD64VPOPCNTBMasked128
	OpAMD64VPOPCNTBMasked256
	OpAMD64VPOPCNTBMasked512
	OpAMD64VPOPCNTD128
	OpAMD64VPOPCNTD256
	OpAMD64VPOPCNTD512
	OpAMD64VPOPCNTDMasked128
	OpAMD64VPOPCNTDMasked256
	OpAMD64VPOPCNTDMasked512
	OpAMD64VPOPCNTQ128
	OpAMD64VPOPCNTQ256
	OpAMD64VPOPCNTQ512
	OpAMD64VPOPCNTQMasked128
	OpAMD64VPOPCNTQMasked256
	OpAMD64VPOPCNTQMasked512
	OpAMD64VPOPCNTW128
	OpAMD64VPOPCNTW256
	OpAMD64VPOPCNTW512
	OpAMD64VPOPCNTWMasked128
	OpAMD64VPOPCNTWMasked256
	OpAMD64VPOPCNTWMasked512
	OpAMD64VPOR128
	OpAMD64VPOR256
	OpAMD64VPORD512
	OpAMD64VPORDMasked128
	OpAMD64VPORDMasked256
	OpAMD64VPORDMasked512
	OpAMD64VPORQ512
	OpAMD64VPORQMasked128
	OpAMD64VPORQMasked256
	OpAMD64VPORQMasked512
	OpAMD64VPROLVD128
	OpAMD64VPROLVD256
	OpAMD64VPROLVD512
	OpAMD64VPROLVDMasked128
	OpAMD64VPROLVDMasked256
	OpAMD64VPROLVDMasked512
	OpAMD64VPROLVQ128
	OpAMD64VPROLVQ256
	OpAMD64VPROLVQ512
	OpAMD64VPROLVQMasked128
	OpAMD64VPROLVQMasked256
	OpAMD64VPROLVQMasked512
	OpAMD64VPRORVD128
	OpAMD64VPRORVD256
	OpAMD64VPRORVD512
	OpAMD64VPRORVDMasked128
	OpAMD64VPRORVDMasked256
	OpAMD64VPRORVDMasked512
	OpAMD64VPRORVQ128
	OpAMD64VPRORVQ256
	OpAMD64VPRORVQ512
	OpAMD64VPRORVQMasked128
	OpAMD64VPRORVQMasked256
	OpAMD64VPRORVQMasked512
	OpAMD64VPSADBW128
	OpAMD64VPSADBW256
	OpAMD64VPSADBW512
	OpAMD64VPSHLDVD128
	OpAMD64VPSHLDVD256
	OpAMD64VPSHLDVD512
	OpAMD64VPSHLDVDMasked128
	OpAMD64VPSHLDVDMasked256
	OpAMD64VPSHLDVDMasked512
	OpAMD64VPSHLDVQ128
	OpAMD64VPSHLDVQ256
	OpAMD64VPSHLDVQ512
	OpAMD64VPSHLDVQMasked128
	OpAMD64VPSHLDVQMasked256
	OpAMD64VPSHLDVQMasked512
	OpAMD64VPSHLDVW128
	OpAMD64VPSHLDVW256
	OpAMD64VPSHLDVW512
	OpAMD64VPSHLDVWMasked128
	OpAMD64VPSHLDVWMasked256
	OpAMD64VPSHLDVWMasked512
	OpAMD64VPSHRDVD128
	OpAMD64VPSHRDVD256
	OpAMD64VPSHRDVD512
	OpAMD64VPSHRDVDMasked128
	OpAMD64VPSHRDVDMasked256
	OpAMD64VPSHRDVDMasked512
	OpAMD64VPSHRDVQ128
	OpAMD64VPSHRDVQ256
	OpAMD64VPSHRDVQ512
	OpAMD64VPSHRDVQMasked128
	OpAMD64VPSHRDVQMasked256
	OpAMD64VPSHRDVQMasked512
	OpAMD64VPSHRDVW128
	OpAMD64VPSHRDVW256
	OpAMD64VPSHRDVW512
	OpAMD64VPSHRDVWMasked128
	OpAMD64VPSHRDVWMasked256
	OpAMD64VPSHRDVWMasked512
	OpAMD64VPSHUFB128
	OpAMD64VPSHUFB256
	OpAMD64VPSHUFB512
	OpAMD64VPSHUFBMasked128
	OpAMD64VPSHUFBMasked256
	OpAMD64VPSHUFBMasked512
	OpAMD64VPSIGNB128
	OpAMD64VPSIGNB256
	OpAMD64VPSIGND128
	OpAMD64VPSIGND256
	OpAMD64VPSIGNW128
	OpAMD64VPSIGNW256
	OpAMD64VPSLLD128
	OpAMD64VPSLLD256
	OpAMD64VPSLLD512
	OpAMD64VPSLLDMasked128
	OpAMD64VPSLLDMasked256
	OpAMD64VPSLLDMasked512
	OpAMD64VPSLLQ128
	OpAMD64VPSLLQ256
	OpAMD64VPSLLQ512
	OpAMD64VPSLLQMasked128
	OpAMD64VPSLLQMasked256
	OpAMD64VPSLLQMasked512
	OpAMD64VPSLLVD128
	OpAMD64VPSLLVD256
	OpAMD64VPSLLVD512
	OpAMD64VPSLLVDMasked128
	OpAMD64VPSLLVDMasked256
	OpAMD64VPSLLVDMasked512
	OpAMD64VPSLLVQ128
	OpAMD64VPSLLVQ256
	OpAMD64VPSLLVQ512
	OpAMD64VPSLLVQMasked128
	OpAMD64VPSLLVQMasked256
	OpAMD64VPSLLVQMasked512
	OpAMD64VPSLLVW128
	OpAMD64VPSLLVW256
	OpAMD64VPSLLVW512
	OpAMD64VPSLLVWMasked128
	OpAMD64VPSLLVWMasked256
	OpAMD64VPSLLVWMasked512
	OpAMD64VPSLLW128
	OpAMD64VPSLLW256
	OpAMD64VPSLLW512
	OpAMD64VPSLLWMasked128
	OpAMD64VPSLLWMasked256
	OpAMD64VPSLLWMasked512
	OpAMD64VPSRAD128
	OpAMD64VPSRAD256
	OpAMD64VPSRAD512
	OpAMD64VPSRADMasked128
	OpAMD64VPSRADMasked256
	OpAMD64VPSRADMasked512
	OpAMD64VPSRAQ128
	OpAMD64VPSRAQ256
	OpAMD64VPSRAQ512
	OpAMD64VPSRAQMasked128
	OpAMD64VPSRAQMasked256
	OpAMD64VPSRAQMasked512
	OpAMD64VPSRAVD128
	OpAMD64VPSRAVD256
	OpAMD64VPSRAVD512
	OpAMD64VPSRAVDMasked128
	OpAMD64VPSRAVDMasked256
	OpAMD64VPSRAVDMasked512
	OpAMD64VPSRAVQ128
	OpAMD64VPSRAVQ256
	OpAMD64VPSRAVQ512
	OpAMD64VPSRAVQMasked128
	OpAMD64VPSRAVQMasked256
	OpAMD64VPSRAVQMasked512
	OpAMD64VPSRAVW128
	OpAMD64VPSRAVW256
	OpAMD64VPSRAVW512
	OpAMD64VPSRAVWMasked128
	OpAMD64VPSRAVWMasked256
	OpAMD64VPSRAVWMasked512
	OpAMD64VPSRAW128
	OpAMD64VPSRAW256
	OpAMD64VPSRAW512
	OpAMD64VPSRAWMasked128
	OpAMD64VPSRAWMasked256
	OpAMD64VPSRAWMasked512
	OpAMD64VPSRLD128
	OpAMD64VPSRLD256
	OpAMD64VPSRLD512
	OpAMD64VPSRLDMasked128
	OpAMD64VPSRLDMasked256
	OpAMD64VPSRLDMasked512
	OpAMD64VPSRLQ128
	OpAMD64VPSRLQ256
	OpAMD64VPSRLQ512
	OpAMD64VPSRLQMasked128
	OpAMD64VPSRLQMasked256
	OpAMD64VPSRLQMasked512
	OpAMD64VPSRLVD128
	OpAMD64VPSRLVD256
	OpAMD64VPSRLVD512
	OpAMD64VPSRLVDMasked128
	OpAMD64VPSRLVDMasked256
	OpAMD64VPSRLVDMasked512
	OpAMD64VPSRLVQ128
	OpAMD64VPSRLVQ256
	OpAMD64VPSRLVQ512
	OpAMD64VPSRLVQMasked128
	OpAMD64VPSRLVQMasked256
	OpAMD64VPSRLVQMasked512
	OpAMD64VPSRLVW128
	OpAMD64VPSRLVW256
	OpAMD64VPSRLVW512
	OpAMD64VPSRLVWMasked128
	OpAMD64VPSRLVWMasked256
	OpAMD64VPSRLVWMasked512
	OpAMD64VPSRLW128
	OpAMD64VPSRLW256
	OpAMD64VPSRLW512
	OpAMD64VPSRLWMasked128
	OpAMD64VPSRLWMasked256
	OpAMD64VPSRLWMasked512
	OpAMD64VPSUBB128
	OpAMD64VPSUBB256
	OpAMD64VPSUBB512
	OpAMD64VPSUBBMasked128
	OpAMD64VPSUBBMasked256
	OpAMD64VPSUBBMasked512
	OpAMD64VPSUBD128
	OpAMD64VPSUBD256
	OpAMD64VPSUBD512
	OpAMD64VPSUBDMasked128
	OpAMD64VPSUBDMasked256
	OpAMD64VPSUBDMasked512
	OpAMD64VPSUBQ128
	OpAMD64VPSUBQ256
	OpAMD64VPSUBQ512
	OpAMD64VPSUBQMasked128
	OpAMD64VPSUBQMasked256
	OpAMD64VPSUBQMasked512
	OpAMD64VPSUBSB128
	OpAMD64VPSUBSB256
	OpAMD64VPSUBSB512
	OpAMD64VPSUBSBMasked128
	OpAMD64VPSUBSBMasked256
	OpAMD64VPSUBSBMasked512
	OpAMD64VPSUBSW128
	OpAMD64VPSUBSW256
	OpAMD64VPSUBSW512
	OpAMD64VPSUBSWMasked128
	OpAMD64VPSUBSWMasked256
	OpAMD64VPSUBSWMasked512
	OpAMD64VPSUBUSB128
	OpAMD64VPSUBUSB256
	OpAMD64VPSUBUSB512
	OpAMD64VPSUBUSBMasked128
	OpAMD64VPSUBUSBMasked256
	OpAMD64VPSUBUSBMasked512
	OpAMD64VPSUBUSW128
	OpAMD64VPSUBUSW256
	OpAMD64VPSUBUSW512
	OpAMD64VPSUBUSWMasked128
	OpAMD64VPSUBUSWMasked256
	OpAMD64VPSUBUSWMasked512
	OpAMD64VPSUBW128
	OpAMD64VPSUBW256
	OpAMD64VPSUBW512
	OpAMD64VPSUBWMasked128
	OpAMD64VPSUBWMasked256
	OpAMD64VPSUBWMasked512
	OpAMD64VPUNPCKHDQ128
	OpAMD64VPUNPCKHDQ256
	OpAMD64VPUNPCKHDQ512
	OpAMD64VPUNPCKHQDQ128
	OpAMD64VPUNPCKHQDQ256
	OpAMD64VPUNPCKHQDQ512
	OpAMD64VPUNPCKHWD128
	OpAMD64VPUNPCKHWD256
	OpAMD64VPUNPCKHWD512
	OpAMD64VPUNPCKLDQ128
	OpAMD64VPUNPCKLDQ256
	OpAMD64VPUNPCKLDQ512
	OpAMD64VPUNPCKLQDQ128
	OpAMD64VPUNPCKLQDQ256
	OpAMD64VPUNPCKLQDQ512
	OpAMD64VPUNPCKLWD128
	OpAMD64VPUNPCKLWD256
	OpAMD64VPUNPCKLWD512
	OpAMD64VPXOR128
	OpAMD64VPXOR256
	OpAMD64VPXORD512
	OpAMD64VPXORDMasked128
	OpAMD64VPXORDMasked256
	OpAMD64VPXORDMasked512
	OpAMD64VPXORQ512
	OpAMD64VPXORQMasked128
	OpAMD64VPXORQMasked256
	OpAMD64VPXORQMasked512
	OpAMD64VRCP14PD128
	OpAMD64VRCP14PD256
	OpAMD64VRCP14PD512
	OpAMD64VRCP14PDMasked128
	OpAMD64VRCP14PDMasked256
	OpAMD64VRCP14PDMasked512
	OpAMD64VRCP14PS512
	OpAMD64VRCP14PSMasked128
	OpAMD64VRCP14PSMasked256
	OpAMD64VRCP14PSMasked512
	OpAMD64VRCPPS128
	OpAMD64VRCPPS256
	OpAMD64VRSQRT14PD128
	OpAMD64VRSQRT14PD256
	OpAMD64VRSQRT14PD512
	OpAMD64VRSQRT14PDMasked128
	OpAMD64VRSQRT14PDMasked256
	OpAMD64VRSQRT14PDMasked512
	OpAMD64VRSQRT14PS512
	OpAMD64VRSQRT14PSMasked128
	OpAMD64VRSQRT14PSMasked256
	OpAMD64VRSQRT14PSMasked512
	OpAMD64VRSQRTPS128
	OpAMD64VRSQRTPS256
	OpAMD64VSCALEFPD128
	OpAMD64VSCALEFPD256
	OpAMD64VSCALEFPD512
	OpAMD64VSCALEFPDMasked128
	OpAMD64VSCALEFPDMasked256
	OpAMD64VSCALEFPDMasked512
	OpAMD64VSCALEFPS128
	OpAMD64VSCALEFPS256
	OpAMD64VSCALEFPS512
	OpAMD64VSCALEFPSMasked128
	OpAMD64VSCALEFPSMasked256
	OpAMD64VSCALEFPSMasked512
	OpAMD64VSQRTPD128
	OpAMD64VSQRTPD256
	OpAMD64VSQRTPD512
	OpAMD64VSQRTPDMasked128
	OpAMD64VSQRTPDMasked256
	OpAMD64VSQRTPDMasked512
	OpAMD64VSQRTPS128
	OpAMD64VSQRTPS256
	OpAMD64VSQRTPS512
	OpAMD64VSQRTPSMasked128
	OpAMD64VSQRTPSMasked256
	OpAMD64VSQRTPSMasked512
	OpAMD64VSUBPD128
	OpAMD64VSUBPD256
	OpAMD64VSUBPD512
	OpAMD64VSUBPDMasked128
	OpAMD64VSUBPDMasked256
	OpAMD64VSUBPDMasked512
	OpAMD64VSUBPS128
	OpAMD64VSUBPS256
	OpAMD64VSUBPS512
	OpAMD64VSUBPSMasked128
	OpAMD64VSUBPSMasked256
	OpAMD64VSUBPSMasked512
	OpAMD64SHA1RNDS4128
	OpAMD64VAESKEYGENASSIST128
	OpAMD64VCMPPD128
	OpAMD64VCMPPD256
	OpAMD64VCMPPD512
	OpAMD64VCMPPDMasked128
	OpAMD64VCMPPDMasked256
	OpAMD64VCMPPDMasked512
	OpAMD64VCMPPS128
	OpAMD64VCMPPS256
	OpAMD64VCMPPS512
	OpAMD64VCMPPSMasked128
	OpAMD64VCMPPSMasked256
	OpAMD64VCMPPSMasked512
	OpAMD64VEXTRACTF64X4256
	OpAMD64VEXTRACTF128128
	OpAMD64VEXTRACTI64X4256
	OpAMD64VEXTRACTI128128
	OpAMD64VGF2P8AFFINEINVQB128
	OpAMD64VGF2P8AFFINEINVQB256
	OpAMD64VGF2P8AFFINEINVQB512
	OpAMD64VGF2P8AFFINEINVQBMasked128
	OpAMD64VGF2P8AFFINEINVQBMasked256
	OpAMD64VGF2P8AFFINEINVQBMasked512
	OpAMD64VGF2P8AFFINEQB128
	OpAMD64VGF2P8AFFINEQB256
	OpAMD64VGF2P8AFFINEQB512
	OpAMD64VGF2P8AFFINEQBMasked128
	OpAMD64VGF2P8AFFINEQBMasked256
	OpAMD64VGF2P8AFFINEQBMasked512
	OpAMD64VINSERTF64X4512
	OpAMD64VINSERTF128256
	OpAMD64VINSERTI64X4512
	OpAMD64VINSERTI128256
	OpAMD64VPALIGNR128
	OpAMD64VPALIGNR256
	OpAMD64VPALIGNR512
	OpAMD64VPALIGNRMasked128
	OpAMD64VPALIGNRMasked256
	OpAMD64VPALIGNRMasked512
	OpAMD64VPCLMULQDQ128
	OpAMD64VPCLMULQDQ256
	OpAMD64VPCLMULQDQ512
	OpAMD64VPCMPB512
	OpAMD64VPCMPBMasked128
	OpAMD64VPCMPBMasked256
	OpAMD64VPCMPBMasked512
	OpAMD64VPCMPD512
	OpAMD64VPCMPDMasked128
	OpAMD64VPCMPDMasked256
	OpAMD64VPCMPDMasked512
	OpAMD64VPCMPQ512
	OpAMD64VPCMPQMasked128
	OpAMD64VPCMPQMasked256
	OpAMD64VPCMPQMasked512
	OpAMD64VPCMPUB512
	OpAMD64VPCMPUBMasked128
	OpAMD64VPCMPUBMasked256
	OpAMD64VPCMPUBMasked512
	OpAMD64VPCMPUD512
	OpAMD64VPCMPUDMasked128
	OpAMD64VPCMPUDMasked256
	OpAMD64VPCMPUDMasked512
	OpAMD64VPCMPUQ512
	OpAMD64VPCMPUQMasked128
	OpAMD64VPCMPUQMasked256
	OpAMD64VPCMPUQMasked512
	OpAMD64VPCMPUW512
	OpAMD64VPCMPUWMasked128
	OpAMD64VPCMPUWMasked256
	OpAMD64VPCMPUWMasked512
	OpAMD64VPCMPW512
	OpAMD64VPCMPWMasked128
	OpAMD64VPCMPWMasked256
	OpAMD64VPCMPWMasked512
	OpAMD64VPERM2F128256
	OpAMD64VPERM2I128256
	OpAMD64VPEXTRB128
	OpAMD64VPEXTRD128
	OpAMD64VPEXTRQ128
	OpAMD64VPEXTRW128
	OpAMD64VPINSRB128
	OpAMD64VPINSRD128
	OpAMD64VPINSRQ128
	OpAMD64VPINSRW128
	OpAMD64VPROLD128
	OpAMD64VPROLD256
	OpAMD64VPROLD512
	OpAMD64VPROLDMasked128
	OpAMD64VPROLDMasked256
	OpAMD64VPROLDMasked512
	OpAMD64VPROLQ128
	OpAMD64VPROLQ256
	OpAMD64VPROLQ512
	OpAMD64VPROLQMasked128
	OpAMD64VPROLQMasked256
	OpAMD64VPROLQMasked512
	OpAMD64VPRORD128
	OpAMD64VPRORD256
	OpAMD64VPRORD512
	OpAMD64VPRORDMasked128
	OpAMD64VPRORDMasked256
	OpAMD64VPRORDMasked512
	OpAMD64VPRORQ128
	OpAMD64VPRORQ256
	OpAMD64VPRORQ512
	OpAMD64VPRORQMasked128
	OpAMD64VPRORQMasked256
	OpAMD64VPRORQMasked512
	OpAMD64VPSHLDD128
	OpAMD64VPSHLDD256
	OpAMD64VPSHLDD512
	OpAMD64VPSHLDDMasked128
	OpAMD64VPSHLDDMasked256
	OpAMD64VPSHLDDMasked512
	OpAMD64VPSHLDQ128
	OpAMD64VPSHLDQ256
	OpAMD64VPSHLDQ512
	OpAMD64VPSHLDQMasked128
	OpAMD64VPSHLDQMasked256
	OpAMD64VPSHLDQMasked512
	OpAMD64VPSHLDW128
	OpAMD64VPSHLDW256
	OpAMD64VPSHLDW512
	OpAMD64VPSHLDWMasked128
	OpAMD64VPSHLDWMasked256
	OpAMD64VPSHLDWMasked512
	OpAMD64VPSHRDD128
	OpAMD64VPSHRDD256
	OpAMD64VPSHRDD512
	OpAMD64VPSHRDDMasked128
	OpAMD64VPSHRDDMasked256
	OpAMD64VPSHRDDMasked512
	OpAMD64VPSHRDQ128
	OpAMD64VPSHRDQ256
	OpAMD64VPSHRDQ512
	OpAMD64VPSHRDQMasked128
	OpAMD64VPSHRDQMasked256
	OpAMD64VPSHRDQMasked512
	OpAMD64VPSHRDW128
	OpAMD64VPSHRDW256
	OpAMD64VPSHRDW512
	OpAMD64VPSHRDWMasked128
	OpAMD64VPSHRDWMasked256
	OpAMD64VPSHRDWMasked512
	OpAMD64VPSHUFD128
	OpAMD64VPSHUFD256
	OpAMD64VPSHUFD512
	OpAMD64VPSHUFDMasked128
	OpAMD64VPSHUFDMasked256
	OpAMD64VPSHUFDMasked512
	OpAMD64VPSHUFHW128
	OpAMD64VPSHUFHW256
	OpAMD64VPSHUFHW512
	OpAMD64VPSHUFHWMasked128
	OpAMD64VPSHUFHWMasked256
	OpAMD64VPSHUFHWMasked512
	OpAMD64VPSHUFLW128
	OpAMD64VPSHUFLW256
	OpAMD64VPSHUFLW512
	OpAMD64VPSHUFLWMasked128
	OpAMD64VPSHUFLWMasked256
	OpAMD64VPSHUFLWMasked512
	OpAMD64VPSLLD128const
	OpAMD64VPSLLD256const
	OpAMD64VPSLLD512const
	OpAMD64VPSLLDMasked128const
	OpAMD64VPSLLDMasked256const
	OpAMD64VPSLLDMasked512const
	OpAMD64VPSLLQ128const
	OpAMD64VPSLLQ256const
	OpAMD64VPSLLQ512const
	OpAMD64VPSLLQMasked128const
	OpAMD64VPSLLQMasked256const
	OpAMD64VPSLLQMasked512const
	OpAMD64VPSLLW128const
	OpAMD64VPSLLW256const
	OpAMD64VPSLLW512const
	OpAMD64VPSLLWMasked128const
	OpAMD64VPSLLWMasked256const
	OpAMD64VPSLLWMasked512const
	OpAMD64VPSRAD128const
	OpAMD64VPSRAD256const
	OpAMD64VPSRAD512const
	OpAMD64VPSRADMasked128const
	OpAMD64VPSRADMasked256const
	OpAMD64VPSRADMasked512const
	OpAMD64VPSRAQ128const
	OpAMD64VPSRAQ256const
	OpAMD64VPSRAQ512const
	OpAMD64VPSRAQMasked128const
	OpAMD64VPSRAQMasked256const
	OpAMD64VPSRAQMasked512const
	OpAMD64VPSRAW128const
	OpAMD64VPSRAW256const
	OpAMD64VPSRAW512const
	OpAMD64VPSRAWMasked128const
	OpAMD64VPSRAWMasked256const
	OpAMD64VPSRAWMasked512const
	OpAMD64VPSRLD128const
	OpAMD64VPSRLD256const
	OpAMD64VPSRLD512const
	OpAMD64VPSRLDMasked128const
	OpAMD64VPSRLDMasked256const
	OpAMD64VPSRLDMasked512const
	OpAMD64VPSRLQ128const
	OpAMD64VPSRLQ256const
	OpAMD64VPSRLQ512const
	OpAMD64VPSRLQMasked128const
	OpAMD64VPSRLQMasked256const
	OpAMD64VPSRLQMasked512const
	OpAMD64VPSRLW128const
	OpAMD64VPSRLW256const
	OpAMD64VPSRLW512const
	OpAMD64VPSRLWMasked128const
	OpAMD64VPSRLWMasked256const
	OpAMD64VPSRLWMasked512const
	OpAMD64VPTERNLOGD128
	OpAMD64VPTERNLOGD256
	OpAMD64VPTERNLOGD512
	OpAMD64VPTERNLOGQ128
	OpAMD64VPTERNLOGQ256
	OpAMD64VPTERNLOGQ512
	OpAMD64VREDUCEPD128
	OpAMD64VREDUCEPD256
	OpAMD64VREDUCEPD512
	OpAMD64VREDUCEPDMasked128
	OpAMD64VREDUCEPDMasked256
	OpAMD64VREDUCEPDMasked512
	OpAMD64VREDUCEPS128
	OpAMD64VREDUCEPS256
	OpAMD64VREDUCEPS512
	OpAMD64VREDUCEPSMasked128
	OpAMD64VREDUCEPSMasked256
	OpAMD64VREDUCEPSMasked512
	OpAMD64VRNDSCALEPD128
	OpAMD64VRNDSCALEPD256
	OpAMD64VRNDSCALEPD512
	OpAMD64VRNDSCALEPDMasked128
	OpAMD64VRNDSCALEPDMasked256
	OpAMD64VRNDSCALEPDMasked512
	OpAMD64VRNDSCALEPS128
	OpAMD64VRNDSCALEPS256
	OpAMD64VRNDSCALEPS512
	OpAMD64VRNDSCALEPSMasked128
	OpAMD64VRNDSCALEPSMasked256
	OpAMD64VRNDSCALEPSMasked512
	OpAMD64VROUNDPD128
	OpAMD64VROUNDPD256
	OpAMD64VROUNDPS128
	OpAMD64VROUNDPS256
	OpAMD64VSHUFPD128
	OpAMD64VSHUFPD256
	OpAMD64VSHUFPD512
	OpAMD64VSHUFPS128
	OpAMD64VSHUFPS256
	OpAMD64VSHUFPS512
	OpAMD64VADDPD512load
	OpAMD64VADDPDMasked128load
	OpAMD64VADDPDMasked256load
	OpAMD64VADDPDMasked512load
	OpAMD64VADDPS512load
	OpAMD64VADDPSMasked128load
	OpAMD64VADDPSMasked256load
	OpAMD64VADDPSMasked512load
	OpAMD64VCVTDQ2PD512load
	OpAMD64VCVTDQ2PDMasked256load
	OpAMD64VCVTDQ2PDMasked512load
	OpAMD64VCVTDQ2PS512load
	OpAMD64VCVTDQ2PSMasked128load
	OpAMD64VCVTDQ2PSMasked256load
	OpAMD64VCVTDQ2PSMasked512load
	OpAMD64VCVTPD2PS256load
	OpAMD64VCVTPD2PSMasked256load
	OpAMD64VCVTPD2PSXMasked128load
	OpAMD64VCVTPD2PSYMasked128load
	OpAMD64VCVTPS2PD512load
	OpAMD64VCVTPS2PDMasked256load
	OpAMD64VCVTPS2PDMasked512load
	OpAMD64VCVTQQ2PD128load
	OpAMD64VCVTQQ2PD256load
	OpAMD64VCVTQQ2PD512load
	OpAMD64VCVTQQ2PDMasked128load
	OpAMD64VCVTQQ2PDMasked256load
	OpAMD64VCVTQQ2PDMasked512load
	OpAMD64VCVTQQ2PS256load
	OpAMD64VCVTQQ2PSMasked256load
	OpAMD64VCVTQQ2PSX128load
	OpAMD64VCVTQQ2PSXMasked128load
	OpAMD64VCVTQQ2PSY128load
	OpAMD64VCVTQQ2PSYMasked128load
	OpAMD64VCVTTPD2DQ256load
	OpAMD64VCVTTPD2DQMasked256load
	OpAMD64VCVTTPD2DQXMasked128load
	OpAMD64VCVTTPD2DQYMasked128load
	OpAMD64VCVTTPD2QQ128load
	OpAMD64VCVTTPD2QQ256load
	OpAMD64VCVTTPD2QQ512load
	OpAMD64VCVTTPD2QQMasked128load
	OpAMD64VCVTTPD2QQMasked256load
	OpAMD64VCVTTPD2QQMasked512load
	OpAMD64VCVTTPD2UDQ256load
	OpAMD64VCVTTPD2UDQMasked256load
	OpAMD64VCVTTPD2UDQX128load
	OpAMD64VCVTTPD2UDQXMasked128load
	OpAMD64VCVTTPD2UDQY128load
	OpAMD64VCVTTPD2UDQYMasked128load
	OpAMD64VCVTTPD2UQQ128load
	OpAMD64VCVTTPD2UQQ256load
	OpAMD64VCVTTPD2UQQ512load
	OpAMD64VCVTTPD2UQQMasked128load
	OpAMD64VCVTTPD2UQQMasked256load
	OpAMD64VCVTTPD2UQQMasked512load
	OpAMD64VCVTTPS2DQ512load
	OpAMD64VCVTTPS2DQMasked128load
	OpAMD64VCVTTPS2DQMasked256load
	OpAMD64VCVTTPS2DQMasked512load
	OpAMD64VCVTTPS2QQ256load
	OpAMD64VCVTTPS2QQ512load
	OpAMD64VCVTTPS2QQMasked256load
	OpAMD64VCVTTPS2QQMasked512load
	OpAMD64VCVTTPS2UDQ128load
	OpAMD64VCVTTPS2UDQ256load
	OpAMD64VCVTTPS2UDQ512load
	OpAMD64VCVTTPS2UDQMasked128load
	OpAMD64VCVTTPS2UDQMasked256load
	OpAMD64VCVTTPS2UDQMasked512load
	OpAMD64VCVTTPS2UQQ256load
	OpAMD64VCVTTPS2UQQ512load
	OpAMD64VCVTTPS2UQQMasked256load
	OpAMD64VCVTTPS2UQQMasked512load
	OpAMD64VCVTUDQ2PD256load
	OpAMD64VCVTUDQ2PD512load
	OpAMD64VCVTUDQ2PDMasked256load
	OpAMD64VCVTUDQ2PDMasked512load
	OpAMD64VCVTUDQ2PS128load
	OpAMD64VCVTUDQ2PS256load
	OpAMD64VCVTUDQ2PS512load
	OpAMD64VCVTUDQ2PSMasked128load
	OpAMD64VCVTUDQ2PSMasked256load
	OpAMD64VCVTUDQ2PSMasked512load
	OpAMD64VCVTUQQ2PD128load
	OpAMD64VCVTUQQ2PD256load
	OpAMD64VCVTUQQ2PD512load
	OpAMD64VCVTUQQ2PDMasked128load
	OpAMD64VCVTUQQ2PDMasked256load
	OpAMD64VCVTUQQ2PDMasked512load
	OpAMD64VCVTUQQ2PS256load
	OpAMD64VCVTUQQ2PSMasked256load
	OpAMD64VCVTUQQ2PSX128load
	OpAMD64VCVTUQQ2PSXMasked128load
	OpAMD64VCVTUQQ2PSY128load
	OpAMD64VCVTUQQ2PSYMasked128load
	OpAMD64VDIVPD512load
	OpAMD64VDIVPDMasked128load
	OpAMD64VDIVPDMasked256load
	OpAMD64VDIVPDMasked512load
	OpAMD64VDIVPS512load
	OpAMD64VDIVPSMasked128load
	OpAMD64VDIVPSMasked256load
	OpAMD64VDIVPSMasked512load
	OpAMD64VFMADD213PD512load
	OpAMD64VFMADD213PDMasked128load
	OpAMD64VFMADD213PDMasked256load
	OpAMD64VFMADD213PDMasked512load
	OpAMD64VFMADD213PS512load
	OpAMD64VFMADD213PSMasked128load
	OpAMD64VFMADD213PSMasked256load
	OpAMD64VFMADD213PSMasked512load
	OpAMD64VFMADDSUB213PD512load
	OpAMD64VFMADDSUB213PDMasked128load
	OpAMD64VFMADDSUB213PDMasked256load
	OpAMD64VFMADDSUB213PDMasked512load
	OpAMD64VFMADDSUB213PS512load
	OpAMD64VFMADDSUB213PSMasked128load
	OpAMD64VFMADDSUB213PSMasked256load
	OpAMD64VFMADDSUB213PSMasked512load
	OpAMD64VFMSUBADD213PD512load
	OpAMD64VFMSUBADD213PDMasked128load
	OpAMD64VFMSUBADD213PDMasked256load
	OpAMD64VFMSUBADD213PDMasked512load
	OpAMD64VFMSUBADD213PS512load
	OpAMD64VFMSUBADD213PSMasked128load
	OpAMD64VFMSUBADD213PSMasked256load
	OpAMD64VFMSUBADD213PSMasked512load
	OpAMD64VMAXPD512load
	OpAMD64VMAXPDMasked128load
	OpAMD64VMAXPDMasked256load
	OpAMD64VMAXPDMasked512load
	OpAMD64VMAXPS512load
	OpAMD64VMAXPSMasked128load
	OpAMD64VMAXPSMasked256load
	OpAMD64VMAXPSMasked512load
	OpAMD64VMINPD512load
	OpAMD64VMINPDMasked128load
	OpAMD64VMINPDMasked256load
	OpAMD64VMINPDMasked512load
	OpAMD64VMINPS512load
	OpAMD64VMINPSMasked128load
	OpAMD64VMINPSMasked256load
	OpAMD64VMINPSMasked512load
	OpAMD64VMULPD512load
	OpAMD64VMULPDMasked128load
	OpAMD64VMULPDMasked256load
	OpAMD64VMULPDMasked512load
	OpAMD64VMULPS512load
	OpAMD64VMULPSMasked128load
	OpAMD64VMULPSMasked256load
	OpAMD64VMULPSMasked512load
	OpAMD64VPABSD512load
	OpAMD64VPABSDMasked128load
	OpAMD64VPABSDMasked256load
	OpAMD64VPABSDMasked512load
	OpAMD64VPABSQ128load
	OpAMD64VPABSQ256load
	OpAMD64VPABSQ512load
	OpAMD64VPABSQMasked128load
	OpAMD64VPABSQMasked256load
	OpAMD64VPABSQMasked512load
	OpAMD64VPACKSSDW512load
	OpAMD64VPACKSSDWMasked128load
	OpAMD64VPACKSSDWMasked256load
	OpAMD64VPACKSSDWMasked512load
	OpAMD64VPACKUSDW512load
	OpAMD64VPACKUSDWMasked128load
	OpAMD64VPACKUSDWMasked256load
	OpAMD64VPACKUSDWMasked512load
	OpAMD64VPADDD512load
	OpAMD64VPADDDMasked128load
	OpAMD64VPADDDMasked256load
	OpAMD64VPADDDMasked512load
	OpAMD64VPADDQ512load
	OpAMD64VPADDQMasked128load
	OpAMD64VPADDQMasked256load
	OpAMD64VPADDQMasked512load
	OpAMD64VPANDD512load
	OpAMD64VPANDDMasked128load
	OpAMD64VPANDDMasked256load
	OpAMD64VPANDDMasked512load
	OpAMD64VPANDND512load
	OpAMD64VPANDNDMasked128load
	OpAMD64VPANDNDMasked256load
	OpAMD64VPANDNDMasked512load
	OpAMD64VPANDNQ512load
	OpAMD64VPANDNQMasked128load
	OpAMD64VPANDNQMasked256load
	OpAMD64VPANDNQMasked512load
	OpAMD64VPANDQ512load
	OpAMD64VPANDQMasked128load
	OpAMD64VPANDQMasked256load
	OpAMD64VPANDQMasked512load
	OpAMD64VPBLENDMDMasked512load
	OpAMD64VPBLENDMQMasked512load
	OpAMD64VPCMPEQD512load
	OpAMD64VPCMPEQQ512load
	OpAMD64VPCMPGTD512load
	OpAMD64VPCMPGTQ512load
	OpAMD64VPDPWSSD512load
	OpAMD64VPDPWSSDMasked128load
	OpAMD64VPDPWSSDMasked256load
	OpAMD64VPDPWSSDMasked512load
	OpAMD64VPERMD512load
	OpAMD64VPERMDMasked256load
	OpAMD64VPERMDMasked512load
	OpAMD64VPERMI2D128load
	OpAMD64VPERMI2D256load
	OpAMD64VPERMI2D512load
	OpAMD64VPERMI2DMasked128load
	OpAMD64VPERMI2DMasked256load
	OpAMD64VPERMI2DMasked512load
	OpAMD64VPERMI2PD128load
	OpAMD64VPERMI2PD256load
	OpAMD64VPERMI2PD512load
	OpAMD64VPERMI2PDMasked128load
	OpAMD64VPERMI2PDMasked256load
	OpAMD64VPERMI2PDMasked512load
	OpAMD64VPERMI2PS128load
	OpAMD64VPERMI2PS256load
	OpAMD64VPERMI2PS512load
	OpAMD64VPERMI2PSMasked128load
	OpAMD64VPERMI2PSMasked256load
	OpAMD64VPERMI2PSMasked512load
	OpAMD64VPERMI2Q128load
	OpAMD64VPERMI2Q256load
	OpAMD64VPERMI2Q512load
	OpAMD64VPERMI2QMasked128load
	OpAMD64VPERMI2QMasked256load
	OpAMD64VPERMI2QMasked512load
	OpAMD64VPERMPD256load
	OpAMD64VPERMPD512load
	OpAMD64VPERMPDMasked256load
	OpAMD64VPERMPDMasked512load
	OpAMD64VPERMPS512load
	OpAMD64VPERMPSMasked256load
	OpAMD64VPERMPSMasked512load
	OpAMD64VPERMQ256load
	OpAMD64VPERMQ512load
	OpAMD64VPERMQMasked256load
	OpAMD64VPERMQMasked512load
	OpAMD64VPLZCNTD128load
	OpAMD64VPLZCNTD256load
	OpAMD64VPLZCNTD512load
	OpAMD64VPLZCNTDMasked128load
	OpAMD64VPLZCNTDMasked256load
	OpAMD64VPLZCNTDMasked512load
	OpAMD64VPLZCNTQ128load
	OpAMD64VPLZCNTQ256load
	OpAMD64VPLZCNTQ512load
	OpAMD64VPLZCNTQMasked128load
	OpAMD64VPLZCNTQMasked256load
	OpAMD64VPLZCNTQMasked512load
	OpAMD64VPMAXSD512load
	OpAMD64VPMAXSDMasked128load
	OpAMD64VPMAXSDMasked256load
	OpAMD64VPMAXSDMasked512load
	OpAMD64VPMAXSQ128load
	OpAMD64VPMAXSQ256load
	OpAMD64VPMAXSQ512load
	OpAMD64VPMAXSQMasked128load
	OpAMD64VPMAXSQMasked256load
	OpAMD64VPMAXSQMasked512load
	OpAMD64VPMAXUD512load
	OpAMD64VPMAXUDMasked128load
	OpAMD64VPMAXUDMasked256load
	OpAMD64VPMAXUDMasked512load
	OpAMD64VPMAXUQ128load
	OpAMD64VPMAXUQ256load
	OpAMD64VPMAXUQ512load
	OpAMD64VPMAXUQMasked128load
	OpAMD64VPMAXUQMasked256load
	OpAMD64VPMAXUQMasked512load
	OpAMD64VPMINSD512load
	OpAMD64VPMINSDMasked128load
	OpAMD64VPMINSDMasked256load
	OpAMD64VPMINSDMasked512load
	OpAMD64VPMINSQ128load
	OpAMD64VPMINSQ256load
	OpAMD64VPMINSQ512load
	OpAMD64VPMINSQMasked128load
	OpAMD64VPMINSQMasked256load
	OpAMD64VPMINSQMasked512load
	OpAMD64VPMINUD512load
	OpAMD64VPMINUDMasked128load
	OpAMD64VPMINUDMasked256load
	OpAMD64VPMINUDMasked512load
	OpAMD64VPMINUQ128load
	OpAMD64VPMINUQ256load
	OpAMD64VPMINUQ512load
	OpAMD64VPMINUQMasked128load
	OpAMD64VPMINUQMasked256load
	OpAMD64VPMINUQMasked512load
	OpAMD64VPMULLD512load
	OpAMD64VPMULLDMasked128load
	OpAMD64VPMULLDMasked256load
	OpAMD64VPMULLDMasked512load
	OpAMD64VPMULLQ128load
	OpAMD64VPMULLQ256load
	OpAMD64VPMULLQ512load
	OpAMD64VPMULLQMasked128load
	OpAMD64VPMULLQMasked256load
	OpAMD64VPMULLQMasked512load
	OpAMD64VPOPCNTD128load
	OpAMD64VPOPCNTD256load
	OpAMD64VPOPCNTD512load
	OpAMD64VPOPCNTDMasked128load
	OpAMD64VPOPCNTDMasked256load
	OpAMD64VPOPCNTDMasked512load
	OpAMD64VPOPCNTQ128load
	OpAMD64VPOPCNTQ256load
	OpAMD64VPOPCNTQ512load
	OpAMD64VPOPCNTQMasked128load
	OpAMD64VPOPCNTQMasked256load
	OpAMD64VPOPCNTQMasked512load
	OpAMD64VPORD512load
	OpAMD64VPORDMasked128load
	OpAMD64VPORDMasked256load
	OpAMD64VPORDMasked512load
	OpAMD64VPORQ512load
	OpAMD64VPORQMasked128load
	OpAMD64VPORQMasked256load
	OpAMD64VPORQMasked512load
	OpAMD64VPROLVD128load
	OpAMD64VPROLVD256load
	OpAMD64VPROLVD512load
	OpAMD64VPROLVDMasked128load
	OpAMD64VPROLVDMasked256load
	OpAMD64VPROLVDMasked512load
	OpAMD64VPROLVQ128load
	OpAMD64VPROLVQ256load
	OpAMD64VPROLVQ512load
	OpAMD64VPROLVQMasked128load
	OpAMD64VPROLVQMasked256load
	OpAMD64VPROLVQMasked512load
	OpAMD64VPRORVD128load
	OpAMD64VPRORVD256load
	OpAMD64VPRORVD512load
	OpAMD64VPRORVDMasked128load
	OpAMD64VPRORVDMasked256load
	OpAMD64VPRORVDMasked512load
	OpAMD64VPRORVQ128load
	OpAMD64VPRORVQ256load
	OpAMD64VPRORVQ512load
	OpAMD64VPRORVQMasked128load
	OpAMD64VPRORVQMasked256load
	OpAMD64VPRORVQMasked512load
	OpAMD64VPSHLDVD128load
	OpAMD64VPSHLDVD256load
	OpAMD64VPSHLDVD512load
	OpAMD64VPSHLDVDMasked128load
	OpAMD64VPSHLDVDMasked256load
	OpAMD64VPSHLDVDMasked512load
	OpAMD64VPSHLDVQ128load
	OpAMD64VPSHLDVQ256load
	OpAMD64VPSHLDVQ512load
	OpAMD64VPSHLDVQMasked128load
	OpAMD64VPSHLDVQMasked256load
	OpAMD64VPSHLDVQMasked512load
	OpAMD64VPSHRDVD128load
	OpAMD64VPSHRDVD256load
	OpAMD64VPSHRDVD512load
	OpAMD64VPSHRDVDMasked128load
	OpAMD64VPSHRDVDMasked256load
	OpAMD64VPSHRDVDMasked512load
	OpAMD64VPSHRDVQ128load
	OpAMD64VPSHRDVQ256load
	OpAMD64VPSHRDVQ512load
	OpAMD64VPSHRDVQMasked128load
	OpAMD64VPSHRDVQMasked256load
	OpAMD64VPSHRDVQMasked512load
	OpAMD64VPSLLVD512load
	OpAMD64VPSLLVDMasked128load
	OpAMD64VPSLLVDMasked256load
	OpAMD64VPSLLVDMasked512load
	OpAMD64VPSLLVQ512load
	OpAMD64VPSLLVQMasked128load
	OpAMD64VPSLLVQMasked256load
	OpAMD64VPSLLVQMasked512load
	OpAMD64VPSRAVD512load
	OpAMD64VPSRAVDMasked128load
	OpAMD64VPSRAVDMasked256load
	OpAMD64VPSRAVDMasked512load
	OpAMD64VPSRAVQ128load
	OpAMD64VPSRAVQ256load
	OpAMD64VPSRAVQ512load
	OpAMD64VPSRAVQMasked128load
	OpAMD64VPSRAVQMasked256load
	OpAMD64VPSRAVQMasked512load
	OpAMD64VPSRLVD512load
	OpAMD64VPSRLVDMasked128load
	OpAMD64VPSRLVDMasked256load
	OpAMD64VPSRLVDMasked512load
	OpAMD64VPSRLVQ512load
	OpAMD64VPSRLVQMasked128load
	OpAMD64VPSRLVQMasked256load
	OpAMD64VPSRLVQMasked512load
	OpAMD64VPSUBD512load
	OpAMD64VPSUBDMasked128load
	OpAMD64VPSUBDMasked256load
	OpAMD64VPSUBDMasked512load
	OpAMD64VPSUBQ512load
	OpAMD64VPSUBQMasked128load
	OpAMD64VPSUBQMasked256load
	OpAMD64VPSUBQMasked512load
	OpAMD64VPUNPCKHDQ512load
	OpAMD64VPUNPCKHQDQ512load
	OpAMD64VPUNPCKLDQ512load
	OpAMD64VPUNPCKLQDQ512load
	OpAMD64VPXORD512load
	OpAMD64VPXORDMasked128load
	OpAMD64VPXORDMasked256load
	OpAMD64VPXORDMasked512load
	OpAMD64VPXORQ512load
	OpAMD64VPXORQMasked128load
	OpAMD64VPXORQMasked256load
	OpAMD64VPXORQMasked512load
	OpAMD64VRCP14PD128load
	OpAMD64VRCP14PD256load
	OpAMD64VRCP14PD512load
	OpAMD64VRCP14PDMasked128load
	OpAMD64VRCP14PDMasked256load
	OpAMD64VRCP14PDMasked512load
	OpAMD64VRCP14PS512load
	OpAMD64VRCP14PSMasked128load
	OpAMD64VRCP14PSMasked256load
	OpAMD64VRCP14PSMasked512load
	OpAMD64VRSQRT14PD128load
	OpAMD64VRSQRT14PD256load
	OpAMD64VRSQRT14PD512load
	OpAMD64VRSQRT14PDMasked128load
	OpAMD64VRSQRT14PDMasked256load
	OpAMD64VRSQRT14PDMasked512load
	OpAMD64VRSQRT14PS512load
	OpAMD64VRSQRT14PSMasked128load
	OpAMD64VRSQRT14PSMasked256load
	OpAMD64VRSQRT14PSMasked512load
	OpAMD64VSCALEFPD128load
	OpAMD64VSCALEFPD256load
	OpAMD64VSCALEFPD512load
	OpAMD64VSCALEFPDMasked128load
	OpAMD64VSCALEFPDMasked256load
	OpAMD64VSCALEFPDMasked512load
	OpAMD64VSCALEFPS128load
	OpAMD64VSCALEFPS256load
	OpAMD64VSCALEFPS512load
	OpAMD64VSCALEFPSMasked128load
	OpAMD64VSCALEFPSMasked256load
	OpAMD64VSCALEFPSMasked512load
	OpAMD64VSQRTPD512load
	OpAMD64VSQRTPDMasked128load
	OpAMD64VSQRTPDMasked256load
	OpAMD64VSQRTPDMasked512load
	OpAMD64VSQRTPS512load
	OpAMD64VSQRTPSMasked128load
	OpAMD64VSQRTPSMasked256load
	OpAMD64VSQRTPSMasked512load
	OpAMD64VSUBPD512load
	OpAMD64VSUBPDMasked128load
	OpAMD64VSUBPDMasked256load
	OpAMD64VSUBPDMasked512load
	OpAMD64VSUBPS512load
	OpAMD64VSUBPSMasked128load
	OpAMD64VSUBPSMasked256load
	OpAMD64VSUBPSMasked512load
	OpAMD64VCMPPD512load
	OpAMD64VCMPPDMasked128load
	OpAMD64VCMPPDMasked256load
	OpAMD64VCMPPDMasked512load
	OpAMD64VCMPPS512load
	OpAMD64VCMPPSMasked128load
	OpAMD64VCMPPSMasked256load
	OpAMD64VCMPPSMasked512load
	OpAMD64VGF2P8AFFINEINVQB128load
	OpAMD64VGF2P8AFFINEINVQB256load
	OpAMD64VGF2P8AFFINEINVQB512load
	OpAMD64VGF2P8AFFINEINVQBMasked128load
	OpAMD64VGF2P8AFFINEINVQBMasked256load
	OpAMD64VGF2P8AFFINEINVQBMasked512load
	OpAMD64VGF2P8AFFINEQB128load
	OpAMD64VGF2P8AFFINEQB256load
	OpAMD64VGF2P8AFFINEQB512load
	OpAMD64VGF2P8AFFINEQBMasked128load
	OpAMD64VGF2P8AFFINEQBMasked256load
	OpAMD64VGF2P8AFFINEQBMasked512load
	OpAMD64VPCMPD512load
	OpAMD64VPCMPDMasked128load
	OpAMD64VPCMPDMasked256load
	OpAMD64VPCMPDMasked512load
	OpAMD64VPCMPQ512load
	OpAMD64VPCMPQMasked128load
	OpAMD64VPCMPQMasked256load
	OpAMD64VPCMPQMasked512load
	OpAMD64VPCMPUD512load
	OpAMD64VPCMPUDMasked128load
	OpAMD64VPCMPUDMasked256load
	OpAMD64VPCMPUDMasked512load
	OpAMD64VPCMPUQ512load
	OpAMD64VPCMPUQMasked128load
	OpAMD64VPCMPUQMasked256load
	OpAMD64VPCMPUQMasked512load
	OpAMD64VPROLD128load
	OpAMD64VPROLD256load
	OpAMD64VPROLD512load
	OpAMD64VPROLDMasked128load
	OpAMD64VPROLDMasked256load
	OpAMD64VPROLDMasked512load
	OpAMD64VPROLQ128load
	OpAMD64VPROLQ256load
	OpAMD64VPROLQ512load
	OpAMD64VPROLQMasked128load
	OpAMD64VPROLQMasked256load
	OpAMD64VPROLQMasked512load
	OpAMD64VPRORD128load
	OpAMD64VPRORD256load
	OpAMD64VPRORD512load
	OpAMD64VPRORDMasked128load
	OpAMD64VPRORDMasked256load
	OpAMD64VPRORDMasked512load
	OpAMD64VPRORQ128load
	OpAMD64VPRORQ256load
	OpAMD64VPRORQ512load
	OpAMD64VPRORQMasked128load
	OpAMD64VPRORQMasked256load
	OpAMD64VPRORQMasked512load
	OpAMD64VPSHLDD128load
	OpAMD64VPSHLDD256load
	OpAMD64VPSHLDD512load
	OpAMD64VPSHLDDMasked128load
	OpAMD64VPSHLDDMasked256load
	OpAMD64VPSHLDDMasked512load
	OpAMD64VPSHLDQ128load
	OpAMD64VPSHLDQ256load
	OpAMD64VPSHLDQ512load
	OpAMD64VPSHLDQMasked128load
	OpAMD64VPSHLDQMasked256load
	OpAMD64VPSHLDQMasked512load
	OpAMD64VPSHRDD128load
	OpAMD64VPSHRDD256load
	OpAMD64VPSHRDD512load
	OpAMD64VPSHRDDMasked128load
	OpAMD64VPSHRDDMasked256load
	OpAMD64VPSHRDDMasked512load
	OpAMD64VPSHRDQ128load
	OpAMD64VPSHRDQ256load
	OpAMD64VPSHRDQ512load
	OpAMD64VPSHRDQMasked128load
	OpAMD64VPSHRDQMasked256load
	OpAMD64VPSHRDQMasked512load
	OpAMD64VPSHUFD512load
	OpAMD64VPSHUFDMasked128load
	OpAMD64VPSHUFDMasked256load
	OpAMD64VPSHUFDMasked512load
	OpAMD64VPSLLD512constload
	OpAMD64VPSLLDMasked128constload
	OpAMD64VPSLLDMasked256constload
	OpAMD64VPSLLDMasked512constload
	OpAMD64VPSLLQ512constload
	OpAMD64VPSLLQMasked128constload
	OpAMD64VPSLLQMasked256constload
	OpAMD64VPSLLQMasked512constload
	OpAMD64VPSRAD512constload
	OpAMD64VPSRADMasked128constload
	OpAMD64VPSRADMasked256constload
	OpAMD64VPSRADMasked512constload
	OpAMD64VPSRAQ128constload
	OpAMD64VPSRAQ256constload
	OpAMD64VPSRAQ512constload
	OpAMD64VPSRAQMasked128constload
	OpAMD64VPSRAQMasked256constload
	OpAMD64VPSRAQMasked512constload
	OpAMD64VPSRLD512constload
	OpAMD64VPSRLDMasked128constload
	OpAMD64VPSRLDMasked256constload
	OpAMD64VPSRLDMasked512constload
	OpAMD64VPSRLQ512constload
	OpAMD64VPSRLQMasked128constload
	OpAMD64VPSRLQMasked256constload
	OpAMD64VPSRLQMasked512constload
	OpAMD64VPTERNLOGD128load
	OpAMD64VPTERNLOGD256load
	OpAMD64VPTERNLOGD512load
	OpAMD64VPTERNLOGQ128load
	OpAMD64VPTERNLOGQ256load
	OpAMD64VPTERNLOGQ512load
	OpAMD64VREDUCEPD128load
	OpAMD64VREDUCEPD256load
	OpAMD64VREDUCEPD512load
	OpAMD64VREDUCEPDMasked128load
	OpAMD64VREDUCEPDMasked256load
	OpAMD64VREDUCEPDMasked512load
	OpAMD64VREDUCEPS128load
	OpAMD64VREDUCEPS256load
	OpAMD64VREDUCEPS512load
	OpAMD64VREDUCEPSMasked128load
	OpAMD64VREDUCEPSMasked256load
	OpAMD64VREDUCEPSMasked512load
	OpAMD64VRNDSCALEPD128load
	OpAMD64VRNDSCALEPD256load
	OpAMD64VRNDSCALEPD512load
	OpAMD64VRNDSCALEPDMasked128load
	OpAMD64VRNDSCALEPDMasked256load
	OpAMD64VRNDSCALEPDMasked512load
	OpAMD64VRNDSCALEPS128load
	OpAMD64VRNDSCALEPS256load
	OpAMD64VRNDSCALEPS512load
	OpAMD64VRNDSCALEPSMasked128load
	OpAMD64VRNDSCALEPSMasked256load
	OpAMD64VRNDSCALEPSMasked512load
	OpAMD64VSHUFPD512load
	OpAMD64VSHUFPS512load
	OpAMD64VADDPDMasked128Merging
	OpAMD64VADDPDMasked256Merging
	OpAMD64VADDPDMasked512Merging
	OpAMD64VADDPSMasked128Merging
	OpAMD64VADDPSMasked256Merging
	OpAMD64VADDPSMasked512Merging
	OpAMD64VBROADCASTSDMasked256Merging
	OpAMD64VBROADCASTSDMasked512Merging
	OpAMD64VBROADCASTSSMasked128Merging
	OpAMD64VBROADCASTSSMasked256Merging
	OpAMD64VBROADCASTSSMasked512Merging
	OpAMD64VCVTDQ2PDMasked256Merging
	OpAMD64VCVTDQ2PDMasked512Merging
	OpAMD64VCVTDQ2PSMasked128Merging
	OpAMD64VCVTDQ2PSMasked256Merging
	OpAMD64VCVTDQ2PSMasked512Merging
	OpAMD64VCVTPD2PSMasked256Merging
	OpAMD64VCVTPD2PSXMasked128Merging
	OpAMD64VCVTPD2PSYMasked128Merging
	OpAMD64VCVTPS2PDMasked256Merging
	OpAMD64VCVTPS2PDMasked512Merging
	OpAMD64VCVTQQ2PDMasked128Merging
	OpAMD64VCVTQQ2PDMasked256Merging
	OpAMD64VCVTQQ2PDMasked512Merging
	OpAMD64VCVTQQ2PSMasked256Merging
	OpAMD64VCVTQQ2PSXMasked128Merging
	OpAMD64VCVTQQ2PSYMasked128Merging
	OpAMD64VCVTTPD2DQMasked256Merging
	OpAMD64VCVTTPD2DQXMasked128Merging
	OpAMD64VCVTTPD2DQYMasked128Merging
	OpAMD64VCVTTPD2QQMasked128Merging
	OpAMD64VCVTTPD2QQMasked256Merging
	OpAMD64VCVTTPD2QQMasked512Merging
	OpAMD64VCVTTPD2UDQMasked256Merging
	OpAMD64VCVTTPD2UDQXMasked128Merging
	OpAMD64VCVTTPD2UDQYMasked128Merging
	OpAMD64VCVTTPD2UQQMasked128Merging
	OpAMD64VCVTTPD2UQQMasked256Merging
	OpAMD64VCVTTPD2UQQMasked512Merging
	OpAMD64VCVTTPS2DQMasked128Merging
	OpAMD64VCVTTPS2DQMasked256Merging
	OpAMD64VCVTTPS2DQMasked512Merging
	OpAMD64VCVTTPS2QQMasked256Merging
	OpAMD64VCVTTPS2QQMasked512Merging
	OpAMD64VCVTTPS2UDQMasked128Merging
	OpAMD64VCVTTPS2UDQMasked256Merging
	OpAMD64VCVTTPS2UDQMasked512Merging
	OpAMD64VCVTTPS2UQQMasked256Merging
	OpAMD64VCVTTPS2UQQMasked512Merging
	OpAMD64VCVTUDQ2PDMasked256Merging
	OpAMD64VCVTUDQ2PDMasked512Merging
	OpAMD64VCVTUDQ2PSMasked128Merging
	OpAMD64VCVTUDQ2PSMasked256Merging
	OpAMD64VCVTUDQ2PSMasked512Merging
	OpAMD64VCVTUQQ2PDMasked128Merging
	OpAMD64VCVTUQQ2PDMasked256Merging
	OpAMD64VCVTUQQ2PDMasked512Merging
	OpAMD64VCVTUQQ2PSMasked256Merging
	OpAMD64VCVTUQQ2PSXMasked128Merging
	OpAMD64VCVTUQQ2PSYMasked128Merging
	OpAMD64VDIVPDMasked128Merging
	OpAMD64VDIVPDMasked256Merging
	OpAMD64VDIVPDMasked512Merging
	OpAMD64VDIVPSMasked128Merging
	OpAMD64VDIVPSMasked256Merging
	OpAMD64VDIVPSMasked512Merging
	OpAMD64VGF2P8MULBMasked128Merging
	OpAMD64VGF2P8MULBMasked256Merging
	OpAMD64VGF2P8MULBMasked512Merging
	OpAMD64VMAXPDMasked128Merging
	OpAMD64VMAXPDMasked256Merging
	OpAMD64VMAXPDMasked512Merging
	OpAMD64VMAXPSMasked128Merging
	OpAMD64VMAXPSMasked256Merging
	OpAMD64VMAXPSMasked512Merging
	OpAMD64VMINPDMasked128Merging
	OpAMD64VMINPDMasked256Merging
	OpAMD64VMINPDMasked512Merging
	OpAMD64VMINPSMasked128Merging
	OpAMD64VMINPSMasked256Merging
	OpAMD64VMINPSMasked512Merging
	OpAMD64VMULPDMasked128Merging
	OpAMD64VMULPDMasked256Merging
	OpAMD64VMULPDMasked512Merging
	OpAMD64VMULPSMasked128Merging
	OpAMD64VMULPSMasked256Merging
	OpAMD64VMULPSMasked512Merging
	OpAMD64VPABSBMasked128Merging
	OpAMD64VPABSBMasked256Merging
	OpAMD64VPABSBMasked512Merging
	OpAMD64VPABSDMasked128Merging
	OpAMD64VPABSDMasked256Merging
	OpAMD64VPABSDMasked512Merging
	OpAMD64VPABSQMasked128Merging
	OpAMD64VPABSQMasked256Merging
	OpAMD64VPABSQMasked512Merging
	OpAMD64VPABSWMasked128Merging
	OpAMD64VPABSWMasked256Merging
	OpAMD64VPABSWMasked512Merging
	OpAMD64VPACKSSDWMasked128Merging
	OpAMD64VPACKSSDWMasked256Merging
	OpAMD64VPACKSSDWMasked512Merging
	OpAMD64VPACKUSDWMasked128Merging
	OpAMD64VPACKUSDWMasked256Merging
	OpAMD64VPACKUSDWMasked512Merging
	OpAMD64VPADDBMasked128Merging
	OpAMD64VPADDBMasked256Merging
	OpAMD64VPADDBMasked512Merging
	OpAMD64VPADDDMasked128Merging
	OpAMD64VPADDDMasked256Merging
	OpAMD64VPADDDMasked512Merging
	OpAMD64VPADDQMasked128Merging
	OpAMD64VPADDQMasked256Merging
	OpAMD64VPADDQMasked512Merging
	OpAMD64VPADDSBMasked128Merging
	OpAMD64VPADDSBMasked256Merging
	OpAMD64VPADDSBMasked512Merging
	OpAMD64VPADDSWMasked128Merging
	OpAMD64VPADDSWMasked256Merging
	OpAMD64VPADDSWMasked512Merging
	OpAMD64VPADDUSBMasked128Merging
	OpAMD64VPADDUSBMasked256Merging
	OpAMD64VPADDUSBMasked512Merging
	OpAMD64VPADDUSWMasked128Merging
	OpAMD64VPADDUSWMasked256Merging
	OpAMD64VPADDUSWMasked512Merging
	OpAMD64VPADDWMasked128Merging
	OpAMD64VPADDWMasked256Merging
	OpAMD64VPADDWMasked512Merging
	OpAMD64VPANDDMasked128Merging
	OpAMD64VPANDDMasked256Merging
	OpAMD64VPANDDMasked512Merging
	OpAMD64VPANDQMasked128Merging
	OpAMD64VPANDQMasked256Merging
	OpAMD64VPANDQMasked512Merging
	OpAMD64VPAVGBMasked128Merging
	OpAMD64VPAVGBMasked256Merging
	OpAMD64VPAVGBMasked512Merging
	OpAMD64VPAVGWMasked128Merging
	OpAMD64VPAVGWMasked256Merging
	OpAMD64VPAVGWMasked512Merging
	OpAMD64VPBROADCASTBMasked128Merging
	OpAMD64VPBROADCASTBMasked256Merging
	OpAMD64VPBROADCASTBMasked512Merging
	OpAMD64VPBROADCASTDMasked128Merging
	OpAMD64VPBROADCASTDMasked256Merging
	OpAMD64VPBROADCASTDMasked512Merging
	OpAMD64VPBROADCASTQMasked128Merging
	OpAMD64VPBROADCASTQMasked256Merging
	OpAMD64VPBROADCASTQMasked512Merging
	OpAMD64VPBROADCASTWMasked128Merging
	OpAMD64VPBROADCASTWMasked256Merging
	OpAMD64VPBROADCASTWMasked512Merging
	OpAMD64VPLZCNTDMasked128Merging
	OpAMD64VPLZCNTDMasked256Merging
	OpAMD64VPLZCNTDMasked512Merging
	OpAMD64VPLZCNTQMasked128Merging
	OpAMD64VPLZCNTQMasked256Merging
	OpAMD64VPLZCNTQMasked512Merging
	OpAMD64VPMADDUBSWMasked128Merging
	OpAMD64VPMADDUBSWMasked256Merging
	OpAMD64VPMADDUBSWMasked512Merging
	OpAMD64VPMADDWDMasked128Merging
	OpAMD64VPMADDWDMasked256Merging
	OpAMD64VPMADDWDMasked512Merging
	OpAMD64VPMAXSBMasked128Merging
	OpAMD64VPMAXSBMasked256Merging
	OpAMD64VPMAXSBMasked512Merging
	OpAMD64VPMAXSDMasked128Merging
	OpAMD64VPMAXSDMasked256Merging
	OpAMD64VPMAXSDMasked512Merging
	OpAMD64VPMAXSQMasked128Merging
	OpAMD64VPMAXSQMasked256Merging
	OpAMD64VPMAXSQMasked512Merging
	OpAMD64VPMAXSWMasked128Merging
	OpAMD64VPMAXSWMasked256Merging
	OpAMD64VPMAXSWMasked512Merging
	OpAMD64VPMAXUBMasked128Merging
	OpAMD64VPMAXUBMasked256Merging
	OpAMD64VPMAXUBMasked512Merging
	OpAMD64VPMAXUDMasked128Merging
	OpAMD64VPMAXUDMasked256Merging
	OpAMD64VPMAXUDMasked512Merging
	OpAMD64VPMAXUQMasked128Merging
	OpAMD64VPMAXUQMasked256Merging
	OpAMD64VPMAXUQMasked512Merging
	OpAMD64VPMAXUWMasked128Merging
	OpAMD64VPMAXUWMasked256Merging
	OpAMD64VPMAXUWMasked512Merging
	OpAMD64VPMINSBMasked128Merging
	OpAMD64VPMINSBMasked256Merging
	OpAMD64VPMINSBMasked512Merging
	OpAMD64VPMINSDMasked128Merging
	OpAMD64VPMINSDMasked256Merging
	OpAMD64VPMINSDMasked512Merging
	OpAMD64VPMINSQMasked128Merging
	OpAMD64VPMINSQMasked256Merging
	OpAMD64VPMINSQMasked512Merging
	OpAMD64VPMINSWMasked128Merging
	OpAMD64VPMINSWMasked256Merging
	OpAMD64VPMINSWMasked512Merging
	OpAMD64VPMINUBMasked128Merging
	OpAMD64VPMINUBMasked256Merging
	OpAMD64VPMINUBMasked512Merging
	OpAMD64VPMINUDMasked128Merging
	OpAMD64VPMINUDMasked256Merging
	OpAMD64VPMINUDMasked512Merging
	OpAMD64VPMINUQMasked128Merging
	OpAMD64VPMINUQMasked256Merging
	OpAMD64VPMINUQMasked512Merging
	OpAMD64VPMINUWMasked128Merging
	OpAMD64VPMINUWMasked256Merging
	OpAMD64VPMINUWMasked512Merging
	OpAMD64VPMOVDBMasked128_128Merging
	OpAMD64VPMOVDBMasked128_256Merging
	OpAMD64VPMOVDBMasked128_512Merging
	OpAMD64VPMOVDWMasked128_128Merging
	OpAMD64VPMOVDWMasked128_256Merging
	OpAMD64VPMOVDWMasked256Merging
	OpAMD64VPMOVQBMasked128_128Merging
	OpAMD64VPMOVQBMasked128_256Merging
	OpAMD64VPMOVQBMasked128_512Merging
	OpAMD64VPMOVQDMasked128_128Merging
	OpAMD64VPMOVQDMasked128_256Merging
	OpAMD64VPMOVQDMasked256Merging
	OpAMD64VPMOVQWMasked128_128Merging
	OpAMD64VPMOVQWMasked128_256Merging
	OpAMD64VPMOVQWMasked128_512Merging
	OpAMD64VPMOVSDBMasked128_128Merging
	OpAMD64VPMOVSDBMasked128_256Merging
	OpAMD64VPMOVSDBMasked128_512Merging
	OpAMD64VPMOVSDWMasked128_128Merging
	OpAMD64VPMOVSDWMasked128_256Merging
	OpAMD64VPMOVSDWMasked256Merging
	OpAMD64VPMOVSQBMasked128_128Merging
	OpAMD64VPMOVSQBMasked128_256Merging
	OpAMD64VPMOVSQBMasked128_512Merging
	OpAMD64VPMOVSQDMasked128_128Merging
	OpAMD64VPMOVSQDMasked128_256Merging
	OpAMD64VPMOVSQDMasked256Merging
	OpAMD64VPMOVSQWMasked128_128Merging
	OpAMD64VPMOVSQWMasked128_256Merging
	OpAMD64VPMOVSQWMasked128_512Merging
	OpAMD64VPMOVSWBMasked128_128Merging
	OpAMD64VPMOVSWBMasked128_256Merging
	OpAMD64VPMOVSWBMasked256Merging
	OpAMD64VPMOVSXBDMasked128Merging
	OpAMD64VPMOVSXBDMasked256Merging
	OpAMD64VPMOVSXBDMasked512Merging
	OpAMD64VPMOVSXBQMasked128Merging
	OpAMD64VPMOVSXBQMasked256Merging
	OpAMD64VPMOVSXBQMasked512Merging
	OpAMD64VPMOVSXBWMasked128Merging
	OpAMD64VPMOVSXBWMasked256Merging
	OpAMD64VPMOVSXBWMasked512Merging
	OpAMD64VPMOVSXDQMasked128Merging
	OpAMD64VPMOVSXDQMasked256Merging
	OpAMD64VPMOVSXDQMasked512Merging
	OpAMD64VPMOVSXWDMasked128Merging
	OpAMD64VPMOVSXWDMasked256Merging
	OpAMD64VPMOVSXWDMasked512Merging
	OpAMD64VPMOVSXWQMasked128Merging
	OpAMD64VPMOVSXWQMasked256Merging
	OpAMD64VPMOVSXWQMasked512Merging
	OpAMD64VPMOVUSDBMasked128_128Merging
	OpAMD64VPMOVUSDBMasked128_256Merging
	OpAMD64VPMOVUSDBMasked128_512Merging
	OpAMD64VPMOVUSDWMasked128_128Merging
	OpAMD64VPMOVUSDWMasked128_256Merging
	OpAMD64VPMOVUSDWMasked256Merging
	OpAMD64VPMOVUSQBMasked128_128Merging
	OpAMD64VPMOVUSQBMasked128_256Merging
	OpAMD64VPMOVUSQBMasked128_512Merging
	OpAMD64VPMOVUSQDMasked128_128Merging
	OpAMD64VPMOVUSQDMasked128_256Merging
	OpAMD64VPMOVUSQDMasked256Merging
	OpAMD64VPMOVUSQWMasked128_128Merging
	OpAMD64VPMOVUSQWMasked128_256Merging
	OpAMD64VPMOVUSQWMasked128_512Merging
	OpAMD64VPMOVUSWBMasked128_128Merging
	OpAMD64VPMOVUSWBMasked128_256Merging
	OpAMD64VPMOVUSWBMasked256Merging
	OpAMD64VPMOVWBMasked128_128Merging
	OpAMD64VPMOVWBMasked128_256Merging
	OpAMD64VPMOVWBMasked256Merging
	OpAMD64VPMOVZXBDMasked128Merging
	OpAMD64VPMOVZXBDMasked256Merging
	OpAMD64VPMOVZXBDMasked512Merging
	OpAMD64VPMOVZXBQMasked128Merging
	OpAMD64VPMOVZXBQMasked256Merging
	OpAMD64VPMOVZXBQMasked512Merging
	OpAMD64VPMOVZXBWMasked128Merging
	OpAMD64VPMOVZXBWMasked256Merging
	OpAMD64VPMOVZXBWMasked512Merging
	OpAMD64VPMOVZXDQMasked128Merging
	OpAMD64VPMOVZXDQMasked256Merging
	OpAMD64VPMOVZXDQMasked512Merging
	OpAMD64VPMOVZXWDMasked128Merging
	OpAMD64VPMOVZXWDMasked256Merging
	OpAMD64VPMOVZXWDMasked512Merging
	OpAMD64VPMOVZXWQMasked128Merging
	OpAMD64VPMOVZXWQMasked256Merging
	OpAMD64VPMOVZXWQMasked512Merging
	OpAMD64VPMULHUWMasked128Merging
	OpAMD64VPMULHUWMasked256Merging
	OpAMD64VPMULHUWMasked512Merging
	OpAMD64VPMULHWMasked128Merging
	OpAMD64VPMULHWMasked256Merging
	OpAMD64VPMULHWMasked512Merging
	OpAMD64VPMULLDMasked128Merging
	OpAMD64VPMULLDMasked256Merging
	OpAMD64VPMULLDMasked512Merging
	OpAMD64VPMULLQMasked128Merging
	OpAMD64VPMULLQMasked256Merging
	OpAMD64VPMULLQMasked512Merging
	OpAMD64VPMULLWMasked128Merging
	OpAMD64VPMULLWMasked256Merging
	OpAMD64VPMULLWMasked512Merging
	OpAMD64VPOPCNTBMasked128Merging
	OpAMD64VPOPCNTBMasked256Merging
	OpAMD64VPOPCNTBMasked512Merging
	OpAMD64VPOPCNTDMasked128Merging
	OpAMD64VPOPCNTDMasked256Merging
	OpAMD64VPOPCNTDMasked512Merging
	OpAMD64VPOPCNTQMasked128Merging
	OpAMD64VPOPCNTQMasked256Merging
	OpAMD64VPOPCNTQMasked512Merging
	OpAMD64VPOPCNTWMasked128Merging
	OpAMD64VPOPCNTWMasked256Merging
	OpAMD64VPOPCNTWMasked512Merging
	OpAMD64VPORDMasked128Merging
	OpAMD64VPORDMasked256Merging
	OpAMD64VPORDMasked512Merging
	OpAMD64VPORQMasked128Merging
	OpAMD64VPORQMasked256Merging
	OpAMD64VPORQMasked512Merging
	OpAMD64VPROLVDMasked128Merging
	OpAMD64VPROLVDMasked256Merging
	OpAMD64VPROLVDMasked512Merging
	OpAMD64VPROLVQMasked128Merging
	OpAMD64VPROLVQMasked256Merging
	OpAMD64VPROLVQMasked512Merging
	OpAMD64VPRORVDMasked128Merging
	OpAMD64VPRORVDMasked256Merging
	OpAMD64VPRORVDMasked512Merging
	OpAMD64VPRORVQMasked128Merging
	OpAMD64VPRORVQMasked256Merging
	OpAMD64VPRORVQMasked512Merging
	OpAMD64VPSHUFBMasked128Merging
	OpAMD64VPSHUFBMasked256Merging
	OpAMD64VPSHUFBMasked512Merging
	OpAMD64VPSLLVDMasked128Merging
	OpAMD64VPSLLVDMasked256Merging
	OpAMD64VPSLLVDMasked512Merging
	OpAMD64VPSLLVQMasked128Merging
	OpAMD64VPSLLVQMasked256Merging
	OpAMD64VPSLLVQMasked512Merging
	OpAMD64VPSLLVWMasked128Merging
	OpAMD64VPSLLVWMasked256Merging
	OpAMD64VPSLLVWMasked512Merging
	OpAMD64VPSRAVDMasked128Merging
	OpAMD64VPSRAVDMasked256Merging
	OpAMD64VPSRAVDMasked512Merging
	OpAMD64VPSRAVQMasked128Merging
	OpAMD64VPSRAVQMasked256Merging
	OpAMD64VPSRAVQMasked512Merging
	OpAMD64VPSRAVWMasked128Merging
	OpAMD64VPSRAVWMasked256Merging
	OpAMD64VPSRAVWMasked512Merging
	OpAMD64VPSRLVDMasked128Merging
	OpAMD64VPSRLVDMasked256Merging
	OpAMD64VPSRLVDMasked512Merging
	OpAMD64VPSRLVQMasked128Merging
	OpAMD64VPSRLVQMasked256Merging
	OpAMD64VPSRLVQMasked512Merging
	OpAMD64VPSRLVWMasked128Merging
	OpAMD64VPSRLVWMasked256Merging
	OpAMD64VPSRLVWMasked512Merging
	OpAMD64VPSUBBMasked128Merging
	OpAMD64VPSUBBMasked256Merging
	OpAMD64VPSUBBMasked512Merging
	OpAMD64VPSUBDMasked128Merging
	OpAMD64VPSUBDMasked256Merging
	OpAMD64VPSUBDMasked512Merging
	OpAMD64VPSUBQMasked128Merging
	OpAMD64VPSUBQMasked256Merging
	OpAMD64VPSUBQMasked512Merging
	OpAMD64VPSUBSBMasked128Merging
	OpAMD64VPSUBSBMasked256Merging
	OpAMD64VPSUBSBMasked512Merging
	OpAMD64VPSUBSWMasked128Merging
	OpAMD64VPSUBSWMasked256Merging
	OpAMD64VPSUBSWMasked512Merging
	OpAMD64VPSUBUSBMasked128Merging
	OpAMD64VPSUBUSBMasked256Merging
	OpAMD64VPSUBUSBMasked512Merging
	OpAMD64VPSUBUSWMasked128Merging
	OpAMD64VPSUBUSWMasked256Merging
	OpAMD64VPSUBUSWMasked512Merging
	OpAMD64VPSUBWMasked128Merging
	OpAMD64VPSUBWMasked256Merging
	OpAMD64VPSUBWMasked512Merging
	OpAMD64VPXORDMasked128Merging
	OpAMD64VPXORDMasked256Merging
	OpAMD64VPXORDMasked512Merging
	OpAMD64VPXORQMasked128Merging
	OpAMD64VPXORQMasked256Merging
	OpAMD64VPXORQMasked512Merging
	OpAMD64VRCP14PDMasked128Merging
	OpAMD64VRCP14PDMasked256Merging
	OpAMD64VRCP14PDMasked512Merging
	OpAMD64VRCP14PSMasked128Merging
	OpAMD64VRCP14PSMasked256Merging
	OpAMD64VRCP14PSMasked512Merging
	OpAMD64VRSQRT14PDMasked128Merging
	OpAMD64VRSQRT14PDMasked256Merging
	OpAMD64VRSQRT14PDMasked512Merging
	OpAMD64VRSQRT14PSMasked128Merging
	OpAMD64VRSQRT14PSMasked256Merging
	OpAMD64VRSQRT14PSMasked512Merging
	OpAMD64VSCALEFPDMasked128Merging
	OpAMD64VSCALEFPDMasked256Merging
	OpAMD64VSCALEFPDMasked512Merging
	OpAMD64VSCALEFPSMasked128Merging
	OpAMD64VSCALEFPSMasked256Merging
	OpAMD64VSCALEFPSMasked512Merging
	OpAMD64VSQRTPDMasked128Merging
	OpAMD64VSQRTPDMasked256Merging
	OpAMD64VSQRTPDMasked512Merging
	OpAMD64VSQRTPSMasked128Merging
	OpAMD64VSQRTPSMasked256Merging
	OpAMD64VSQRTPSMasked512Merging
	OpAMD64VSUBPDMasked128Merging
	OpAMD64VSUBPDMasked256Merging
	OpAMD64VSUBPDMasked512Merging
	OpAMD64VSUBPSMasked128Merging
	OpAMD64VSUBPSMasked256Merging
	OpAMD64VSUBPSMasked512Merging
	OpAMD64VPALIGNRMasked128Merging
	OpAMD64VPALIGNRMasked256Merging
	OpAMD64VPALIGNRMasked512Merging
	OpAMD64VPROLDMasked128Merging
	OpAMD64VPROLDMasked256Merging
	OpAMD64VPROLDMasked512Merging
	OpAMD64VPROLQMasked128Merging
	OpAMD64VPROLQMasked256Merging
	OpAMD64VPROLQMasked512Merging
	OpAMD64VPRORDMasked128Merging
	OpAMD64VPRORDMasked256Merging
	OpAMD64VPRORDMasked512Merging
	OpAMD64VPRORQMasked128Merging
	OpAMD64VPRORQMasked256Merging
	OpAMD64VPRORQMasked512Merging
	OpAMD64VPSHLDDMasked128Merging
	OpAMD64VPSHLDDMasked256Merging
	OpAMD64VPSHLDDMasked512Merging
	OpAMD64VPSHLDQMasked128Merging
	OpAMD64VPSHLDQMasked256Merging
	OpAMD64VPSHLDQMasked512Merging
	OpAMD64VPSHLDWMasked128Merging
	OpAMD64VPSHLDWMasked256Merging
	OpAMD64VPSHLDWMasked512Merging
	OpAMD64VPSHRDDMasked128Merging
	OpAMD64VPSHRDDMasked256Merging
	OpAMD64VPSHRDDMasked512Merging
	OpAMD64VPSHRDQMasked128Merging
	OpAMD64VPSHRDQMasked256Merging
	OpAMD64VPSHRDQMasked512Merging
	OpAMD64VPSHRDWMasked128Merging
	OpAMD64VPSHRDWMasked256Merging
	OpAMD64VPSHRDWMasked512Merging
	OpAMD64VPSHUFDMasked128Merging
	OpAMD64VPSHUFDMasked256Merging
	OpAMD64VPSHUFDMasked512Merging
	OpAMD64VPSHUFHWMasked128Merging
	OpAMD64VPSHUFHWMasked256Merging
	OpAMD64VPSHUFHWMasked512Merging
	OpAMD64VPSHUFLWMasked128Merging
	OpAMD64VPSHUFLWMasked256Merging
	OpAMD64VPSHUFLWMasked512Merging
	OpAMD64VPSLLDMasked128constMerging
	OpAMD64VPSLLDMasked256constMerging
	OpAMD64VPSLLDMasked512constMerging
	OpAMD64VPSLLQMasked128constMerging
	OpAMD64VPSLLQMasked256constMerging
	OpAMD64VPSLLQMasked512constMerging
	OpAMD64VPSLLWMasked128constMerging
	OpAMD64VPSLLWMasked256constMerging
	OpAMD64VPSLLWMasked512constMerging
	OpAMD64VPSRADMasked128constMerging
	OpAMD64VPSRADMasked256constMerging
	OpAMD64VPSRADMasked512constMerging
	OpAMD64VPSRAQMasked128constMerging
	OpAMD64VPSRAQMasked256constMerging
	OpAMD64VPSRAQMasked512constMerging
	OpAMD64VPSRAWMasked128constMerging
	OpAMD64VPSRAWMasked256constMerging
	OpAMD64VPSRAWMasked512constMerging
	OpAMD64VPSRLDMasked128constMerging
	OpAMD64VPSRLDMasked256constMerging
	OpAMD64VPSRLDMasked512constMerging
	OpAMD64VPSRLQMasked128constMerging
	OpAMD64VPSRLQMasked256constMerging
	OpAMD64VPSRLQMasked512constMerging
	OpAMD64VPSRLWMasked128constMerging
	OpAMD64VPSRLWMasked256constMerging
	OpAMD64VPSRLWMasked512constMerging
	OpAMD64VREDUCEPDMasked128Merging
	OpAMD64VREDUCEPDMasked256Merging
	OpAMD64VREDUCEPDMasked512Merging
	OpAMD64VREDUCEPSMasked128Merging
	OpAMD64VREDUCEPSMasked256Merging
	OpAMD64VREDUCEPSMasked512Merging
	OpAMD64VRNDSCALEPDMasked128Merging
	OpAMD64VRNDSCALEPDMasked256Merging
	OpAMD64VRNDSCALEPDMasked512Merging
	OpAMD64VRNDSCALEPSMasked128Merging
	OpAMD64VRNDSCALEPSMasked256Merging
	OpAMD64VRNDSCALEPSMasked512Merging

	OpARMADD
	OpARMADDconst
	OpARMSUB
	OpARMSUBconst
	OpARMRSB
	OpARMRSBconst
	OpARMMUL
	OpARMHMUL
	OpARMHMULU
	OpARMCALLudiv
	OpARMADDS
	OpARMADDSconst
	OpARMADC
	OpARMADCconst
	OpARMADCS
	OpARMSUBS
	OpARMSUBSconst
	OpARMRSBSconst
	OpARMSBC
	OpARMSBCconst
	OpARMRSCconst
	OpARMMULLU
	OpARMMULA
	OpARMMULS
	OpARMADDF
	OpARMADDD
	OpARMSUBF
	OpARMSUBD
	OpARMMULF
	OpARMMULD
	OpARMNMULF
	OpARMNMULD
	OpARMDIVF
	OpARMDIVD
	OpARMMULAF
	OpARMMULAD
	OpARMMULSF
	OpARMMULSD
	OpARMFMULAD
	OpARMAND
	OpARMANDconst
	OpARMOR
	OpARMORconst
	OpARMXOR
	OpARMXORconst
	OpARMBIC
	OpARMBICconst
	OpARMBFX
	OpARMBFXU
	OpARMMVN
	OpARMNEGF
	OpARMNEGD
	OpARMSQRTD
	OpARMSQRTF
	OpARMABSD
	OpARMCLZ
	OpARMREV
	OpARMREV16
	OpARMRBIT
	OpARMSLL
	OpARMSLLconst
	OpARMSRL
	OpARMSRLconst
	OpARMSRA
	OpARMSRAconst
	OpARMSRR
	OpARMSRRconst
	OpARMADDshiftLL
	OpARMADDshiftRL
	OpARMADDshiftRA
	OpARMSUBshiftLL
	OpARMSUBshiftRL
	OpARMSUBshiftRA
	OpARMRSBshiftLL
	OpARMRSBshiftRL
	OpARMRSBshiftRA
	OpARMANDshiftLL
	OpARMANDshiftRL
	OpARMANDshiftRA
	OpARMORshiftLL
	OpARMORshiftRL
	OpARMORshiftRA
	OpARMXORshiftLL
	OpARMXORshiftRL
	OpARMXORshiftRA
	OpARMXORshiftRR
	OpARMBICshiftLL
	OpARMBICshiftRL
	OpARMBICshiftRA
	OpARMMVNshiftLL
	OpARMMVNshiftRL
	OpARMMVNshiftRA
	OpARMADCshiftLL
	OpARMADCshiftRL
	OpARMADCshiftRA
	OpARMSBCshiftLL
	OpARMSBCshiftRL
	OpARMSBCshiftRA
	OpARMRSCshiftLL
	OpARMRSCshiftRL
	OpARMRSCshiftRA
	OpARMADDSshiftLL
	OpARMADDSshiftRL
	OpARMADDSshiftRA
	OpARMSUBSshiftLL
	OpARMSUBSshiftRL
	OpARMSUBSshiftRA
	OpARMRSBSshiftLL
	OpARMRSBSshiftRL
	OpARMRSBSshiftRA
	OpARMADDshiftLLreg
	OpARMADDshiftRLreg
	OpARMADDshiftRAreg
	OpARMSUBshiftLLreg
	OpARMSUBshiftRLreg
	OpARMSUBshiftRAreg
	OpARMRSBshiftLLreg
	OpARMRSBshiftRLreg
	OpARMRSBshiftRAreg
	OpARMANDshiftLLreg
	OpARMANDshiftRLreg
	OpARMANDshiftRAreg
	OpARMORshiftLLreg
	OpARMORshiftRLreg
	OpARMORshiftRAreg
	OpARMXORshiftLLreg
	OpARMXORshiftRLreg
	OpARMXORshiftRAreg
	OpARMBICshiftLLreg
	OpARMBICshiftRLreg
	OpARMBICshiftRAreg
	OpARMMVNshiftLLreg
	OpARMMVNshiftRLreg
	OpARMMVNshiftRAreg
	OpARMADCshiftLLreg
	OpARMADCshiftRLreg
	OpARMADCshiftRAreg
	OpARMSBCshiftLLreg
	OpARMSBCshiftRLreg
	OpARMSBCshiftRAreg
	OpARMRSCshiftLLreg
	OpARMRSCshiftRLreg
	OpARMRSCshiftRAreg
	OpARMADDSshiftLLreg
	OpARMADDSshiftRLreg
	OpARMADDSshiftRAreg
	OpARMSUBSshiftLLreg
	OpARMSUBSshiftRLreg
	OpARMSUBSshiftRAreg
	OpARMRSBSshiftLLreg
	OpARMRSBSshiftRLreg
	OpARMRSBSshiftRAreg
	OpARMCMP
	OpARMCMPconst
	OpARMCMN
	OpARMCMNconst
	OpARMTST
	OpARMTSTconst
	OpARMTEQ
	OpARMTEQconst
	OpARMCMPF
	OpARMCMPD
	OpARMCMPshiftLL
	OpARMCMPshiftRL
	OpARMCMPshiftRA
	OpARMCMNshiftLL
	OpARMCMNshiftRL
	OpARMCMNshiftRA
	OpARMTSTshiftLL
	OpARMTSTshiftRL
	OpARMTSTshiftRA
	OpARMTEQshiftLL
	OpARMTEQshiftRL
	OpARMTEQshiftRA
	OpARMCMPshiftLLreg
	OpARMCMPshiftRLreg
	OpARMCMPshiftRAreg
	OpARMCMNshiftLLreg
	OpARMCMNshiftRLreg
	OpARMCMNshiftRAreg
	OpARMTSTshiftLLreg
	OpARMTSTshiftRLreg
	OpARMTSTshiftRAreg
	OpARMTEQshiftLLreg
	OpARMTEQshiftRLreg
	OpARMTEQshiftRAreg
	OpARMCMPF0
	OpARMCMPD0
	OpARMMOVWconst
	OpARMMOVFconst
	OpARMMOVDconst
	OpARMMOVWaddr
	OpARMMOVBload
	OpARMMOVBUload
	OpARMMOVHload
	OpARMMOVHUload
	OpARMMOVWload
	OpARMMOVFload
	OpARMMOVDload
	OpARMMOVBstore
	OpARMMOVHstore
	OpARMMOVWstore
	OpARMMOVFstore
	OpARMMOVDstore
	OpARMMOVWloadidx
	OpARMMOVWloadshiftLL
	OpARMMOVWloadshiftRL
	OpARMMOVWloadshiftRA
	OpARMMOVBUloadidx
	OpARMMOVBloadidx
	OpARMMOVHUloadidx
	OpARMMOVHloadidx
	OpARMMOVWstoreidx
	OpARMMOVWstoreshiftLL
	OpARMMOVWstoreshiftRL
	OpARMMOVWstoreshiftRA
	OpARMMOVBstoreidx
	OpARMMOVHstoreidx
	OpARMMOVBreg
	OpARMMOVBUreg
	OpARMMOVHreg
	OpARMMOVHUreg
	OpARMMOVWreg
	OpARMMOVWnop
	OpARMMOVWF
	OpARMMOVWD
	OpARMMOVWUF
	OpARMMOVWUD
	OpARMMOVFW
	OpARMMOVDW
	OpARMMOVFWU
	OpARMMOVDWU
	OpARMMOVFD
	OpARMMOVDF
	OpARMCMOVWHSconst
	OpARMCMOVWLSconst
	OpARMSRAcond
	OpARMCALLstatic
	OpARMCALLtail
	OpARMCALLclosure
	OpARMCALLinter
	OpARMLoweredNilCheck
	OpARMEqual
	OpARMNotEqual
	OpARMLessThan
	OpARMLessEqual
	OpARMGreaterThan
	OpARMGreaterEqual
	OpARMLessThanU
	OpARMLessEqualU
	OpARMGreaterThanU
	OpARMGreaterEqualU
	OpARMDUFFZERO
	OpARMDUFFCOPY
	OpARMLoweredZero
	OpARMLoweredMove
	OpARMLoweredGetClosurePtr
	OpARMLoweredGetCallerSP
	OpARMLoweredGetCallerPC
	OpARMLoweredPanicBoundsRR
	OpARMLoweredPanicBoundsRC
	OpARMLoweredPanicBoundsCR
	OpARMLoweredPanicBoundsCC
	OpARMLoweredPanicExtendRR
	OpARMLoweredPanicExtendRC
	OpARMFlagConstant
	OpARMInvertFlags
	OpARMLoweredWB

	OpARM64ADCSflags
	OpARM64ADCzerocarry
	OpARM64ADD
	OpARM64ADDconst
	OpARM64ADDSconstflags
	OpARM64ADDSflags
	OpARM64SUB
	OpARM64SUBconst
	OpARM64SBCSflags
	OpARM64SUBSflags
	OpARM64MUL
	OpARM64MULW
	OpARM64MNEG
	OpARM64MNEGW
	OpARM64MULH
	OpARM64UMULH
	OpARM64MULL
	OpARM64UMULL
	OpARM64DIV
	OpARM64UDIV
	OpARM64DIVW
	OpARM64UDIVW
	OpARM64MOD
	OpARM64UMOD
	OpARM64MODW
	OpARM64UMODW
	OpARM64FADDS
	OpARM64FADDD
	OpARM64FSUBS
	OpARM64FSUBD
	OpARM64FMULS
	OpARM64FMULD
	OpARM64FNMULS
	OpARM64FNMULD
	OpARM64FDIVS
	OpARM64FDIVD
	OpARM64AND
	OpARM64ANDconst
	OpARM64OR
	OpARM64ORconst
	OpARM64XOR
	OpARM64XORconst
	OpARM64BIC
	OpARM64EON
	OpARM64ORN
	OpARM64MVN
	OpARM64NEG
	OpARM64NEGSflags
	OpARM64NGCzerocarry
	OpARM64FABSD
	OpARM64FNEGS
	OpARM64FNEGD
	OpARM64FSQRTD
	OpARM64FSQRTS
	OpARM64FMIND
	OpARM64FMINS
	OpARM64FMAXD
	OpARM64FMAXS
	OpARM64REV
	OpARM64REVW
	OpARM64REV16
	OpARM64REV16W
	OpARM64RBIT
	OpARM64RBITW
	OpARM64CLZ
	OpARM64CLZW
	OpARM64VCNT
	OpARM64VUADDLV
	OpARM64LoweredRound32F
	OpARM64LoweredRound64F
	OpARM64FMADDS
	OpARM64FMADDD
	OpARM64FNMADDS
	OpARM64FNMADDD
	OpARM64FMSUBS
	OpARM64FMSUBD
	OpARM64FNMSUBS
	OpARM64FNMSUBD
	OpARM64MADD
	OpARM64MADDW
	OpARM64MSUB
	OpARM64MSUBW
	OpARM64SLL
	OpARM64SLLconst
	OpARM64SRL
	OpARM64SRLconst
	OpARM64SRA
	OpARM64SRAconst
	OpARM64ROR
	OpARM64RORW
	OpARM64RORconst
	OpARM64RORWconst
	OpARM64EXTRconst
	OpARM64EXTRWconst
	OpARM64CMP
	OpARM64CMPconst
	OpARM64CMPW
	OpARM64CMPWconst
	OpARM64CMN
	OpARM64CMNconst
	OpARM64CMNW
	OpARM64CMNWconst
	OpARM64TST
	OpARM64TSTconst
	OpARM64TSTW
	OpARM64TSTWconst
	OpARM64FCMPS
	OpARM64FCMPD
	OpARM64FCMPS0
	OpARM64FCMPD0
	OpARM64MVNshiftLL
	OpARM64MVNshiftRL
	OpARM64MVNshiftRA
	OpARM64MVNshiftRO
	OpARM64NEGshiftLL
	OpARM64NEGshiftRL
	OpARM64NEGshiftRA
	OpARM64ADDshiftLL
	OpARM64ADDshiftRL
	OpARM64ADDshiftRA
	OpARM64SUBshiftLL
	OpARM64SUBshiftRL
	OpARM64SUBshiftRA
	OpARM64ANDshiftLL
	OpARM64ANDshiftRL
	OpARM64ANDshiftRA
	OpARM64ANDshiftRO
	OpARM64ORshiftLL
	OpARM64ORshiftRL
	OpARM64ORshiftRA
	OpARM64ORshiftRO
	OpARM64XORshiftLL
	OpARM64XORshiftRL
	OpARM64XORshiftRA
	OpARM64XORshiftRO
	OpARM64BICshiftLL
	OpARM64BICshiftRL
	OpARM64BICshiftRA
	OpARM64BICshiftRO
	OpARM64EONshiftLL
	OpARM64EONshiftRL
	OpARM64EONshiftRA
	OpARM64EONshiftRO
	OpARM64ORNshiftLL
	OpARM64ORNshiftRL
	OpARM64ORNshiftRA
	OpARM64ORNshiftRO
	OpARM64CMPshiftLL
	OpARM64CMPshiftRL
	OpARM64CMPshiftRA
	OpARM64CMNshiftLL
	OpARM64CMNshiftRL
	OpARM64CMNshiftRA
	OpARM64TSTshiftLL
	OpARM64TSTshiftRL
	OpARM64TSTshiftRA
	OpARM64TSTshiftRO
	OpARM64BFI
	OpARM64BFXIL
	OpARM64SBFIZ
	OpARM64SBFX
	OpARM64UBFIZ
	OpARM64UBFX
	OpARM64MOVDconst
	OpARM64FMOVSconst
	OpARM64FMOVDconst
	OpARM64MOVDaddr
	OpARM64MOVBload
	OpARM64MOVBUload
	OpARM64MOVHload
	OpARM64MOVHUload
	OpARM64MOVWload
	OpARM64MOVWUload
	OpARM64MOVDload
	OpARM64FMOVSload
	OpARM64FMOVDload
	OpARM64LDP
	OpARM64LDPW
	OpARM64LDPSW
	OpARM64FLDPD
	OpARM64FLDPS
	OpARM64MOVDloadidx
	OpARM64MOVWloadidx
	OpARM64MOVWUloadidx
	OpARM64MOVHloadidx
	OpARM64MOVHUloadidx
	OpARM64MOVBloadidx
	OpARM64MOVBUloadidx
	OpARM64FMOVSloadidx
	OpARM64FMOVDloadidx
	OpARM64MOVHloadidx2
	OpARM64MOVHUloadidx2
	OpARM64MOVWloadidx4
	OpARM64MOVWUloadidx4
	OpARM64MOVDloadidx8
	OpARM64FMOVSloadidx4
	OpARM64FMOVDloadidx8
	OpARM64MOVBstore
	OpARM64MOVHstore
	OpARM64MOVWstore
	OpARM64MOVDstore
	OpARM64FMOVSstore
	OpARM64FMOVDstore
	OpARM64STP
	OpARM64STPW
	OpARM64FSTPD
	OpARM64FSTPS
	OpARM64MOVBstoreidx
	OpARM64MOVHstoreidx
	OpARM64MOVWstoreidx
	OpARM64MOVDstoreidx
	OpARM64FMOVSstoreidx
	OpARM64FMOVDstoreidx
	OpARM64MOVHstoreidx2
	OpARM64MOVWstoreidx4
	OpARM64MOVDstoreidx8
	OpARM64FMOVSstoreidx4
	OpARM64FMOVDstoreidx8
	OpARM64FMOVDgpfp
	OpARM64FMOVDfpgp
	OpARM64FMOVSgpfp
	OpARM64FMOVSfpgp
	OpARM64MOVBreg
	OpARM64MOVBUreg
	OpARM64MOVHreg
	OpARM64MOVHUreg
	OpARM64MOVWreg
	OpARM64MOVWUreg
	OpARM64MOVDreg
	OpARM64MOVDnop
	OpARM64SCVTFWS
	OpARM64SCVTFWD
	OpARM64UCVTFWS
	OpARM64UCVTFWD
	OpARM64SCVTFS
	OpARM64SCVTFD
	OpARM64UCVTFS
	OpARM64UCVTFD
	OpARM64FCVTZSSW
	OpARM64FCVTZSDW
	OpARM64FCVTZUSW
	OpARM64FCVTZUDW
	OpARM64FCVTZSS
	OpARM64FCVTZSD
	OpARM64FCVTZUS
	OpARM64FCVTZUD
	OpARM64FCVTSD
	OpARM64FCVTDS
	OpARM64FRINTAD
	OpARM64FRINTMD
	OpARM64FRINTND
	OpARM64FRINTPD
	OpARM64FRINTZD
	OpARM64CSEL
	OpARM64CSEL0
	OpARM64CSINC
	OpARM64CSINV
	OpARM64CSNEG
	OpARM64CSETM
	OpARM64CCMP
	OpARM64CCMN
	OpARM64CCMPconst
	OpARM64CCMNconst
	OpARM64CCMPW
	OpARM64CCMNW
	OpARM64CCMPWconst
	OpARM64CCMNWconst
	OpARM64CALLstatic
	OpARM64CALLtail
	OpARM64CALLclosure
	OpARM64CALLinter
	OpARM64LoweredNilCheck
	OpARM64LoweredMemEq
	OpARM64Equal
	OpARM64NotEqual
	OpARM64LessThan
	OpARM64LessEqual
	OpARM64GreaterThan
	OpARM64GreaterEqual
	OpARM64LessThanU
	OpARM64LessEqualU
	OpARM64GreaterThanU
	OpARM64GreaterEqualU
	OpARM64LessThanF
	OpARM64LessEqualF
	OpARM64GreaterThanF
	OpARM64GreaterEqualF
	OpARM64NotLessThanF
	OpARM64NotLessEqualF
	OpARM64NotGreaterThanF
	OpARM64NotGreaterEqualF
	OpARM64LessThanNoov
	OpARM64GreaterEqualNoov
	OpARM64LoweredZero
	OpARM64LoweredZeroLoop
	OpARM64LoweredMove
	OpARM64LoweredMoveLoop
	OpARM64LoweredGetClosurePtr
	OpARM64LoweredGetCallerSP
	OpARM64LoweredGetCallerPC
	OpARM64FlagConstant
	OpARM64InvertFlags
	OpARM64LDAR
	OpARM64LDARB
	OpARM64LDARW
	OpARM64STLRB
	OpARM64STLR
	OpARM64STLRW
	OpARM64LoweredAtomicExchange64
	OpARM64LoweredAtomicExchange32
	OpARM64LoweredAtomicExchange8
	OpARM64LoweredAtomicExchange64Variant
	OpARM64LoweredAtomicExchange32Variant
	OpARM64LoweredAtomicExchange8Variant
	OpARM64LoweredAtomicAdd64
	OpARM64LoweredAtomicAdd32
	OpARM64LoweredAtomicAdd64Variant
	OpARM64LoweredAtomicAdd32Variant
	OpARM64LoweredAtomicCas64
	OpARM64LoweredAtomicCas32
	OpARM64LoweredAtomicCas64Variant
	OpARM64LoweredAtomicCas32Variant
	OpARM64LoweredAtomicAnd8
	OpARM64LoweredAtomicOr8
	OpARM64LoweredAtomicAnd64
	OpARM64LoweredAtomicOr64
	OpARM64LoweredAtomicAnd32
	OpARM64LoweredAtomicOr32
	OpARM64LoweredAtomicAnd8Variant
	OpARM64LoweredAtomicOr8Variant
	OpARM64LoweredAtomicAnd64Variant
	OpARM64LoweredAtomicOr64Variant
	OpARM64LoweredAtomicAnd32Variant
	OpARM64LoweredAtomicOr32Variant
	OpARM64LoweredWB
	OpARM64LoweredPanicBoundsRR
	OpARM64LoweredPanicBoundsRC
	OpARM64LoweredPanicBoundsCR
	OpARM64LoweredPanicBoundsCC
	OpARM64PRFM
	OpARM64DMB
	OpARM64ZERO

	OpLOONG64NEGV
	OpLOONG64NEGF
	OpLOONG64NEGD
	OpLOONG64SQRTD
	OpLOONG64SQRTF
	OpLOONG64ABSD
	OpLOONG64CLZW
	OpLOONG64CLZV
	OpLOONG64CTZW
	OpLOONG64CTZV
	OpLOONG64REVB2H
	OpLOONG64REVB2W
	OpLOONG64REVB4H
	OpLOONG64REVBV
	OpLOONG64BITREV4B
	OpLOONG64BITREVW
	OpLOONG64BITREVV
	OpLOONG64VPCNT64
	OpLOONG64VPCNT32
	OpLOONG64VPCNT16
	OpLOONG64ADDV
	OpLOONG64ADDVconst
	OpLOONG64ADDV16const
	OpLOONG64SUBV
	OpLOONG64SUBVconst
	OpLOONG64MULV
	OpLOONG64MULHV
	OpLOONG64MULHVU
	OpLOONG64MULH
	OpLOONG64MULHU
	OpLOONG64DIVV
	OpLOONG64DIVVU
	OpLOONG64REMV
	OpLOONG64REMVU
	OpLOONG64MULWVW
	OpLOONG64MULWVWU
	OpLOONG64ADDF
	OpLOONG64ADDD
	OpLOONG64SUBF
	OpLOONG64SUBD
	OpLOONG64MULF
	OpLOONG64MULD
	OpLOONG64DIVF
	OpLOONG64DIVD
	OpLOONG64AND
	OpLOONG64ANDconst
	OpLOONG64OR
	OpLOONG64ORconst
	OpLOONG64XOR
	OpLOONG64XORconst
	OpLOONG64NOR
	OpLOONG64NORconst
	OpLOONG64ANDN
	OpLOONG64ORN
	OpLOONG64FMADDF
	OpLOONG64FMADDD
	OpLOONG64FMSUBF
	OpLOONG64FMSUBD
	OpLOONG64FNMADDF
	OpLOONG64FNMADDD
	OpLOONG64FNMSUBF
	OpLOONG64FNMSUBD
	OpLOONG64FMINF
	OpLOONG64FMIND
	OpLOONG64FMAXF
	OpLOONG64FMAXD
	OpLOONG64MASKEQZ
	OpLOONG64MASKNEZ
	OpLOONG64FCOPYSGD
	OpLOONG64SLL
	OpLOONG64SLLV
	OpLOONG64SLLconst
	OpLOONG64SLLVconst
	OpLOONG64SRL
	OpLOONG64SRLV
	OpLOONG64SRLconst
	OpLOONG64SRLVconst
	OpLOONG64SRA
	OpLOONG64SRAV
	OpLOONG64SRAconst
	OpLOONG64SRAVconst
	OpLOONG64ROTR
	OpLOONG64ROTRV
	OpLOONG64ROTRconst
	OpLOONG64ROTRVconst
	OpLOONG64SGT
	OpLOONG64SGTconst
	OpLOONG64SGTU
	OpLOONG64SGTUconst
	OpLOONG64CMPEQF
	OpLOONG64CMPEQD
	OpLOONG64CMPGEF
	OpLOONG64CMPGED
	OpLOONG64CMPGTF
	OpLOONG64CMPGTD
	OpLOONG64BSTRPICKW
	OpLOONG64BSTRPICKV
	OpLOONG64MOVVconst
	OpLOONG64MOVFconst
	OpLOONG64MOVDconst
	OpLOONG64MOVVaddr
	OpLOONG64MOVBload
	OpLOONG64MOVBUload
	OpLOONG64MOVHload
	OpLOONG64MOVHUload
	OpLOONG64MOVWload
	OpLOONG64MOVWUload
	OpLOONG64MOVVload
	OpLOONG64MOVFload
	OpLOONG64MOVDload
	OpLOONG64MOVVloadidx
	OpLOONG64MOVWloadidx
	OpLOONG64MOVWUloadidx
	OpLOONG64MOVHloadidx
	OpLOONG64MOVHUloadidx
	OpLOONG64MOVBloadidx
	OpLOONG64MOVBUloadidx
	OpLOONG64MOVFloadidx
	OpLOONG64MOVDloadidx
	OpLOONG64MOVBstore
	OpLOONG64MOVHstore
	OpLOONG64MOVWstore
	OpLOONG64MOVVstore
	OpLOONG64MOVFstore
	OpLOONG64MOVDstore
	OpLOONG64MOVBstoreidx
	OpLOONG64MOVHstoreidx
	OpLOONG64MOVWstoreidx
	OpLOONG64MOVVstoreidx
	OpLOONG64MOVFstoreidx
	OpLOONG64MOVDstoreidx
	OpLOONG64MOVWfpgp
	OpLOONG64MOVWgpfp
	OpLOONG64MOVVfpgp
	OpLOONG64MOVVgpfp
	OpLOONG64MOVBreg
	OpLOONG64MOVBUreg
	OpLOONG64MOVHreg
	OpLOONG64MOVHUreg
	OpLOONG64MOVWreg
	OpLOONG64MOVWUreg
	OpLOONG64MOVVreg
	OpLOONG64MOVVnop
	OpLOONG64MOVWF
	OpLOONG64MOVWD
	OpLOONG64MOVVF
	OpLOONG64MOVVD
	OpLOONG64TRUNCFW
	OpLOONG64TRUNCDW
	OpLOONG64TRUNCFV
	OpLOONG64TRUNCDV
	OpLOONG64MOVFD
	OpLOONG64MOVDF
	OpLOONG64LoweredRound32F
	OpLOONG64LoweredRound64F
	OpLOONG64CALLstatic
	OpLOONG64CALLtail
	OpLOONG64CALLclosure
	OpLOONG64CALLinter
	OpLOONG64LoweredZero
	OpLOONG64LoweredZeroLoop
	OpLOONG64LoweredMove
	OpLOONG64LoweredMoveLoop
	OpLOONG64LoweredAtomicLoad8
	OpLOONG64LoweredAtomicLoad32
	OpLOONG64LoweredAtomicLoad64
	OpLOONG64LoweredAtomicStore8
	OpLOONG64LoweredAtomicStore32
	OpLOONG64LoweredAtomicStore64
	OpLOONG64LoweredAtomicStore8Variant
	OpLOONG64LoweredAtomicStore32Variant
	OpLOONG64LoweredAtomicStore64Variant
	OpLOONG64LoweredAtomicExchange32
	OpLOONG64LoweredAtomicExchange64
	OpLOONG64LoweredAtomicExchange8Variant
	OpLOONG64LoweredAtomicAdd32
	OpLOONG64LoweredAtomicAdd64
	OpLOONG64LoweredAtomicCas32
	OpLOONG64LoweredAtomicCas64
	OpLOONG64LoweredAtomicCas64Variant
	OpLOONG64LoweredAtomicCas32Variant
	OpLOONG64LoweredAtomicAnd32
	OpLOONG64LoweredAtomicOr32
	OpLOONG64LoweredAtomicAnd32value
	OpLOONG64LoweredAtomicAnd64value
	OpLOONG64LoweredAtomicOr32value
	OpLOONG64LoweredAtomicOr64value
	OpLOONG64LoweredNilCheck
	OpLOONG64FPFlagTrue
	OpLOONG64FPFlagFalse
	OpLOONG64LoweredGetClosurePtr
	OpLOONG64LoweredGetCallerSP
	OpLOONG64LoweredGetCallerPC
	OpLOONG64LoweredWB
	OpLOONG64LoweredPubBarrier
	OpLOONG64LoweredPanicBoundsRR
	OpLOONG64LoweredPanicBoundsRC
	OpLOONG64LoweredPanicBoundsCR
	OpLOONG64LoweredPanicBoundsCC
	OpLOONG64PRELD
	OpLOONG64PRELDX
	OpLOONG64ADDshiftLLV
	OpLOONG64ZERO

	OpMIPSADD
	OpMIPSADDconst
	OpMIPSSUB
	OpMIPSSUBconst
	OpMIPSMUL
	OpMIPSMULT
	OpMIPSMULTU
	OpMIPSDIV
	OpMIPSDIVU
	OpMIPSADDF
	OpMIPSADDD
	OpMIPSSUBF
	OpMIPSSUBD
	OpMIPSMULF
	OpMIPSMULD
	OpMIPSDIVF
	OpMIPSDIVD
	OpMIPSAND
	OpMIPSANDconst
	OpMIPSOR
	OpMIPSORconst
	OpMIPSXOR
	OpMIPSXORconst
	OpMIPSNOR
	OpMIPSNORconst
	OpMIPSNEG
	OpMIPSNEGF
	OpMIPSNEGD
	OpMIPSABSD
	OpMIPSSQRTD
	OpMIPSSQRTF
	OpMIPSSLL
	OpMIPSSLLconst
	OpMIPSSRL
	OpMIPSSRLconst
	OpMIPSSRA
	OpMIPSSRAconst
	OpMIPSCLZ
	OpMIPSSGT
	OpMIPSSGTconst
	OpMIPSSGTzero
	OpMIPSSGTU
	OpMIPSSGTUconst
	OpMIPSSGTUzero
	OpMIPSCMPEQF
	OpMIPSCMPEQD
	OpMIPSCMPGEF
	OpMIPSCMPGED
	OpMIPSCMPGTF
	OpMIPSCMPGTD
	OpMIPSMOVWconst
	OpMIPSMOVFconst
	OpMIPSMOVDconst
	OpMIPSMOVWaddr
	OpMIPSMOVBload
	OpMIPSMOVBUload
	OpMIPSMOVHload
	OpMIPSMOVHUload
	OpMIPSMOVWload
	OpMIPSMOVFload
	OpMIPSMOVDload
	OpMIPSMOVBstore
	OpMIPSMOVHstore
	OpMIPSMOVWstore
	OpMIPSMOVFstore
	OpMIPSMOVDstore
	OpMIPSMOVBstorezero
	OpMIPSMOVHstorezero
	OpMIPSMOVWstorezero
	OpMIPSMOVWfpgp
	OpMIPSMOVWgpfp
	OpMIPSMOVBreg
	OpMIPSMOVBUreg
	OpMIPSMOVHreg
	OpMIPSMOVHUreg
	OpMIPSMOVWreg
	OpMIPSMOVWnop
	OpMIPSCMOVZ
	OpMIPSCMOVZzero
	OpMIPSMOVWF
	OpMIPSMOVWD
	OpMIPSTRUNCFW
	OpMIPSTRUNCDW
	OpMIPSMOVFD
	OpMIPSMOVDF
	OpMIPSCALLstatic
	OpMIPSCALLtail
	OpMIPSCALLclosure
	OpMIPSCALLinter
	OpMIPSLoweredAtomicLoad8
	OpMIPSLoweredAtomicLoad32
	OpMIPSLoweredAtomicStore8
	OpMIPSLoweredAtomicStore32
	OpMIPSLoweredAtomicStorezero
	OpMIPSLoweredAtomicExchange
	OpMIPSLoweredAtomicAdd
	OpMIPSLoweredAtomicAddconst
	OpMIPSLoweredAtomicCas
	OpMIPSLoweredAtomicAnd
	OpMIPSLoweredAtomicOr
	OpMIPSLoweredZero
	OpMIPSLoweredMove
	OpMIPSLoweredNilCheck
	OpMIPSFPFlagTrue
	OpMIPSFPFlagFalse
	OpMIPSLoweredGetClosurePtr
	OpMIPSLoweredGetCallerSP
	OpMIPSLoweredGetCallerPC
	OpMIPSLoweredWB
	OpMIPSLoweredPubBarrier
	OpMIPSLoweredPanicBoundsRR
	OpMIPSLoweredPanicBoundsRC
	OpMIPSLoweredPanicBoundsCR
	OpMIPSLoweredPanicBoundsCC
	OpMIPSLoweredPanicExtendRR
	OpMIPSLoweredPanicExtendRC

	OpMIPS64ADDV
	OpMIPS64ADDVconst
	OpMIPS64SUBV
	OpMIPS64SUBVconst
	OpMIPS64MULV
	OpMIPS64MULVU
	OpMIPS64DIVV
	OpMIPS64DIVVU
	OpMIPS64ADDF
	OpMIPS64ADDD
	OpMIPS64SUBF
	OpMIPS64SUBD
	OpMIPS64MULF
	OpMIPS64MULD
	OpMIPS64DIVF
	OpMIPS64DIVD
	OpMIPS64AND
	OpMIPS64ANDconst
	OpMIPS64OR
	OpMIPS64ORconst
	OpMIPS64XOR
	OpMIPS64XORconst
	OpMIPS64NOR
	OpMIPS64NORconst
	OpMIPS64NEGV
	OpMIPS64NEGF
	OpMIPS64NEGD
	OpMIPS64ABSD
	OpMIPS64SQRTD
	OpMIPS64SQRTF
	OpMIPS64SLLV
	OpMIPS64SLLVconst
	OpMIPS64SRLV
	OpMIPS64SRLVconst
	OpMIPS64SRAV
	OpMIPS64SRAVconst
	OpMIPS64SGT
	OpMIPS64SGTconst
	OpMIPS64SGTU
	OpMIPS64SGTUconst
	OpMIPS64CMPEQF
	OpMIPS64CMPEQD
	OpMIPS64CMPGEF
	OpMIPS64CMPGED
	OpMIPS64CMPGTF
	OpMIPS64CMPGTD
	OpMIPS64MOVVconst
	OpMIPS64MOVFconst
	OpMIPS64MOVDconst
	OpMIPS64MOVVaddr
	OpMIPS64MOVBload
	OpMIPS64MOVBUload
	OpMIPS64MOVHload
	OpMIPS64MOVHUload
	OpMIPS64MOVWload
	OpMIPS64MOVWUload
	OpMIPS64MOVVload
	OpMIPS64MOVFload
	OpMIPS64MOVDload
	OpMIPS64MOVBstore
	OpMIPS64MOVHstore
	OpMIPS64MOVWstore
	OpMIPS64MOVVstore
	OpMIPS64MOVFstore
	OpMIPS64MOVDstore
	OpMIPS64ZERO
	OpMIPS64MOVWfpgp
	OpMIPS64MOVWgpfp
	OpMIPS64MOVVfpgp
	OpMIPS64MOVVgpfp
	OpMIPS64MOVBreg
	OpMIPS64MOVBUreg
	OpMIPS64MOVHreg
	OpMIPS64MOVHUreg
	OpMIPS64MOVWreg
	OpMIPS64MOVWUreg
	OpMIPS64MOVVreg
	OpMIPS64MOVVnop
	OpMIPS64MOVWF
	OpMIPS64MOVWD
	OpMIPS64MOVVF
	OpMIPS64MOVVD
	OpMIPS64TRUNCFW
	OpMIPS64TRUNCDW
	OpMIPS64TRUNCFV
	OpMIPS64TRUNCDV
	OpMIPS64MOVFD
	OpMIPS64MOVDF
	OpMIPS64CALLstatic
	OpMIPS64CALLtail
	OpMIPS64CALLclosure
	OpMIPS64CALLinter
	OpMIPS64DUFFZERO
	OpMIPS64DUFFCOPY
	OpMIPS64LoweredZero
	OpMIPS64LoweredMove
	OpMIPS64LoweredAtomicAnd32
	OpMIPS64LoweredAtomicOr32
	OpMIPS64LoweredAtomicLoad8
	OpMIPS64LoweredAtomicLoad32
	OpMIPS64LoweredAtomicLoad64
	OpMIPS64LoweredAtomicStore8
	OpMIPS64LoweredAtomicStore32
	OpMIPS64LoweredAtomicStore64
	OpMIPS64LoweredAtomicStorezero32
	OpMIPS64LoweredAtomicStorezero64
	OpMIPS64LoweredAtomicExchange32
	OpMIPS64LoweredAtomicExchange64
	OpMIPS64LoweredAtomicAdd32
	OpMIPS64LoweredAtomicAdd64
	OpMIPS64LoweredAtomicAddconst32
	OpMIPS64LoweredAtomicAddconst64
	OpMIPS64LoweredAtomicCas32
	OpMIPS64LoweredAtomicCas64
	OpMIPS64LoweredNilCheck
	OpMIPS64FPFlagTrue
	OpMIPS64FPFlagFalse
	OpMIPS64LoweredGetClosurePtr
	OpMIPS64LoweredGetCallerSP
	OpMIPS64LoweredGetCallerPC
	OpMIPS64LoweredWB
	OpMIPS64LoweredPubBarrier
	OpMIPS64LoweredPanicBoundsRR
	OpMIPS64LoweredPanicBoundsRC
	OpMIPS64LoweredPanicBoundsCR
	OpMIPS64LoweredPanicBoundsCC

	OpPPC64ADD
	OpPPC64ADDCC
	OpPPC64ADDconst
	OpPPC64ADDCCconst
	OpPPC64FADD
	OpPPC64FADDS
	OpPPC64SUB
	OpPPC64SUBCC
	OpPPC64SUBFCconst
	OpPPC64FSUB
	OpPPC64FSUBS
	OpPPC64XSMINJDP
	OpPPC64XSMAXJDP
	OpPPC64MULLD
	OpPPC64MULLW
	OpPPC64MULLDconst
	OpPPC64MULLWconst
	OpPPC64MADDLD
	OpPPC64MULHD
	OpPPC64MULHW
	OpPPC64MULHDU
	OpPPC64MULHDUCC
	OpPPC64MULHWU
	OpPPC64FMUL
	OpPPC64FMULS
	OpPPC64FMADD
	OpPPC64FMADDS
	OpPPC64FMSUB
	OpPPC64FMSUBS
	OpPPC64SRAD
	OpPPC64SRAW
	OpPPC64SRD
	OpPPC64SRW
	OpPPC64SLD
	OpPPC64SLW
	OpPPC64ROTL
	OpPPC64ROTLW
	OpPPC64CLRLSLWI
	OpPPC64CLRLSLDI
	OpPPC64ADDC
	OpPPC64SUBC
	OpPPC64ADDCconst
	OpPPC64SUBCconst
	OpPPC64ADDE
	OpPPC64ADDZE
	OpPPC64SUBE
	OpPPC64ADDZEzero
	OpPPC64SUBZEzero
	OpPPC64SRADconst
	OpPPC64SRAWconst
	OpPPC64SRDconst
	OpPPC64SRWconst
	OpPPC64SLDconst
	OpPPC64SLWconst
	OpPPC64ROTLconst
	OpPPC64ROTLWconst
	OpPPC64EXTSWSLconst
	OpPPC64RLWINM
	OpPPC64RLWNM
	OpPPC64RLWMI
	OpPPC64RLDICL
	OpPPC64RLDICLCC
	OpPPC64RLDICR
	OpPPC64CNTLZD
	OpPPC64CNTLZDCC
	OpPPC64CNTLZW
	OpPPC64CNTTZD
	OpPPC64CNTTZW
	OpPPC64POPCNTD
	OpPPC64POPCNTW
	OpPPC64POPCNTB
	OpPPC64FDIV
	OpPPC64FDIVS
	OpPPC64DIVD
	OpPPC64DIVW
	OpPPC64DIVDU
	OpPPC64DIVWU
	OpPPC64MODUD
	OpPPC64MODSD
	OpPPC64MODUW
	OpPPC64MODSW
	OpPPC64FCTIDZ
	OpPPC64FCTIWZ
	OpPPC64FCFID
	OpPPC64FCFIDS
	OpPPC64FRSP
	OpPPC64MFVSRD
	OpPPC64MTVSRD
	OpPPC64AND
	OpPPC64ANDN
	OpPPC64ANDNCC
	OpPPC64ANDCC
	OpPPC64OR
	OpPPC64ORN
	OpPPC64ORCC
	OpPPC64NOR
	OpPPC64NORCC
	OpPPC64XOR
	OpPPC64XORCC
	OpPPC64EQV
	OpPPC64NEG
	OpPPC64NEGCC
	OpPPC64BRD
	OpPPC64BRW
	OpPPC64BRH
	OpPPC64FNEG
	OpPPC64FSQRT
	OpPPC64FSQRTS
	OpPPC64FFLOOR
	OpPPC64FCEIL
	OpPPC64FTRUNC
	OpPPC64FROUND
	OpPPC64FABS
	OpPPC64FNABS
	OpPPC64FCPSGN
	OpPPC64ORconst
	OpPPC64XORconst
	OpPPC64ANDCCconst
	OpPPC64ANDconst
	OpPPC64MOVBreg
	OpPPC64MOVBZreg
	OpPPC64MOVHreg
	OpPPC64MOVHZreg
	OpPPC64MOVWreg
	OpPPC64MOVWZreg
	OpPPC64MOVBZload
	OpPPC64MOVHload
	OpPPC64MOVHZload
	OpPPC64MOVWload
	OpPPC64MOVWZload
	OpPPC64MOVDload
	OpPPC64MOVDBRload
	OpPPC64MOVWBRload
	OpPPC64MOVHBRload
	OpPPC64MOVBZloadidx
	OpPPC64MOVHloadidx
	OpPPC64MOVHZloadidx
	OpPPC64MOVWloadidx
	OpPPC64MOVWZloadidx
	OpPPC64MOVDloadidx
	OpPPC64MOVHBRloadidx
	OpPPC64MOVWBRloadidx
	OpPPC64MOVDBRloadidx
	OpPPC64FMOVDloadidx
	OpPPC64FMOVSloadidx
	OpPPC64DCBT
	OpPPC64MOVDBRstore
	OpPPC64MOVWBRstore
	OpPPC64MOVHBRstore
	OpPPC64FMOVDload
	OpPPC64FMOVSload
	OpPPC64MOVBstore
	OpPPC64MOVHstore
	OpPPC64MOVWstore
	OpPPC64MOVDstore
	OpPPC64FMOVDstore
	OpPPC64FMOVSstore
	OpPPC64MOVBstoreidx
	OpPPC64MOVHstoreidx
	OpPPC64MOVWstoreidx
	OpPPC64MOVDstoreidx
	OpPPC64FMOVDstoreidx
	OpPPC64FMOVSstoreidx
	OpPPC64MOVHBRstoreidx
	OpPPC64MOVWBRstoreidx
	OpPPC64MOVDBRstoreidx
	OpPPC64MOVBstorezero
	OpPPC64MOVHstorezero
	OpPPC64MOVWstorezero
	OpPPC64MOVDstorezero
	OpPPC64MOVDaddr
	OpPPC64MOVDconst
	OpPPC64FMOVDconst
	OpPPC64FMOVSconst
	OpPPC64FCMPU
	OpPPC64CMP
	OpPPC64CMPU
	OpPPC64CMPW
	OpPPC64CMPWU
	OpPPC64CMPconst
	OpPPC64CMPUconst
	OpPPC64CMPWconst
	OpPPC64CMPWUconst
	OpPPC64ISEL
	OpPPC64ISELZ
	OpPPC64SETBC
	OpPPC64SETBCR
	OpPPC64Equal
	OpPPC64NotEqual
	OpPPC64LessThan
	OpPPC64FLessThan
	OpPPC64LessEqual
	OpPPC64FLessEqual
	OpPPC64GreaterThan
	OpPPC64FGreaterThan
	OpPPC64GreaterEqual
	OpPPC64FGreaterEqual
	OpPPC64LoweredGetClosurePtr
	OpPPC64LoweredGetCallerSP
	OpPPC64LoweredGetCallerPC
	OpPPC64LoweredNilCheck
	OpPPC64LoweredRound32F
	OpPPC64LoweredRound64F
	OpPPC64CALLstatic
	OpPPC64CALLtail
	OpPPC64CALLclosure
	OpPPC64CALLinter
	OpPPC64LoweredZero
	OpPPC64LoweredZeroShort
	OpPPC64LoweredQuadZeroShort
	OpPPC64LoweredQuadZero
	OpPPC64LoweredMove
	OpPPC64LoweredMoveShort
	OpPPC64LoweredQuadMove
	OpPPC64LoweredQuadMoveShort
	OpPPC64LoweredAtomicStore8
	OpPPC64LoweredAtomicStore32
	OpPPC64LoweredAtomicStore64
	OpPPC64LoweredAtomicLoad8
	OpPPC64LoweredAtomicLoad32
	OpPPC64LoweredAtomicLoad64
	OpPPC64LoweredAtomicLoadPtr
	OpPPC64LoweredAtomicAdd32
	OpPPC64LoweredAtomicAdd64
	OpPPC64LoweredAtomicExchange8
	OpPPC64LoweredAtomicExchange32
	OpPPC64LoweredAtomicExchange64
	OpPPC64LoweredAtomicCas64
	OpPPC64LoweredAtomicCas32
	OpPPC64LoweredAtomicAnd8
	OpPPC64LoweredAtomicAnd32
	OpPPC64LoweredAtomicOr8
	OpPPC64LoweredAtomicOr32
	OpPPC64LoweredWB
	OpPPC64LoweredPubBarrier
	OpPPC64LoweredPanicBoundsRR
	OpPPC64LoweredPanicBoundsRC
	OpPPC64LoweredPanicBoundsCR
	OpPPC64LoweredPanicBoundsCC
	OpPPC64InvertFlags
	OpPPC64FlagEQ
	OpPPC64FlagLT
	OpPPC64FlagGT

	OpRISCV64ADD
	OpRISCV64ADDI
	OpRISCV64ADDIW
	OpRISCV64NEG
	OpRISCV64NEGW
	OpRISCV64SUB
	OpRISCV64SUBW
	OpRISCV64MUL
	OpRISCV64MULW
	OpRISCV64MULH
	OpRISCV64MULHU
	OpRISCV64LoweredMuluhilo
	OpRISCV64LoweredMuluover
	OpRISCV64DIV
	OpRISCV64DIVU
	OpRISCV64DIVW
	OpRISCV64DIVUW
	OpRISCV64REM
	OpRISCV64REMU
	OpRISCV64REMW
	OpRISCV64REMUW
	OpRISCV64MOVaddr
	OpRISCV64MOVDconst
	OpRISCV64FMOVDconst
	OpRISCV64FMOVFconst
	OpRISCV64MOVBload
	OpRISCV64MOVHload
	OpRISCV64MOVWload
	OpRISCV64MOVDload
	OpRISCV64MOVBUload
	OpRISCV64MOVHUload
	OpRISCV64MOVWUload
	OpRISCV64MOVBstore
	OpRISCV64MOVHstore
	OpRISCV64MOVWstore
	OpRISCV64MOVDstore
	OpRISCV64MOVBstorezero
	OpRISCV64MOVHstorezero
	OpRISCV64MOVWstorezero
	OpRISCV64MOVDstorezero
	OpRISCV64MOVBreg
	OpRISCV64MOVHreg
	OpRISCV64MOVWreg
	OpRISCV64MOVDreg
	OpRISCV64MOVBUreg
	OpRISCV64MOVHUreg
	OpRISCV64MOVWUreg
	OpRISCV64MOVDnop
	OpRISCV64SLL
	OpRISCV64SLLW
	OpRISCV64SRA
	OpRISCV64SRAW
	OpRISCV64SRL
	OpRISCV64SRLW
	OpRISCV64SLLI
	OpRISCV64SLLIW
	OpRISCV64SRAI
	OpRISCV64SRAIW
	OpRISCV64SRLI
	OpRISCV64SRLIW
	OpRISCV64SH1ADD
	OpRISCV64SH2ADD
	OpRISCV64SH3ADD
	OpRISCV64AND
	OpRISCV64ANDN
	OpRISCV64ANDI
	OpRISCV64CLZ
	OpRISCV64CLZW
	OpRISCV64CPOP
	OpRISCV64CPOPW
	OpRISCV64CTZ
	OpRISCV64CTZW
	OpRISCV64NOT
	OpRISCV64OR
	OpRISCV64ORN
	OpRISCV64ORI
	OpRISCV64REV8
	OpRISCV64ROL
	OpRISCV64ROLW
	OpRISCV64ROR
	OpRISCV64RORI
	OpRISCV64RORIW
	OpRISCV64RORW
	OpRISCV64XNOR
	OpRISCV64XOR
	OpRISCV64XORI
	OpRISCV64MIN
	OpRISCV64MAX
	OpRISCV64MINU
	OpRISCV64MAXU
	OpRISCV64SEQZ
	OpRISCV64SNEZ
	OpRISCV64SLT
	OpRISCV64SLTI
	OpRISCV64SLTU
	OpRISCV64SLTIU
	OpRISCV64LoweredRound32F
	OpRISCV64LoweredRound64F
	OpRISCV64CALLstatic
	OpRISCV64CALLtail
	OpRISCV64CALLclosure
	OpRISCV64CALLinter
	OpRISCV64LoweredZero
	OpRISCV64LoweredZeroLoop
	OpRISCV64LoweredMove
	OpRISCV64LoweredMoveLoop
	OpRISCV64LoweredAtomicLoad8
	OpRISCV64LoweredAtomicLoad32
	OpRISCV64LoweredAtomicLoad64
	OpRISCV64LoweredAtomicStore8
	OpRISCV64LoweredAtomicStore32
	OpRISCV64LoweredAtomicStore64
	OpRISCV64LoweredAtomicExchange32
	OpRISCV64LoweredAtomicExchange64
	OpRISCV64LoweredAtomicAdd32
	OpRISCV64LoweredAtomicAdd64
	OpRISCV64LoweredAtomicCas32
	OpRISCV64LoweredAtomicCas64
	OpRISCV64LoweredAtomicAnd32
	OpRISCV64LoweredAtomicOr32
	OpRISCV64LoweredNilCheck
	OpRISCV64LoweredGetClosurePtr
	OpRISCV64LoweredGetCallerSP
	OpRISCV64LoweredGetCallerPC
	OpRISCV64LoweredWB
	OpRISCV64LoweredPubBarrier
	OpRISCV64LoweredPanicBoundsRR
	OpRISCV64LoweredPanicBoundsRC
	OpRISCV64LoweredPanicBoundsCR
	OpRISCV64LoweredPanicBoundsCC
	OpRISCV64FADDS
	OpRISCV64FSUBS
	OpRISCV64FMULS
	OpRISCV64FDIVS
	OpRISCV64FMADDS
	OpRISCV64FMSUBS
	OpRISCV64FNMADDS
	OpRISCV64FNMSUBS
	OpRISCV64FSQRTS
	OpRISCV64FNEGS
	OpRISCV64FMVSX
	OpRISCV64FMVXS
	OpRISCV64FCVTSW
	OpRISCV64FCVTSL
	OpRISCV64FCVTWS
	OpRISCV64FCVTLS
	OpRISCV64FMOVWload
	OpRISCV64FMOVWstore
	OpRISCV64FEQS
	OpRISCV64FNES
	OpRISCV64FLTS
	OpRISCV64FLES
	OpRISCV64LoweredFMAXS
	OpRISCV64LoweredFMINS
	OpRISCV64FADDD
	OpRISCV64FSUBD
	OpRISCV64FMULD
	OpRISCV64FDIVD
	OpRISCV64FMADDD
	OpRISCV64FMSUBD
	OpRISCV64FNMADDD
	OpRISCV64FNMSUBD
	OpRISCV64FSQRTD
	OpRISCV64FNEGD
	OpRISCV64FABSD
	OpRISCV64FSGNJD
	OpRISCV64FMVDX
	OpRISCV64FMVXD
	OpRISCV64FCVTDW
	OpRISCV64FCVTDL
	OpRISCV64FCVTWD
	OpRISCV64FCVTLD
	OpRISCV64FCVTDS
	OpRISCV64FCVTSD
	OpRISCV64FMOVDload
	OpRISCV64FMOVDstore
	OpRISCV64FEQD
	OpRISCV64FNED
	OpRISCV64FLTD
	OpRISCV64FLED
	OpRISCV64LoweredFMIND
	OpRISCV64LoweredFMAXD
	OpRISCV64FCLASSS
	OpRISCV64FCLASSD

	OpS390XFADDS
	OpS390XFADD
	OpS390XFSUBS
	OpS390XFSUB
	OpS390XFMULS
	OpS390XFMUL
	OpS390XFDIVS
	OpS390XFDIV
	OpS390XFNEGS
	OpS390XFNEG
	OpS390XFMADDS
	OpS390XFMADD
	OpS390XFMSUBS
	OpS390XFMSUB
	OpS390XLPDFR
	OpS390XLNDFR
	OpS390XCPSDR
	OpS390XWFMAXDB
	OpS390XWFMAXSB
	OpS390XWFMINDB
	OpS390XWFMINSB
	OpS390XFIDBR
	OpS390XFMOVSload
	OpS390XFMOVDload
	OpS390XFMOVSconst
	OpS390XFMOVDconst
	OpS390XFMOVSloadidx
	OpS390XFMOVDloadidx
	OpS390XFMOVSstore
	OpS390XFMOVDstore
	OpS390XFMOVSstoreidx
	OpS390XFMOVDstoreidx
	OpS390XADD
	OpS390XADDW
	OpS390XADDconst
	OpS390XADDWconst
	OpS390XADDload
	OpS390XADDWload
	OpS390XSUB
	OpS390XSUBW
	OpS390XSUBconst
	OpS390XSUBWconst
	OpS390XSUBload
	OpS390XSUBWload
	OpS390XMULLD
	OpS390XMULLW
	OpS390XMULLDconst
	OpS390XMULLWconst
	OpS390XMULLDload
	OpS390XMULLWload
	OpS390XMULHD
	OpS390XMULHDU
	OpS390XDIVD
	OpS390XDIVW
	OpS390XDIVDU
	OpS390XDIVWU
	OpS390XMODD
	OpS390XMODW
	OpS390XMODDU
	OpS390XMODWU
	OpS390XAND
	OpS390XANDW
	OpS390XANDconst
	OpS390XANDWconst
	OpS390XANDload
	OpS390XANDWload
	OpS390XOR
	OpS390XORW
	OpS390XORconst
	OpS390XORWconst
	OpS390XORload
	OpS390XORWload
	OpS390XXOR
	OpS390XXORW
	OpS390XXORconst
	OpS390XXORWconst
	OpS390XXORload
	OpS390XXORWload
	OpS390XADDC
	OpS390XADDCconst
	OpS390XADDE
	OpS390XSUBC
	OpS390XSUBE
	OpS390XCMP
	OpS390XCMPW
	OpS390XCMPU
	OpS390XCMPWU
	OpS390XCMPconst
	OpS390XCMPWconst
	OpS390XCMPUconst
	OpS390XCMPWUconst
	OpS390XFCMPS
	OpS390XFCMP
	OpS390XLTDBR
	OpS390XLTEBR
	OpS390XSLD
	OpS390XSLW
	OpS390XSLDconst
	OpS390XSLWconst
	OpS390XSRD
	OpS390XSRW
	OpS390XSRDconst
	OpS390XSRWconst
	OpS390XSRAD
	OpS390XSRAW
	OpS390XSRADconst
	OpS390XSRAWconst
	OpS390XRLLG
	OpS390XRLL
	OpS390XRLLconst
	OpS390XRXSBG
	OpS390XRISBGZ
	OpS390XNEG
	OpS390XNEGW
	OpS390XNOT
	OpS390XNOTW
	OpS390XFSQRT
	OpS390XFSQRTS
	OpS390XLOCGR
	OpS390XMOVBreg
	OpS390XMOVBZreg
	OpS390XMOVHreg
	OpS390XMOVHZreg
	OpS390XMOVWreg
	OpS390XMOVWZreg
	OpS390XMOVDconst
	OpS390XLDGR
	OpS390XLGDR
	OpS390XCFDBRA
	OpS390XCGDBRA
	OpS390XCFEBRA
	OpS390XCGEBRA
	OpS390XCEFBRA
	OpS390XCDFBRA
	OpS390XCEGBRA
	OpS390XCDGBRA
	OpS390XCLFEBR
	OpS390XCLFDBR
	OpS390XCLGEBR
	OpS390XCLGDBR
	OpS390XCELFBR
	OpS390XCDLFBR
	OpS390XCELGBR
	OpS390XCDLGBR
	OpS390XLEDBR
	OpS390XLDEBR
	OpS390XMOVDaddr
	OpS390XMOVDaddridx
	OpS390XMOVBZload
	OpS390XMOVBload
	OpS390XMOVHZload
	OpS390XMOVHload
	OpS390XMOVWZload
	OpS390XMOVWload
	OpS390XMOVDload
	OpS390XMOVWBR
	OpS390XMOVDBR
	OpS390XMOVHBRload
	OpS390XMOVWBRload
	OpS390XMOVDBRload
	OpS390XMOVBstore
	OpS390XMOVHstore
	OpS390XMOVWstore
	OpS390XMOVDstore
	OpS390XMOVHBRstore
	OpS390XMOVWBRstore
	OpS390XMOVDBRstore
	OpS390XMVC
	OpS390XMOVBZloadidx
	OpS390XMOVBloadidx
	OpS390XMOVHZloadidx
	OpS390XMOVHloadidx
	OpS390XMOVWZloadidx
	OpS390XMOVWloadidx
	OpS390XMOVDloadidx
	OpS390XMOVHBRloadidx
	OpS390XMOVWBRloadidx
	OpS390XMOVDBRloadidx
	OpS390XMOVBstoreidx
	OpS390XMOVHstoreidx
	OpS390XMOVWstoreidx
	OpS390XMOVDstoreidx
	OpS390XMOVHBRstoreidx
	OpS390XMOVWBRstoreidx
	OpS390XMOVDBRstoreidx
	OpS390XMOVBstoreconst
	OpS390XMOVHstoreconst
	OpS390XMOVWstoreconst
	OpS390XMOVDstoreconst
	OpS390XCLEAR
	OpS390XCALLstatic
	OpS390XCALLtail
	OpS390XCALLclosure
	OpS390XCALLinter
	OpS390XInvertFlags
	OpS390XLoweredGetG
	OpS390XLoweredGetClosurePtr
	OpS390XLoweredGetCallerSP
	OpS390XLoweredGetCallerPC
	OpS390XLoweredNilCheck
	OpS390XLoweredRound32F
	OpS390XLoweredRound64F
	OpS390XLoweredWB
	OpS390XLoweredPanicBoundsRR
	OpS390XLoweredPanicBoundsRC
	OpS390XLoweredPanicBoundsCR
	OpS390XLoweredPanicBoundsCC
	OpS390XFlagEQ
	OpS390XFlagLT
	OpS390XFlagGT
	OpS390XFlagOV
	OpS390XSYNC
	OpS390XMOVBZatomicload
	OpS390XMOVWZatomicload
	OpS390XMOVDatomicload
	OpS390XMOVBatomicstore
	OpS390XMOVWatomicstore
	OpS390XMOVDatomicstore
	OpS390XLAA
	OpS390XLAAG
	OpS390XAddTupleFirst32
	OpS390XAddTupleFirst64
	OpS390XLAN
	OpS390XLANfloor
	OpS390XLAO
	OpS390XLAOfloor
	OpS390XLoweredAtomicCas32
	OpS390XLoweredAtomicCas64
	OpS390XLoweredAtomicExchange32
	OpS390XLoweredAtomicExchange64
	OpS390XFLOGR
	OpS390XPOPCNT
	OpS390XMLGR
	OpS390XSumBytes2
	OpS390XSumBytes4
	OpS390XSumBytes8
	OpS390XSTMG2
	OpS390XSTMG3
	OpS390XSTMG4
	OpS390XSTM2
	OpS390XSTM3
	OpS390XSTM4
	OpS390XLoweredMove
	OpS390XLoweredZero

	OpWasmLoweredStaticCall
	OpWasmLoweredTailCall
	OpWasmLoweredClosureCall
	OpWasmLoweredInterCall
	OpWasmLoweredAddr
	OpWasmLoweredMove
	OpWasmLoweredZero
	OpWasmLoweredGetClosurePtr
	OpWasmLoweredGetCallerPC
	OpWasmLoweredGetCallerSP
	OpWasmLoweredNilCheck
	OpWasmLoweredWB
	OpWasmLoweredConvert
	OpWasmSelect
	OpWasmI64Load8U
	OpWasmI64Load8S
	OpWasmI64Load16U
	OpWasmI64Load16S
	OpWasmI64Load32U
	OpWasmI64Load32S
	OpWasmI64Load
	OpWasmI64Store8
	OpWasmI64Store16
	OpWasmI64Store32
	OpWasmI64Store
	OpWasmF32Load
	OpWasmF64Load
	OpWasmF32Store
	OpWasmF64Store
	OpWasmI64Const
	OpWasmF32Const
	OpWasmF64Const
	OpWasmI64Eqz
	OpWasmI64Eq
	OpWasmI64Ne
	OpWasmI64LtS
	OpWasmI64LtU
	OpWasmI64GtS
	OpWasmI64GtU
	OpWasmI64LeS
	OpWasmI64LeU
	OpWasmI64GeS
	OpWasmI64GeU
	OpWasmF32Eq
	OpWasmF32Ne
	OpWasmF32Lt
	OpWasmF32Gt
	OpWasmF32Le
	OpWasmF32Ge
	OpWasmF64Eq
	OpWasmF64Ne
	OpWasmF64Lt
	OpWasmF64Gt
	OpWasmF64Le
	OpWasmF64Ge
	OpWasmI64Add
	OpWasmI64AddConst
	OpWasmI64Sub
	OpWasmI64Mul
	OpWasmI64DivS
	OpWasmI64DivU
	OpWasmI64RemS
	OpWasmI64RemU
	OpWasmI64And
	OpWasmI64Or
	OpWasmI64Xor
	OpWasmI64Shl
	OpWasmI64ShrS
	OpWasmI64ShrU
	OpWasmF32Neg
	OpWasmF32Add
	OpWasmF32Sub
	OpWasmF32Mul
	OpWasmF32Div
	OpWasmF64Neg
	OpWasmF64Add
	OpWasmF64Sub
	OpWasmF64Mul
	OpWasmF64Div
	OpWasmI64TruncSatF64S
	OpWasmI64TruncSatF64U
	OpWasmI64TruncSatF32S
	OpWasmI64TruncSatF32U
	OpWasmF32ConvertI64S
	OpWasmF32ConvertI64U
	OpWasmF64ConvertI64S
	OpWasmF64ConvertI64U
	OpWasmF32DemoteF64
	OpWasmF64PromoteF32
	OpWasmI64Extend8S
	OpWasmI64Extend16S
	OpWasmI64Extend32S
	OpWasmF32Sqrt
	OpWasmF32Trunc
	OpWasmF32Ceil
	OpWasmF32Floor
	OpWasmF32Nearest
	OpWasmF32Abs
	OpWasmF32Copysign
	OpWasmF64Sqrt
	OpWasmF64Trunc
	OpWasmF64Ceil
	OpWasmF64Floor
	OpWasmF64Nearest
	OpWasmF64Abs
	OpWasmF64Copysign
	OpWasmI64Ctz
	OpWasmI64Clz
	OpWasmI32Rotl
	OpWasmI64Rotl
	OpWasmI64Popcnt

	OpLast
	OpAdd8
	OpAdd16
	OpAdd32
	OpAdd64
	OpAddPtr
	OpAdd32F
	OpAdd64F
	OpSub8
	OpSub16
	OpSub32
	OpSub64
	OpSubPtr
	OpSub32F
	OpSub64F
	OpMul8
	OpMul16
	OpMul32
	OpMul64
	OpMul32F
	OpMul64F
	OpDiv32F
	OpDiv64F
	OpHmul32
	OpHmul32u
	OpHmul64
	OpHmul64u
	OpMul32uhilo
	OpMul64uhilo
	OpMul32uover
	OpMul64uover
	OpAvg32u
	OpAvg64u
	OpDiv8
	OpDiv8u
	OpDiv16
	OpDiv16u
	OpDiv32
	OpDiv32u
	OpDiv64
	OpDiv64u
	OpDiv128u
	OpMod8
	OpMod8u
	OpMod16
	OpMod16u
	OpMod32
	OpMod32u
	OpMod64
	OpMod64u
	OpAnd8
	OpAnd16
	OpAnd32
	OpAnd64
	OpOr8
	OpOr16
	OpOr32
	OpOr64
	OpXor8
	OpXor16
	OpXor32
	OpXor64
	OpLsh8x8
	OpLsh8x16
	OpLsh8x32
	OpLsh8x64
	OpLsh16x8
	OpLsh16x16
	OpLsh16x32
	OpLsh16x64
	OpLsh32x8
	OpLsh32x16
	OpLsh32x32
	OpLsh32x64
	OpLsh64x8
	OpLsh64x16
	OpLsh64x32
	OpLsh64x64
	OpRsh8x8
	OpRsh8x16
	OpRsh8x32
	OpRsh8x64
	OpRsh16x8
	OpRsh16x16
	OpRsh16x32
	OpRsh16x64
	OpRsh32x8
	OpRsh32x16
	OpRsh32x32
	OpRsh32x64
	OpRsh64x8
	OpRsh64x16
	OpRsh64x32
	OpRsh64x64
	OpRsh8Ux8
	OpRsh8Ux16
	OpRsh8Ux32
	OpRsh8Ux64
	OpRsh16Ux8
	OpRsh16Ux16
	OpRsh16Ux32
	OpRsh16Ux64
	OpRsh32Ux8
	OpRsh32Ux16
	OpRsh32Ux32
	OpRsh32Ux64
	OpRsh64Ux8
	OpRsh64Ux16
	OpRsh64Ux32
	OpRsh64Ux64
	OpEq8
	OpEq16
	OpEq32
	OpEq64
	OpEqPtr
	OpEqInter
	OpEqSlice
	OpEq32F
	OpEq64F
	OpNeq8
	OpNeq16
	OpNeq32
	OpNeq64
	OpNeqPtr
	OpNeqInter
	OpNeqSlice
	OpNeq32F
	OpNeq64F
	OpLess8
	OpLess8U
	OpLess16
	OpLess16U
	OpLess32
	OpLess32U
	OpLess64
	OpLess64U
	OpLess32F
	OpLess64F
	OpLeq8
	OpLeq8U
	OpLeq16
	OpLeq16U
	OpLeq32
	OpLeq32U
	OpLeq64
	OpLeq64U
	OpLeq32F
	OpLeq64F
	OpCondSelect
	OpAndB
	OpOrB
	OpEqB
	OpNeqB
	OpNot
	OpNeg8
	OpNeg16
	OpNeg32
	OpNeg64
	OpNeg32F
	OpNeg64F
	OpCom8
	OpCom16
	OpCom32
	OpCom64
	OpCtz8
	OpCtz16
	OpCtz32
	OpCtz64
	OpCtz64On32
	OpCtz8NonZero
	OpCtz16NonZero
	OpCtz32NonZero
	OpCtz64NonZero
	OpBitLen8
	OpBitLen16
	OpBitLen32
	OpBitLen64
	OpBswap16
	OpBswap32
	OpBswap64
	OpBitRev8
	OpBitRev16
	OpBitRev32
	OpBitRev64
	OpPopCount8
	OpPopCount16
	OpPopCount32
	OpPopCount64
	OpRotateLeft64
	OpRotateLeft32
	OpRotateLeft16
	OpRotateLeft8
	OpSqrt
	OpSqrt32
	OpFloor
	OpCeil
	OpTrunc
	OpRound
	OpRoundToEven
	OpAbs
	OpCopysign
	OpMin64
	OpMax64
	OpMin64u
	OpMax64u
	OpMin64F
	OpMin32F
	OpMax64F
	OpMax32F
	OpFMA
	OpPhi
	OpCopy
	OpConvert
	OpConstBool
	OpConstString
	OpConstNil
	OpConst8
	OpConst16
	OpConst32
	OpConst64
	OpConst32F
	OpConst64F
	OpConstInterface
	OpConstSlice
	OpInitMem
	OpArg
	OpArgIntReg
	OpArgFloatReg
	OpAddr
	OpLocalAddr
	OpSP
	OpSB
	OpSPanchored
	OpLoad
	OpDereference
	OpStore
	OpLoadMasked8
	OpLoadMasked16
	OpLoadMasked32
	OpLoadMasked64
	OpStoreMasked8
	OpStoreMasked16
	OpStoreMasked32
	OpStoreMasked64
	OpMove
	OpZero
	OpStoreWB
	OpMoveWB
	OpZeroWB
	OpWBend
	OpWB
	OpHasCPUFeature
	OpPanicBounds
	OpPanicExtend
	OpClosureCall
	OpStaticCall
	OpInterCall
	OpTailCall
	OpClosureLECall
	OpStaticLECall
	OpInterLECall
	OpTailLECall
	OpSignExt8to16
	OpSignExt8to32
	OpSignExt8to64
	OpSignExt16to32
	OpSignExt16to64
	OpSignExt32to64
	OpZeroExt8to16
	OpZeroExt8to32
	OpZeroExt8to64
	OpZeroExt16to32
	OpZeroExt16to64
	OpZeroExt32to64
	OpTrunc16to8
	OpTrunc32to8
	OpTrunc32to16
	OpTrunc64to8
	OpTrunc64to16
	OpTrunc64to32
	OpCvt32to32F
	OpCvt32to64F
	OpCvt64to32F
	OpCvt64to64F
	OpCvt32Fto32
	OpCvt32Fto64
	OpCvt64Fto32
	OpCvt64Fto64
	OpCvt32Fto64F
	OpCvt64Fto32F
	OpCvtBoolToUint8
	OpRound32F
	OpRound64F
	OpIsNonNil
	OpIsInBounds
	OpIsSliceInBounds
	OpNilCheck
	OpGetG
	OpGetClosurePtr
	OpGetCallerPC
	OpGetCallerSP
	OpPtrIndex
	OpOffPtr
	OpSliceMake
	OpSlicePtr
	OpSliceLen
	OpSliceCap
	OpSlicePtrUnchecked
	OpComplexMake
	OpComplexReal
	OpComplexImag
	OpStringMake
	OpStringPtr
	OpStringLen
	OpIMake
	OpITab
	OpIData
	OpStructMake
	OpStructSelect
	OpArrayMake0
	OpArrayMake1
	OpArraySelect
	OpStoreReg
	OpLoadReg
	OpFwdRef
	OpUnknown
	OpVarDef
	OpVarLive
	OpKeepAlive
	OpInlMark
	OpInt64Make
	OpInt64Hi
	OpInt64Lo
	OpAdd32carry
	OpAdd32withcarry
	OpAdd32carrywithcarry
	OpSub32carry
	OpSub32withcarry
	OpAdd64carry
	OpSub64borrow
	OpSignmask
	OpZeromask
	OpSlicemask
	OpSpectreIndex
	OpSpectreSliceIndex
	OpCvt32Uto32F
	OpCvt32Uto64F
	OpCvt32Fto32U
	OpCvt64Fto32U
	OpCvt64Uto32F
	OpCvt64Uto64F
	OpCvt32Fto64U
	OpCvt64Fto64U
	OpSelect0
	OpSelect1
	OpMakeTuple
	OpSelectN
	OpSelectNAddr
	OpMakeResult
	OpAtomicLoad8
	OpAtomicLoad32
	OpAtomicLoad64
	OpAtomicLoadPtr
	OpAtomicLoadAcq32
	OpAtomicLoadAcq64
	OpAtomicStore8
	OpAtomicStore32
	OpAtomicStore64
	OpAtomicStorePtrNoWB
	OpAtomicStoreRel32
	OpAtomicStoreRel64
	OpAtomicExchange8
	OpAtomicExchange32
	OpAtomicExchange64
	OpAtomicAdd32
	OpAtomicAdd64
	OpAtomicCompareAndSwap32
	OpAtomicCompareAndSwap64
	OpAtomicCompareAndSwapRel32
	OpAtomicAnd8
	OpAtomicOr8
	OpAtomicAnd32
	OpAtomicOr32
	OpAtomicAnd64value
	OpAtomicAnd32value
	OpAtomicAnd8value
	OpAtomicOr64value
	OpAtomicOr32value
	OpAtomicOr8value
	OpAtomicStore8Variant
	OpAtomicStore32Variant
	OpAtomicStore64Variant
	OpAtomicAdd32Variant
	OpAtomicAdd64Variant
	OpAtomicExchange8Variant
	OpAtomicExchange32Variant
	OpAtomicExchange64Variant
	OpAtomicCompareAndSwap32Variant
	OpAtomicCompareAndSwap64Variant
	OpAtomicAnd64valueVariant
	OpAtomicOr64valueVariant
	OpAtomicAnd32valueVariant
	OpAtomicOr32valueVariant
	OpAtomicAnd8valueVariant
	OpAtomicOr8valueVariant
	OpPubBarrier
	OpClobber
	OpClobberReg
	OpPrefetchCache
	OpPrefetchCacheStreamed
	OpMemEq
	OpZeroSIMD
	OpCvt16toMask8x16
	OpCvt32toMask8x32
	OpCvt64toMask8x64
	OpCvt8toMask16x8
	OpCvt16toMask16x16
	OpCvt32toMask16x32
	OpCvt8toMask32x4
	OpCvt8toMask32x8
	OpCvt16toMask32x16
	OpCvt8toMask64x2
	OpCvt8toMask64x4
	OpCvt8toMask64x8
	OpCvtMask8x16to16
	OpCvtMask8x32to32
	OpCvtMask8x64to64
	OpCvtMask16x8to8
	OpCvtMask16x16to16
	OpCvtMask16x32to32
	OpCvtMask32x4to8
	OpCvtMask32x8to8
	OpCvtMask32x16to16
	OpCvtMask64x2to8
	OpCvtMask64x4to8
	OpCvtMask64x8to8
	OpIsZeroVec
	OpIsNaNFloat32x4
	OpIsNaNFloat32x8
	OpIsNaNFloat32x16
	OpIsNaNFloat64x2
	OpIsNaNFloat64x4
	OpIsNaNFloat64x8
	OpAESDecryptLastRoundUint8x16
	OpAESDecryptLastRoundUint8x32
	OpAESDecryptLastRoundUint8x64
	OpAESDecryptOneRoundUint8x16
	OpAESDecryptOneRoundUint8x32
	OpAESDecryptOneRoundUint8x64
	OpAESEncryptLastRoundUint8x16
	OpAESEncryptLastRoundUint8x32
	OpAESEncryptLastRoundUint8x64
	OpAESEncryptOneRoundUint8x16
	OpAESEncryptOneRoundUint8x32
	OpAESEncryptOneRoundUint8x64
	OpAESInvMixColumnsUint32x4
	OpAbsInt8x16
	OpAbsInt8x32
	OpAbsInt8x64
	OpAbsInt16x8
	OpAbsInt16x16
	OpAbsInt16x32
	OpAbsInt32x4
	OpAbsInt32x8
	OpAbsInt32x16
	OpAbsInt64x2
	OpAbsInt64x4
	OpAbsInt64x8
	OpAddFloat32x4
	OpAddFloat32x8
	OpAddFloat32x16
	OpAddFloat64x2
	OpAddFloat64x4
	OpAddFloat64x8
	OpAddInt8x16
	OpAddInt8x32
	OpAddInt8x64
	OpAddInt16x8
	OpAddInt16x16
	OpAddInt16x32
	OpAddInt32x4
	OpAddInt32x8
	OpAddInt32x16
	OpAddInt64x2
	OpAddInt64x4
	OpAddInt64x8
	OpAddPairsFloat32x4
	OpAddPairsFloat64x2
	OpAddPairsGroupedFloat32x8
	OpAddPairsGroupedFloat64x4
	OpAddPairsGroupedInt16x16
	OpAddPairsGroupedInt32x8
	OpAddPairsGroupedUint16x16
	OpAddPairsGroupedUint32x8
	OpAddPairsInt16x8
	OpAddPairsInt32x4
	OpAddPairsSaturatedGroupedInt16x16
	OpAddPairsSaturatedInt16x8
	OpAddPairsUint16x8
	OpAddPairsUint32x4
	OpAddSaturatedInt8x16
	OpAddSaturatedInt8x32
	OpAddSaturatedInt8x64
	OpAddSaturatedInt16x8
	OpAddSaturatedInt16x16
	OpAddSaturatedInt16x32
	OpAddSaturatedUint8x16
	OpAddSaturatedUint8x32
	OpAddSaturatedUint8x64
	OpAddSaturatedUint16x8
	OpAddSaturatedUint16x16
	OpAddSaturatedUint16x32
	OpAddSubFloat32x4
	OpAddSubFloat32x8
	OpAddSubFloat64x2
	OpAddSubFloat64x4
	OpAddUint8x16
	OpAddUint8x32
	OpAddUint8x64
	OpAddUint16x8
	OpAddUint16x16
	OpAddUint16x32
	OpAddUint32x4
	OpAddUint32x8
	OpAddUint32x16
	OpAddUint64x2
	OpAddUint64x4
	OpAddUint64x8
	OpAndInt8x16
	OpAndInt8x32
	OpAndInt8x64
	OpAndInt16x8
	OpAndInt16x16
	OpAndInt16x32
	OpAndInt32x4
	OpAndInt32x8
	OpAndInt32x16
	OpAndInt64x2
	OpAndInt64x4
	OpAndInt64x8
	OpAndNotInt8x16
	OpAndNotInt8x32
	OpAndNotInt8x64
	OpAndNotInt16x8
	OpAndNotInt16x16
	OpAndNotInt16x32
	OpAndNotInt32x4
	OpAndNotInt32x8
	OpAndNotInt32x16
	OpAndNotInt64x2
	OpAndNotInt64x4
	OpAndNotInt64x8
	OpAndNotUint8x16
	OpAndNotUint8x32
	OpAndNotUint8x64
	OpAndNotUint16x8
	OpAndNotUint16x16
	OpAndNotUint16x32
	OpAndNotUint32x4
	OpAndNotUint32x8
	OpAndNotUint32x16
	OpAndNotUint64x2
	OpAndNotUint64x4
	OpAndNotUint64x8
	OpAndUint8x16
	OpAndUint8x32
	OpAndUint8x64
	OpAndUint16x8
	OpAndUint16x16
	OpAndUint16x32
	OpAndUint32x4
	OpAndUint32x8
	OpAndUint32x16
	OpAndUint64x2
	OpAndUint64x4
	OpAndUint64x8
	OpAverageUint8x16
	OpAverageUint8x32
	OpAverageUint8x64
	OpAverageUint16x8
	OpAverageUint16x16
	OpAverageUint16x32
	OpBroadcast1To2Float64x2
	OpBroadcast1To2Int64x2
	OpBroadcast1To2Uint64x2
	OpBroadcast1To4Float32x4
	OpBroadcast1To4Float64x2
	OpBroadcast1To4Int32x4
	OpBroadcast1To4Int64x2
	OpBroadcast1To4Uint32x4
	OpBroadcast1To4Uint64x2
	OpBroadcast1To8Float32x4
	OpBroadcast1To8Float64x2
	OpBroadcast1To8Int16x8
	OpBroadcast1To8Int32x4
	OpBroadcast1To8Int64x2
	OpBroadcast1To8Uint16x8
	OpBroadcast1To8Uint32x4
	OpBroadcast1To8Uint64x2
	OpBroadcast1To16Float32x4
	OpBroadcast1To16Int8x16
	OpBroadcast1To16Int16x8
	OpBroadcast1To16Int32x4
	OpBroadcast1To16Uint8x16
	OpBroadcast1To16Uint16x8
	OpBroadcast1To16Uint32x4
	OpBroadcast1To32Int8x16
	OpBroadcast1To32Int16x8
	OpBroadcast1To32Uint8x16
	OpBroadcast1To32Uint16x8
	OpBroadcast1To64Int8x16
	OpBroadcast1To64Uint8x16
	OpCeilFloat32x4
	OpCeilFloat32x8
	OpCeilFloat64x2
	OpCeilFloat64x4
	OpCompressFloat32x4
	OpCompressFloat32x8
	OpCompressFloat32x16
	OpCompressFloat64x2
	OpCompressFloat64x4
	OpCompressFloat64x8
	OpCompressInt8x16
	OpCompressInt8x32
	OpCompressInt8x64
	OpCompressInt16x8
	OpCompressInt16x16
	OpCompressInt16x32
	OpCompressInt32x4
	OpCompressInt32x8
	OpCompressInt32x16
	OpCompressInt64x2
	OpCompressInt64x4
	OpCompressInt64x8
	OpCompressUint8x16
	OpCompressUint8x32
	OpCompressUint8x64
	OpCompressUint16x8
	OpCompressUint16x16
	OpCompressUint16x32
	OpCompressUint32x4
	OpCompressUint32x8
	OpCompressUint32x16
	OpCompressUint64x2
	OpCompressUint64x4
	OpCompressUint64x8
	OpConcatPermuteFloat32x4
	OpConcatPermuteFloat32x8
	OpConcatPermuteFloat32x16
	OpConcatPermuteFloat64x2
	OpConcatPermuteFloat64x4
	OpConcatPermuteFloat64x8
	OpConcatPermuteInt8x16
	OpConcatPermuteInt8x32
	OpConcatPermuteInt8x64
	OpConcatPermuteInt16x8
	OpConcatPermuteInt16x16
	OpConcatPermuteInt16x32
	OpConcatPermuteInt32x4
	OpConcatPermuteInt32x8
	OpConcatPermuteInt32x16
	OpConcatPermuteInt64x2
	OpConcatPermuteInt64x4
	OpConcatPermuteInt64x8
	OpConcatPermuteUint8x16
	OpConcatPermuteUint8x32
	OpConcatPermuteUint8x64
	OpConcatPermuteUint16x8
	OpConcatPermuteUint16x16
	OpConcatPermuteUint16x32
	OpConcatPermuteUint32x4
	OpConcatPermuteUint32x8
	OpConcatPermuteUint32x16
	OpConcatPermuteUint64x2
	OpConcatPermuteUint64x4
	OpConcatPermuteUint64x8
	OpConvertToFloat32Float64x2
	OpConvertToFloat32Float64x4
	OpConvertToFloat32Float64x8
	OpConvertToFloat32Int32x4
	OpConvertToFloat32Int32x8
	OpConvertToFloat32Int32x16
	OpConvertToFloat32Int64x2
	OpConvertToFloat32Int64x4
	OpConvertToFloat32Int64x8
	OpConvertToFloat32Uint32x4
	OpConvertToFloat32Uint32x8
	OpConvertToFloat32Uint32x16
	OpConvertToFloat32Uint64x2
	OpConvertToFloat32Uint64x4
	OpConvertToFloat32Uint64x8
	OpConvertToFloat64Float32x4
	OpConvertToFloat64Float32x8
	OpConvertToFloat64Int32x4
	OpConvertToFloat64Int32x8
	OpConvertToFloat64Int64x2
	OpConvertToFloat64Int64x4
	OpConvertToFloat64Int64x8
	OpConvertToFloat64Uint32x4
	OpConvertToFloat64Uint32x8
	OpConvertToFloat64Uint64x2
	OpConvertToFloat64Uint64x4
	OpConvertToFloat64Uint64x8
	OpConvertToInt32Float32x4
	OpConvertToInt32Float32x8
	OpConvertToInt32Float32x16
	OpConvertToInt32Float64x2
	OpConvertToInt32Float64x4
	OpConvertToInt32Float64x8
	OpConvertToInt64Float32x4
	OpConvertToInt64Float32x8
	OpConvertToInt64Float64x2
	OpConvertToInt64Float64x4
	OpConvertToInt64Float64x8
	OpConvertToUint32Float32x4
	OpConvertToUint32Float32x8
	OpConvertToUint32Float32x16
	OpConvertToUint32Float64x2
	OpConvertToUint32Float64x4
	OpConvertToUint32Float64x8
	OpConvertToUint64Float32x4
	OpConvertToUint64Float32x8
	OpConvertToUint64Float64x2
	OpConvertToUint64Float64x4
	OpConvertToUint64Float64x8
	OpCopySignInt8x16
	OpCopySignInt8x32
	OpCopySignInt16x8
	OpCopySignInt16x16
	OpCopySignInt32x4
	OpCopySignInt32x8
	OpDivFloat32x4
	OpDivFloat32x8
	OpDivFloat32x16
	OpDivFloat64x2
	OpDivFloat64x4
	OpDivFloat64x8
	OpDotProductPairsInt16x8
	OpDotProductPairsInt16x16
	OpDotProductPairsInt16x32
	OpDotProductPairsSaturatedUint8x16
	OpDotProductPairsSaturatedUint8x32
	OpDotProductPairsSaturatedUint8x64
	OpEqualFloat32x4
	OpEqualFloat32x8
	OpEqualFloat32x16
	OpEqualFloat64x2
	OpEqualFloat64x4
	OpEqualFloat64x8
	OpEqualInt8x16
	OpEqualInt8x32
	OpEqualInt8x64
	OpEqualInt16x8
	OpEqualInt16x16
	OpEqualInt16x32
	OpEqualInt32x4
	OpEqualInt32x8
	OpEqualInt32x16
	OpEqualInt64x2
	OpEqualInt64x4
	OpEqualInt64x8
	OpEqualUint8x16
	OpEqualUint8x32
	OpEqualUint8x64
	OpEqualUint16x8
	OpEqualUint16x16
	OpEqualUint16x32
	OpEqualUint32x4
	OpEqualUint32x8
	OpEqualUint32x16
	OpEqualUint64x2
	OpEqualUint64x4
	OpEqualUint64x8
	OpExpandFloat32x4
	OpExpandFloat32x8
	OpExpandFloat32x16
	OpExpandFloat64x2
	OpExpandFloat64x4
	OpExpandFloat64x8
	OpExpandInt8x16
	OpExpandInt8x32
	OpExpandInt8x64
	OpExpandInt16x8
	OpExpandInt16x16
	OpExpandInt16x32
	OpExpandInt32x4
	OpExpandInt32x8
	OpExpandInt32x16
	OpExpandInt64x2
	OpExpandInt64x4
	OpExpandInt64x8
	OpExpandUint8x16
	OpExpandUint8x32
	OpExpandUint8x64
	OpExpandUint16x8
	OpExpandUint16x16
	OpExpandUint16x32
	OpExpandUint32x4
	OpExpandUint32x8
	OpExpandUint32x16
	OpExpandUint64x2
	OpExpandUint64x4
	OpExpandUint64x8
	OpExtendLo2ToInt64Int8x16
	OpExtendLo2ToInt64Int16x8
	OpExtendLo2ToInt64Int32x4
	OpExtendLo2ToUint64Uint8x16
	OpExtendLo2ToUint64Uint16x8
	OpExtendLo2ToUint64Uint32x4
	OpExtendLo4ToInt32Int8x16
	OpExtendLo4ToInt32Int16x8
	OpExtendLo4ToInt64Int8x16
	OpExtendLo4ToInt64Int16x8
	OpExtendLo4ToUint32Uint8x16
	OpExtendLo4ToUint32Uint16x8
	OpExtendLo4ToUint64Uint8x16
	OpExtendLo4ToUint64Uint16x8
	OpExtendLo8ToInt16Int8x16
	OpExtendLo8ToInt32Int8x16
	OpExtendLo8ToInt64Int8x16
	OpExtendLo8ToUint16Uint8x16
	OpExtendLo8ToUint32Uint8x16
	OpExtendLo8ToUint64Uint8x16
	OpExtendToInt16Int8x16
	OpExtendToInt16Int8x32
	OpExtendToInt32Int8x16
	OpExtendToInt32Int16x8
	OpExtendToInt32Int16x16
	OpExtendToInt64Int16x8
	OpExtendToInt64Int32x4
	OpExtendToInt64Int32x8
	OpExtendToUint16Uint8x16
	OpExtendToUint16Uint8x32
	OpExtendToUint32Uint8x16
	OpExtendToUint32Uint16x8
	OpExtendToUint32Uint16x16
	OpExtendToUint64Uint16x8
	OpExtendToUint64Uint32x4
	OpExtendToUint64Uint32x8
	OpFloorFloat32x4
	OpFloorFloat32x8
	OpFloorFloat64x2
	OpFloorFloat64x4
	OpGaloisFieldMulUint8x16
	OpGaloisFieldMulUint8x32
	OpGaloisFieldMulUint8x64
	OpGetHiFloat32x8
	OpGetHiFloat32x16
	OpGetHiFloat64x4
	OpGetHiFloat64x8
	OpGetHiInt8x32
	OpGetHiInt8x64
	OpGetHiInt16x16
	OpGetHiInt16x32
	OpGetHiInt32x8
	OpGetHiInt32x16
	OpGetHiInt64x4
	OpGetHiInt64x8
	OpGetHiUint8x32
	OpGetHiUint8x64
	OpGetHiUint16x16
	OpGetHiUint16x32
	OpGetHiUint32x8
	OpGetHiUint32x16
	OpGetHiUint64x4
	OpGetHiUint64x8
	OpGetLoFloat32x8
	OpGetLoFloat32x16
	OpGetLoFloat64x4
	OpGetLoFloat64x8
	OpGetLoInt8x32
	OpGetLoInt8x64
	OpGetLoInt16x16
	OpGetLoInt16x32
	OpGetLoInt32x8
	OpGetLoInt32x16
	OpGetLoInt64x4
	OpGetLoInt64x8
	OpGetLoUint8x32
	OpGetLoUint8x64
	OpGetLoUint16x16
	OpGetLoUint16x32
	OpGetLoUint32x8
	OpGetLoUint32x16
	OpGetLoUint64x4
	OpGetLoUint64x8
	OpGreaterEqualFloat32x4
	OpGreaterEqualFloat32x8
	OpGreaterEqualFloat32x16
	OpGreaterEqualFloat64x2
	OpGreaterEqualFloat64x4
	OpGreaterEqualFloat64x8
	OpGreaterEqualInt8x64
	OpGreaterEqualInt16x32
	OpGreaterEqualInt32x16
	OpGreaterEqualInt64x8
	OpGreaterEqualUint8x64
	OpGreaterEqualUint16x32
	OpGreaterEqualUint32x16
	OpGreaterEqualUint64x8
	OpGreaterFloat32x4
	OpGreaterFloat32x8
	OpGreaterFloat32x16
	OpGreaterFloat64x2
	OpGreaterFloat64x4
	OpGreaterFloat64x8
	OpGreaterInt8x16
	OpGreaterInt8x32
	OpGreaterInt8x64
	OpGreaterInt16x8
	OpGreaterInt16x16
	OpGreaterInt16x32
	OpGreaterInt32x4
	OpGreaterInt32x8
	OpGreaterInt32x16
	OpGreaterInt64x2
	OpGreaterInt64x4
	OpGreaterInt64x8
	OpGreaterUint8x64
	OpGreaterUint16x32
	OpGreaterUint32x16
	OpGreaterUint64x8
	OpInterleaveHiGroupedInt16x16
	OpInterleaveHiGroupedInt16x32
	OpInterleaveHiGroupedInt32x8
	OpInterleaveHiGroupedInt32x16
	OpInterleaveHiGroupedInt64x4
	OpInterleaveHiGroupedInt64x8
	OpInterleaveHiGroupedUint16x16
	OpInterleaveHiGroupedUint16x32
	OpInterleaveHiGroupedUint32x8
	OpInterleaveHiGroupedUint32x16
	OpInterleaveHiGroupedUint64x4
	OpInterleaveHiGroupedUint64x8
	OpInterleaveHiInt16x8
	OpInterleaveHiInt32x4
	OpInterleaveHiInt64x2
	OpInterleaveHiUint16x8
	OpInterleaveHiUint32x4
	OpInterleaveHiUint64x2
	OpInterleaveLoGroupedInt16x16
	OpInterleaveLoGroupedInt16x32
	OpInterleaveLoGroupedInt32x8
	OpInterleaveLoGroupedInt32x16
	OpInterleaveLoGroupedInt64x4
	OpInterleaveLoGroupedInt64x8
	OpInterleaveLoGroupedUint16x16
	OpInterleaveLoGroupedUint16x32
	OpInterleaveLoGroupedUint32x8
	OpInterleaveLoGroupedUint32x16
	OpInterleaveLoGroupedUint64x4
	OpInterleaveLoGroupedUint64x8
	OpInterleaveLoInt16x8
	OpInterleaveLoInt32x4
	OpInterleaveLoInt64x2
	OpInterleaveLoUint16x8
	OpInterleaveLoUint32x4
	OpInterleaveLoUint64x2
	OpLeadingZerosInt32x4
	OpLeadingZerosInt32x8
	OpLeadingZerosInt32x16
	OpLeadingZerosInt64x2
	OpLeadingZerosInt64x4
	OpLeadingZerosInt64x8
	OpLeadingZerosUint32x4
	OpLeadingZerosUint32x8
	OpLeadingZerosUint32x16
	OpLeadingZerosUint64x2
	OpLeadingZerosUint64x4
	OpLeadingZerosUint64x8
	OpLessEqualFloat32x4
	OpLessEqualFloat32x8
	OpLessEqualFloat32x16
	OpLessEqualFloat64x2
	OpLessEqualFloat64x4
	OpLessEqualFloat64x8
	OpLessEqualInt8x64
	OpLessEqualInt16x32
	OpLessEqualInt32x16
	OpLessEqualInt64x8
	OpLessEqualUint8x64
	OpLessEqualUint16x32
	OpLessEqualUint32x16
	OpLessEqualUint64x8
	OpLessFloat32x4
	OpLessFloat32x8
	OpLessFloat32x16
	OpLessFloat64x2
	OpLessFloat64x4
	OpLessFloat64x8
	OpLessInt8x64
	OpLessInt16x32
	OpLessInt32x16
	OpLessInt64x8
	OpLessUint8x64
	OpLessUint16x32
	OpLessUint32x16
	OpLessUint64x8
	OpMaxFloat32x4
	OpMaxFloat32x8
	OpMaxFloat32x16
	OpMaxFloat64x2
	OpMaxFloat64x4
	OpMaxFloat64x8
	OpMaxInt8x16
	OpMaxInt8x32
	OpMaxInt8x64
	OpMaxInt16x8
	OpMaxInt16x16
	OpMaxInt16x32
	OpMaxInt32x4
	OpMaxInt32x8
	OpMaxInt32x16
	OpMaxInt64x2
	OpMaxInt64x4
	OpMaxInt64x8
	OpMaxUint8x16
	OpMaxUint8x32
	OpMaxUint8x64
	OpMaxUint16x8
	OpMaxUint16x16
	OpMaxUint16x32
	OpMaxUint32x4
	OpMaxUint32x8
	OpMaxUint32x16
	OpMaxUint64x2
	OpMaxUint64x4
	OpMaxUint64x8
	OpMinFloat32x4
	OpMinFloat32x8
	OpMinFloat32x16
	OpMinFloat64x2
	OpMinFloat64x4
	OpMinFloat64x8
	OpMinInt8x16
	OpMinInt8x32
	OpMinInt8x64
	OpMinInt16x8
	OpMinInt16x16
	OpMinInt16x32
	OpMinInt32x4
	OpMinInt32x8
	OpMinInt32x16
	OpMinInt64x2
	OpMinInt64x4
	OpMinInt64x8
	OpMinUint8x16
	OpMinUint8x32
	OpMinUint8x64
	OpMinUint16x8
	OpMinUint16x16
	OpMinUint16x32
	OpMinUint32x4
	OpMinUint32x8
	OpMinUint32x16
	OpMinUint64x2
	OpMinUint64x4
	OpMinUint64x8
	OpMulAddFloat32x4
	OpMulAddFloat32x8
	OpMulAddFloat32x16
	OpMulAddFloat64x2
	OpMulAddFloat64x4
	OpMulAddFloat64x8
	OpMulAddSubFloat32x4
	OpMulAddSubFloat32x8
	OpMulAddSubFloat32x16
	OpMulAddSubFloat64x2
	OpMulAddSubFloat64x4
	OpMulAddSubFloat64x8
	OpMulEvenWidenInt32x4
	OpMulEvenWidenInt32x8
	OpMulEvenWidenUint32x4
	OpMulEvenWidenUint32x8
	OpMulFloat32x4
	OpMulFloat32x8
	OpMulFloat32x16
	OpMulFloat64x2
	OpMulFloat64x4
	OpMulFloat64x8
	OpMulHighInt16x8
	OpMulHighInt16x16
	OpMulHighInt16x32
	OpMulHighUint16x8
	OpMulHighUint16x16
	OpMulHighUint16x32
	OpMulInt16x8
	OpMulInt16x16
	OpMulInt16x32
	OpMulInt32x4
	OpMulInt32x8
	OpMulInt32x16
	OpMulInt64x2
	OpMulInt64x4
	OpMulInt64x8
	OpMulSubAddFloat32x4
	OpMulSubAddFloat32x8
	OpMulSubAddFloat32x16
	OpMulSubAddFloat64x2
	OpMulSubAddFloat64x4
	OpMulSubAddFloat64x8
	OpMulUint16x8
	OpMulUint16x16
	OpMulUint16x32
	OpMulUint32x4
	OpMulUint32x8
	OpMulUint32x16
	OpMulUint64x2
	OpMulUint64x4
	OpMulUint64x8
	OpNotEqualFloat32x4
	OpNotEqualFloat32x8
	OpNotEqualFloat32x16
	OpNotEqualFloat64x2
	OpNotEqualFloat64x4
	OpNotEqualFloat64x8
	OpNotEqualInt8x64
	OpNotEqualInt16x32
	OpNotEqualInt32x16
	OpNotEqualInt64x8
	OpNotEqualUint8x64
	OpNotEqualUint16x32
	OpNotEqualUint32x16
	OpNotEqualUint64x8
	OpOnesCountInt8x16
	OpOnesCountInt8x32
	OpOnesCountInt8x64
	OpOnesCountInt16x8
	OpOnesCountInt16x16
	OpOnesCountInt16x32
	OpOnesCountInt32x4
	OpOnesCountInt32x8
	OpOnesCountInt32x16
	OpOnesCountInt64x2
	OpOnesCountInt64x4
	OpOnesCountInt64x8
	OpOnesCountUint8x16
	OpOnesCountUint8x32
	OpOnesCountUint8x64
	OpOnesCountUint16x8
	OpOnesCountUint16x16
	OpOnesCountUint16x32
	OpOnesCountUint32x4
	OpOnesCountUint32x8
	OpOnesCountUint32x16
	OpOnesCountUint64x2
	OpOnesCountUint64x4
	OpOnesCountUint64x8
	OpOrInt8x16
	OpOrInt8x32
	OpOrInt8x64
	OpOrInt16x8
	OpOrInt16x16
	OpOrInt16x32
	OpOrInt32x4
	OpOrInt32x8
	OpOrInt32x16
	OpOrInt64x2
	OpOrInt64x4
	OpOrInt64x8
	OpOrUint8x16
	OpOrUint8x32
	OpOrUint8x64
	OpOrUint16x8
	OpOrUint16x16
	OpOrUint16x32
	OpOrUint32x4
	OpOrUint32x8
	OpOrUint32x16
	OpOrUint64x2
	OpOrUint64x4
	OpOrUint64x8
	OpPermuteFloat32x8
	OpPermuteFloat32x16
	OpPermuteFloat64x4
	OpPermuteFloat64x8
	OpPermuteInt8x16
	OpPermuteInt8x32
	OpPermuteInt8x64
	OpPermuteInt16x8
	OpPermuteInt16x16
	OpPermuteInt16x32
	OpPermuteInt32x8
	OpPermuteInt32x16
	OpPermuteInt64x4
	OpPermuteInt64x8
	OpPermuteOrZeroGroupedInt8x32
	OpPermuteOrZeroGroupedInt8x64
	OpPermuteOrZeroGroupedUint8x32
	OpPermuteOrZeroGroupedUint8x64
	OpPermuteOrZeroInt8x16
	OpPermuteOrZeroUint8x16
	OpPermuteUint8x16
	OpPermuteUint8x32
	OpPermuteUint8x64
	OpPermuteUint16x8
	OpPermuteUint16x16
	OpPermuteUint16x32
	OpPermuteUint32x8
	OpPermuteUint32x16
	OpPermuteUint64x4
	OpPermuteUint64x8
	OpReciprocalFloat32x4
	OpReciprocalFloat32x8
	OpReciprocalFloat32x16
	OpReciprocalFloat64x2
	OpReciprocalFloat64x4
	OpReciprocalFloat64x8
	OpReciprocalSqrtFloat32x4
	OpReciprocalSqrtFloat32x8
	OpReciprocalSqrtFloat32x16
	OpReciprocalSqrtFloat64x2
	OpReciprocalSqrtFloat64x4
	OpReciprocalSqrtFloat64x8
	OpRotateLeftInt32x4
	OpRotateLeftInt32x8
	OpRotateLeftInt32x16
	OpRotateLeftInt64x2
	OpRotateLeftInt64x4
	OpRotateLeftInt64x8
	OpRotateLeftUint32x4
	OpRotateLeftUint32x8
	OpRotateLeftUint32x16
	OpRotateLeftUint64x2
	OpRotateLeftUint64x4
	OpRotateLeftUint64x8
	OpRotateRightInt32x4
	OpRotateRightInt32x8
	OpRotateRightInt32x16
	OpRotateRightInt64x2
	OpRotateRightInt64x4
	OpRotateRightInt64x8
	OpRotateRightUint32x4
	OpRotateRightUint32x8
	OpRotateRightUint32x16
	OpRotateRightUint64x2
	OpRotateRightUint64x4
	OpRotateRightUint64x8
	OpRoundToEvenFloat32x4
	OpRoundToEvenFloat32x8
	OpRoundToEvenFloat64x2
	OpRoundToEvenFloat64x4
	OpSHA1Message1Uint32x4
	OpSHA1Message2Uint32x4
	OpSHA1NextEUint32x4
	OpSHA256Message1Uint32x4
	OpSHA256Message2Uint32x4
	OpSHA256TwoRoundsUint32x4
	OpSaturateToInt8Int16x8
	OpSaturateToInt8Int16x16
	OpSaturateToInt8Int16x32
	OpSaturateToInt8Int32x4
	OpSaturateToInt8Int32x8
	OpSaturateToInt8Int32x16
	OpSaturateToInt8Int64x2
	OpSaturateToInt8Int64x4
	OpSaturateToInt8Int64x8
	OpSaturateToInt16ConcatGroupedInt32x8
	OpSaturateToInt16ConcatGroupedInt32x16
	OpSaturateToInt16ConcatInt32x4
	OpSaturateToInt16Int32x4
	OpSaturateToInt16Int32x8
	OpSaturateToInt16Int32x16
	OpSaturateToInt16Int64x2
	OpSaturateToInt16Int64x4
	OpSaturateToInt16Int64x8
	OpSaturateToInt32Int64x2
	OpSaturateToInt32Int64x4
	OpSaturateToInt32Int64x8
	OpSaturateToUint8Uint16x8
	OpSaturateToUint8Uint16x16
	OpSaturateToUint8Uint16x32
	OpSaturateToUint8Uint32x4
	OpSaturateToUint8Uint32x8
	OpSaturateToUint8Uint32x16
	OpSaturateToUint8Uint64x2
	OpSaturateToUint8Uint64x4
	OpSaturateToUint8Uint64x8
	OpSaturateToUint16ConcatGroupedInt32x8
	OpSaturateToUint16ConcatGroupedInt32x16
	OpSaturateToUint16ConcatInt32x4
	OpSaturateToUint16Uint32x4
	OpSaturateToUint16Uint32x8
	OpSaturateToUint16Uint32x16
	OpSaturateToUint16Uint64x2
	OpSaturateToUint16Uint64x4
	OpSaturateToUint16Uint64x8
	OpSaturateToUint32Uint64x2
	OpSaturateToUint32Uint64x4
	OpSaturateToUint32Uint64x8
	OpScaleFloat32x4
	OpScaleFloat32x8
	OpScaleFloat32x16
	OpScaleFloat64x2
	OpScaleFloat64x4
	OpScaleFloat64x8
	OpSetHiFloat32x8
	OpSetHiFloat32x16
	OpSetHiFloat64x4
	OpSetHiFloat64x8
	OpSetHiInt8x32
	OpSetHiInt8x64
	OpSetHiInt16x16
	OpSetHiInt16x32
	OpSetHiInt32x8
	OpSetHiInt32x16
	OpSetHiInt64x4
	OpSetHiInt64x8
	OpSetHiUint8x32
	OpSetHiUint8x64
	OpSetHiUint16x16
	OpSetHiUint16x32
	OpSetHiUint32x8
	OpSetHiUint32x16
	OpSetHiUint64x4
	OpSetHiUint64x8
	OpSetLoFloat32x8
	OpSetLoFloat32x16
	OpSetLoFloat64x4
	OpSetLoFloat64x8
	OpSetLoInt8x32
	OpSetLoInt8x64
	OpSetLoInt16x16
	OpSetLoInt16x32
	OpSetLoInt32x8
	OpSetLoInt32x16
	OpSetLoInt64x4
	OpSetLoInt64x8
	OpSetLoUint8x32
	OpSetLoUint8x64
	OpSetLoUint16x16
	OpSetLoUint16x32
	OpSetLoUint32x8
	OpSetLoUint32x16
	OpSetLoUint64x4
	OpSetLoUint64x8
	OpShiftAllLeftInt16x8
	OpShiftAllLeftInt16x16
	OpShiftAllLeftInt16x32
	OpShiftAllLeftInt32x4
	OpShiftAllLeftInt32x8
	OpShiftAllLeftInt32x16
	OpShiftAllLeftInt64x2
	OpShiftAllLeftInt64x4
	OpShiftAllLeftInt64x8
	OpShiftAllLeftUint16x8
	OpShiftAllLeftUint16x16
	OpShiftAllLeftUint16x32
	OpShiftAllLeftUint32x4
	OpShiftAllLeftUint32x8
	OpShiftAllLeftUint32x16
	OpShiftAllLeftUint64x2
	OpShiftAllLeftUint64x4
	OpShiftAllLeftUint64x8
	OpShiftAllRightInt16x8
	OpShiftAllRightInt16x16
	OpShiftAllRightInt16x32
	OpShiftAllRightInt32x4
	OpShiftAllRightInt32x8
	OpShiftAllRightInt32x16
	OpShiftAllRightInt64x2
	OpShiftAllRightInt64x4
	OpShiftAllRightInt64x8
	OpShiftAllRightUint16x8
	OpShiftAllRightUint16x16
	OpShiftAllRightUint16x32
	OpShiftAllRightUint32x4
	OpShiftAllRightUint32x8
	OpShiftAllRightUint32x16
	OpShiftAllRightUint64x2
	OpShiftAllRightUint64x4
	OpShiftAllRightUint64x8
	OpShiftLeftConcatInt16x8
	OpShiftLeftConcatInt16x16
	OpShiftLeftConcatInt16x32
	OpShiftLeftConcatInt32x4
	OpShiftLeftConcatInt32x8
	OpShiftLeftConcatInt32x16
	OpShiftLeftConcatInt64x2
	OpShiftLeftConcatInt64x4
	OpShiftLeftConcatInt64x8
	OpShiftLeftConcatUint16x8
	OpShiftLeftConcatUint16x16
	OpShiftLeftConcatUint16x32
	OpShiftLeftConcatUint32x4
	OpShiftLeftConcatUint32x8
	OpShiftLeftConcatUint32x16
	OpShiftLeftConcatUint64x2
	OpShiftLeftConcatUint64x4
	OpShiftLeftConcatUint64x8
	OpShiftLeftInt16x8
	OpShiftLeftInt16x16
	OpShiftLeftInt16x32
	OpShiftLeftInt32x4
	OpShiftLeftInt32x8
	OpShiftLeftInt32x16
	OpShiftLeftInt64x2
	OpShiftLeftInt64x4
	OpShiftLeftInt64x8
	OpShiftLeftUint16x8
	OpShiftLeftUint16x16
	OpShiftLeftUint16x32
	OpShiftLeftUint32x4
	OpShiftLeftUint32x8
	OpShiftLeftUint32x16
	OpShiftLeftUint64x2
	OpShiftLeftUint64x4
	OpShiftLeftUint64x8
	OpShiftRightConcatInt16x8
	OpShiftRightConcatInt16x16
	OpShiftRightConcatInt16x32
	OpShiftRightConcatInt32x4
	OpShiftRightConcatInt32x8
	OpShiftRightConcatInt32x16
	OpShiftRightConcatInt64x2
	OpShiftRightConcatInt64x4
	OpShiftRightConcatInt64x8
	OpShiftRightConcatUint16x8
	OpShiftRightConcatUint16x16
	OpShiftRightConcatUint16x32
	OpShiftRightConcatUint32x4
	OpShiftRightConcatUint32x8
	OpShiftRightConcatUint32x16
	OpShiftRightConcatUint64x2
	OpShiftRightConcatUint64x4
	OpShiftRightConcatUint64x8
	OpShiftRightInt16x8
	OpShiftRightInt16x16
	OpShiftRightInt16x32
	OpShiftRightInt32x4
	OpShiftRightInt32x8
	OpShiftRightInt32x16
	OpShiftRightInt64x2
	OpShiftRightInt64x4
	OpShiftRightInt64x8
	OpShiftRightUint16x8
	OpShiftRightUint16x16
	OpShiftRightUint16x32
	OpShiftRightUint32x4
	OpShiftRightUint32x8
	OpShiftRightUint32x16
	OpShiftRightUint64x2
	OpShiftRightUint64x4
	OpShiftRightUint64x8
	OpSqrtFloat32x4
	OpSqrtFloat32x8
	OpSqrtFloat32x16
	OpSqrtFloat64x2
	OpSqrtFloat64x4
	OpSqrtFloat64x8
	OpSubFloat32x4
	OpSubFloat32x8
	OpSubFloat32x16
	OpSubFloat64x2
	OpSubFloat64x4
	OpSubFloat64x8
	OpSubInt8x16
	OpSubInt8x32
	OpSubInt8x64
	OpSubInt16x8
	OpSubInt16x16
	OpSubInt16x32
	OpSubInt32x4
	OpSubInt32x8
	OpSubInt32x16
	OpSubInt64x2
	OpSubInt64x4
	OpSubInt64x8
	OpSubPairsFloat32x4
	OpSubPairsFloat64x2
	OpSubPairsGroupedFloat32x8
	OpSubPairsGroupedFloat64x4
	OpSubPairsGroupedInt16x16
	OpSubPairsGroupedInt32x8
	OpSubPairsGroupedUint16x16
	OpSubPairsGroupedUint32x8
	OpSubPairsInt16x8
	OpSubPairsInt32x4
	OpSubPairsSaturatedGroupedInt16x16
	OpSubPairsSaturatedInt16x8
	OpSubPairsUint16x8
	OpSubPairsUint32x4
	OpSubSaturatedInt8x16
	OpSubSaturatedInt8x32
	OpSubSaturatedInt8x64
	OpSubSaturatedInt16x8
	OpSubSaturatedInt16x16
	OpSubSaturatedInt16x32
	OpSubSaturatedUint8x16
	OpSubSaturatedUint8x32
	OpSubSaturatedUint8x64
	OpSubSaturatedUint16x8
	OpSubSaturatedUint16x16
	OpSubSaturatedUint16x32
	OpSubUint8x16
	OpSubUint8x32
	OpSubUint8x64
	OpSubUint16x8
	OpSubUint16x16
	OpSubUint16x32
	OpSubUint32x4
	OpSubUint32x8
	OpSubUint32x16
	OpSubUint64x2
	OpSubUint64x4
	OpSubUint64x8
	OpSumAbsDiffUint8x16
	OpSumAbsDiffUint8x32
	OpSumAbsDiffUint8x64
	OpTruncFloat32x4
	OpTruncFloat32x8
	OpTruncFloat64x2
	OpTruncFloat64x4
	OpTruncateToInt8Int16x8
	OpTruncateToInt8Int16x16
	OpTruncateToInt8Int16x32
	OpTruncateToInt8Int32x4
	OpTruncateToInt8Int32x8
	OpTruncateToInt8Int32x16
	OpTruncateToInt8Int64x2
	OpTruncateToInt8Int64x4
	OpTruncateToInt8Int64x8
	OpTruncateToInt16Int32x4
	OpTruncateToInt16Int32x8
	OpTruncateToInt16Int32x16
	OpTruncateToInt16Int64x2
	OpTruncateToInt16Int64x4
	OpTruncateToInt16Int64x8
	OpTruncateToInt32Int64x2
	OpTruncateToInt32Int64x4
	OpTruncateToInt32Int64x8
	OpTruncateToUint8Uint16x8
	OpTruncateToUint8Uint16x16
	OpTruncateToUint8Uint16x32
	OpTruncateToUint8Uint32x4
	OpTruncateToUint8Uint32x8
	OpTruncateToUint8Uint32x16
	OpTruncateToUint8Uint64x2
	OpTruncateToUint8Uint64x4
	OpTruncateToUint8Uint64x8
	OpTruncateToUint16Uint32x4
	OpTruncateToUint16Uint32x8
	OpTruncateToUint16Uint32x16
	OpTruncateToUint16Uint64x2
	OpTruncateToUint16Uint64x4
	OpTruncateToUint16Uint64x8
	OpTruncateToUint32Uint64x2
	OpTruncateToUint32Uint64x4
	OpTruncateToUint32Uint64x8
	OpXorInt8x16
	OpXorInt8x32
	OpXorInt8x64
	OpXorInt16x8
	OpXorInt16x16
	OpXorInt16x32
	OpXorInt32x4
	OpXorInt32x8
	OpXorInt32x16
	OpXorInt64x2
	OpXorInt64x4
	OpXorInt64x8
	OpXorUint8x16
	OpXorUint8x32
	OpXorUint8x64
	OpXorUint16x8
	OpXorUint16x16
	OpXorUint16x32
	OpXorUint32x4
	OpXorUint32x8
	OpXorUint32x16
	OpXorUint64x2
	OpXorUint64x4
	OpXorUint64x8
	OpblendInt8x16
	OpblendInt8x32
	OpblendMaskedInt8x64
	OpblendMaskedInt16x32
	OpblendMaskedInt32x16
	OpblendMaskedInt64x8
	OpAESRoundKeyGenAssistUint32x4
	OpCeilScaledFloat32x4
	OpCeilScaledFloat32x8
	OpCeilScaledFloat32x16
	OpCeilScaledFloat64x2
	OpCeilScaledFloat64x4
	OpCeilScaledFloat64x8
	OpCeilScaledResidueFloat32x4
	OpCeilScaledResidueFloat32x8
	OpCeilScaledResidueFloat32x16
	OpCeilScaledResidueFloat64x2
	OpCeilScaledResidueFloat64x4
	OpCeilScaledResidueFloat64x8
	OpConcatShiftBytesRightGroupedUint8x32
	OpConcatShiftBytesRightGroupedUint8x64
	OpConcatShiftBytesRightUint8x16
	OpFloorScaledFloat32x4
	OpFloorScaledFloat32x8
	OpFloorScaledFloat32x16
	OpFloorScaledFloat64x2
	OpFloorScaledFloat64x4
	OpFloorScaledFloat64x8
	OpFloorScaledResidueFloat32x4
	OpFloorScaledResidueFloat32x8
	OpFloorScaledResidueFloat32x16
	OpFloorScaledResidueFloat64x2
	OpFloorScaledResidueFloat64x4
	OpFloorScaledResidueFloat64x8
	OpGaloisFieldAffineTransformInverseUint8x16
	OpGaloisFieldAffineTransformInverseUint8x32
	OpGaloisFieldAffineTransformInverseUint8x64
	OpGaloisFieldAffineTransformUint8x16
	OpGaloisFieldAffineTransformUint8x32
	OpGaloisFieldAffineTransformUint8x64
	OpGetElemFloat32x4
	OpGetElemFloat64x2
	OpGetElemInt8x16
	OpGetElemInt16x8
	OpGetElemInt32x4
	OpGetElemInt64x2
	OpGetElemUint8x16
	OpGetElemUint16x8
	OpGetElemUint32x4
	OpGetElemUint64x2
	OpRotateAllLeftInt32x4
	OpRotateAllLeftInt32x8
	OpRotateAllLeftInt32x16
	OpRotateAllLeftInt64x2
	OpRotateAllLeftInt64x4
	OpRotateAllLeftInt64x8
	OpRotateAllLeftUint32x4
	OpRotateAllLeftUint32x8
	OpRotateAllLeftUint32x16
	OpRotateAllLeftUint64x2
	OpRotateAllLeftUint64x4
	OpRotateAllLeftUint64x8
	OpRotateAllRightInt32x4
	OpRotateAllRightInt32x8
	OpRotateAllRightInt32x16
	OpRotateAllRightInt64x2
	OpRotateAllRightInt64x4
	OpRotateAllRightInt64x8
	OpRotateAllRightUint32x4
	OpRotateAllRightUint32x8
	OpRotateAllRightUint32x16
	OpRotateAllRightUint64x2
	OpRotateAllRightUint64x4
	OpRotateAllRightUint64x8
	OpRoundToEvenScaledFloat32x4
	OpRoundToEvenScaledFloat32x8
	OpRoundToEvenScaledFloat32x16
	OpRoundToEvenScaledFloat64x2
	OpRoundToEvenScaledFloat64x4
	OpRoundToEvenScaledFloat64x8
	OpRoundToEvenScaledResidueFloat32x4
	OpRoundToEvenScaledResidueFloat32x8
	OpRoundToEvenScaledResidueFloat32x16
	OpRoundToEvenScaledResidueFloat64x2
	OpRoundToEvenScaledResidueFloat64x4
	OpRoundToEvenScaledResidueFloat64x8
	OpSHA1FourRoundsUint32x4
	OpSelect128FromPairFloat32x8
	OpSelect128FromPairFloat64x4
	OpSelect128FromPairInt8x32
	OpSelect128FromPairInt16x16
	OpSelect128FromPairInt32x8
	OpSelect128FromPairInt64x4
	OpSelect128FromPairUint8x32
	OpSelect128FromPairUint16x16
	OpSelect128FromPairUint32x8
	OpSelect128FromPairUint64x4
	OpSetElemFloat32x4
	OpSetElemFloat64x2
	OpSetElemInt8x16
	OpSetElemInt16x8
	OpSetElemInt32x4
	OpSetElemInt64x2
	OpSetElemUint8x16
	OpSetElemUint16x8
	OpSetElemUint32x4
	OpSetElemUint64x2
	OpShiftAllLeftConcatInt16x8
	OpShiftAllLeftConcatInt16x16
	OpShiftAllLeftConcatInt16x32
	OpShiftAllLeftConcatInt32x4
	OpShiftAllLeftConcatInt32x8
	OpShiftAllLeftConcatInt32x16
	OpShiftAllLeftConcatInt64x2
	OpShiftAllLeftConcatInt64x4
	OpShiftAllLeftConcatInt64x8
	OpShiftAllLeftConcatUint16x8
	OpShiftAllLeftConcatUint16x16
	OpShiftAllLeftConcatUint16x32
	OpShiftAllLeftConcatUint32x4
	OpShiftAllLeftConcatUint32x8
	OpShiftAllLeftConcatUint32x16
	OpShiftAllLeftConcatUint64x2
	OpShiftAllLeftConcatUint64x4
	OpShiftAllLeftConcatUint64x8
	OpShiftAllRightConcatInt16x8
	OpShiftAllRightConcatInt16x16
	OpShiftAllRightConcatInt16x32
	OpShiftAllRightConcatInt32x4
	OpShiftAllRightConcatInt32x8
	OpShiftAllRightConcatInt32x16
	OpShiftAllRightConcatInt64x2
	OpShiftAllRightConcatInt64x4
	OpShiftAllRightConcatInt64x8
	OpShiftAllRightConcatUint16x8
	OpShiftAllRightConcatUint16x16
	OpShiftAllRightConcatUint16x32
	OpShiftAllRightConcatUint32x4
	OpShiftAllRightConcatUint32x8
	OpShiftAllRightConcatUint32x16
	OpShiftAllRightConcatUint64x2
	OpShiftAllRightConcatUint64x4
	OpShiftAllRightConcatUint64x8
	OpTruncScaledFloat32x4
	OpTruncScaledFloat32x8
	OpTruncScaledFloat32x16
	OpTruncScaledFloat64x2
	OpTruncScaledFloat64x4
	OpTruncScaledFloat64x8
	OpTruncScaledResidueFloat32x4
	OpTruncScaledResidueFloat32x8
	OpTruncScaledResidueFloat32x16
	OpTruncScaledResidueFloat64x2
	OpTruncScaledResidueFloat64x4
	OpTruncScaledResidueFloat64x8
	OpcarrylessMultiplyUint64x2
	OpcarrylessMultiplyUint64x4
	OpcarrylessMultiplyUint64x8
	OpconcatSelectedConstantFloat32x4
	OpconcatSelectedConstantFloat64x2
	OpconcatSelectedConstantGroupedFloat32x8
	OpconcatSelectedConstantGroupedFloat32x16
	OpconcatSelectedConstantGroupedFloat64x4
	OpconcatSelectedConstantGroupedFloat64x8
	OpconcatSelectedConstantGroupedInt32x8
	OpconcatSelectedConstantGroupedInt32x16
	OpconcatSelectedConstantGroupedInt64x4
	OpconcatSelectedConstantGroupedInt64x8
	OpconcatSelectedConstantGroupedUint32x8
	OpconcatSelectedConstantGroupedUint32x16
	OpconcatSelectedConstantGroupedUint64x4
	OpconcatSelectedConstantGroupedUint64x8
	OpconcatSelectedConstantInt32x4
	OpconcatSelectedConstantInt64x2
	OpconcatSelectedConstantUint32x4
	OpconcatSelectedConstantUint64x2
	OppermuteScalarsGroupedInt32x8
	OppermuteScalarsGroupedInt32x16
	OppermuteScalarsGroupedUint32x8
	OppermuteScalarsGroupedUint32x16
	OppermuteScalarsHiGroupedInt16x16
	OppermuteScalarsHiGroupedInt16x32
	OppermuteScalarsHiGroupedUint16x16
	OppermuteScalarsHiGroupedUint16x32
	OppermuteScalarsHiInt16x8
	OppermuteScalarsHiUint16x8
	OppermuteScalarsInt32x4
	OppermuteScalarsLoGroupedInt16x16
	OppermuteScalarsLoGroupedInt16x32
	OppermuteScalarsLoGroupedUint16x16
	OppermuteScalarsLoGroupedUint16x32
	OppermuteScalarsLoInt16x8
	OppermuteScalarsLoUint16x8
	OppermuteScalarsUint32x4
	OpternInt32x4
	OpternInt32x8
	OpternInt32x16
	OpternInt64x2
	OpternInt64x4
	OpternInt64x8
	OpternUint32x4
	OpternUint32x8
	OpternUint32x16
	OpternUint64x2
	OpternUint64x4
	OpternUint64x8
)

var opcodeTable = [...]opInfo{
	{name: "OpInvalid"},

	{
		name:         "ADDSS",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AADDSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:         "ADDSD",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AADDSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:         "SUBSS",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:         "SUBSD",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:         "MULSS",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AMULSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:         "MULSD",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AMULSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:         "DIVSS",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ADIVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:         "DIVSD",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ADIVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "MOVSSload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "MOVSDload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:              "MOVSSconst",
		auxType:           auxFloat32,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVSS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:              "MOVSDconst",
		auxType:           auxFloat64,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVSD,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:      "MOVSSloadidx1",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:      "MOVSSloadidx4",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:      "MOVSDloadidx1",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:      "MOVSDloadidx8",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "MOVSSstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "MOVSDstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVSSstoreidx1",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVSSstoreidx4",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVSDstoreidx1",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVSDstoreidx8",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "ADDSSload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AADDSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "ADDSDload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AADDSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "SUBSSload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ASUBSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "SUBSDload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ASUBSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "MULSSload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AMULSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "MULSDload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AMULSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "DIVSSload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ADIVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:           "DIVSDload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ADIVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:         "ADDL",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 239}, // AX CX DX BX BP SI DI
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ADDLconst",
		auxType:      auxInt32,
		argLen:       1,
		clobberFlags: true,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ADDLcarry",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ADDLconstcarry",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ADCL",
		argLen:       3,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AADCL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ADCLcarry",
		argLen:       3,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AADCL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ADCLconst",
		auxType:      auxInt32,
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AADCL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SUBL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SUBLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SUBLcarry",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SUBLconstcarry",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SBBL",
		argLen:       3,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASBBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SBBLconst",
		auxType:      auxInt32,
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASBBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "MULL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AIMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "MULLconst",
		auxType:      auxInt32,
		argLen:       1,
		clobberFlags: true,
		asm:          x86.AIMUL3L,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "MULLU",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
			clobbers: 4, // DX
			outputs: []outputInfo{
				{1, 0},
				{0, 1}, // AX
			},
		},
	},
	{
		name:         "HMULL",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AIMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "HMULLU",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "MULLQU",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
			outputs: []outputInfo{
				{0, 4}, // DX
				{1, 1}, // AX
			},
		},
	},
	{
		name:         "AVGLU",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "DIVL",
		auxType:      auxBool,
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AIDIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 251}, // AX CX BX SP BP SI DI
			},
			clobbers: 4, // DX
			outputs: []outputInfo{
				{0, 1}, // AX
			},
		},
	},
	{
		name:         "DIVW",
		auxType:      auxBool,
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AIDIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 251}, // AX CX BX SP BP SI DI
			},
			clobbers: 4, // DX
			outputs: []outputInfo{
				{0, 1}, // AX
			},
		},
	},
	{
		name:         "DIVLU",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.ADIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 251}, // AX CX BX SP BP SI DI
			},
			clobbers: 4, // DX
			outputs: []outputInfo{
				{0, 1}, // AX
			},
		},
	},
	{
		name:         "DIVWU",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.ADIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 251}, // AX CX BX SP BP SI DI
			},
			clobbers: 4, // DX
			outputs: []outputInfo{
				{0, 1}, // AX
			},
		},
	},
	{
		name:         "MODL",
		auxType:      auxBool,
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AIDIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 251}, // AX CX BX SP BP SI DI
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "MODW",
		auxType:      auxBool,
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AIDIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 251}, // AX CX BX SP BP SI DI
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "MODLU",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.ADIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 251}, // AX CX BX SP BP SI DI
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "MODWU",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.ADIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},   // AX
				{1, 251}, // AX CX BX SP BP SI DI
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "ANDL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ANDLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ORL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ORLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "XORL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "XORLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "CMPL",
		argLen: 2,
		asm:    x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:   "CMPW",
		argLen: 2,
		asm:    x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:   "CMPB",
		argLen: 2,
		asm:    x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:    "CMPLconst",
		auxType: auxInt32,
		argLen:  1,
		asm:     x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:    "CMPWconst",
		auxType: auxInt16,
		argLen:  1,
		asm:     x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:    "CMPBconst",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:           "CMPLload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "CMPWload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "CMPBload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "CMPLconstload",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "CMPWconstload",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "CMPBconstload",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:   "UCOMISS",
		argLen: 2,
		asm:    x86.AUCOMISS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:   "UCOMISD",
		argLen: 2,
		asm:    x86.AUCOMISD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:        "TESTL",
		argLen:      2,
		commutative: true,
		asm:         x86.ATESTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:        "TESTW",
		argLen:      2,
		commutative: true,
		asm:         x86.ATESTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:        "TESTB",
		argLen:      2,
		commutative: true,
		asm:         x86.ATESTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
				{1, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:    "TESTLconst",
		auxType: auxInt32,
		argLen:  1,
		asm:     x86.ATESTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:    "TESTWconst",
		auxType: auxInt16,
		argLen:  1,
		asm:     x86.ATESTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:    "TESTBconst",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.ATESTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:         "SHLL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHLL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SHLLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHLL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SHRL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SHRW",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SHRB",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SHRLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SHRWconst",
		auxType:      auxInt16,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SHRBconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SARL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SARW",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SARB",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SARLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SARWconst",
		auxType:      auxInt16,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SARBconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ROLL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ROLW",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ROLB",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},   // CX
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ROLLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ROLWconst",
		auxType:      auxInt16,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ROLBconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "ADDLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "SUBLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "MULLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AIMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "ANDLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "ORLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "XORLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ADDLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SUBLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "MULLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AIMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ANDLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "ORLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "XORLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239},   // AX CX DX BX BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{1, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "NEGL",
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ANEGL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "NOTL",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ANOTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "BSFL",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABSFL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "BSFW",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABSFW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "LoweredCtz32",
		argLen:       1,
		clobberFlags: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:            "LoweredCtz64",
		argLen:          2,
		resultNotInArgs: true,
		clobberFlags:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "BSRL",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABSRL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "BSRW",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABSRW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "BSWAPL",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ABSWAPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SQRTSD",
		argLen: 1,
		asm:    x86.ASQRTSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:   "SQRTSS",
		argLen: 1,
		asm:    x86.ASQRTSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:   "SBBLcarrymask",
		argLen: 1,
		asm:    x86.ASBBL,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETEQ",
		argLen: 1,
		asm:    x86.ASETEQ,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETNE",
		argLen: 1,
		asm:    x86.ASETNE,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETL",
		argLen: 1,
		asm:    x86.ASETLT,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETLE",
		argLen: 1,
		asm:    x86.ASETLE,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETG",
		argLen: 1,
		asm:    x86.ASETGT,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETGE",
		argLen: 1,
		asm:    x86.ASETGE,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETB",
		argLen: 1,
		asm:    x86.ASETCS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETBE",
		argLen: 1,
		asm:    x86.ASETLS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETA",
		argLen: 1,
		asm:    x86.ASETHI,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETAE",
		argLen: 1,
		asm:    x86.ASETCC,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETO",
		argLen: 1,
		asm:    x86.ASETOS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SETEQF",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ASETEQ,
		reg: regInfo{
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 238}, // CX DX BX BP SI DI
			},
		},
	},
	{
		name:         "SETNEF",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ASETNE,
		reg: regInfo{
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 238}, // CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETORD",
		argLen: 1,
		asm:    x86.ASETPC,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETNAN",
		argLen: 1,
		asm:    x86.ASETPS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETGF",
		argLen: 1,
		asm:    x86.ASETHI,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "SETGEF",
		argLen: 1,
		asm:    x86.ASETCC,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "MOVBLSX",
		argLen: 1,
		asm:    x86.AMOVBLSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "MOVBLZX",
		argLen: 1,
		asm:    x86.AMOVBLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "MOVWLSX",
		argLen: 1,
		asm:    x86.AMOVWLSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "MOVWLZX",
		argLen: 1,
		asm:    x86.AMOVWLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:              "MOVLconst",
		auxType:           auxInt32,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVL,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "CVTTSD2SL",
		argLen: 1,
		asm:    x86.ACVTTSD2SL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "CVTTSS2SL",
		argLen: 1,
		asm:    x86.ACVTTSS2SL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "CVTSL2SS",
		argLen: 1,
		asm:    x86.ACVTSL2SS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:   "CVTSL2SD",
		argLen: 1,
		asm:    x86.ACVTSL2SD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:   "CVTSD2SS",
		argLen: 1,
		asm:    x86.ACVTSD2SS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:   "CVTSS2SD",
		argLen: 1,
		asm:    x86.ACVTSS2SD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:         "PXOR",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.APXOR,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
				{1, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:              "LEAL",
		auxType:           auxSymOff,
		argLen:            1,
		rematerializeable: true,
		symEffect:         SymAddr,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:        "LEAL1",
		auxType:     auxSymOff,
		argLen:      2,
		commutative: true,
		symEffect:   SymAddr,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:      "LEAL2",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:      "LEAL4",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:      "LEAL8",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "MOVBload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVBLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "MOVBLSXload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVBLSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "MOVWload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVWLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "MOVWLSXload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVWLSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "MOVLload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "MOVBstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "MOVWstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "MOVLstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "ADDLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "SUBLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "ANDLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "ORLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "XORLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:         "ADDLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:         "SUBLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:         "ANDLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:         "ORLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:         "XORLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "ADDLconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "ANDLconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "ORLconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "XORLconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:         "ADDLconstmodifyidx4",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:         "ANDLconstmodifyidx4",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:         "ORLconstmodifyidx4",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:         "XORLconstmodifyidx4",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:        "MOVBloadidx1",
		auxType:     auxSymOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.AMOVBLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:        "MOVWloadidx1",
		auxType:     auxSymOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.AMOVWLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:      "MOVWloadidx2",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVWLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:        "MOVLloadidx1",
		auxType:     auxSymOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:      "MOVLloadidx4",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:        "MOVBstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:        "MOVWstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVWstoreidx2",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:        "MOVLstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVLstoreidx4",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{2, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "MOVBstoreconst",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "MOVWstoreconst",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "MOVLstoreconst",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVBstoreconstidx1",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymWrite,
		asm:       x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVWstoreconstidx1",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymWrite,
		asm:       x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVWstoreconstidx2",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymWrite,
		asm:       x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVLstoreconstidx1",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymWrite,
		asm:       x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:      "MOVLstoreconstidx4",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymWrite,
		asm:       x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 255},   // AX CX DX BX SP BP SI DI
				{0, 65791}, // AX CX DX BX SP BP SI DI SB
			},
		},
	},
	{
		name:           "DUFFZERO",
		auxType:        auxInt64,
		argLen:         3,
		faultOnNilArg0: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128}, // DI
				{1, 1},   // AX
			},
			clobbers: 130, // CX DI
		},
	},
	{
		name:           "REPSTOSL",
		argLen:         4,
		faultOnNilArg0: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128}, // DI
				{1, 2},   // CX
				{2, 1},   // AX
			},
			clobbers: 130, // CX DI
		},
	},
	{
		name:         "CALLstatic",
		auxType:      auxCallOff,
		argLen:       1,
		clobberFlags: true,
		call:         true,
		reg: regInfo{
			clobbers: 65519, // AX CX DX BX BP SI DI X0 X1 X2 X3 X4 X5 X6 X7
		},
	},
	{
		name:         "CALLtail",
		auxType:      auxCallOff,
		argLen:       1,
		clobberFlags: true,
		call:         true,
		tailCall:     true,
		reg: regInfo{
			clobbers: 65519, // AX CX DX BX BP SI DI X0 X1 X2 X3 X4 X5 X6 X7
		},
	},
	{
		name:         "CALLclosure",
		auxType:      auxCallOff,
		argLen:       3,
		clobberFlags: true,
		call:         true,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 4},   // DX
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
			clobbers: 65519, // AX CX DX BX BP SI DI X0 X1 X2 X3 X4 X5 X6 X7
		},
	},
	{
		name:         "CALLinter",
		auxType:      auxCallOff,
		argLen:       2,
		clobberFlags: true,
		call:         true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			clobbers: 65519, // AX CX DX BX BP SI DI X0 X1 X2 X3 X4 X5 X6 X7
		},
	},
	{
		name:           "DUFFCOPY",
		auxType:        auxInt64,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		faultOnNilArg1: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128}, // DI
				{1, 64},  // SI
			},
			clobbers: 194, // CX SI DI
		},
	},
	{
		name:           "REPMOVSL",
		argLen:         4,
		faultOnNilArg0: true,
		faultOnNilArg1: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128}, // DI
				{1, 64},  // SI
				{2, 2},   // CX
			},
			clobbers: 194, // CX SI DI
		},
	},
	{
		name:   "InvertFlags",
		argLen: 1,
		reg:    regInfo{},
	},
	{
		name:   "LoweredGetG",
		argLen: 1,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:      "LoweredGetClosurePtr",
		argLen:    0,
		zeroWidth: true,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:              "LoweredGetCallerPC",
		argLen:            0,
		rematerializeable: true,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:              "LoweredGetCallerSP",
		argLen:            1,
		rematerializeable: true,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:           "LoweredNilCheck",
		argLen:         2,
		clobberFlags:   true,
		nilCheck:       true,
		faultOnNilArg0: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 255}, // AX CX DX BX SP BP SI DI
			},
		},
	},
	{
		name:         "LoweredWB",
		auxType:      auxInt64,
		argLen:       1,
		clobberFlags: true,
		reg: regInfo{
			clobbers: 65280, // X0 X1 X2 X3 X4 X5 X6 X7
			outputs: []outputInfo{
				{0, 128}, // DI
			},
		},
	},
	{
		name:    "LoweredPanicBoundsRR",
		auxType: auxInt64,
		argLen:  3,
		call:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
				{1, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:    "LoweredPanicBoundsRC",
		auxType: auxPanicBoundsC,
		argLen:  2,
		call:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:    "LoweredPanicBoundsCR",
		auxType: auxPanicBoundsC,
		argLen:  2,
		call:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:    "LoweredPanicBoundsCC",
		auxType: auxPanicBoundsCC,
		argLen:  1,
		call:    true,
		reg:     regInfo{},
	},
	{
		name:    "LoweredPanicExtendRR",
		auxType: auxInt64,
		argLen:  4,
		call:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 15},  // AX CX DX BX
				{1, 15},  // AX CX DX BX
				{2, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:    "LoweredPanicExtendRC",
		auxType: auxPanicBoundsC,
		argLen:  3,
		call:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 15}, // AX CX DX BX
				{1, 15}, // AX CX DX BX
			},
		},
	},
	{
		name:   "FlagEQ",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagLT_ULT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagLT_UGT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagGT_UGT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagGT_ULT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:    "MOVSSconst1",
		auxType: auxFloat32,
		argLen:  0,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:    "MOVSDconst1",
		auxType: auxFloat64,
		argLen:  0,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
		},
	},
	{
		name:   "MOVSSconst2",
		argLen: 1,
		asm:    x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},
	{
		name:   "MOVSDconst2",
		argLen: 1,
		asm:    x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 239}, // AX CX DX BX BP SI DI
			},
			outputs: []outputInfo{
				{0, 65280}, // X0 X1 X2 X3 X4 X5 X6 X7
			},
		},
	},

	{
		name:         "ADDSS",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AADDSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "ADDSD",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AADDSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SUBSS",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SUBSD",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "MULSS",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AMULSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "MULSD",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AMULSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "DIVSS",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ADIVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "DIVSD",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ADIVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "MOVSSload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "MOVSDload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:              "MOVSSconst",
		auxType:           auxFloat32,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVSS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:              "MOVSDconst",
		auxType:           auxFloat64,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVSD,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:      "MOVSSloadidx1",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVSS,
		scale:     1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:      "MOVSSloadidx4",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVSS,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:      "MOVSDloadidx1",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVSD,
		scale:     1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:      "MOVSDloadidx8",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVSD,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "MOVSSstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "MOVSDstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:      "MOVSSstoreidx1",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVSS,
		scale:     1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:      "MOVSSstoreidx4",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVSS,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:      "MOVSDstoreidx1",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVSD,
		scale:     1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:      "MOVSDstoreidx8",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVSD,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "ADDSSload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AADDSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "ADDSDload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AADDSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "SUBSSload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ASUBSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "SUBSDload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ASUBSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "MULSSload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AMULSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "MULSDload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AMULSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "DIVSSload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ADIVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "DIVSDload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ADIVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "ADDSSloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.AADDSS,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "ADDSSloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.AADDSS,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "ADDSDloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.AADDSD,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "ADDSDloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.AADDSD,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SUBSSloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.ASUBSS,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SUBSSloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.ASUBSS,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SUBSDloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.ASUBSD,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SUBSDloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.ASUBSD,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "MULSSloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.AMULSS,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "MULSSloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.AMULSS,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "MULSDloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.AMULSD,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "MULSDloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.AMULSD,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "DIVSSloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.ADIVSS,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "DIVSSloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.ADIVSS,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "DIVSDloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.ADIVSD,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "DIVSDloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		symEffect:    SymRead,
		asm:          x86.ADIVSD,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "ADDQ",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDL",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDQconst",
		auxType:      auxInt32,
		argLen:       1,
		clobberFlags: true,
		asm:          x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDLconst",
		auxType:      auxInt32,
		argLen:       1,
		clobberFlags: true,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ADDQconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ADDLconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "SUBQ",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASUBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBQconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASUBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "MULQ",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AIMULQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "MULL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AIMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "MULQconst",
		auxType:      auxInt32,
		argLen:       1,
		clobberFlags: true,
		asm:          x86.AIMUL3Q,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "MULLconst",
		auxType:      auxInt32,
		argLen:       1,
		clobberFlags: true,
		asm:          x86.AIMUL3L,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "MULLU",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 4, // DX
			outputs: []outputInfo{
				{1, 0},
				{0, 1}, // AX
			},
		},
	},
	{
		name:         "MULQU",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AMULQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 4, // DX
			outputs: []outputInfo{
				{1, 0},
				{0, 1}, // AX
			},
		},
	},
	{
		name:         "HMULQ",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AIMULQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "HMULL",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AIMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "HMULQU",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AMULQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "HMULLU",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AMULL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:         "AVGQU",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "DIVQ",
		auxType:      auxBool,
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AIDIVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49147}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 1}, // AX
				{1, 4}, // DX
			},
		},
	},
	{
		name:         "DIVL",
		auxType:      auxBool,
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AIDIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49147}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 1}, // AX
				{1, 4}, // DX
			},
		},
	},
	{
		name:         "DIVW",
		auxType:      auxBool,
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AIDIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49147}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 1}, // AX
				{1, 4}, // DX
			},
		},
	},
	{
		name:         "DIVQU",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.ADIVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49147}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 1}, // AX
				{1, 4}, // DX
			},
		},
	},
	{
		name:         "DIVLU",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.ADIVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49147}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 1}, // AX
				{1, 4}, // DX
			},
		},
	},
	{
		name:         "DIVWU",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.ADIVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49147}, // AX CX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 1}, // AX
				{1, 4}, // DX
			},
		},
	},
	{
		name:         "NEGLflags",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ANEGL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDQconstflags",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDLconstflags",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDQcarry",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADCQ",
		argLen:       3,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.AADCQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDQconstcarry",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADCQconst",
		auxType:      auxInt32,
		argLen:       2,
		resultInArg0: true,
		asm:          x86.AADCQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBQborrow",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASUBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SBBQ",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ASBBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBQconstborrow",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ASUBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SBBQconst",
		auxType:      auxInt32,
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASBBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "MULQU2",
		argLen:       2,
		commutative:  true,
		clobberFlags: true,
		asm:          x86.AMULQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 1},     // AX
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 4}, // DX
				{1, 1}, // AX
			},
		},
	},
	{
		name:         "DIVQU2",
		argLen:       3,
		clobberFlags: true,
		asm:          x86.ADIVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4},     // DX
				{1, 1},     // AX
				{2, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 1}, // AX
				{1, 4}, // DX
			},
		},
	},
	{
		name:         "ANDQ",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ANDL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ANDQconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ANDLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ANDQconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ANDLconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORQ",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ORL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ORQconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ORLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ORQconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ORLconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORQ",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AXORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "XORL",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "XORQconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AXORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "XORLconst",
		auxType:      auxInt32,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "XORQconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AXORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "XORLconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:   "CMPQ",
		argLen: 2,
		asm:    x86.ACMPQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "CMPL",
		argLen: 2,
		asm:    x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "CMPW",
		argLen: 2,
		asm:    x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "CMPB",
		argLen: 2,
		asm:    x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "CMPQconst",
		auxType: auxInt32,
		argLen:  1,
		asm:     x86.ACMPQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "CMPLconst",
		auxType: auxInt32,
		argLen:  1,
		asm:     x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "CMPWconst",
		auxType: auxInt16,
		argLen:  1,
		asm:     x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "CMPBconst",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "CMPQload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "CMPLload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "CMPWload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "CMPBload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "CMPQconstload",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "CMPLconstload",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "CMPWconstload",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "CMPBconstload",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ACMPB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "CMPQloadidx8",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymRead,
		asm:       x86.ACMPQ,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "CMPQloadidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.ACMPQ,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "CMPLloadidx4",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymRead,
		asm:       x86.ACMPL,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "CMPLloadidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.ACMPL,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "CMPWloadidx2",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymRead,
		asm:       x86.ACMPW,
		scale:     2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "CMPWloadidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.ACMPW,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "CMPBloadidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.ACMPB,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "CMPQconstloadidx8",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.ACMPQ,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "CMPQconstloadidx1",
		auxType:     auxSymValAndOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.ACMPQ,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "CMPLconstloadidx4",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.ACMPL,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "CMPLconstloadidx1",
		auxType:     auxSymValAndOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.ACMPL,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "CMPWconstloadidx2",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.ACMPW,
		scale:     2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "CMPWconstloadidx1",
		auxType:     auxSymValAndOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.ACMPW,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "CMPBconstloadidx1",
		auxType:     auxSymValAndOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.ACMPB,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:   "UCOMISS",
		argLen: 2,
		asm:    x86.AUCOMISS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "UCOMISD",
		argLen: 2,
		asm:    x86.AUCOMISD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "BTL",
		argLen: 2,
		asm:    x86.ABTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "BTQ",
		argLen: 2,
		asm:    x86.ABTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BTCL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ABTCL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BTCQ",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ABTCQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BTRL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ABTRL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BTRQ",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ABTRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BTSL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ABTSL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BTSQ",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ABTSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "BTLconst",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.ABTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "BTQconst",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.ABTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BTCQconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ABTCQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BTRQconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ABTRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BTSQconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ABTSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "BTSQconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.ABTSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "BTRQconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.ABTRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "BTCQconstmodify",
		auxType:        auxSymValAndOff,
		argLen:         2,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.ABTCQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "TESTQ",
		argLen:      2,
		commutative: true,
		asm:         x86.ATESTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "TESTL",
		argLen:      2,
		commutative: true,
		asm:         x86.ATESTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "TESTW",
		argLen:      2,
		commutative: true,
		asm:         x86.ATESTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "TESTB",
		argLen:      2,
		commutative: true,
		asm:         x86.ATESTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "TESTQconst",
		auxType: auxInt32,
		argLen:  1,
		asm:     x86.ATESTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "TESTLconst",
		auxType: auxInt32,
		argLen:  1,
		asm:     x86.ATESTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "TESTWconst",
		auxType: auxInt16,
		argLen:  1,
		asm:     x86.ATESTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "TESTBconst",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.ATESTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHLQ",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHLL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHLL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHLQconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHLLconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHLL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHRQ",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHRL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHRW",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHRB",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHRQconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHRLconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHRWconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHRBconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SARQ",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SARL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SARW",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SARB",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SARQconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SARLconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SARWconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SARBconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASARB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHRDQ",
		argLen:       3,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SHLDQ",
		argLen:       3,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ASHLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ROLQ",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ROLL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ROLW",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ROLB",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "RORQ",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ARORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "RORL",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ARORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "RORW",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ARORW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "RORB",
		argLen:       2,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ARORB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2},     // CX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ROLQconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ROLLconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ROLWconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ROLBconst",
		auxType:      auxInt8,
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.AROLB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ADDLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ADDQload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SUBQload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ASUBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SUBLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ANDLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ANDQload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ORQload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ORLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "XORQload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AXORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "XORLload",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		symEffect:      SymRead,
		asm:            x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDLloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AADDL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AADDL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDLloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AADDL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDQloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AADDQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ADDQloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AADDQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBLloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.ASUBL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.ASUBL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBLloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.ASUBL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBQloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.ASUBQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SUBQloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.ASUBQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ANDLloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AANDL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ANDLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AANDL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ANDLloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AANDL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ANDQloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AANDQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ANDQloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AANDQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ORLloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AORL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ORLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AORL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ORLloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AORL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ORQloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AORQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ORQloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AORQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "XORLloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AXORL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "XORLloadidx4",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AXORL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "XORLloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AXORL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "XORQloadidx1",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AXORQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "XORQloadidx8",
		auxType:      auxSymOff,
		argLen:       4,
		resultInArg0: true,
		clobberFlags: true,
		symEffect:    SymRead,
		asm:          x86.AXORQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ADDQmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SUBQmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.ASUBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ANDQmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ORQmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "XORQmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AXORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ADDLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SUBLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.ASUBL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ANDLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ORLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "XORLmodify",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		symEffect:      SymRead | SymWrite,
		asm:            x86.AXORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDQmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDQmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "SUBQmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.ASUBQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "SUBQmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.ASUBQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDQmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDQmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORQmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORQmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORQmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORQmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDLmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDLmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "SUBLmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.ASUBL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "SUBLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.ASUBL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "SUBLmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.ASUBL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDLmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDLmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORLmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORLmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORLmodifyidx1",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORLmodifyidx4",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORLmodifyidx8",
		auxType:      auxSymOff,
		argLen:       4,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDQconstmodifyidx1",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDQconstmodifyidx8",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDQconstmodifyidx1",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDQconstmodifyidx8",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORQconstmodifyidx1",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORQconstmodifyidx8",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORQconstmodifyidx1",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORQ,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORQconstmodifyidx8",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORQ,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDLconstmodifyidx1",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDLconstmodifyidx4",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ADDLconstmodifyidx8",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AADDL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDLconstmodifyidx1",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDLconstmodifyidx4",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDLconstmodifyidx8",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AANDL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORLconstmodifyidx1",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORLconstmodifyidx4",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ORLconstmodifyidx8",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AORL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORLconstmodifyidx1",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORL,
		scale:        1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORLconstmodifyidx4",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORL,
		scale:        4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "XORLconstmodifyidx8",
		auxType:      auxSymValAndOff,
		argLen:       3,
		clobberFlags: true,
		symEffect:    SymRead | SymWrite,
		asm:          x86.AXORL,
		scale:        8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "NEGQ",
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ANEGQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "NEGL",
		argLen:       1,
		resultInArg0: true,
		clobberFlags: true,
		asm:          x86.ANEGL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "NOTQ",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ANOTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "NOTL",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ANOTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "BSFQ",
		argLen: 1,
		asm:    x86.ABSFQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BSFL",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABSFL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "BSRQ",
		argLen: 1,
		asm:    x86.ABSRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BSRL",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABSRL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQEQ",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQNE",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQLT",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQLT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQGT",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQGT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQLE",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQLE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQGE",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQGE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQLS",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQLS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQHI",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQHI,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQCC",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQCC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQCS",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQCS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLEQ",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLNE",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLLT",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLLT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLGT",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLGT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLLE",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLLE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLGE",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLGE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLLS",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLLS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLHI",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLHI,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLCC",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLCC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLCS",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLCS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWEQ",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWNE",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWLT",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWLT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWGT",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWGT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWLE",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWLE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWGE",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWGE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWLS",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWLS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWHI",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWHI,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWCC",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWCC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWCS",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWCS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQEQF",
		argLen:       3,
		resultInArg0: true,
		needIntTemp:  true,
		asm:          x86.ACMOVQNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQNEF",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQGTF",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQHI,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVQGEF",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVQCC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLEQF",
		argLen:       3,
		resultInArg0: true,
		needIntTemp:  true,
		asm:          x86.ACMOVLNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLNEF",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLGTF",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLHI,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVLGEF",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVLCC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWEQF",
		argLen:       3,
		resultInArg0: true,
		needIntTemp:  true,
		asm:          x86.ACMOVWNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWNEF",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWGTF",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWHI,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "CMOVWGEF",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ACMOVWCC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BSWAPQ",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ABSWAPQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BSWAPL",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.ABSWAPL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "POPCNTQ",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.APOPCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "POPCNTL",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.APOPCNTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SQRTSD",
		argLen: 1,
		asm:    x86.ASQRTSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "SQRTSS",
		argLen: 1,
		asm:    x86.ASQRTSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:    "ROUNDSD",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.AROUNDSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "LoweredRound32F",
		argLen:       1,
		resultInArg0: true,
		zeroWidth:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "LoweredRound64F",
		argLen:       1,
		resultInArg0: true,
		zeroWidth:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADD231SS",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADD231SS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADD231SD",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADD231SD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "MINSD",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.AMINSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "MINSS",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.AMINSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "SBBQcarrymask",
		argLen: 1,
		asm:    x86.ASBBQ,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SBBLcarrymask",
		argLen: 1,
		asm:    x86.ASBBL,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETEQ",
		argLen: 1,
		asm:    x86.ASETEQ,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETNE",
		argLen: 1,
		asm:    x86.ASETNE,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETL",
		argLen: 1,
		asm:    x86.ASETLT,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETLE",
		argLen: 1,
		asm:    x86.ASETLE,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETG",
		argLen: 1,
		asm:    x86.ASETGT,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETGE",
		argLen: 1,
		asm:    x86.ASETGE,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETB",
		argLen: 1,
		asm:    x86.ASETCS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETBE",
		argLen: 1,
		asm:    x86.ASETLS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETA",
		argLen: 1,
		asm:    x86.ASETHI,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETAE",
		argLen: 1,
		asm:    x86.ASETCC,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETO",
		argLen: 1,
		asm:    x86.ASETOS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SETEQstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SETNEstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETNE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SETLstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETLT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SETLEstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETLE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SETGstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETGT,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SETGEstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETGE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SETBstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETCS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SETBEstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETLS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SETAstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETHI,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "SETAEstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.ASETCC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETEQstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETEQ,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETNEstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETNE,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETLstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETLT,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETLEstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETLE,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETGstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETGT,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETGEstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETGE,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETBstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETCS,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETBEstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETLS,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETAstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETHI,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "SETAEstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.ASETCC,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "SETEQF",
		argLen:       1,
		clobberFlags: true,
		needIntTemp:  true,
		asm:          x86.ASETEQ,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "SETNEF",
		argLen:       1,
		clobberFlags: true,
		needIntTemp:  true,
		asm:          x86.ASETNE,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETORD",
		argLen: 1,
		asm:    x86.ASETPC,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETNAN",
		argLen: 1,
		asm:    x86.ASETPS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETGF",
		argLen: 1,
		asm:    x86.ASETHI,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SETGEF",
		argLen: 1,
		asm:    x86.ASETCC,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "MOVBQSX",
		argLen: 1,
		asm:    x86.AMOVBQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "MOVBQZX",
		argLen: 1,
		asm:    x86.AMOVBLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "MOVWQSX",
		argLen: 1,
		asm:    x86.AMOVWQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "MOVWQZX",
		argLen: 1,
		asm:    x86.AMOVWLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "MOVLQSX",
		argLen: 1,
		asm:    x86.AMOVLQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "MOVLQZX",
		argLen: 1,
		asm:    x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:              "MOVLconst",
		auxType:           auxInt32,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVL,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:              "MOVQconst",
		auxType:           auxInt64,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AMOVQ,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "CVTTSD2SL",
		argLen: 1,
		asm:    x86.ACVTTSD2SL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "CVTTSD2SQ",
		argLen: 1,
		asm:    x86.ACVTTSD2SQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "CVTTSS2SL",
		argLen: 1,
		asm:    x86.ACVTTSS2SL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "CVTTSS2SQ",
		argLen: 1,
		asm:    x86.ACVTTSS2SQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "CVTSL2SS",
		argLen: 1,
		asm:    x86.ACVTSL2SS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "CVTSL2SD",
		argLen: 1,
		asm:    x86.ACVTSL2SD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "CVTSQ2SS",
		argLen: 1,
		asm:    x86.ACVTSQ2SS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "CVTSQ2SD",
		argLen: 1,
		asm:    x86.ACVTSQ2SD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "CVTSD2SS",
		argLen: 1,
		asm:    x86.ACVTSD2SS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "CVTSS2SD",
		argLen: 1,
		asm:    x86.ACVTSS2SD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "MOVQi2f",
		argLen: 1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "MOVQf2i",
		argLen: 1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "MOVLi2f",
		argLen: 1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "MOVLf2i",
		argLen: 1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "PXOR",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.APXOR,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "POR",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.APOR,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:              "LEAQ",
		auxType:           auxSymOff,
		argLen:            1,
		rematerializeable: true,
		symEffect:         SymAddr,
		asm:               x86.ALEAQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:              "LEAL",
		auxType:           auxSymOff,
		argLen:            1,
		rematerializeable: true,
		symEffect:         SymAddr,
		asm:               x86.ALEAL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:              "LEAW",
		auxType:           auxSymOff,
		argLen:            1,
		rematerializeable: true,
		symEffect:         SymAddr,
		asm:               x86.ALEAW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "LEAQ1",
		auxType:     auxSymOff,
		argLen:      2,
		commutative: true,
		symEffect:   SymAddr,
		asm:         x86.ALEAQ,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "LEAL1",
		auxType:     auxSymOff,
		argLen:      2,
		commutative: true,
		symEffect:   SymAddr,
		asm:         x86.ALEAL,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "LEAW1",
		auxType:     auxSymOff,
		argLen:      2,
		commutative: true,
		symEffect:   SymAddr,
		asm:         x86.ALEAW,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LEAQ2",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		asm:       x86.ALEAQ,
		scale:     2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LEAL2",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		asm:       x86.ALEAL,
		scale:     2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LEAW2",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		asm:       x86.ALEAW,
		scale:     2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LEAQ4",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		asm:       x86.ALEAQ,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LEAL4",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		asm:       x86.ALEAL,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LEAW4",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		asm:       x86.ALEAW,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LEAQ8",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		asm:       x86.ALEAQ,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LEAL8",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		asm:       x86.ALEAL,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LEAW8",
		auxType:   auxSymOff,
		argLen:    2,
		symEffect: SymAddr,
		asm:       x86.ALEAW,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVBload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVBLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVBQSXload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVBQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVWload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVWLZX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVWQSXload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVWQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVLload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVLQSXload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVLQSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVQload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVBstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVWstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVLstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVQstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVOload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVUPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "MOVOstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVUPS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:        "MOVBloadidx1",
		auxType:     auxSymOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.AMOVBLZX,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "MOVWloadidx1",
		auxType:     auxSymOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.AMOVWLZX,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "MOVWloadidx2",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVWLZX,
		scale:     2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "MOVLloadidx1",
		auxType:     auxSymOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.AMOVL,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "MOVLloadidx4",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVL,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "MOVLloadidx8",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVL,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "MOVQloadidx1",
		auxType:     auxSymOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.AMOVQ,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "MOVQloadidx8",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVQ,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "MOVBstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVB,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVWstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVW,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVWstoreidx2",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVW,
		scale:     2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVLstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVL,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVLstoreidx4",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVL,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVLstoreidx8",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVL,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVQstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVQ,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVQstoreidx8",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVQ,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVBstoreconst",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVWstoreconst",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVLstoreconst",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVQstoreconst",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVOstoreconst",
		auxType:        auxSymValAndOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVUPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVBstoreconstidx1",
		auxType:     auxSymValAndOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVB,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVWstoreconstidx1",
		auxType:     auxSymValAndOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVW,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVWstoreconstidx2",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymWrite,
		asm:       x86.AMOVW,
		scale:     2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVLstoreconstidx1",
		auxType:     auxSymValAndOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVL,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVLstoreconstidx4",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymWrite,
		asm:       x86.AMOVL,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVQstoreconstidx1",
		auxType:     auxSymValAndOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVQ,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVQstoreconstidx8",
		auxType:   auxSymValAndOff,
		argLen:    3,
		symEffect: SymWrite,
		asm:       x86.AMOVQ,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "LoweredZero",
		auxType:        auxInt64,
		argLen:         2,
		faultOnNilArg0: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "LoweredZeroLoop",
		auxType:        auxInt64,
		argLen:         2,
		clobberFlags:   true,
		needIntTemp:    true,
		faultOnNilArg0: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbersArg0: true,
		},
	},
	{
		name:           "REPSTOSQ",
		argLen:         4,
		faultOnNilArg0: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128}, // DI
				{1, 2},   // CX
				{2, 1},   // AX
			},
			clobbers: 130, // CX DI
		},
	},
	{
		name:         "CALLstatic",
		auxType:      auxCallOff,
		argLen:       -1,
		clobberFlags: true,
		call:         true,
		reg: regInfo{
			clobbers: 2147483631, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 g R15 X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
		},
	},
	{
		name:         "CALLtail",
		auxType:      auxCallOff,
		argLen:       -1,
		clobberFlags: true,
		call:         true,
		tailCall:     true,
		reg: regInfo{
			clobbers: 2147483631, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 g R15 X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
		},
	},
	{
		name:         "CALLclosure",
		auxType:      auxCallOff,
		argLen:       -1,
		clobberFlags: true,
		call:         true,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 4},     // DX
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 2147483631, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 g R15 X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
		},
	},
	{
		name:         "CALLinter",
		auxType:      auxCallOff,
		argLen:       -1,
		clobberFlags: true,
		call:         true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 2147483631, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 g R15 X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
		},
	},
	{
		name:           "LoweredMove",
		auxType:        auxInt64,
		argLen:         3,
		faultOnNilArg0: true,
		faultOnNilArg1: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 1073741824, // X14
		},
	},
	{
		name:           "LoweredMoveLoop",
		auxType:        auxInt64,
		argLen:         3,
		clobberFlags:   true,
		needIntTemp:    true,
		faultOnNilArg0: true,
		faultOnNilArg1: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers:     1073741824, // X14
			clobbersArg0: true,
			clobbersArg1: true,
		},
	},
	{
		name:           "REPMOVSQ",
		argLen:         4,
		faultOnNilArg0: true,
		faultOnNilArg1: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 128}, // DI
				{1, 64},  // SI
				{2, 2},   // CX
			},
			clobbers: 194, // CX SI DI
		},
	},
	{
		name:   "InvertFlags",
		argLen: 1,
		reg:    regInfo{},
	},
	{
		name:   "LoweredGetG",
		argLen: 1,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "LoweredGetClosurePtr",
		argLen:    0,
		zeroWidth: true,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 4}, // DX
			},
		},
	},
	{
		name:              "LoweredGetCallerPC",
		argLen:            0,
		rematerializeable: true,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:              "LoweredGetCallerSP",
		argLen:            1,
		rematerializeable: true,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "LoweredNilCheck",
		argLen:         2,
		clobberFlags:   true,
		nilCheck:       true,
		faultOnNilArg0: true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49151}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "LoweredWB",
		auxType:      auxInt64,
		argLen:       1,
		clobberFlags: true,
		reg: regInfo{
			clobbers: 2147418112, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			outputs: []outputInfo{
				{0, 2048}, // R11
			},
		},
	},
	{
		name:              "LoweredHasCPUFeature",
		auxType:           auxSym,
		argLen:            0,
		rematerializeable: true,
		symEffect:         SymNone,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "LoweredPanicBoundsRR",
		auxType: auxInt64,
		argLen:  3,
		call:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "LoweredPanicBoundsRC",
		auxType: auxPanicBoundsC,
		argLen:  2,
		call:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "LoweredPanicBoundsCR",
		auxType: auxPanicBoundsC,
		argLen:  2,
		call:    true,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:    "LoweredPanicBoundsCC",
		auxType: auxPanicBoundsCC,
		argLen:  1,
		call:    true,
		reg:     regInfo{},
	},
	{
		name:   "FlagEQ",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagLT_ULT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagLT_UGT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagGT_UGT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:   "FlagGT_ULT",
		argLen: 0,
		reg:    regInfo{},
	},
	{
		name:           "MOVBatomicload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVLatomicload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVQatomicload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "XCHGB",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AXCHGB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "XCHGL",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AXCHGL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "XCHGQ",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		faultOnNilArg1: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AXCHGQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "XADDLlock",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AXADDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "XADDQlock",
		auxType:        auxSymOff,
		argLen:         3,
		resultInArg0:   true,
		clobberFlags:   true,
		faultOnNilArg1: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AXADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "AddTupleFirst32",
		argLen: 2,
		reg:    regInfo{},
	},
	{
		name:   "AddTupleFirst64",
		argLen: 2,
		reg:    regInfo{},
	},
	{
		name:           "CMPXCHGLlock",
		auxType:        auxSymOff,
		argLen:         4,
		clobberFlags:   true,
		faultOnNilArg0: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.ACMPXCHGL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 1},     // AX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "CMPXCHGQlock",
		auxType:        auxSymOff,
		argLen:         4,
		clobberFlags:   true,
		faultOnNilArg0: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.ACMPXCHGQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 1},     // AX
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			clobbers: 1, // AX
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "ANDBlock",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AANDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ANDLlock",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ANDQlock",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ORBlock",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AORB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ORLlock",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "ORQlock",
		auxType:        auxSymOff,
		argLen:         3,
		clobberFlags:   true,
		faultOnNilArg0: true,
		hasSideEffects: true,
		symEffect:      SymRdWr,
		asm:            x86.AORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:            "LoweredAtomicAnd64",
		auxType:         auxSymOff,
		argLen:          3,
		resultNotInArgs: true,
		clobberFlags:    true,
		needIntTemp:     true,
		faultOnNilArg0:  true,
		hasSideEffects:  true,
		unsafePoint:     true,
		symEffect:       SymRdWr,
		asm:             x86.AANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49134}, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49134}, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 1}, // AX
			},
		},
	},
	{
		name:            "LoweredAtomicAnd32",
		auxType:         auxSymOff,
		argLen:          3,
		resultNotInArgs: true,
		clobberFlags:    true,
		needIntTemp:     true,
		faultOnNilArg0:  true,
		hasSideEffects:  true,
		unsafePoint:     true,
		symEffect:       SymRdWr,
		asm:             x86.AANDL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49134}, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49134}, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 1}, // AX
			},
		},
	},
	{
		name:            "LoweredAtomicOr64",
		auxType:         auxSymOff,
		argLen:          3,
		resultNotInArgs: true,
		clobberFlags:    true,
		needIntTemp:     true,
		faultOnNilArg0:  true,
		hasSideEffects:  true,
		unsafePoint:     true,
		symEffect:       SymRdWr,
		asm:             x86.AORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49134}, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49134}, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 1}, // AX
			},
		},
	},
	{
		name:            "LoweredAtomicOr32",
		auxType:         auxSymOff,
		argLen:          3,
		resultNotInArgs: true,
		clobberFlags:    true,
		needIntTemp:     true,
		faultOnNilArg0:  true,
		hasSideEffects:  true,
		unsafePoint:     true,
		symEffect:       SymRdWr,
		asm:             x86.AORL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49134}, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49134}, // CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 1}, // AX
			},
		},
	},
	{
		name:           "PrefetchT0",
		argLen:         2,
		hasSideEffects: true,
		asm:            x86.APREFETCHT0,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "PrefetchNTA",
		argLen:         2,
		hasSideEffects: true,
		asm:            x86.APREFETCHNTA,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:         "ANDNQ",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AANDNQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "ANDNL",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AANDNL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BLSIQ",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABLSIQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BLSIL",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABLSIL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BLSMSKQ",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABLSMSKQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "BLSMSKL",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ABLSMSKL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "BLSRQ",
		argLen: 1,
		asm:    x86.ABLSRQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "BLSRL",
		argLen: 1,
		asm:    x86.ABLSRL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{1, 0},
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "TZCNTQ",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ATZCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "TZCNTL",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ATZCNTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "LZCNTQ",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ALZCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "LZCNTL",
		argLen:       1,
		clobberFlags: true,
		asm:          x86.ALZCNTL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVBEWstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVBEW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVBELload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVBEL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVBELstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVBEL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:           "MOVBEQload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AMOVBEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "MOVBEQstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AMOVBEQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVBELloadidx1",
		auxType:     auxSymOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.AMOVBEL,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "MOVBELloadidx4",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVBEL,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "MOVBELloadidx8",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVBEL,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "MOVBEQloadidx1",
		auxType:     auxSymOff,
		argLen:      3,
		commutative: true,
		symEffect:   SymRead,
		asm:         x86.AMOVBEQ,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "MOVBEQloadidx8",
		auxType:   auxSymOff,
		argLen:    3,
		symEffect: SymRead,
		asm:       x86.AMOVBEQ,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:        "MOVBEWstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVBEW,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVBEWstoreidx2",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVBEW,
		scale:     2,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVBELstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVBEL,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVBELstoreidx4",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVBEL,
		scale:     4,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVBELstoreidx8",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVBEL,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:        "MOVBEQstoreidx1",
		auxType:     auxSymOff,
		argLen:      4,
		commutative: true,
		symEffect:   SymWrite,
		asm:         x86.AMOVBEQ,
		scale:       1,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:      "MOVBEQstoreidx8",
		auxType:   auxSymOff,
		argLen:    4,
		symEffect: SymWrite,
		asm:       x86.AMOVBEQ,
		scale:     8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{2, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
		},
	},
	{
		name:   "SARXQ",
		argLen: 2,
		asm:    x86.ASARXQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SARXL",
		argLen: 2,
		asm:    x86.ASARXL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SHLXQ",
		argLen: 2,
		asm:    x86.ASHLXQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SHLXL",
		argLen: 2,
		asm:    x86.ASHLXL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SHRXQ",
		argLen: 2,
		asm:    x86.ASHRXQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "SHRXL",
		argLen: 2,
		asm:    x86.ASHRXL,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SARXLload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASARXL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SARXQload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASARXQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHLXLload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHLXL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHLXQload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHLXQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHRXLload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHRXL,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHRXQload",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHRXQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SARXLloadidx1",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASARXL,
		scale:          1,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SARXLloadidx4",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASARXL,
		scale:          4,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SARXLloadidx8",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASARXL,
		scale:          8,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SARXQloadidx1",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASARXQ,
		scale:          1,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SARXQloadidx8",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASARXQ,
		scale:          8,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHLXLloadidx1",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHLXL,
		scale:          1,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHLXLloadidx4",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHLXL,
		scale:          4,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHLXLloadidx8",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHLXL,
		scale:          8,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHLXQloadidx1",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHLXQ,
		scale:          1,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHLXQloadidx8",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHLXQ,
		scale:          8,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHRXLloadidx1",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHRXL,
		scale:          1,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHRXLloadidx4",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHRXL,
		scale:          4,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHRXLloadidx8",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHRXL,
		scale:          8,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHRXQloadidx1",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHRXQ,
		scale:          1,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "SHRXQloadidx8",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.ASHRXQ,
		scale:          8,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 49135},             // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
				{1, 49151},             // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15
				{0, 72057594037993471}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 g R15 SB
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "PUNPCKLBW",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.APUNPCKLBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:    "PSHUFLW",
		auxType: auxInt8,
		argLen:  1,
		asm:     x86.APSHUFLW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "PSHUFBbroadcast",
		argLen:       1,
		resultInArg0: true,
		asm:          x86.APSHUFB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTB",
		argLen: 1,
		asm:    x86.AVPBROADCASTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "PSIGNB",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.APSIGNB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "PCMPEQB",
		argLen:       2,
		commutative:  true,
		resultInArg0: true,
		asm:          x86.APCMPEQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "PMOVMSKB",
		argLen: 1,
		asm:    x86.APMOVMSKB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:           "VMOVDQUload128",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVDQU,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VMOVDQUstore128",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVMOVDQU,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VMOVDQUload256",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVDQU,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VMOVDQUstore256",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVMOVDQU,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VMOVDQUload512",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVDQU64,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VMOVDQUstore512",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVMOVDQU64,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VPMASK32load128",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVPMASKMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VPMASK32store128",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVPMASKMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VPMASK64load128",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVPMASKMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VPMASK64store128",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVPMASKMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VPMASK32load256",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVPMASKMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VPMASK32store256",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVPMASKMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VPMASK64load256",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVPMASKMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VPMASK64store256",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVPMASKMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VPMASK8load512",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVDQU8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VPMASK8store512",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVMOVDQU8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VPMASK16load512",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVDQU16,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VPMASK16store512",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVMOVDQU16,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VPMASK32load512",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVDQU32,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VPMASK32store512",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVMOVDQU32,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "VPMASK64load512",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVDQU64,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VPMASK64store512",
		auxType:        auxSymOff,
		argLen:         4,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AVMOVDQU64,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{2, 2147418112},        // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:   "VPMOVMToVec8x16",
		argLen: 1,
		asm:    x86.AVPMOVM2B,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVMToVec8x32",
		argLen: 1,
		asm:    x86.AVPMOVM2B,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVMToVec8x64",
		argLen: 1,
		asm:    x86.AVPMOVM2B,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVMToVec16x8",
		argLen: 1,
		asm:    x86.AVPMOVM2W,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVMToVec16x16",
		argLen: 1,
		asm:    x86.AVPMOVM2W,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVMToVec16x32",
		argLen: 1,
		asm:    x86.AVPMOVM2W,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVMToVec32x4",
		argLen: 1,
		asm:    x86.AVPMOVM2D,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVMToVec32x8",
		argLen: 1,
		asm:    x86.AVPMOVM2D,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVMToVec32x16",
		argLen: 1,
		asm:    x86.AVPMOVM2D,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVMToVec64x2",
		argLen: 1,
		asm:    x86.AVPMOVM2Q,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVMToVec64x4",
		argLen: 1,
		asm:    x86.AVPMOVM2Q,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVMToVec64x8",
		argLen: 1,
		asm:    x86.AVPMOVM2Q,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVVec8x16ToM",
		argLen: 1,
		asm:    x86.AVPMOVB2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec8x32ToM",
		argLen: 1,
		asm:    x86.AVPMOVB2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec8x64ToM",
		argLen: 1,
		asm:    x86.AVPMOVB2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec16x8ToM",
		argLen: 1,
		asm:    x86.AVPMOVW2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec16x16ToM",
		argLen: 1,
		asm:    x86.AVPMOVW2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec16x32ToM",
		argLen: 1,
		asm:    x86.AVPMOVW2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec32x4ToM",
		argLen: 1,
		asm:    x86.AVPMOVD2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec32x8ToM",
		argLen: 1,
		asm:    x86.AVPMOVD2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec32x16ToM",
		argLen: 1,
		asm:    x86.AVPMOVD2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec64x2ToM",
		argLen: 1,
		asm:    x86.AVPMOVQ2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec64x4ToM",
		argLen: 1,
		asm:    x86.AVPMOVQ2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVVec64x8ToM",
		argLen: 1,
		asm:    x86.AVPMOVQ2M,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPMOVMSKB128",
		argLen: 1,
		asm:    x86.AVPMOVMSKB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "VPMOVMSKB256",
		argLen: 1,
		asm:    x86.AVPMOVMSKB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "VMOVMSKPS128",
		argLen: 1,
		asm:    x86.AVMOVMSKPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "VMOVMSKPS256",
		argLen: 1,
		asm:    x86.AVMOVMSKPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "VMOVMSKPD128",
		argLen: 1,
		asm:    x86.AVMOVMSKPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "VMOVMSKPD256",
		argLen: 1,
		asm:    x86.AVMOVMSKPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:      "Zero128",
		argLen:    0,
		zeroWidth: true,
		fixedReg:  true,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 2147483648}, // X15
			},
		},
	},
	{
		name:   "Zero256",
		argLen: 0,
		asm:    x86.AVPXOR,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "Zero512",
		argLen: 0,
		asm:    x86.AVPXORQ,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVSDf2v",
		argLen: 1,
		asm:    x86.AVMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VMOVSSf2v",
		argLen: 1,
		asm:    x86.AVMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VMOVQ",
		argLen: 1,
		asm:    x86.AVMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VMOVD",
		argLen: 1,
		asm:    x86.AVMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VMOVQload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VMOVDload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VMOVSSload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:           "VMOVSDload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AVMOVSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:              "VMOVSSconst",
		auxType:           auxFloat32,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AVMOVSS,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:              "VMOVSDconst",
		auxType:           auxFloat64,
		argLen:            0,
		rematerializeable: true,
		asm:               x86.AVMOVSD,
		reg: regInfo{
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VZEROUPPER",
		argLen: 1,
		asm:    x86.AVZEROUPPER,
		reg: regInfo{
			clobbers: 2147418112, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
		},
	},
	{
		name:   "VZEROALL",
		argLen: 1,
		asm:    x86.AVZEROALL,
		reg: regInfo{
			clobbers: 2147418112, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
		},
	},
	{
		name:           "KMOVBload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AKMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:           "KMOVWload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AKMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:           "KMOVDload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AKMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:           "KMOVQload",
		auxType:        auxSymOff,
		argLen:         2,
		faultOnNilArg0: true,
		symEffect:      SymRead,
		asm:            x86.AKMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:           "KMOVBstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AKMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "KMOVWstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AKMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "KMOVDstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AKMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:           "KMOVQstore",
		auxType:        auxSymOff,
		argLen:         3,
		faultOnNilArg0: true,
		symEffect:      SymWrite,
		asm:            x86.AKMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 72057594037977087}, // AX CX DX BX SP BP SI DI R8 R9 R10 R11 R12 R13 R15 SB
			},
		},
	},
	{
		name:   "KMOVQk",
		argLen: 1,
		asm:    x86.AKMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "KMOVDk",
		argLen: 1,
		asm:    x86.AKMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "KMOVWk",
		argLen: 1,
		asm:    x86.AKMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "KMOVBk",
		argLen: 1,
		asm:    x86.AKMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "KMOVQi",
		argLen: 1,
		asm:    x86.AKMOVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "KMOVDi",
		argLen: 1,
		asm:    x86.AKMOVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "KMOVWi",
		argLen: 1,
		asm:    x86.AKMOVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:   "KMOVBi",
		argLen: 1,
		asm:    x86.AKMOVB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
			outputs: []outputInfo{
				{0, 49135}, // AX CX DX BX BP SI DI R8 R9 R10 R11 R12 R13 R15
			},
		},
	},
	{
		name:         "VPTEST",
		argLen:       2,
		clobberFlags: true,
		asm:          x86.AVPTEST,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
		},
	},
	{
		name:         "SHA1MSG1128",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHA1MSG1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SHA1MSG2128",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHA1MSG2,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SHA1NEXTE128",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHA1NEXTE,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SHA256MSG1128",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHA256MSG1,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SHA256MSG2128",
		argLen:       2,
		resultInArg0: true,
		asm:          x86.ASHA256MSG2,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "SHA256RNDS2128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.ASHA256RNDS2,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 65536},      // X0
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VADDPD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVADDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VADDPD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVADDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VADDPD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVADDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VADDPDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVADDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VADDPDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVADDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VADDPDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVADDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VADDPS128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVADDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VADDPS256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVADDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VADDPS512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVADDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VADDPSMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVADDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VADDPSMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVADDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VADDPSMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVADDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VADDSUBPD128",
		argLen: 2,
		asm:    x86.AVADDSUBPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VADDSUBPD256",
		argLen: 2,
		asm:    x86.AVADDSUBPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VADDSUBPS128",
		argLen: 2,
		asm:    x86.AVADDSUBPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VADDSUBPS256",
		argLen: 2,
		asm:    x86.AVADDSUBPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VAESDEC128",
		argLen: 2,
		asm:    x86.AVAESDEC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VAESDEC256",
		argLen: 2,
		asm:    x86.AVAESDEC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VAESDEC512",
		argLen: 2,
		asm:    x86.AVAESDEC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VAESDECLAST128",
		argLen: 2,
		asm:    x86.AVAESDECLAST,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VAESDECLAST256",
		argLen: 2,
		asm:    x86.AVAESDECLAST,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VAESDECLAST512",
		argLen: 2,
		asm:    x86.AVAESDECLAST,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VAESENC128",
		argLen: 2,
		asm:    x86.AVAESENC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VAESENC256",
		argLen: 2,
		asm:    x86.AVAESENC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VAESENC512",
		argLen: 2,
		asm:    x86.AVAESENC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VAESENCLAST128",
		argLen: 2,
		asm:    x86.AVAESENCLAST,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VAESENCLAST256",
		argLen: 2,
		asm:    x86.AVAESENCLAST,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VAESENCLAST512",
		argLen: 2,
		asm:    x86.AVAESENCLAST,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VAESIMC128",
		argLen: 1,
		asm:    x86.AVAESIMC,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VBROADCASTSD256",
		argLen: 1,
		asm:    x86.AVBROADCASTSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VBROADCASTSD512",
		argLen: 1,
		asm:    x86.AVBROADCASTSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VBROADCASTSDMasked256",
		argLen: 2,
		asm:    x86.AVBROADCASTSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VBROADCASTSDMasked512",
		argLen: 2,
		asm:    x86.AVBROADCASTSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VBROADCASTSS128",
		argLen: 1,
		asm:    x86.AVBROADCASTSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VBROADCASTSS256",
		argLen: 1,
		asm:    x86.AVBROADCASTSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VBROADCASTSS512",
		argLen: 1,
		asm:    x86.AVBROADCASTSS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VBROADCASTSSMasked128",
		argLen: 2,
		asm:    x86.AVBROADCASTSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VBROADCASTSSMasked256",
		argLen: 2,
		asm:    x86.AVBROADCASTSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VBROADCASTSSMasked512",
		argLen: 2,
		asm:    x86.AVBROADCASTSS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCOMPRESSPDMasked128",
		argLen: 2,
		asm:    x86.AVCOMPRESSPD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCOMPRESSPDMasked256",
		argLen: 2,
		asm:    x86.AVCOMPRESSPD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCOMPRESSPDMasked512",
		argLen: 2,
		asm:    x86.AVCOMPRESSPD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCOMPRESSPSMasked128",
		argLen: 2,
		asm:    x86.AVCOMPRESSPS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCOMPRESSPSMasked256",
		argLen: 2,
		asm:    x86.AVCOMPRESSPS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCOMPRESSPSMasked512",
		argLen: 2,
		asm:    x86.AVCOMPRESSPS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTDQ2PD256",
		argLen: 1,
		asm:    x86.AVCVTDQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTDQ2PD512",
		argLen: 1,
		asm:    x86.AVCVTDQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTDQ2PDMasked256",
		argLen: 2,
		asm:    x86.AVCVTDQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTDQ2PDMasked512",
		argLen: 2,
		asm:    x86.AVCVTDQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTDQ2PS128",
		argLen: 1,
		asm:    x86.AVCVTDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTDQ2PS256",
		argLen: 1,
		asm:    x86.AVCVTDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTDQ2PS512",
		argLen: 1,
		asm:    x86.AVCVTDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTDQ2PSMasked128",
		argLen: 2,
		asm:    x86.AVCVTDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTDQ2PSMasked256",
		argLen: 2,
		asm:    x86.AVCVTDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTDQ2PSMasked512",
		argLen: 2,
		asm:    x86.AVCVTDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTPD2PS256",
		argLen: 1,
		asm:    x86.AVCVTPD2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTPD2PSMasked256",
		argLen: 2,
		asm:    x86.AVCVTPD2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTPD2PSX128",
		argLen: 1,
		asm:    x86.AVCVTPD2PSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTPD2PSXMasked128",
		argLen: 2,
		asm:    x86.AVCVTPD2PSX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTPD2PSY128",
		argLen: 1,
		asm:    x86.AVCVTPD2PSY,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTPD2PSYMasked128",
		argLen: 2,
		asm:    x86.AVCVTPD2PSY,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTPS2PD256",
		argLen: 1,
		asm:    x86.AVCVTPS2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTPS2PD512",
		argLen: 1,
		asm:    x86.AVCVTPS2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTPS2PDMasked256",
		argLen: 2,
		asm:    x86.AVCVTPS2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTPS2PDMasked512",
		argLen: 2,
		asm:    x86.AVCVTPS2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PD128",
		argLen: 1,
		asm:    x86.AVCVTQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PD256",
		argLen: 1,
		asm:    x86.AVCVTQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PD512",
		argLen: 1,
		asm:    x86.AVCVTQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PDMasked128",
		argLen: 2,
		asm:    x86.AVCVTQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PDMasked256",
		argLen: 2,
		asm:    x86.AVCVTQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PDMasked512",
		argLen: 2,
		asm:    x86.AVCVTQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PS256",
		argLen: 1,
		asm:    x86.AVCVTQQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PSMasked256",
		argLen: 2,
		asm:    x86.AVCVTQQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PSX128",
		argLen: 1,
		asm:    x86.AVCVTQQ2PSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PSXMasked128",
		argLen: 2,
		asm:    x86.AVCVTQQ2PSX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PSY128",
		argLen: 1,
		asm:    x86.AVCVTQQ2PSY,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTQQ2PSYMasked128",
		argLen: 2,
		asm:    x86.AVCVTQQ2PSY,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2DQ256",
		argLen: 1,
		asm:    x86.AVCVTTPD2DQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2DQMasked256",
		argLen: 2,
		asm:    x86.AVCVTTPD2DQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2DQX128",
		argLen: 1,
		asm:    x86.AVCVTTPD2DQX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTTPD2DQXMasked128",
		argLen: 2,
		asm:    x86.AVCVTTPD2DQX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2DQY128",
		argLen: 1,
		asm:    x86.AVCVTTPD2DQY,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTTPD2DQYMasked128",
		argLen: 2,
		asm:    x86.AVCVTTPD2DQY,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2QQ128",
		argLen: 1,
		asm:    x86.AVCVTTPD2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2QQ256",
		argLen: 1,
		asm:    x86.AVCVTTPD2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2QQ512",
		argLen: 1,
		asm:    x86.AVCVTTPD2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2QQMasked128",
		argLen: 2,
		asm:    x86.AVCVTTPD2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2QQMasked256",
		argLen: 2,
		asm:    x86.AVCVTTPD2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2QQMasked512",
		argLen: 2,
		asm:    x86.AVCVTTPD2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UDQ256",
		argLen: 1,
		asm:    x86.AVCVTTPD2UDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UDQMasked256",
		argLen: 2,
		asm:    x86.AVCVTTPD2UDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UDQX128",
		argLen: 1,
		asm:    x86.AVCVTTPD2UDQX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UDQXMasked128",
		argLen: 2,
		asm:    x86.AVCVTTPD2UDQX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UDQY128",
		argLen: 1,
		asm:    x86.AVCVTTPD2UDQY,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UDQYMasked128",
		argLen: 2,
		asm:    x86.AVCVTTPD2UDQY,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UQQ128",
		argLen: 1,
		asm:    x86.AVCVTTPD2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UQQ256",
		argLen: 1,
		asm:    x86.AVCVTTPD2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UQQ512",
		argLen: 1,
		asm:    x86.AVCVTTPD2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UQQMasked128",
		argLen: 2,
		asm:    x86.AVCVTTPD2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UQQMasked256",
		argLen: 2,
		asm:    x86.AVCVTTPD2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPD2UQQMasked512",
		argLen: 2,
		asm:    x86.AVCVTTPD2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2DQ128",
		argLen: 1,
		asm:    x86.AVCVTTPS2DQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTTPS2DQ256",
		argLen: 1,
		asm:    x86.AVCVTTPS2DQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VCVTTPS2DQ512",
		argLen: 1,
		asm:    x86.AVCVTTPS2DQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2DQMasked128",
		argLen: 2,
		asm:    x86.AVCVTTPS2DQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2DQMasked256",
		argLen: 2,
		asm:    x86.AVCVTTPS2DQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2DQMasked512",
		argLen: 2,
		asm:    x86.AVCVTTPS2DQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2QQ256",
		argLen: 1,
		asm:    x86.AVCVTTPS2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2QQ512",
		argLen: 1,
		asm:    x86.AVCVTTPS2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2QQMasked256",
		argLen: 2,
		asm:    x86.AVCVTTPS2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2QQMasked512",
		argLen: 2,
		asm:    x86.AVCVTTPS2QQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UDQ128",
		argLen: 1,
		asm:    x86.AVCVTTPS2UDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UDQ256",
		argLen: 1,
		asm:    x86.AVCVTTPS2UDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UDQ512",
		argLen: 1,
		asm:    x86.AVCVTTPS2UDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UDQMasked128",
		argLen: 2,
		asm:    x86.AVCVTTPS2UDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UDQMasked256",
		argLen: 2,
		asm:    x86.AVCVTTPS2UDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UDQMasked512",
		argLen: 2,
		asm:    x86.AVCVTTPS2UDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UQQ256",
		argLen: 1,
		asm:    x86.AVCVTTPS2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UQQ512",
		argLen: 1,
		asm:    x86.AVCVTTPS2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UQQMasked256",
		argLen: 2,
		asm:    x86.AVCVTTPS2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTTPS2UQQMasked512",
		argLen: 2,
		asm:    x86.AVCVTTPS2UQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PD256",
		argLen: 1,
		asm:    x86.AVCVTUDQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PD512",
		argLen: 1,
		asm:    x86.AVCVTUDQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PDMasked256",
		argLen: 2,
		asm:    x86.AVCVTUDQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PDMasked512",
		argLen: 2,
		asm:    x86.AVCVTUDQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PS128",
		argLen: 1,
		asm:    x86.AVCVTUDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PS256",
		argLen: 1,
		asm:    x86.AVCVTUDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PS512",
		argLen: 1,
		asm:    x86.AVCVTUDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PSMasked128",
		argLen: 2,
		asm:    x86.AVCVTUDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PSMasked256",
		argLen: 2,
		asm:    x86.AVCVTUDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUDQ2PSMasked512",
		argLen: 2,
		asm:    x86.AVCVTUDQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PD128",
		argLen: 1,
		asm:    x86.AVCVTUQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PD256",
		argLen: 1,
		asm:    x86.AVCVTUQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PD512",
		argLen: 1,
		asm:    x86.AVCVTUQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PDMasked128",
		argLen: 2,
		asm:    x86.AVCVTUQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PDMasked256",
		argLen: 2,
		asm:    x86.AVCVTUQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PDMasked512",
		argLen: 2,
		asm:    x86.AVCVTUQQ2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PS256",
		argLen: 1,
		asm:    x86.AVCVTUQQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PSMasked256",
		argLen: 2,
		asm:    x86.AVCVTUQQ2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PSX128",
		argLen: 1,
		asm:    x86.AVCVTUQQ2PSX,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PSXMasked128",
		argLen: 2,
		asm:    x86.AVCVTUQQ2PSX,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PSY128",
		argLen: 1,
		asm:    x86.AVCVTUQQ2PSY,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VCVTUQQ2PSYMasked128",
		argLen: 2,
		asm:    x86.AVCVTUQQ2PSY,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VDIVPD128",
		argLen: 2,
		asm:    x86.AVDIVPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VDIVPD256",
		argLen: 2,
		asm:    x86.AVDIVPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VDIVPD512",
		argLen: 2,
		asm:    x86.AVDIVPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VDIVPDMasked128",
		argLen: 3,
		asm:    x86.AVDIVPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VDIVPDMasked256",
		argLen: 3,
		asm:    x86.AVDIVPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VDIVPDMasked512",
		argLen: 3,
		asm:    x86.AVDIVPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VDIVPS128",
		argLen: 2,
		asm:    x86.AVDIVPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VDIVPS256",
		argLen: 2,
		asm:    x86.AVDIVPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VDIVPS512",
		argLen: 2,
		asm:    x86.AVDIVPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VDIVPSMasked128",
		argLen: 3,
		asm:    x86.AVDIVPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VDIVPSMasked256",
		argLen: 3,
		asm:    x86.AVDIVPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VDIVPSMasked512",
		argLen: 3,
		asm:    x86.AVDIVPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VEXPANDPDMasked128",
		argLen: 2,
		asm:    x86.AVEXPANDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VEXPANDPDMasked256",
		argLen: 2,
		asm:    x86.AVEXPANDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VEXPANDPDMasked512",
		argLen: 2,
		asm:    x86.AVEXPANDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VEXPANDPSMasked128",
		argLen: 2,
		asm:    x86.AVEXPANDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VEXPANDPSMasked256",
		argLen: 2,
		asm:    x86.AVEXPANDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VEXPANDPSMasked512",
		argLen: 2,
		asm:    x86.AVEXPANDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADD213PD128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADD213PD256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADD213PD512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADD213PDMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADD213PDMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADD213PDMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADD213PS128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADD213PS256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADD213PS512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADD213PSMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADD213PSMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADD213PSMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADDSUB213PD128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADDSUB213PD256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADDSUB213PD512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADDSUB213PDMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADDSUB213PDMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADDSUB213PDMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADDSUB213PS128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADDSUB213PS256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMADDSUB213PS512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADDSUB213PSMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADDSUB213PSMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMADDSUB213PSMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMADDSUB213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMSUBADD213PD128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMSUBADD213PD256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMSUBADD213PD512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMSUBADD213PDMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMSUBADD213PDMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMSUBADD213PDMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMSUBADD213PS128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMSUBADD213PS256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VFMSUBADD213PS512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMSUBADD213PSMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMSUBADD213PSMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VFMSUBADD213PSMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVFMSUBADD213PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VGF2P8MULB128",
		argLen: 2,
		asm:    x86.AVGF2P8MULB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VGF2P8MULB256",
		argLen: 2,
		asm:    x86.AVGF2P8MULB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VGF2P8MULB512",
		argLen: 2,
		asm:    x86.AVGF2P8MULB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VGF2P8MULBMasked128",
		argLen: 3,
		asm:    x86.AVGF2P8MULB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VGF2P8MULBMasked256",
		argLen: 3,
		asm:    x86.AVGF2P8MULB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VGF2P8MULBMasked512",
		argLen: 3,
		asm:    x86.AVGF2P8MULB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VHADDPD128",
		argLen: 2,
		asm:    x86.AVHADDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VHADDPD256",
		argLen: 2,
		asm:    x86.AVHADDPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VHADDPS128",
		argLen: 2,
		asm:    x86.AVHADDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VHADDPS256",
		argLen: 2,
		asm:    x86.AVHADDPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VHSUBPD128",
		argLen: 2,
		asm:    x86.AVHSUBPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VHSUBPD256",
		argLen: 2,
		asm:    x86.AVHSUBPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VHSUBPS128",
		argLen: 2,
		asm:    x86.AVHSUBPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VHSUBPS256",
		argLen: 2,
		asm:    x86.AVHSUBPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMAXPD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMAXPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMAXPD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMAXPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMAXPD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMAXPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMAXPDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMAXPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMAXPDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMAXPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMAXPDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMAXPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMAXPS128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMAXPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMAXPS256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMAXPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMAXPS512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMAXPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMAXPSMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMAXPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMAXPSMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMAXPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMAXPSMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMAXPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMINPD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMINPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMINPD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMINPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMINPD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMINPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMINPDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMINPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMINPDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMINPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMINPDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMINPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMINPS128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMINPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMINPS256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMINPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMINPS512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMINPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMINPSMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMINPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMINPSMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMINPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMINPSMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMINPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU8Masked128",
		argLen: 2,
		asm:    x86.AVMOVDQU8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU8Masked256",
		argLen: 2,
		asm:    x86.AVMOVDQU8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU8Masked512",
		argLen: 2,
		asm:    x86.AVMOVDQU8,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU16Masked128",
		argLen: 2,
		asm:    x86.AVMOVDQU16,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU16Masked256",
		argLen: 2,
		asm:    x86.AVMOVDQU16,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU16Masked512",
		argLen: 2,
		asm:    x86.AVMOVDQU16,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU32Masked128",
		argLen: 2,
		asm:    x86.AVMOVDQU32,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU32Masked256",
		argLen: 2,
		asm:    x86.AVMOVDQU32,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU32Masked512",
		argLen: 2,
		asm:    x86.AVMOVDQU32,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU64Masked128",
		argLen: 2,
		asm:    x86.AVMOVDQU64,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU64Masked256",
		argLen: 2,
		asm:    x86.AVMOVDQU64,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VMOVDQU64Masked512",
		argLen: 2,
		asm:    x86.AVMOVDQU64,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMULPD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMULPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMULPD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMULPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMULPD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMULPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMULPDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMULPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMULPDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMULPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMULPDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMULPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMULPS128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMULPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMULPS256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMULPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VMULPS512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVMULPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMULPSMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMULPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMULPSMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMULPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VMULPSMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVMULPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSB128",
		argLen: 1,
		asm:    x86.AVPABSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPABSB256",
		argLen: 1,
		asm:    x86.AVPABSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPABSB512",
		argLen: 1,
		asm:    x86.AVPABSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSBMasked128",
		argLen: 2,
		asm:    x86.AVPABSB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSBMasked256",
		argLen: 2,
		asm:    x86.AVPABSB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSBMasked512",
		argLen: 2,
		asm:    x86.AVPABSB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSD128",
		argLen: 1,
		asm:    x86.AVPABSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPABSD256",
		argLen: 1,
		asm:    x86.AVPABSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPABSD512",
		argLen: 1,
		asm:    x86.AVPABSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSDMasked128",
		argLen: 2,
		asm:    x86.AVPABSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSDMasked256",
		argLen: 2,
		asm:    x86.AVPABSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSDMasked512",
		argLen: 2,
		asm:    x86.AVPABSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSQ128",
		argLen: 1,
		asm:    x86.AVPABSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSQ256",
		argLen: 1,
		asm:    x86.AVPABSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSQ512",
		argLen: 1,
		asm:    x86.AVPABSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSQMasked128",
		argLen: 2,
		asm:    x86.AVPABSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSQMasked256",
		argLen: 2,
		asm:    x86.AVPABSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSQMasked512",
		argLen: 2,
		asm:    x86.AVPABSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSW128",
		argLen: 1,
		asm:    x86.AVPABSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPABSW256",
		argLen: 1,
		asm:    x86.AVPABSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPABSW512",
		argLen: 1,
		asm:    x86.AVPABSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSWMasked128",
		argLen: 2,
		asm:    x86.AVPABSW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSWMasked256",
		argLen: 2,
		asm:    x86.AVPABSW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPABSWMasked512",
		argLen: 2,
		asm:    x86.AVPABSW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPACKSSDW128",
		argLen: 2,
		asm:    x86.AVPACKSSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPACKSSDW256",
		argLen: 2,
		asm:    x86.AVPACKSSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPACKSSDW512",
		argLen: 2,
		asm:    x86.AVPACKSSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPACKSSDWMasked128",
		argLen: 3,
		asm:    x86.AVPACKSSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPACKSSDWMasked256",
		argLen: 3,
		asm:    x86.AVPACKSSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPACKSSDWMasked512",
		argLen: 3,
		asm:    x86.AVPACKSSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPACKUSDW128",
		argLen: 2,
		asm:    x86.AVPACKUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPACKUSDW256",
		argLen: 2,
		asm:    x86.AVPACKUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPACKUSDW512",
		argLen: 2,
		asm:    x86.AVPACKUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPACKUSDWMasked128",
		argLen: 3,
		asm:    x86.AVPACKUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPACKUSDWMasked256",
		argLen: 3,
		asm:    x86.AVPACKUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPACKUSDWMasked512",
		argLen: 3,
		asm:    x86.AVPACKUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDB128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDB256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDB512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDBMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDBMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDBMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDQ128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDQ256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDQ512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDQMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDQMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDQMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDSB128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDSB256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDSB512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDSBMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDSBMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDSBMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDSW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDSW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDSW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDSWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDSWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDSWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDUSB128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDUSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDUSB256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDUSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDUSB512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDUSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDUSBMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDUSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDUSBMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDUSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDUSBMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDUSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDUSW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDUSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDUSW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDUSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDUSW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDUSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDUSWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDUSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDUSWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDUSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDUSWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDUSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPADDW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPADDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPADDWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPADDW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPAND128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPAND,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPAND256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPAND,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPANDD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPANDD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPANDDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPANDD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPANDDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPANDD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPANDDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPANDD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPANDN128",
		argLen: 2,
		asm:    x86.AVPANDN,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPANDN256",
		argLen: 2,
		asm:    x86.AVPANDN,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPANDND512",
		argLen: 2,
		asm:    x86.AVPANDND,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPANDNDMasked128",
		argLen: 3,
		asm:    x86.AVPANDND,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPANDNDMasked256",
		argLen: 3,
		asm:    x86.AVPANDND,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPANDNDMasked512",
		argLen: 3,
		asm:    x86.AVPANDND,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPANDNQ512",
		argLen: 2,
		asm:    x86.AVPANDNQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPANDNQMasked128",
		argLen: 3,
		asm:    x86.AVPANDNQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPANDNQMasked256",
		argLen: 3,
		asm:    x86.AVPANDNQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPANDNQMasked512",
		argLen: 3,
		asm:    x86.AVPANDNQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPANDQ512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPANDQMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPANDQMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPANDQMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPAVGB128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPAVGB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPAVGB256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPAVGB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPAVGB512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPAVGB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPAVGBMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPAVGB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPAVGBMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPAVGB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPAVGBMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPAVGB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPAVGW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPAVGW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPAVGW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPAVGW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPAVGW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPAVGW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPAVGWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPAVGW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPAVGWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPAVGW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPAVGWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPAVGW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBLENDMBMasked512",
		argLen: 3,
		asm:    x86.AVPBLENDMB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBLENDMDMasked512",
		argLen: 3,
		asm:    x86.AVPBLENDMD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBLENDMQMasked512",
		argLen: 3,
		asm:    x86.AVPBLENDMQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBLENDMWMasked512",
		argLen: 3,
		asm:    x86.AVPBLENDMW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBLENDVB128",
		argLen: 3,
		asm:    x86.AVPBLENDVB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBLENDVB256",
		argLen: 3,
		asm:    x86.AVPBLENDVB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTB128",
		argLen: 1,
		asm:    x86.AVPBROADCASTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTB256",
		argLen: 1,
		asm:    x86.AVPBROADCASTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTB512",
		argLen: 1,
		asm:    x86.AVPBROADCASTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTBMasked128",
		argLen: 2,
		asm:    x86.AVPBROADCASTB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTBMasked256",
		argLen: 2,
		asm:    x86.AVPBROADCASTB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTBMasked512",
		argLen: 2,
		asm:    x86.AVPBROADCASTB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTD128",
		argLen: 1,
		asm:    x86.AVPBROADCASTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTD256",
		argLen: 1,
		asm:    x86.AVPBROADCASTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTD512",
		argLen: 1,
		asm:    x86.AVPBROADCASTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTDMasked128",
		argLen: 2,
		asm:    x86.AVPBROADCASTD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTDMasked256",
		argLen: 2,
		asm:    x86.AVPBROADCASTD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTDMasked512",
		argLen: 2,
		asm:    x86.AVPBROADCASTD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTQ128",
		argLen: 1,
		asm:    x86.AVPBROADCASTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTQ256",
		argLen: 1,
		asm:    x86.AVPBROADCASTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTQ512",
		argLen: 1,
		asm:    x86.AVPBROADCASTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTQMasked128",
		argLen: 2,
		asm:    x86.AVPBROADCASTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTQMasked256",
		argLen: 2,
		asm:    x86.AVPBROADCASTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTQMasked512",
		argLen: 2,
		asm:    x86.AVPBROADCASTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTW128",
		argLen: 1,
		asm:    x86.AVPBROADCASTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTW256",
		argLen: 1,
		asm:    x86.AVPBROADCASTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPBROADCASTW512",
		argLen: 1,
		asm:    x86.AVPBROADCASTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTWMasked128",
		argLen: 2,
		asm:    x86.AVPBROADCASTW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTWMasked256",
		argLen: 2,
		asm:    x86.AVPBROADCASTW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPBROADCASTWMasked512",
		argLen: 2,
		asm:    x86.AVPBROADCASTW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPCMPEQB128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPCMPEQB256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPCMPEQB512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:        "VPCMPEQD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPCMPEQD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPCMPEQD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:        "VPCMPEQQ128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPCMPEQQ256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPCMPEQQ512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:        "VPCMPEQW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPCMPEQW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPCMPEQW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPCMPEQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPCMPGTB128",
		argLen: 2,
		asm:    x86.AVPCMPGTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPCMPGTB256",
		argLen: 2,
		asm:    x86.AVPCMPGTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPCMPGTB512",
		argLen: 2,
		asm:    x86.AVPCMPGTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPCMPGTD128",
		argLen: 2,
		asm:    x86.AVPCMPGTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPCMPGTD256",
		argLen: 2,
		asm:    x86.AVPCMPGTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPCMPGTD512",
		argLen: 2,
		asm:    x86.AVPCMPGTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPCMPGTQ128",
		argLen: 2,
		asm:    x86.AVPCMPGTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPCMPGTQ256",
		argLen: 2,
		asm:    x86.AVPCMPGTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPCMPGTQ512",
		argLen: 2,
		asm:    x86.AVPCMPGTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPCMPGTW128",
		argLen: 2,
		asm:    x86.AVPCMPGTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPCMPGTW256",
		argLen: 2,
		asm:    x86.AVPCMPGTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPCMPGTW512",
		argLen: 2,
		asm:    x86.AVPCMPGTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
			},
		},
	},
	{
		name:   "VPCOMPRESSBMasked128",
		argLen: 2,
		asm:    x86.AVPCOMPRESSB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSBMasked256",
		argLen: 2,
		asm:    x86.AVPCOMPRESSB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSBMasked512",
		argLen: 2,
		asm:    x86.AVPCOMPRESSB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSDMasked128",
		argLen: 2,
		asm:    x86.AVPCOMPRESSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSDMasked256",
		argLen: 2,
		asm:    x86.AVPCOMPRESSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSDMasked512",
		argLen: 2,
		asm:    x86.AVPCOMPRESSD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSQMasked128",
		argLen: 2,
		asm:    x86.AVPCOMPRESSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSQMasked256",
		argLen: 2,
		asm:    x86.AVPCOMPRESSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSQMasked512",
		argLen: 2,
		asm:    x86.AVPCOMPRESSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSWMasked128",
		argLen: 2,
		asm:    x86.AVPCOMPRESSW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSWMasked256",
		argLen: 2,
		asm:    x86.AVPCOMPRESSW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPCOMPRESSWMasked512",
		argLen: 2,
		asm:    x86.AVPCOMPRESSW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPDPWSSD128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPDPWSSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VPDPWSSD256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPDPWSSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
				{2, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:         "VPDPWSSD512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPDPWSSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPDPWSSDMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPDPWSSD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPDPWSSDMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPDPWSSD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPDPWSSDMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPDPWSSD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMB128",
		argLen: 2,
		asm:    x86.AVPERMB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMB256",
		argLen: 2,
		asm:    x86.AVPERMB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMB512",
		argLen: 2,
		asm:    x86.AVPERMB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMBMasked128",
		argLen: 3,
		asm:    x86.AVPERMB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMBMasked256",
		argLen: 3,
		asm:    x86.AVPERMB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMBMasked512",
		argLen: 3,
		asm:    x86.AVPERMB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMD256",
		argLen: 2,
		asm:    x86.AVPERMD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPERMD512",
		argLen: 2,
		asm:    x86.AVPERMD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMDMasked256",
		argLen: 3,
		asm:    x86.AVPERMD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMDMasked512",
		argLen: 3,
		asm:    x86.AVPERMD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2B128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2B,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2B256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2B,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2B512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2B,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2BMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2B,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2BMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2B,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2BMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2B,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2D128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2D,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2D256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2D,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2D512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2D,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2DMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2D,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2DMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2D,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2DMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2D,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PD128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PD256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PD512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PDMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PDMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PDMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2PD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PS128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PS256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PS512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PSMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PSMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2PSMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2PS,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2Q128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2Q,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2Q256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2Q,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2Q512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2Q,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2QMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2Q,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2QMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2Q,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2QMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2Q,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2W128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2W,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2W256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2W,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2W512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPERMI2W,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2WMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2W,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2WMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2W,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPERMI2WMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPERMI2W,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMPD256",
		argLen: 2,
		asm:    x86.AVPERMPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMPD512",
		argLen: 2,
		asm:    x86.AVPERMPD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMPDMasked256",
		argLen: 3,
		asm:    x86.AVPERMPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMPDMasked512",
		argLen: 3,
		asm:    x86.AVPERMPD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMPS256",
		argLen: 2,
		asm:    x86.AVPERMPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPERMPS512",
		argLen: 2,
		asm:    x86.AVPERMPS,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMPSMasked256",
		argLen: 3,
		asm:    x86.AVPERMPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMPSMasked512",
		argLen: 3,
		asm:    x86.AVPERMPS,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMQ256",
		argLen: 2,
		asm:    x86.AVPERMQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMQ512",
		argLen: 2,
		asm:    x86.AVPERMQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMQMasked256",
		argLen: 3,
		asm:    x86.AVPERMQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMQMasked512",
		argLen: 3,
		asm:    x86.AVPERMQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMW128",
		argLen: 2,
		asm:    x86.AVPERMW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMW256",
		argLen: 2,
		asm:    x86.AVPERMW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMW512",
		argLen: 2,
		asm:    x86.AVPERMW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMWMasked128",
		argLen: 3,
		asm:    x86.AVPERMW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMWMasked256",
		argLen: 3,
		asm:    x86.AVPERMW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPERMWMasked512",
		argLen: 3,
		asm:    x86.AVPERMW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDBMasked128",
		argLen: 2,
		asm:    x86.AVPEXPANDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDBMasked256",
		argLen: 2,
		asm:    x86.AVPEXPANDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDBMasked512",
		argLen: 2,
		asm:    x86.AVPEXPANDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDDMasked128",
		argLen: 2,
		asm:    x86.AVPEXPANDD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDDMasked256",
		argLen: 2,
		asm:    x86.AVPEXPANDD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDDMasked512",
		argLen: 2,
		asm:    x86.AVPEXPANDD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDQMasked128",
		argLen: 2,
		asm:    x86.AVPEXPANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDQMasked256",
		argLen: 2,
		asm:    x86.AVPEXPANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDQMasked512",
		argLen: 2,
		asm:    x86.AVPEXPANDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDWMasked128",
		argLen: 2,
		asm:    x86.AVPEXPANDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDWMasked256",
		argLen: 2,
		asm:    x86.AVPEXPANDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPEXPANDWMasked512",
		argLen: 2,
		asm:    x86.AVPEXPANDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPHADDD128",
		argLen: 2,
		asm:    x86.AVPHADDD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHADDD256",
		argLen: 2,
		asm:    x86.AVPHADDD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHADDSW128",
		argLen: 2,
		asm:    x86.AVPHADDSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHADDSW256",
		argLen: 2,
		asm:    x86.AVPHADDSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHADDW128",
		argLen: 2,
		asm:    x86.AVPHADDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHADDW256",
		argLen: 2,
		asm:    x86.AVPHADDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHSUBD128",
		argLen: 2,
		asm:    x86.AVPHSUBD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHSUBD256",
		argLen: 2,
		asm:    x86.AVPHSUBD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHSUBSW128",
		argLen: 2,
		asm:    x86.AVPHSUBSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHSUBSW256",
		argLen: 2,
		asm:    x86.AVPHSUBSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHSUBW128",
		argLen: 2,
		asm:    x86.AVPHSUBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPHSUBW256",
		argLen: 2,
		asm:    x86.AVPHSUBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPLZCNTD128",
		argLen: 1,
		asm:    x86.AVPLZCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTD256",
		argLen: 1,
		asm:    x86.AVPLZCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTD512",
		argLen: 1,
		asm:    x86.AVPLZCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTDMasked128",
		argLen: 2,
		asm:    x86.AVPLZCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTDMasked256",
		argLen: 2,
		asm:    x86.AVPLZCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTDMasked512",
		argLen: 2,
		asm:    x86.AVPLZCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTQ128",
		argLen: 1,
		asm:    x86.AVPLZCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTQ256",
		argLen: 1,
		asm:    x86.AVPLZCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTQ512",
		argLen: 1,
		asm:    x86.AVPLZCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTQMasked128",
		argLen: 2,
		asm:    x86.AVPLZCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTQMasked256",
		argLen: 2,
		asm:    x86.AVPLZCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPLZCNTQMasked512",
		argLen: 2,
		asm:    x86.AVPLZCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMADDUBSW128",
		argLen: 2,
		asm:    x86.AVPMADDUBSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMADDUBSW256",
		argLen: 2,
		asm:    x86.AVPMADDUBSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMADDUBSW512",
		argLen: 2,
		asm:    x86.AVPMADDUBSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMADDUBSWMasked128",
		argLen: 3,
		asm:    x86.AVPMADDUBSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMADDUBSWMasked256",
		argLen: 3,
		asm:    x86.AVPMADDUBSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMADDUBSWMasked512",
		argLen: 3,
		asm:    x86.AVPMADDUBSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMADDWD128",
		argLen: 2,
		asm:    x86.AVPMADDWD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMADDWD256",
		argLen: 2,
		asm:    x86.AVPMADDWD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMADDWD512",
		argLen: 2,
		asm:    x86.AVPMADDWD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMADDWDMasked128",
		argLen: 3,
		asm:    x86.AVPMADDWD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMADDWDMasked256",
		argLen: 3,
		asm:    x86.AVPMADDWD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMADDWDMasked512",
		argLen: 3,
		asm:    x86.AVPMADDWD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSB128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXSB256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXSB512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSBMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSBMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSBMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXSD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXSD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSQ128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSQ256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSQ512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSQMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSQMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSQMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXSW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXSW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXSWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUB128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXUB256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXUB512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUBMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUBMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUBMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXUD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXUD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUQ128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUQ256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUQ512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUQMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUQMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUQMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXUW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMAXUW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMAXUW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMAXUWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMAXUW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSB128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINSB256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINSB512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSBMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSBMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSBMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINSD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINSD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSQ128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSQ256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSQ512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSQMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSQMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSQMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINSW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINSW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINSW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINSWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINSW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUB128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINUB256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINUB512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUBMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUBMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUBMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUB,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINUD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINUD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUQ128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUQ256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUQ512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUQMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUQMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUQMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINUW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMINUW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMINUW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMINUWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMINUW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDB128_128",
		argLen: 1,
		asm:    x86.AVPMOVDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDB128_256",
		argLen: 1,
		asm:    x86.AVPMOVDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDB128_512",
		argLen: 1,
		asm:    x86.AVPMOVDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDBMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDBMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDBMasked128_512",
		argLen: 2,
		asm:    x86.AVPMOVDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDW128_128",
		argLen: 1,
		asm:    x86.AVPMOVDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDW128_256",
		argLen: 1,
		asm:    x86.AVPMOVDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDW256",
		argLen: 1,
		asm:    x86.AVPMOVDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDWMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDWMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVDWMasked256",
		argLen: 2,
		asm:    x86.AVPMOVDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQB128_128",
		argLen: 1,
		asm:    x86.AVPMOVQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQB128_256",
		argLen: 1,
		asm:    x86.AVPMOVQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQB128_512",
		argLen: 1,
		asm:    x86.AVPMOVQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQBMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVQB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQBMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVQB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQBMasked128_512",
		argLen: 2,
		asm:    x86.AVPMOVQB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQD128_128",
		argLen: 1,
		asm:    x86.AVPMOVQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQD128_256",
		argLen: 1,
		asm:    x86.AVPMOVQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQD256",
		argLen: 1,
		asm:    x86.AVPMOVQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQDMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVQD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQDMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVQD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQDMasked256",
		argLen: 2,
		asm:    x86.AVPMOVQD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQW128_128",
		argLen: 1,
		asm:    x86.AVPMOVQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQW128_256",
		argLen: 1,
		asm:    x86.AVPMOVQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQW128_512",
		argLen: 1,
		asm:    x86.AVPMOVQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQWMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVQW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQWMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVQW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVQWMasked128_512",
		argLen: 2,
		asm:    x86.AVPMOVQW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDB128_128",
		argLen: 1,
		asm:    x86.AVPMOVSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDB128_256",
		argLen: 1,
		asm:    x86.AVPMOVSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDB128_512",
		argLen: 1,
		asm:    x86.AVPMOVSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDBMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDBMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDBMasked128_512",
		argLen: 2,
		asm:    x86.AVPMOVSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDW128_128",
		argLen: 1,
		asm:    x86.AVPMOVSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDW128_256",
		argLen: 1,
		asm:    x86.AVPMOVSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDW256",
		argLen: 1,
		asm:    x86.AVPMOVSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDWMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDWMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSDWMasked256",
		argLen: 2,
		asm:    x86.AVPMOVSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQB128_128",
		argLen: 1,
		asm:    x86.AVPMOVSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQB128_256",
		argLen: 1,
		asm:    x86.AVPMOVSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQB128_512",
		argLen: 1,
		asm:    x86.AVPMOVSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQBMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQBMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQBMasked128_512",
		argLen: 2,
		asm:    x86.AVPMOVSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQD128_128",
		argLen: 1,
		asm:    x86.AVPMOVSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQD128_256",
		argLen: 1,
		asm:    x86.AVPMOVSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQD256",
		argLen: 1,
		asm:    x86.AVPMOVSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQDMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQDMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQDMasked256",
		argLen: 2,
		asm:    x86.AVPMOVSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQW128_128",
		argLen: 1,
		asm:    x86.AVPMOVSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQW128_256",
		argLen: 1,
		asm:    x86.AVPMOVSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQW128_512",
		argLen: 1,
		asm:    x86.AVPMOVSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQWMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQWMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSQWMasked128_512",
		argLen: 2,
		asm:    x86.AVPMOVSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSWB128_128",
		argLen: 1,
		asm:    x86.AVPMOVSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSWB128_256",
		argLen: 1,
		asm:    x86.AVPMOVSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSWB256",
		argLen: 1,
		asm:    x86.AVPMOVSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSWBMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSWBMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSWBMasked256",
		argLen: 2,
		asm:    x86.AVPMOVSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBD128",
		argLen: 1,
		asm:    x86.AVPMOVSXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXBD256",
		argLen: 1,
		asm:    x86.AVPMOVSXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXBD512",
		argLen: 1,
		asm:    x86.AVPMOVSXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBDMasked128",
		argLen: 2,
		asm:    x86.AVPMOVSXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBDMasked256",
		argLen: 2,
		asm:    x86.AVPMOVSXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBDMasked512",
		argLen: 2,
		asm:    x86.AVPMOVSXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBQ128",
		argLen: 1,
		asm:    x86.AVPMOVSXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXBQ256",
		argLen: 1,
		asm:    x86.AVPMOVSXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXBQ512",
		argLen: 1,
		asm:    x86.AVPMOVSXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBQMasked128",
		argLen: 2,
		asm:    x86.AVPMOVSXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBQMasked256",
		argLen: 2,
		asm:    x86.AVPMOVSXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBQMasked512",
		argLen: 2,
		asm:    x86.AVPMOVSXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBW128",
		argLen: 1,
		asm:    x86.AVPMOVSXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXBW256",
		argLen: 1,
		asm:    x86.AVPMOVSXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXBW512",
		argLen: 1,
		asm:    x86.AVPMOVSXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBWMasked128",
		argLen: 2,
		asm:    x86.AVPMOVSXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBWMasked256",
		argLen: 2,
		asm:    x86.AVPMOVSXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXBWMasked512",
		argLen: 2,
		asm:    x86.AVPMOVSXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXDQ128",
		argLen: 1,
		asm:    x86.AVPMOVSXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXDQ256",
		argLen: 1,
		asm:    x86.AVPMOVSXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXDQ512",
		argLen: 1,
		asm:    x86.AVPMOVSXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXDQMasked128",
		argLen: 2,
		asm:    x86.AVPMOVSXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXDQMasked256",
		argLen: 2,
		asm:    x86.AVPMOVSXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXDQMasked512",
		argLen: 2,
		asm:    x86.AVPMOVSXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXWD128",
		argLen: 1,
		asm:    x86.AVPMOVSXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXWD256",
		argLen: 1,
		asm:    x86.AVPMOVSXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXWD512",
		argLen: 1,
		asm:    x86.AVPMOVSXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXWDMasked128",
		argLen: 2,
		asm:    x86.AVPMOVSXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXWDMasked256",
		argLen: 2,
		asm:    x86.AVPMOVSXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXWDMasked512",
		argLen: 2,
		asm:    x86.AVPMOVSXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXWQ128",
		argLen: 1,
		asm:    x86.AVPMOVSXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXWQ256",
		argLen: 1,
		asm:    x86.AVPMOVSXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVSXWQ512",
		argLen: 1,
		asm:    x86.AVPMOVSXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXWQMasked128",
		argLen: 2,
		asm:    x86.AVPMOVSXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXWQMasked256",
		argLen: 2,
		asm:    x86.AVPMOVSXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVSXWQMasked512",
		argLen: 2,
		asm:    x86.AVPMOVSXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDB128_128",
		argLen: 1,
		asm:    x86.AVPMOVUSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDB128_256",
		argLen: 1,
		asm:    x86.AVPMOVUSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDB128_512",
		argLen: 1,
		asm:    x86.AVPMOVUSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDBMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVUSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDBMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVUSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDBMasked128_512",
		argLen: 2,
		asm:    x86.AVPMOVUSDB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDW128_128",
		argLen: 1,
		asm:    x86.AVPMOVUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDW128_256",
		argLen: 1,
		asm:    x86.AVPMOVUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDW256",
		argLen: 1,
		asm:    x86.AVPMOVUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDWMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDWMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSDWMasked256",
		argLen: 2,
		asm:    x86.AVPMOVUSDW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQB128_128",
		argLen: 1,
		asm:    x86.AVPMOVUSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQB128_256",
		argLen: 1,
		asm:    x86.AVPMOVUSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQB128_512",
		argLen: 1,
		asm:    x86.AVPMOVUSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQBMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVUSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQBMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVUSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQBMasked128_512",
		argLen: 2,
		asm:    x86.AVPMOVUSQB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQD128_128",
		argLen: 1,
		asm:    x86.AVPMOVUSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQD128_256",
		argLen: 1,
		asm:    x86.AVPMOVUSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQD256",
		argLen: 1,
		asm:    x86.AVPMOVUSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQDMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVUSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQDMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVUSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQDMasked256",
		argLen: 2,
		asm:    x86.AVPMOVUSQD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQW128_128",
		argLen: 1,
		asm:    x86.AVPMOVUSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQW128_256",
		argLen: 1,
		asm:    x86.AVPMOVUSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQW128_512",
		argLen: 1,
		asm:    x86.AVPMOVUSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQWMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVUSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQWMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVUSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSQWMasked128_512",
		argLen: 2,
		asm:    x86.AVPMOVUSQW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSWB128_128",
		argLen: 1,
		asm:    x86.AVPMOVUSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSWB128_256",
		argLen: 1,
		asm:    x86.AVPMOVUSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSWB256",
		argLen: 1,
		asm:    x86.AVPMOVUSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSWBMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVUSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSWBMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVUSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVUSWBMasked256",
		argLen: 2,
		asm:    x86.AVPMOVUSWB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVWB128_128",
		argLen: 1,
		asm:    x86.AVPMOVWB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVWB128_256",
		argLen: 1,
		asm:    x86.AVPMOVWB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVWB256",
		argLen: 1,
		asm:    x86.AVPMOVWB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVWBMasked128_128",
		argLen: 2,
		asm:    x86.AVPMOVWB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVWBMasked128_256",
		argLen: 2,
		asm:    x86.AVPMOVWB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVWBMasked256",
		argLen: 2,
		asm:    x86.AVPMOVWB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBD128",
		argLen: 1,
		asm:    x86.AVPMOVZXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXBD256",
		argLen: 1,
		asm:    x86.AVPMOVZXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXBD512",
		argLen: 1,
		asm:    x86.AVPMOVZXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBDMasked128",
		argLen: 2,
		asm:    x86.AVPMOVZXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBDMasked256",
		argLen: 2,
		asm:    x86.AVPMOVZXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBDMasked512",
		argLen: 2,
		asm:    x86.AVPMOVZXBD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBQ128",
		argLen: 1,
		asm:    x86.AVPMOVZXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXBQ256",
		argLen: 1,
		asm:    x86.AVPMOVZXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXBQ512",
		argLen: 1,
		asm:    x86.AVPMOVZXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBQMasked128",
		argLen: 2,
		asm:    x86.AVPMOVZXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBQMasked256",
		argLen: 2,
		asm:    x86.AVPMOVZXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBQMasked512",
		argLen: 2,
		asm:    x86.AVPMOVZXBQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBW128",
		argLen: 1,
		asm:    x86.AVPMOVZXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXBW256",
		argLen: 1,
		asm:    x86.AVPMOVZXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXBW512",
		argLen: 1,
		asm:    x86.AVPMOVZXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBWMasked128",
		argLen: 2,
		asm:    x86.AVPMOVZXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBWMasked256",
		argLen: 2,
		asm:    x86.AVPMOVZXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXBWMasked512",
		argLen: 2,
		asm:    x86.AVPMOVZXBW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXDQ128",
		argLen: 1,
		asm:    x86.AVPMOVZXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXDQ256",
		argLen: 1,
		asm:    x86.AVPMOVZXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXDQ512",
		argLen: 1,
		asm:    x86.AVPMOVZXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXDQMasked128",
		argLen: 2,
		asm:    x86.AVPMOVZXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXDQMasked256",
		argLen: 2,
		asm:    x86.AVPMOVZXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXDQMasked512",
		argLen: 2,
		asm:    x86.AVPMOVZXDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXWD128",
		argLen: 1,
		asm:    x86.AVPMOVZXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXWD256",
		argLen: 1,
		asm:    x86.AVPMOVZXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXWD512",
		argLen: 1,
		asm:    x86.AVPMOVZXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXWDMasked128",
		argLen: 2,
		asm:    x86.AVPMOVZXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXWDMasked256",
		argLen: 2,
		asm:    x86.AVPMOVZXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXWDMasked512",
		argLen: 2,
		asm:    x86.AVPMOVZXWD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXWQ128",
		argLen: 1,
		asm:    x86.AVPMOVZXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXWQ256",
		argLen: 1,
		asm:    x86.AVPMOVZXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPMOVZXWQ512",
		argLen: 1,
		asm:    x86.AVPMOVZXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXWQMasked128",
		argLen: 2,
		asm:    x86.AVPMOVZXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXWQMasked256",
		argLen: 2,
		asm:    x86.AVPMOVZXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPMOVZXWQMasked512",
		argLen: 2,
		asm:    x86.AVPMOVZXWQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULDQ128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULDQ256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULHUW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULHUW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULHUW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULHUW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULHUW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULHUW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULHUWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULHUW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULHUWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULHUW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULHUWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULHUW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULHW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULHW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULHW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULHW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULHW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULHW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULHWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULHW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULHWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULHW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULHWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULHW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLD128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULLD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULLD256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULLD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULLD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULLD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULLD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULLD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULLD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLQ128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLQ256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLQ512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLQMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLQMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLQMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULLQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLW128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULLW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULLW256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULLW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULLW512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULLW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLWMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULLW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLWMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULLW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULLWMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPMULLW,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPMULUDQ128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULUDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPMULUDQ256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPMULUDQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPOPCNTB128",
		argLen: 1,
		asm:    x86.AVPOPCNTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTB256",
		argLen: 1,
		asm:    x86.AVPOPCNTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTB512",
		argLen: 1,
		asm:    x86.AVPOPCNTB,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTBMasked128",
		argLen: 2,
		asm:    x86.AVPOPCNTB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTBMasked256",
		argLen: 2,
		asm:    x86.AVPOPCNTB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTBMasked512",
		argLen: 2,
		asm:    x86.AVPOPCNTB,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTD128",
		argLen: 1,
		asm:    x86.AVPOPCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTD256",
		argLen: 1,
		asm:    x86.AVPOPCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTD512",
		argLen: 1,
		asm:    x86.AVPOPCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTDMasked128",
		argLen: 2,
		asm:    x86.AVPOPCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTDMasked256",
		argLen: 2,
		asm:    x86.AVPOPCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTDMasked512",
		argLen: 2,
		asm:    x86.AVPOPCNTD,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTQ128",
		argLen: 1,
		asm:    x86.AVPOPCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTQ256",
		argLen: 1,
		asm:    x86.AVPOPCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTQ512",
		argLen: 1,
		asm:    x86.AVPOPCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTQMasked128",
		argLen: 2,
		asm:    x86.AVPOPCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTQMasked256",
		argLen: 2,
		asm:    x86.AVPOPCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTQMasked512",
		argLen: 2,
		asm:    x86.AVPOPCNTQ,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTW128",
		argLen: 1,
		asm:    x86.AVPOPCNTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTW256",
		argLen: 1,
		asm:    x86.AVPOPCNTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTW512",
		argLen: 1,
		asm:    x86.AVPOPCNTW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTWMasked128",
		argLen: 2,
		asm:    x86.AVPOPCNTW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTWMasked256",
		argLen: 2,
		asm:    x86.AVPOPCNTW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPOPCNTWMasked512",
		argLen: 2,
		asm:    x86.AVPOPCNTW,
		reg: regInfo{
			inputs: []inputInfo{
				{1, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPOR128",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPOR,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPOR256",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPOR,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:        "VPORD512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPORD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPORDMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPORD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPORDMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPORD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPORDMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPORD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPORQ512",
		argLen:      2,
		commutative: true,
		asm:         x86.AVPORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPORQMasked128",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPORQMasked256",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:        "VPORQMasked512",
		argLen:      3,
		commutative: true,
		asm:         x86.AVPORQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVD128",
		argLen: 2,
		asm:    x86.AVPROLVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVD256",
		argLen: 2,
		asm:    x86.AVPROLVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVD512",
		argLen: 2,
		asm:    x86.AVPROLVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVDMasked128",
		argLen: 3,
		asm:    x86.AVPROLVD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVDMasked256",
		argLen: 3,
		asm:    x86.AVPROLVD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVDMasked512",
		argLen: 3,
		asm:    x86.AVPROLVD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVQ128",
		argLen: 2,
		asm:    x86.AVPROLVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVQ256",
		argLen: 2,
		asm:    x86.AVPROLVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVQ512",
		argLen: 2,
		asm:    x86.AVPROLVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVQMasked128",
		argLen: 3,
		asm:    x86.AVPROLVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVQMasked256",
		argLen: 3,
		asm:    x86.AVPROLVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPROLVQMasked512",
		argLen: 3,
		asm:    x86.AVPROLVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVD128",
		argLen: 2,
		asm:    x86.AVPRORVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVD256",
		argLen: 2,
		asm:    x86.AVPRORVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVD512",
		argLen: 2,
		asm:    x86.AVPRORVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVDMasked128",
		argLen: 3,
		asm:    x86.AVPRORVD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVDMasked256",
		argLen: 3,
		asm:    x86.AVPRORVD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVDMasked512",
		argLen: 3,
		asm:    x86.AVPRORVD,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVQ128",
		argLen: 2,
		asm:    x86.AVPRORVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVQ256",
		argLen: 2,
		asm:    x86.AVPRORVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVQ512",
		argLen: 2,
		asm:    x86.AVPRORVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVQMasked128",
		argLen: 3,
		asm:    x86.AVPRORVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVQMasked256",
		argLen: 3,
		asm:    x86.AVPRORVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPRORVQMasked512",
		argLen: 3,
		asm:    x86.AVPRORVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{2, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:   "VPSADBW128",
		argLen: 2,
		asm:    x86.AVPSADBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPSADBW256",
		argLen: 2,
		asm:    x86.AVPSADBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
				{1, 4294901760}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
			},
			outputs: []outputInfo{
				{0, 2147418112}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14
			},
		},
	},
	{
		name:   "VPSADBW512",
		argLen: 2,
		asm:    x86.AVPSADBW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVD128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHLDVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVD256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHLDVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVD512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHLDVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVDMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPSHLDVD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVDMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPSHLDVD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVDMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPSHLDVD,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVQ128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHLDVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVQ256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHLDVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVQ512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHLDVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVQMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPSHLDVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVQMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPSHLDVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVQMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPSHLDVQ,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVW128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHLDVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVW256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHLDVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVW512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHLDVW,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVWMasked128",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPSHLDVW,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVWMasked256",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPSHLDVW,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHLDVWMasked512",
		argLen:       4,
		resultInArg0: true,
		asm:          x86.AVPSHLDVW,
		reg: regInfo{
			inputs: []inputInfo{
				{3, 71494644084506624}, // K1 K2 K3 K4 K5 K6 K7
				{0, 281472829161472},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120},   // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHRDVD128",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHRDVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHRDVD256",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHRDVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
		},
	},
	{
		name:         "VPSHRDVD512",
		argLen:       3,
		resultInArg0: true,
		asm:          x86.AVPSHRDVD,
		reg: regInfo{
			inputs: []inputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{1, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
				{2, 281474976645120}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31
			},
			outputs: []outputInfo{
				{0, 281472829161472}, // X0 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 