/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class FlexAdapter
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(FlexAdapter.class);
    private final FlexLexer myFlex;
    private IElementType myTokenType;
    private CharSequence myText;
    private int myTokenStart;
    private int myTokenEnd;
    private int myBufferEnd;
    private int myState;
    private boolean myFailed;

    public FlexAdapter(@NotNull FlexLexer flex) {
        if (flex == null) {
            FlexAdapter.$$$reportNull$$$0(0);
        }
        this.myFlex = flex;
    }

    public FlexLexer getFlex() {
        return this.myFlex;
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            FlexAdapter.$$$reportNull$$$0(1);
        }
        this.myText = buffer;
        this.myTokenStart = this.myTokenEnd = startOffset;
        this.myBufferEnd = endOffset;
        this.myFlex.reset(this.myText, startOffset, endOffset, initialState);
        this.myTokenType = null;
    }

    @Override
    public int getState() {
        this.locateToken();
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    @Override
    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    @Override
    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            FlexAdapter.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    @Override
    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    protected void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this.myTokenStart = this.myTokenEnd;
        if (this.myFailed) {
            return;
        }
        try {
            this.myState = this.myFlex.yystate();
            this.myTokenType = this.myFlex.advance();
            this.myTokenEnd = this.myFlex.getTokenEnd();
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            this.myFailed = true;
            this.myTokenType = TokenType.BAD_CHARACTER;
            this.myTokenEnd = this.myBufferEnd;
            LOG.warn(this.myFlex.getClass().getName(), e3);
        }
    }

    public String toString() {
        return "FlexAdapter for " + this.myFlex.getClass().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/FlexAdapter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/FlexAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

