//----------------------------------------------------------------------------
//
//  TSDuck - The MPEG Transport Stream Toolkit
//  Copyright (c) 2005-2026, Thierry Lelegard
//  BSD-2-Clause license, see LICENSE.txt file or https://tsduck.io/license
//
//----------------------------------------------------------------------------
//
//   TSDuck core library global header (include all headers)
//
//----------------------------------------------------------------------------

#pragma once
#include "tsAbortInterface.h"
#include "tsAbstractNetworkAddress.h"
#include "tsAbstractNumber.h"
#include "tsAbstractOutputStream.h"
#include "tsAbstractReadStreamInterface.h"
#include "tsAbstractWriteStreamInterface.h"
#include "tsAES128.h"
#include "tsAES256.h"
#include "tsAlgorithm.h"
#include "tsApplicationSharedLibrary.h"
#include "tsArgMix.h"
#include "tsArgs.h"
#include "tsAsyncReport.h"
#include "tsAsyncReportArgs.h"
#include "tsBase64.h"
#include "tsBCD.h"
#include "tsBetterSystemRandomGenerator.h"
#include "tsBlockCipher.h"
#include "tsBlockCipherAlertInterface.h"
#include "tsBlockCipherProperties.h"
#include "tsBoolPredicate.h"
#include "tsBuffer.h"
#include "tsByteBlock.h"
#include "tsByteSwap.h"
#include "tsCBC.h"
#include "tsCerrReport.h"
#include "tsCOM.h"
#include "tsCommandLine.h"
#include "tsCommandLineHandler.h"
#include "tsCompactBitSet.h"
#include "tsConfigFile.h"
#include "tsConfigSection.h"
#include "tsConsoleState.h"
#include "tsCRC32.h"
#include "tsCryptoLibrary.h"
#include "tsCTR.h"
#include "tsCTS1.h"
#include "tsCTS2.h"
#include "tsCTS3.h"
#include "tsCTS4.h"
#include "tsDataBlock.h"
#include "tsDES.h"
#include "tsDisplayInterface.h"
#include "tsDuckConfigFile.h"
#include "tsECB.h"
#include "tsEditLine.h"
#include "tsEnumUtils.h"
#include "tsEnvironment.h"
#include "tsErrCodeReport.h"
#include "tsException.h"
#include "tsExpressions.h"
#include "tsFatal.h"
#include "tsFeatures.h"
#include "tsFileNameGenerator.h"
#include "tsFileTreeManager.h"
#include "tsFileUtils.h"
#include "tsFixedPoint.h"
#include "tsFloatingPoint.h"
#include "tsFloatUtils.h"
#include "tsForkPipe.h"
#include "tsFraction.h"
#include "tsFunctors.h"
#include "tsGitHubRelease.h"
#include "tsGrid.h"
#include "tsHash.h"
#include "tsInfluxArgs.h"
#include "tsInfluxRequest.h"
#include "tsInfluxSender.h"
#include "tsInputRedirector.h"
#include "tsInteger.h"
#include "tsIntegerMap.h"
#include "tsIntegerUtils.h"
#include "tsInterruptHandler.h"
#include "tsIP.h"
#include "tsIPAddress.h"
#include "tsIPAddressMask.h"
#include "tsIPArgs.h"
#include "tsIPPacket.h"
#include "tsIPProtocols.h"
#include "tsIPSocketAddress.h"
#include "tsIPUtils.h"
#include "tsjson.h"
#include "tsjsonArray.h"
#include "tsjsonFalse.h"
#include "tsjsonNull.h"
#include "tsjsonNumber.h"
#include "tsjsonObject.h"
#include "tsjsonOutputArgs.h"
#include "tsjsonRunningDocument.h"
#include "tsjsonString.h"
#include "tsjsonTrue.h"
#include "tsjsonValue.h"
#include "tsjsonYAML.h"
#include "tsKeyTable.h"
#include "tsLibTSCoreVersion.h"
#include "tsMACAddress.h"
#include "tsMain.h"
#include "tsMemory.h"
#include "tsMessagePriorityQueue.h"
#include "tsMessageQueue.h"
#include "tsNames.h"
#include "tsNetworkInterface.h"
#include "tsNullReport.h"
#include "tsObject.h"
#include "tsObjectRepository.h"
#include "tsOutputPager.h"
#include "tsOutputRedirector.h"
#include "tsPagerArgs.h"
#include "tsPcap.h"
#include "tsPcapFile.h"
#include "tsPcapFilter.h"
#include "tsPcapStream.h"
#include "tsPlatform.h"
#include "tsPolledFile.h"
#include "tsPollFiles.h"
#include "tsPollFilesListener.h"
#include "tsPreConfiguration.h"
#include "tsRandomGenerator.h"
#include "tsRegistry.h"
#include "tsReplacement.h"
#include "tsReport.h"
#include "tsReportBuffer.h"
#include "tsReportFile.h"
#include "tsResidentBuffer.h"
#include "tsRestArgs.h"
#include "tsRestClient.h"
#include "tsRestServer.h"
#include "tsRingNode.h"
#include "tsSeverity.h"
#include "tsSHA1.h"
#include "tsSHA256.h"
#include "tsSHA512.h"
#include "tsSharedLibrary.h"
#include "tsSingleDataStatistics.h"
#include "tsSocket.h"
#include "tsStringifyInterface.h"
#include "tsSysInfo.h"
#include "tsSystemMonitor.h"
#include "tsSystemRandomGenerator.h"
#include "tsSysUtils.h"
#include "tsTCPConnection.h"
#include "tsTCPServer.h"
#include "tsTCPSocket.h"
#include "tsTDES.h"
#include "tsTelnetConnection.h"
#include "tsTextFormatter.h"
#include "tsTextParser.h"
#include "tsTextTable.h"
#include "tsThread.h"
#include "tsThreadAttributes.h"
#include "tsTime.h"
#include "tsTLSArgs.h"
#include "tsTLSConnection.h"
#include "tsTLSServer.h"
#include "tstlv.h"
#include "tstlvAnalyzer.h"
#include "tstlvConnection.h"
#include "tstlvLogger.h"
#include "tstlvMessage.h"
#include "tstlvMessageFactory.h"
#include "tstlvProtocol.h"
#include "tstlvSerializer.h"
#include "tsTLVSyntax.h"
#include "tsUChar.h"
#include "tsUDPReceiver.h"
#include "tsUDPReceiverArgs.h"
#include "tsUDPReceiverArgsList.h"
#include "tsUDPSocket.h"
#include "tsUID.h"
#include "tsURL.h"
#include "tsUserInterrupt.h"
#include "tsUString.h"
#include "tsVersion.h"
#include "tsVersionInfo.h"
#include "tsWatchDog.h"
#include "tsWatchDogHandlerInterface.h"
#include "tsWebRequest.h"
#include "tsWebRequestArgs.h"
#include "tsxml.h"
#include "tsxmlAttribute.h"
#include "tsxmlComment.h"
#include "tsxmlDeclaration.h"
#include "tsxmlDocument.h"
#include "tsxmlElement.h"
#include "tsxmlJSONConverter.h"
#include "tsxmlModelDocument.h"
#include "tsxmlNode.h"
#include "tsxmlPatchDocument.h"
#include "tsxmlRunningDocument.h"
#include "tsxmlText.h"
#include "tsxmlTweaks.h"
#include "tsxmlUnknown.h"
#include "tsXoshiro256ss.h"
#include "tsZlib.h"

#if defined(TS_LINUX)
#include "tsOpenSSL.h"
#include "tsSignalAllocator.h"
#include "tsSysCtl.h"
#endif

#if defined(TS_MAC)
#include "tsMacPList.h"
#include "tsOpenSSL.h"
#include "tsSysCtl.h"
#endif

#if defined(TS_FREEBSD)
#include "tsOpenSSL.h"
#include "tsSysCtl.h"
#endif

#if defined(TS_NETBSD)
#include "tsOpenSSL.h"
#include "tsSysCtl.h"
#endif

#if defined(TS_OPENBSD)
#include "tsOpenSSL.h"
#include "tsSysCtl.h"
#endif

#if defined(TS_DRAGONFLYBSD)
#include "tsOpenSSL.h"
#include "tsSysCtl.h"
#endif

#if defined(TS_WINDOWS)
#include "tsComIds.h"
#include "tsComPtr.h"
#include "tsWinModuleInfo.h"
#include "tsWinTLS.h"
#include "tsWinUtils.h"
#endif
