//----------------------------------------------------------------------------
//
// TSDuck - The MPEG Transport Stream Toolkit
// Copyright (c) 2005-2026, Thierry Lelegard
// BSD-2-Clause license, see LICENSE.txt file or https://tsduck.io/license
//
//----------------------------------------------------------------------------
//!
//!  @file
//!  Representation of a smoothing_buffer_descriptor.
//!
//----------------------------------------------------------------------------

#pragma once
#include "tsAbstractDescriptor.h"

namespace ts {
    //!
    //! Representation of a smoothing_buffer_descriptor.
    //! @see ISO/IEC 13818-1, ITU-T Rec. H.222.0, 2.6.30.
    //! @ingroup libtsduck descriptor
    //!
    class TSDUCKDLL SmoothingBufferDescriptor : public AbstractDescriptor
    {
    public:
        // SmoothingBufferDescriptor public members:
        uint32_t sb_leak_rate = 0;  //!< 22 bits, smoothing buffer leak rate in units of 400 b/s.
        uint32_t sb_size = 0;       //!< 22 bits, smoothing buffer size in bytes.

        //!
        //! Default constructor.
        //!
        SmoothingBufferDescriptor();

        //!
        //! Constructor from a binary descriptor
        //! @param [in,out] duck TSDuck execution context.
        //! @param [in] bin A binary descriptor to deserialize.
        //!
        SmoothingBufferDescriptor(DuckContext& duck, const Descriptor& bin);

        // Inherited methods
        DeclareDisplayDescriptor();

    protected:
        // Inherited methods
        virtual void clearContent() override;
        virtual void serializePayload(PSIBuffer&) const override;
        virtual void deserializePayload(PSIBuffer&) override;
        virtual void buildXML(DuckContext&, xml::Element*) const override;
        virtual bool analyzeXML(DuckContext&, const xml::Element*) override;
    };
}
