## META-INFO

Meta-information is generally for OpenFOAM internal use only.

The format, content and meaning may be changed at anytime without
prior notice.
If any of these are changed, these are some of places that will need
to be updated accordingly:

  - bin/foamEtcFile
  - bin/tools/foamConfigurePaths
  - bin/tools/foamPackRelease
  - etc/openfoam
  - wmake/scripts/wmake-build-info

### api-info

This file and its contents are to be tracked by git.

- File content (api) generated by `wmake -build-info` from the
  `OPENFOAM` define in `wmake/rules/General/general`
- File content (patch) is manually generated content.


### build-info

This file is ***never*** to be tracked by git, but may be present in
shipped source archives.

- File content (branch, build) generated by `wmake -build-info` from
  git information and cached from previous wmake (api)


### Content types

#### api

Format: `date +%y%m`

- 4-digit year-month (YYMM) integer corresponding to the major
  release or in unusual cases an intermediate release.
  Example, `2106` for the June-2021 release.


#### patch

Format: `date +%y%m%d`

- 6-digit year-month-day (YYMMDD) integer corresponding to a patch-level
  for the given **released** API.
- The first release can have a patch value of `0` or `1` which
  indicates that it is unpatched or just released. Alternatively
  it can have a patch value corresponding to the release date.

The patch value is only meaningful together with the api value.
However, for *development* branches, the patch level should not be
ascribed too much meaning, but will often correspond to the last
merge with a *maintenance* (*eg*, `master`) branch.


### Flow of information

Changes in the build information must be reflected in information
available in the final binaries. Conversely, it is necessary for later
distributions to have a record of the same information.

| property  | source                    | saved      |
|-----------|---------------------------|------------|
| api       | wmake/rules               | api-info   |
| patch     | manual (api-info)         | build-info |
| branch    | git                       | build-info |
| build     | git                       | build-info |


The command `wmake -build-info -check` is used to determine if
the saved information needs synchronization. The command
`wmake -build-info -update` performs the synchronization.


### Notes

The saved information is split into two separate files.
The `api-info` file contains more permanent information,
whereas the `build-info` is more transient in nature.

----
2021-06-09
