/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines3;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereogroup;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandBackwardLong3
extends CommandMultilines3<ActivityDiagram3> {
    private static final IRegex END = new RegexConcat(new RegexLeaf(1, "TEXT", "(.*)"), new RegexLeaf(";"), RegexLeaf.spaceZeroOrMore(), Stereogroup.optionalStereogroup(), RegexLeaf.end());

    public CommandBackwardLong3() {
        super(CommandBackwardLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH, END);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandBackwardLong3.class.getName(), RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("backward"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "DATA", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(ActivityDiagram3 diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.removeEmptyColumns();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        RegexResult lineLast = this.getEndingPattern().matcher(lines.getLast().getString());
        Stereogroup stereogroup = Stereogroup.build(lineLast);
        Stereotype stereotype = stereogroup.buildStereotype();
        BoxStyle style = stereogroup.getBoxStyle();
        lines = lines.removeStartingAndEnding(line0.get("DATA", 0), 0);
        lines = lines.overrideLastLine(lineLast.get("TEXT", 0));
        LinkRendering in = LinkRendering.none();
        LinkRendering out = LinkRendering.none();
        return diagram.backward(lines.toDisplay(), style, in, out, stereotype);
    }
}

