/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

import net.sourceforge.plantuml.cli.Exit;

public class ExitStatus {
    public static final int OK = 0;
    public static final int ERROR_50_NO_FILE_FOUND = 50;
    public static final int ERROR_100_NO_DIAGRAM_FOUND = 100;
    public static final int ERROR_200_SOME_DIAGRAMS_HAVE_ERROR = 200;
    private volatile boolean hasFiles;
    private volatile boolean hasErrors;
    private volatile boolean hasBlocks;

    private static String formatExitCode(int code, String description) {
        return String.format("  %-4d %s", code, description);
    }

    public static void printExitCodes() {
        String[] all;
        for (String line : all = new String[]{ExitStatus.formatExitCode(0, "Success"), ExitStatus.formatExitCode(50, "No file found"), ExitStatus.formatExitCode(100, "No diagram found in file(s)"), ExitStatus.formatExitCode(200, "Some diagrams have syntax errors")}) {
            System.out.println(line);
        }
    }

    private ExitStatus() {
    }

    public static ExitStatus init() {
        return new ExitStatus();
    }

    public void goesHasFiles() {
        this.hasFiles = true;
    }

    public void goesHasBlocks() {
        this.hasBlocks = true;
    }

    public void goesHasErrors() {
        this.hasErrors = true;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean noDiagramFound() {
        return !this.hasBlocks;
    }

    private int getExitCode() {
        if (this.hasErrors) {
            return 200;
        }
        if (!this.hasFiles) {
            return 50;
        }
        if (!this.hasBlocks) {
            return 100;
        }
        return 0;
    }

    public void eventuallyExit() {
        int code = this.getExitCode();
        if (code != 0) {
            Exit.exit(code);
        }
    }
}

