/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.SName;

class USymbolCollections
extends USymbol {
    USymbolCollections() {
    }

    @Override
    public SName[] getSNames() {
        return new SName[]{SName.collections};
    }

    private void drawCollections(UGraphic ug, double width, double height, double shadowing, double roundCorner) {
        URectangle small = URectangle.build(width - this.getDeltaCollection(), height - this.getDeltaCollection()).rounded(roundCorner);
        small.setDeltaShadow(shadowing);
        ug.apply(new UTranslate(this.getDeltaCollection(), this.getDeltaCollection())).draw(small);
        small.setDeltaShadow(0.0);
        ug.apply(UTranslate.dy(0.0)).draw(small);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    private double getDeltaCollection() {
        return 4.0;
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolCollections.this.drawCollections(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolCollections.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                tb.drawU(ug.apply(new UTranslate(margin.getX1() - USymbolCollections.this.getDeltaCollection() / 2.0, margin.getY1() - USymbolCollections.this.getDeltaCollection() / 2.0)));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolCollections.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double posStereoY;
                double posStereoX;
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolCollections.this.drawCollections(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                if (stereoAlignment == HorizontalAlignment.RIGHT) {
                    posStereoX = width - dimStereo.getWidth() - USymbolCollections.this.getMargin().getX1() / 2.0;
                    posStereoY = USymbolCollections.this.getMargin().getY1() / 2.0;
                } else {
                    posStereoX = (width - dimStereo.getWidth()) / 2.0;
                    posStereoY = 2.0;
                }
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, posStereoY)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

