/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.dedication.DedicationCrypted;
import net.sourceforge.plantuml.dedication.DedicationSimple;
import net.sourceforge.plantuml.dedication.PSystemDedication;
import net.sourceforge.plantuml.dedication.TinyHashableString;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.log.Logme;

public class Dedications {
    private static final List<Dedication> all = new ArrayList<Dedication>();

    private static DedicationCrypted secret(int tiny, String sig, BigInteger pq) throws IOException {
        return new DedicationCrypted(Dedications.load(sig), tiny, sig, pq);
    }

    private static byte[] load(String name) throws IOException {
        InputStream tmp = PSystemDedication.class.getResourceAsStream(name + ".png");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copyInternal(tmp, baos, true);
        return baos.toByteArray();
    }

    private Dedications() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PortableImage get(String line) {
        if (line.length() <= 25) return null;
        TinyHashableString sentence = new TinyHashableString(line);
        Class<Dedications> clazz = Dedications.class;
        synchronized (Dedications.class) {
            for (Dedication dedication : all) {
                PortableImage image = dedication.getImage(sentence);
                if (image == null) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return image;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    static {
        try {
            all.add(new DedicationSimple(Dedications.load("dedication"), "Write your own dedication!"));
            all.add(new DedicationSimple(Dedications.load("linux_china"), "linux_china"));
            all.add(new DedicationSimple(Dedications.load("arkban"), "arkban"));
            all.add(new DedicationSimple(Dedications.load("boundaries"), "Boundaries allow discipline to create true strength"));
            all.add(new DedicationSimple(Dedications.load("dr_chet"), "Thank you, Dr. Chet. I wouldn't be where I am without you"));
            all.add(new DedicationSimple(Dedications.load("ben"), "Ben and Jen 2020"));
            all.add(new DedicationSimple(Dedications.load("baraye"), "baraye"));
            all.add(new DedicationSimple(Dedications.load("nothing"), "Nothing of value is ever easy"));
            all.add(new DedicationSimple(Dedications.load("friends"), "Have good friends and be a good friend to other people"));
            all.add(new DedicationSimple(Dedications.load("fatherson"), "By the time a man realizes that maybe his father was right, he usually has a son who thinks he is wrong"));
            all.add(Dedications.secret(5, "835ff5d643b58cd35a20db6480071d05751aa6a0e01da78662ceafd0161f3f5e", new BigInteger("1182423723677118831606503500858825217076578422970565964857326298418401529955036896808663335300684244453386039908536275400945824932191521017102701344437753036730900076162922741167523337650578479960119614237031234925702200473053235777")));
            all.add(Dedications.secret(3, "514816d583044efbd336882227deb822194ff63e3bdc3cf707a01f17770d5a6a", new BigInteger("538955952645999836068094511687012232127213955837942782605199622268460518023083462090291844640318324475656060087513198129259364840841077651829017347845508167869708224054456044836844382437974410757740941102771969965334031780041648873")));
            all.add(Dedications.secret(1, "ae8a7cf3997ccd6418866fc59e596502e1bd1c0265bba2fc380ad7f51c76518f", new BigInteger("987988542836850639056829173787067531749177506648884857100630852970876999799588072360773169026225182488073794585127241896588994816566037813451743416913613428321215803586563629080034406083114565732322220091545330060636171674602040157")));
        }
        catch (Throwable t) {
            Logme.error(t);
        }
    }
}

