/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.klimt.UMotif;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.g2d.UGraphicG2d;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.png.PngIO;

public class GraphicsPath {
    private final String path;
    private final ColorMapper colorMapper;

    public GraphicsPath(ColorMapper colorMapper, String path) {
        this.path = path;
        this.colorMapper = colorMapper;
    }

    public ImageData writeImage(OutputStream os) throws IOException {
        PortableImage im = this.createImage();
        PngIO.write(im, this.colorMapper, os, null, 96);
        return new ImageDataSimple(im.getWidth(), im.getHeight());
    }

    private PortableImage createImage() {
        StringBounder stringBounder = FileFormat.PNG.getDefaultStringBounder();
        EmptyImageBuilder builder = new EmptyImageBuilder(null, 50, 50, XColor.WHITE, stringBounder);
        PortableImage im = builder.getPortableImage();
        Graphics2D g2d = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(HColors.WHITE, this.colorMapper, stringBounder, g2d, 1.0, FileFormat.PNG);
        ug.setPortableImage(im);
        UMotif motif = new UMotif(this.path);
        motif.drawHorizontal(ug.apply(HColors.BLACK), 20.0, 20.0, 1);
        g2d.dispose();
        return im;
    }
}

