/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.emoji.SvgNanoParser;
import net.sourceforge.plantuml.emoji.data.Dummy;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.teavm.TeaVM;
import net.sourceforge.plantuml.teavm.browser.TeaVmScriptLoader;
import org.teavm.jso.JSBody;

public class Emoji {
    private static final Map<String, Emoji> ALL;
    private SvgNanoParser nano;
    private final String unicode;
    private final String shortcut;
    private static volatile boolean emojiJsLoaded;

    public static Map<String, Emoji> getAll() {
        return Collections.unmodifiableMap(new TreeMap<String, Emoji>(ALL));
    }

    private Emoji(String unicode) {
        int x = unicode.indexOf(59);
        if (x == -1) {
            this.shortcut = null;
        } else {
            this.shortcut = unicode.substring(x + 1);
            if (!TeaVM.isTeaVM()) {
                ALL.put(this.shortcut, this);
            }
            unicode = unicode.substring(0, x);
        }
        this.unicode = unicode;
        if (!TeaVM.isTeaVM()) {
            ALL.put(unicode, this);
        }
    }

    public static Emoji retrieve(String name) {
        if (TeaVM.isTeaVM()) {
            return Emoji.retrieveFromJs(name.toLowerCase());
        }
        return ALL.get(name.toLowerCase());
    }

    private static Emoji retrieveFromJs(String name) {
        String svgData;
        Emoji.loadEmojiJsIfNeeded();
        String unicode = Emoji.jsGetShortcut(name);
        if (unicode == null) {
            unicode = name;
        }
        if ((svgData = Emoji.jsGetEmojiSvg(unicode)) == null) {
            return null;
        }
        return new Emoji(unicode);
    }

    private static void loadEmojiJsIfNeeded() {
        if (emojiJsLoaded) {
            return;
        }
        TeaVmScriptLoader.loadOnceSync("emoji.js");
        emojiJsLoaded = true;
    }

    @JSBody(params={"name"}, script="var s = window.PLANTUML_EMOJI_SHORTCUT;return (s && s[name]) ? s[name] : null;")
    private static native String jsGetShortcut(String var0);

    @JSBody(params={"unicode"}, script="var e = window.PLANTUML_EMOJI;return (e && e[unicode]) ? e[unicode] : null;")
    private static native String jsGetEmojiSvg(String var0);

    private synchronized void loadIfNeed() throws IOException {
        if (this.nano != null) {
            return;
        }
        ArrayList<String> data = new ArrayList<String>();
        if (TeaVM.isTeaVM()) {
            String svgData = Emoji.jsGetEmojiSvg(this.unicode);
            if (svgData != null) {
                data.add(svgData);
            }
        } else {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(Dummy.class.getResourceAsStream(this.unicode + ".svg")));){
                String singleLine = br.readLine();
                data.add(singleLine);
            }
        }
        this.nano = new SvgNanoParser(data);
    }

    public void drawU(UGraphic ug, double scale, HColor colorForMonochrome) {
        try {
            this.loadIfNeed();
        }
        catch (IOException e) {
            Logme.error(e);
        }
        this.nano.drawU(ug, scale, colorForMonochrome, colorForMonochrome);
    }

    public String getShortcut() {
        return this.shortcut;
    }

    static {
        InputStream is;
        ALL = new HashMap<String, Emoji>();
        if (!TeaVM.isTeaVM() && (is = Dummy.class.getResourceAsStream("emoji.txt")) != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String s = null;
                while ((s = br.readLine()) != null) {
                    new Emoji(s);
                }
            }
            catch (IOException e) {
                Logme.error(e);
            }
        }
        emojiJsLoaded = false;
    }
}

