/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flashcode;

import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImageFactory;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.utils.Log;
import zext.plantuml.com.google.zxing.BarcodeFormat;
import zext.plantuml.com.google.zxing.EncodeHintType;
import zext.plantuml.com.google.zxing.client.j2se.MatrixToImageWriter;
import zext.plantuml.com.google.zxing.common.BitMatrix;
import zext.plantuml.com.google.zxing.qrcode.QRCodeWriter;
import zext.plantuml.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

public class FlashCodeUtilsZxing
implements FlashCodeUtils {
    private static final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortableImage exportFlashcode(String s, XColor fore, XColor back) {
        if (lock.tryLock()) {
            try {
                QRCodeWriter writer = new QRCodeWriter();
                Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                hints.put(EncodeHintType.CHARACTER_SET, "UTF8");
                boolean multiple = true;
                BitMatrix bit = writer.encode(s, BarcodeFormat.QR_CODE, 1, hints);
                PortableImage portableImage = PortableImageFactory.build(MatrixToImageWriter.toBufferedImage(bit, fore.getRGB() | 0xFF000000, back.getRGB() | 0xFF000000));
                return portableImage;
            }
            catch (Exception e) {
                Log.debug(() -> "Cannot create qrcode " + String.valueOf(e));
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }
}

