/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.fun;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImageFactory;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SImageIO;

public class IconLoader {
    private static final int NUMBER_OF_ICONS = 31;
    private static final Map<String, PortableImage> all = new ConcurrentHashMap<String, PortableImage>();
    private static final List<String> tmp = new ArrayList<String>();

    public static PortableImage getRandom() {
        return IconLoader.addTransparent(IconLoader.getIcon(IconLoader.getSomeQuote()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSomeQuote() {
        List<String> list = tmp;
        synchronized (list) {
            if (tmp.size() == 0) {
                for (int i = 0; i < 31; ++i) {
                    tmp.add("sprite" + String.format("%03d", i) + ".png");
                }
                Collections.shuffle(tmp);
            }
            int size = tmp.size();
            String result = tmp.get(size - 1);
            tmp.remove(size - 1);
            return result;
        }
    }

    private static PortableImage getIcon(String name) {
        PortableImage result = all.get(name);
        if (result == null && (result = IconLoader.getIconSlow(name)) != null) {
            all.put(name, result);
        }
        return result;
    }

    private static PortableImage getIconSlow(String name) {
        try {
            InputStream is = IconLoader.class.getResourceAsStream(name);
            if (is == null) {
                return null;
            }
            PortableImage image = SImageIO.read(is);
            is.close();
            return image;
        }
        catch (IOException e) {
            Logme.error(e);
            return null;
        }
    }

    private static PortableImage addTransparent(PortableImage ico) {
        if (ico == null) {
            return null;
        }
        PortableImage transparentIcon = PortableImageFactory.build(ico.getWidth(), ico.getHeight(), 3);
        for (int i = 0; i < ico.getWidth(); ++i) {
            for (int j = 0; j < ico.getHeight(); ++j) {
                int col = ico.getRGB(i, j);
                if (col == ico.getRGB(0, 0)) continue;
                transparentIcon.setRGB(i, j, col);
            }
        }
        return transparentIcon;
    }
}

