/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.awt;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import org.teavm.jso.JSBody;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.canvas.ImageData;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.typedarrays.Uint8ClampedArray;

class PortableImageTeaVM
implements PortableImage {
    private final int width;
    private final int height;
    private final int imageType;
    private final int[] pixels;

    PortableImageTeaVM(int width, int height, int imageType) {
        this.width = width;
        this.height = height;
        this.imageType = imageType;
        this.pixels = new int[width * height];
        if (imageType == 1) {
            Arrays.fill(this.pixels, -1);
        } else {
            Arrays.fill(this.pixels, 0);
        }
    }

    PortableImageTeaVM(int width, int height, int imageType, int[] sourcePixels) {
        this.width = width;
        this.height = height;
        this.imageType = imageType;
        this.pixels = new int[width * height];
        System.arraycopy(sourcePixels, 0, this.pixels, 0, Math.min(sourcePixels.length, this.pixels.length));
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getRGB(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return 0;
        }
        return this.pixels[y * this.width + x];
    }

    @Override
    public void setRGB(int x, int y, int rgb) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        this.pixels[y * this.width + x] = rgb;
    }

    public int getType() {
        return this.imageType;
    }

    @Override
    public PortableImage getSubimage(int x, int y, int w, int h) {
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (x + w > this.width) {
            w = this.width - x;
        }
        if (y + h > this.height) {
            h = this.height - y;
        }
        if (w <= 0 || h <= 0) {
            return new PortableImageTeaVM(1, 1, this.imageType);
        }
        int[] subPixels = new int[w * h];
        for (int row = 0; row < h; ++row) {
            int srcOffset = (y + row) * this.width + x;
            int dstOffset = row * w;
            System.arraycopy(this.pixels, srcOffset, subPixels, dstOffset, w);
        }
        return new PortableImageTeaVM(w, h, this.imageType, subPixels);
    }

    @Override
    public int getTransparency() {
        return this.imageType == 1 ? 1 : 3;
    }

    public int[] getPixels() {
        int[] copy = new int[this.pixels.length];
        System.arraycopy(this.pixels, 0, copy, 0, this.pixels.length);
        return copy;
    }

    @Override
    public String toPngDataUrl() {
        HTMLDocument doc = HTMLDocument.current();
        HTMLCanvasElement canvas = (HTMLCanvasElement)doc.createElement("canvas");
        canvas.setWidth(this.width);
        canvas.setHeight(this.height);
        CanvasRenderingContext2D ctx = (CanvasRenderingContext2D)canvas.getContext("2d");
        ImageData imageData = ctx.createImageData((double)this.width, (double)this.height);
        Uint8ClampedArray data = imageData.getData();
        int p = 0;
        for (int i = 0; i < this.pixels.length; ++i) {
            int c = this.pixels[i];
            int a = c >>> 24 & 0xFF;
            int r = c >>> 16 & 0xFF;
            int g = c >>> 8 & 0xFF;
            int b = c & 0xFF;
            data.set(p++, r);
            data.set(p++, g);
            data.set(p++, b);
            data.set(p++, a);
        }
        ctx.putImageData(imageData, 0.0, 0.0);
        return PortableImageTeaVM.canvasToDataUrl(canvas);
    }

    @JSBody(params={"canvas"}, script="return canvas.toDataURL('image/png');")
    private static native String canvasToDataUrl(HTMLCanvasElement var0);

    @Override
    public PortableImage scale(double scaleFactor, int interpolationType) {
        int dstW = (int)Math.round((double)this.width * scaleFactor);
        int dstH = (int)Math.round((double)this.height * scaleFactor);
        if (dstW <= 0 || dstH <= 0) {
            return new PortableImageTeaVM(1, 1, this.imageType);
        }
        int[] dstPixels = new int[dstW * dstH];
        if (interpolationType == 2) {
            PortableImageTeaVM.scaleBilinear(this.pixels, this.width, this.height, dstPixels, dstW, dstH);
        } else {
            PortableImageTeaVM.scaleNearestNeighbor(this.pixels, this.width, this.height, dstPixels, dstW, dstH);
        }
        return new PortableImageTeaVM(dstW, dstH, this.imageType, dstPixels);
    }

    private static void scaleNearestNeighbor(int[] src, int srcW, int srcH, int[] dst, int dstW, int dstH) {
        for (int y = 0; y < dstH; ++y) {
            int srcY = y * srcH / dstH;
            for (int x = 0; x < dstW; ++x) {
                int srcX = x * srcW / dstW;
                dst[y * dstW + x] = src[srcY * srcW + srcX];
            }
        }
    }

    private static void scaleBilinear(int[] src, int srcW, int srcH, int[] dst, int dstW, int dstH) {
        double xRatio = (double)(srcW - 1) / (double)dstW;
        double yRatio = (double)(srcH - 1) / (double)dstH;
        for (int y = 0; y < dstH; ++y) {
            double srcYf = (double)y * yRatio;
            int y0 = (int)srcYf;
            int y1 = Math.min(y0 + 1, srcH - 1);
            double yFrac = srcYf - (double)y0;
            for (int x = 0; x < dstW; ++x) {
                double srcXf = (double)x * xRatio;
                int x0 = (int)srcXf;
                int x1 = Math.min(x0 + 1, srcW - 1);
                double xFrac = srcXf - (double)x0;
                int c00 = src[y0 * srcW + x0];
                int c10 = src[y0 * srcW + x1];
                int c01 = src[y1 * srcW + x0];
                int c11 = src[y1 * srcW + x1];
                int a = PortableImageTeaVM.interpolateChannel(c00, c10, c01, c11, xFrac, yFrac, 24);
                int r = PortableImageTeaVM.interpolateChannel(c00, c10, c01, c11, xFrac, yFrac, 16);
                int g = PortableImageTeaVM.interpolateChannel(c00, c10, c01, c11, xFrac, yFrac, 8);
                int b = PortableImageTeaVM.interpolateChannel(c00, c10, c01, c11, xFrac, yFrac, 0);
                dst[y * dstW + x] = a << 24 | r << 16 | g << 8 | b;
            }
        }
    }

    private static int interpolateChannel(int c00, int c10, int c01, int c11, double xFrac, double yFrac, int shift) {
        int v00 = c00 >> shift & 0xFF;
        int v10 = c10 >> shift & 0xFF;
        int v01 = c01 >> shift & 0xFF;
        int v11 = c11 >> shift & 0xFF;
        double top = (double)v00 + xFrac * (double)(v10 - v00);
        double bottom = (double)v01 + xFrac * (double)(v11 - v01);
        double result = top + yFrac * (bottom - top);
        return Math.min(255, Math.max(0, (int)Math.round(result)));
    }

    @Override
    public BufferedImage getBufferedImage() {
        throw new UnsupportedOperationException("TEAVM9834");
    }

    @Override
    public Graphics2D createGraphics() {
        throw new UnsupportedOperationException("TEAVM9834");
    }

    @Override
    public Graphics getGraphics() {
        throw new UnsupportedOperationException("TEAVM9834");
    }
}

