/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.awt;

import java.awt.Color;

public class XColor {
    public static final XColor BLACK = new XColor(0, 0, 0);
    public static final XColor WHITE = new XColor(255, 255, 255);
    public static final XColor RED = new XColor(255, 0, 0);
    public static final XColor BLUE = new XColor(0, 0, 255);
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    public XColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public XColor(int r, int g, int b, int a) {
        this.red = r & 0xFF;
        this.green = g & 0xFF;
        this.blue = b & 0xFF;
        this.alpha = a & 0xFF;
    }

    public static XColor from(int rgb) {
        int alpha = 255;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return new XColor(red, green, blue, 255);
    }

    public static XColor fromFloat(float r, float g, float b, float a) {
        if (!Float.isFinite(r) || !Float.isFinite(g) || !Float.isFinite(b) || !Float.isFinite(a) || r < 0.0f || r > 1.0f || g < 0.0f || g > 1.0f || b < 0.0f || b > 1.0f || a < 0.0f || a > 1.0f) {
            throw new IllegalArgumentException();
        }
        int red = Math.round(r * 255.0f) & 0xFF;
        int green = Math.round(g * 255.0f) & 0xFF;
        int blue = Math.round(b * 255.0f) & 0xFF;
        int alpha = Math.round(a * 255.0f) & 0xFF;
        return new XColor(red, green, blue, alpha);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getRed() {
        return this.red;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    public int getRGB() {
        return (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public float[] getRGBColorComponents(Object object) {
        float[] result = object == null ? new float[3] : (float[])object;
        result[0] = (float)this.red / 255.0f;
        result[1] = (float)this.green / 255.0f;
        result[2] = (float)this.blue / 255.0f;
        return result;
    }

    public Color toAwtColor() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    public int hashCode() {
        return this.getRGB();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        XColor other = (XColor)obj;
        return this.red == other.red && this.green == other.green && this.blue == other.blue && this.alpha == other.alpha;
    }

    public String toString() {
        return "[r=" + this.red + ",g=" + this.green + ",b=" + this.blue + ",a=" + this.alpha + "]";
    }

    public String toSvg() {
        if (this.alpha == 0) {
            return "#00000000";
        }
        if (this.alpha == 255) {
            return String.format("#%02X%02X%02X", this.red, this.green, this.blue);
        }
        return String.format("#%02X%02X%02X%02X", this.red, this.green, this.blue, this.alpha);
    }

    public static String toHexRGBColor(int rgb) {
        return String.format("#%06X", rgb & 0xFFFFFF);
    }
}

