/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.color;

import net.sourceforge.plantuml.klimt.awt.XColor;

public enum ColorOrder {
    RGB,
    RBG,
    GRB,
    GBR,
    BRG,
    BGR;


    public XColor getColor(XColor color) {
        if (this == RGB) {
            return new XColor(color.getRed(), color.getGreen(), color.getBlue());
        }
        if (this == RBG) {
            return new XColor(color.getRed(), color.getBlue(), color.getGreen());
        }
        if (this == GRB) {
            return new XColor(color.getGreen(), color.getRed(), color.getBlue());
        }
        if (this == GBR) {
            return new XColor(color.getGreen(), color.getBlue(), color.getRed());
        }
        if (this == BRG) {
            return new XColor(color.getBlue(), color.getRed(), color.getGreen());
        }
        if (this == BGR) {
            return new XColor(color.getBlue(), color.getGreen(), color.getRed());
        }
        throw new IllegalStateException();
    }

    public XColor getReverse(XColor color) {
        color = this.getColor(color);
        return new XColor(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static ColorOrder fromString(String order) {
        try {
            return ColorOrder.valueOf(order.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }
}

