/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.color;

import java.util.Collection;
import java.util.TreeSet;
import net.sourceforge.plantuml.klimt.awt.XColor;

public class ColorTrieNode {
    private final ColorTrieNode[] children = new ColorTrieNode[26];
    private XColor value;
    public static final ColorTrieNode INSTANCE = new ColorTrieNode();
    public static final Collection<String> NAMES = new TreeSet<String>();

    private ColorTrieNode child(char k, boolean create) {
        int idx = (k | 0x20) - 97;
        if (idx < 0 || idx >= 26) {
            return null;
        }
        ColorTrieNode c = this.children[idx];
        if (c == null && create) {
            this.children[idx] = c = new ColorTrieNode();
        }
        return c;
    }

    private static void register(String name, XColor color) {
        NAMES.add(name);
        INSTANCE.putColor(name, color);
    }

    public void putColor(CharSequence name, XColor color) {
        ColorTrieNode n = this;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            if ((n = n.child(name.charAt(i), true)) != null) continue;
            return;
        }
        n.value = color;
    }

    public XColor getColor(CharSequence name) {
        ColorTrieNode n = this;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            if ((n = n.child(name.charAt(i), false)) != null) continue;
            return null;
        }
        return n.value;
    }

    static {
        ColorTrieNode.register("AliceBlue", XColor.from(0xF0F8FF));
        ColorTrieNode.register("AntiqueWhite", XColor.from(16444375));
        ColorTrieNode.register("Aqua", XColor.from(65535));
        ColorTrieNode.register("Aquamarine", XColor.from(8388564));
        ColorTrieNode.register("Azure", XColor.from(0xF0FFFF));
        ColorTrieNode.register("Beige", XColor.from(16119260));
        ColorTrieNode.register("Bisque", XColor.from(16770244));
        ColorTrieNode.register("Black", XColor.from(0));
        ColorTrieNode.register("BlanchedAlmond", XColor.from(16772045));
        ColorTrieNode.register("Blue", XColor.from(255));
        ColorTrieNode.register("BlueViolet", XColor.from(9055202));
        ColorTrieNode.register("Brown", XColor.from(0xA52A2A));
        ColorTrieNode.register("BurlyWood", XColor.from(14596231));
        ColorTrieNode.register("CadetBlue", XColor.from(6266528));
        ColorTrieNode.register("Chartreuse", XColor.from(0x7FFF00));
        ColorTrieNode.register("Chocolate", XColor.from(13789470));
        ColorTrieNode.register("Coral", XColor.from(16744272));
        ColorTrieNode.register("CornflowerBlue", XColor.from(6591981));
        ColorTrieNode.register("Cornsilk", XColor.from(16775388));
        ColorTrieNode.register("Crimson", XColor.from(14423100));
        ColorTrieNode.register("Cyan", XColor.from(65535));
        ColorTrieNode.register("DarkBlue", XColor.from(139));
        ColorTrieNode.register("DarkCyan", XColor.from(35723));
        ColorTrieNode.register("DarkGoldenRod", XColor.from(12092939));
        ColorTrieNode.register("DarkGray", XColor.from(0xA9A9A9));
        ColorTrieNode.register("DarkGrey", XColor.from(0xA9A9A9));
        ColorTrieNode.register("DarkGreen", XColor.from(25600));
        ColorTrieNode.register("DarkKhaki", XColor.from(12433259));
        ColorTrieNode.register("DarkMagenta", XColor.from(0x8B008B));
        ColorTrieNode.register("DarkOliveGreen", XColor.from(5597999));
        ColorTrieNode.register("Darkorange", XColor.from(16747520));
        ColorTrieNode.register("DarkOrchid", XColor.from(10040012));
        ColorTrieNode.register("DarkRed", XColor.from(0x8B0000));
        ColorTrieNode.register("DarkSalmon", XColor.from(15308410));
        ColorTrieNode.register("DarkSeaGreen", XColor.from(9419919));
        ColorTrieNode.register("DarkSlateBlue", XColor.from(4734347));
        ColorTrieNode.register("DarkSlateGray", XColor.from(0x2F4F4F));
        ColorTrieNode.register("DarkSlateGrey", XColor.from(0x2F4F4F));
        ColorTrieNode.register("DarkTurquoise", XColor.from(52945));
        ColorTrieNode.register("DarkViolet", XColor.from(9699539));
        ColorTrieNode.register("DeepPink", XColor.from(16716947));
        ColorTrieNode.register("DeepSkyBlue", XColor.from(49151));
        ColorTrieNode.register("DimGray", XColor.from(0x696969));
        ColorTrieNode.register("DimGrey", XColor.from(0x696969));
        ColorTrieNode.register("DodgerBlue", XColor.from(2003199));
        ColorTrieNode.register("FireBrick", XColor.from(0xB22222));
        ColorTrieNode.register("FloralWhite", XColor.from(0xFFFAF0));
        ColorTrieNode.register("ForestGreen", XColor.from(0x228B22));
        ColorTrieNode.register("Fuchsia", XColor.from(0xFF00FF));
        ColorTrieNode.register("Gainsboro", XColor.from(0xDCDCDC));
        ColorTrieNode.register("GhostWhite", XColor.from(0xF8F8FF));
        ColorTrieNode.register("Gold", XColor.from(16766720));
        ColorTrieNode.register("GoldenRod", XColor.from(14329120));
        ColorTrieNode.register("Gray", XColor.from(0x808080));
        ColorTrieNode.register("Grey", XColor.from(0x808080));
        ColorTrieNode.register("Green", XColor.from(32768));
        ColorTrieNode.register("GreenYellow", XColor.from(11403055));
        ColorTrieNode.register("HoneyDew", XColor.from(0xF0FFF0));
        ColorTrieNode.register("HotPink", XColor.from(16738740));
        ColorTrieNode.register("IndianRed", XColor.from(0xCD5C5C));
        ColorTrieNode.register("Indigo", XColor.from(4915330));
        ColorTrieNode.register("Ivory", XColor.from(0xFFFFF0));
        ColorTrieNode.register("Khaki", XColor.from(15787660));
        ColorTrieNode.register("Lavender", XColor.from(15132410));
        ColorTrieNode.register("LavenderBlush", XColor.from(0xFFF0F5));
        ColorTrieNode.register("LawnGreen", XColor.from(8190976));
        ColorTrieNode.register("LemonChiffon", XColor.from(16775885));
        ColorTrieNode.register("LightBlue", XColor.from(11393254));
        ColorTrieNode.register("LightCoral", XColor.from(0xF08080));
        ColorTrieNode.register("LightCyan", XColor.from(0xE0FFFF));
        ColorTrieNode.register("LightGoldenRodYellow", XColor.from(16448210));
        ColorTrieNode.register("LightGray", XColor.from(0xD3D3D3));
        ColorTrieNode.register("LightGrey", XColor.from(0xD3D3D3));
        ColorTrieNode.register("LightGreen", XColor.from(0x90EE90));
        ColorTrieNode.register("LightPink", XColor.from(16758465));
        ColorTrieNode.register("LightSalmon", XColor.from(16752762));
        ColorTrieNode.register("LightSeaGreen", XColor.from(2142890));
        ColorTrieNode.register("LightSkyBlue", XColor.from(8900346));
        ColorTrieNode.register("LightSlateGray", XColor.from(0x778899));
        ColorTrieNode.register("LightSlateGrey", XColor.from(0x778899));
        ColorTrieNode.register("LightSteelBlue", XColor.from(11584734));
        ColorTrieNode.register("LightYellow", XColor.from(0xFFFFE0));
        ColorTrieNode.register("Lime", XColor.from(65280));
        ColorTrieNode.register("LimeGreen", XColor.from(3329330));
        ColorTrieNode.register("Linen", XColor.from(16445670));
        ColorTrieNode.register("Magenta", XColor.from(0xFF00FF));
        ColorTrieNode.register("Maroon", XColor.from(0x800000));
        ColorTrieNode.register("MediumAquaMarine", XColor.from(6737322));
        ColorTrieNode.register("MediumBlue", XColor.from(205));
        ColorTrieNode.register("MediumOrchid", XColor.from(12211667));
        ColorTrieNode.register("MediumPurple", XColor.from(9662680));
        ColorTrieNode.register("MediumSeaGreen", XColor.from(3978097));
        ColorTrieNode.register("MediumSlateBlue", XColor.from(8087790));
        ColorTrieNode.register("MediumSpringGreen", XColor.from(64154));
        ColorTrieNode.register("MediumTurquoise", XColor.from(4772300));
        ColorTrieNode.register("MediumVioletRed", XColor.from(13047173));
        ColorTrieNode.register("MidnightBlue", XColor.from(1644912));
        ColorTrieNode.register("MintCream", XColor.from(0xF5FFFA));
        ColorTrieNode.register("MistyRose", XColor.from(16770273));
        ColorTrieNode.register("Moccasin", XColor.from(16770229));
        ColorTrieNode.register("NavajoWhite", XColor.from(16768685));
        ColorTrieNode.register("Navy", XColor.from(128));
        ColorTrieNode.register("OldLace", XColor.from(16643558));
        ColorTrieNode.register("Olive", XColor.from(0x808000));
        ColorTrieNode.register("OliveDrab", XColor.from(7048739));
        ColorTrieNode.register("Orange", XColor.from(16753920));
        ColorTrieNode.register("OrangeRed", XColor.from(16729344));
        ColorTrieNode.register("Orchid", XColor.from(14315734));
        ColorTrieNode.register("PaleGoldenRod", XColor.from(0xEEE8AA));
        ColorTrieNode.register("PaleGreen", XColor.from(10025880));
        ColorTrieNode.register("PaleTurquoise", XColor.from(0xAFEEEE));
        ColorTrieNode.register("PaleVioletRed", XColor.from(14184595));
        ColorTrieNode.register("PapayaWhip", XColor.from(16773077));
        ColorTrieNode.register("PeachPuff", XColor.from(16767673));
        ColorTrieNode.register("Peru", XColor.from(13468991));
        ColorTrieNode.register("Pink", XColor.from(16761035));
        ColorTrieNode.register("Plum", XColor.from(0xDDA0DD));
        ColorTrieNode.register("PowderBlue", XColor.from(11591910));
        ColorTrieNode.register("Purple", XColor.from(0x800080));
        ColorTrieNode.register("Red", XColor.from(0xFF0000));
        ColorTrieNode.register("RosyBrown", XColor.from(12357519));
        ColorTrieNode.register("RoyalBlue", XColor.from(4286945));
        ColorTrieNode.register("SaddleBrown", XColor.from(9127187));
        ColorTrieNode.register("Salmon", XColor.from(16416882));
        ColorTrieNode.register("SandyBrown", XColor.from(16032864));
        ColorTrieNode.register("SeaGreen", XColor.from(3050327));
        ColorTrieNode.register("SeaShell", XColor.from(0xFFF5EE));
        ColorTrieNode.register("Sienna", XColor.from(10506797));
        ColorTrieNode.register("Silver", XColor.from(0xC0C0C0));
        ColorTrieNode.register("SkyBlue", XColor.from(8900331));
        ColorTrieNode.register("SlateBlue", XColor.from(6970061));
        ColorTrieNode.register("SlateGray", XColor.from(7372944));
        ColorTrieNode.register("SlateGrey", XColor.from(7372944));
        ColorTrieNode.register("Snow", XColor.from(0xFFFAFA));
        ColorTrieNode.register("SpringGreen", XColor.from(65407));
        ColorTrieNode.register("SteelBlue", XColor.from(4620980));
        ColorTrieNode.register("Tan", XColor.from(13808780));
        ColorTrieNode.register("Teal", XColor.from(32896));
        ColorTrieNode.register("Thistle", XColor.from(14204888));
        ColorTrieNode.register("Tomato", XColor.from(16737095));
        ColorTrieNode.register("Turquoise", XColor.from(4251856));
        ColorTrieNode.register("Violet", XColor.from(0xEE82EE));
        ColorTrieNode.register("Wheat", XColor.from(16113331));
        ColorTrieNode.register("White", XColor.from(0xFFFFFF));
        ColorTrieNode.register("WhiteSmoke", XColor.from(0xF5F5F5));
        ColorTrieNode.register("Yellow", XColor.from(0xFFFF00));
        ColorTrieNode.register("YellowGreen", XColor.from(10145074));
        ColorTrieNode.register("BUSINESS", XColor.from(0xFFFFCC));
        ColorTrieNode.register("APPLICATION", XColor.from(12775679));
        ColorTrieNode.register("MOTIVATION", XColor.from(0xCCCCFF));
        ColorTrieNode.register("STRATEGY", XColor.from(16312256));
        ColorTrieNode.register("TECHNOLOGY", XColor.from(0xC9FFC9));
        ColorTrieNode.register("PHYSICAL", XColor.from(0x97FF97));
        ColorTrieNode.register("IMPLEMENTATION", XColor.from(0xFFE0E0));
    }
}

