/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.color;

import java.util.Objects;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.teavm.TeaVM;

public class HColorGradient
extends HColor {
    private final HColor color1;
    private final HColor color2;
    private final char policy;

    HColorGradient(HColor color1arg, HColor color2arg, char policy) {
        if (color1arg instanceof HColorGradient) {
            color1arg = ((HColorGradient)color1arg).color1;
        }
        if (color2arg instanceof HColorGradient) {
            color2arg = ((HColorGradient)color2arg).color2;
        }
        this.color1 = Objects.requireNonNull(color1arg);
        this.color2 = Objects.requireNonNull(color2arg);
        this.policy = policy;
    }

    public final HColor getColor1() {
        return this.color1;
    }

    public final HColor getColor2() {
        return this.color2;
    }

    public final XColor getColor(ColorMapper mapper, double coeff, int alpha) {
        if (coeff > 1.0 || coeff < 0.0) {
            throw new IllegalArgumentException("c=" + coeff);
        }
        XColor c1 = this.color1.toColor(mapper);
        XColor c2 = this.color2.toColor(mapper);
        int diffRed = c2.getRed() - c1.getRed();
        int diffGreen = c2.getGreen() - c1.getGreen();
        int diffBlue = c2.getBlue() - c1.getBlue();
        int vRed = (int)(coeff * (double)diffRed);
        int vGreen = (int)(coeff * (double)diffGreen);
        int vBlue = (int)(coeff * (double)diffBlue);
        int red = c1.getRed() + vRed;
        int green = c1.getGreen() + vGreen;
        int blue = c1.getBlue() + vBlue;
        return new XColor(red, green, blue, alpha);
    }

    public final int getRGB(ColorMapper mapper, double coeff, int alpha) {
        if (TeaVM.isTeaVM()) {
            return 0;
        }
        return this.getColor(mapper, coeff, alpha).getRGB();
    }

    public final char getPolicy() {
        return this.policy;
    }

    @Override
    public XColor toColor(ColorMapper mapper) {
        return this.color1.toColor(mapper);
    }

    @Override
    public HColor opposite() {
        return this.color1.opposite();
    }
}

