/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Fission;
import net.sourceforge.plantuml.klimt.creole.Neutron;
import net.sourceforge.plantuml.klimt.creole.Position;
import net.sourceforge.plantuml.klimt.creole.Sea;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.creole.Stripe;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class SheetBlock1
extends AbstractTextBlock
implements TextBlock,
Atom,
Stencil {
    private final Sheet sheet;
    private List<Stripe> stripes;
    private Map<Stripe, Double> heights;
    private Map<Stripe, Double> widths;
    private Map<Atom, Position> positions;
    private MinMax minMax;
    private final LineBreakStrategy maxWidth;
    private final ClockwiseTopRightBottomLeft padding;
    private final double marginX1;
    private final double marginX2;
    private Class<? extends StringBounder> lastCaller;
    private double minimumWidth;

    public SheetBlock1(Sheet sheet, LineBreakStrategy maxWidth, double padding) {
        this(sheet, maxWidth, ClockwiseTopRightBottomLeft.same(padding), 0.0, 0.0);
    }

    public SheetBlock1(Sheet sheet, LineBreakStrategy maxWidth, Style style) {
        this(sheet, maxWidth, style.getPadding(), 0.0, 0.0);
        this.minimumWidth = style.value(PName.MinimumWidth).asDouble();
    }

    public SheetBlock1(Sheet sheet, LineBreakStrategy maxWidth, double padding, double marginX1, double marginX2) {
        this(sheet, maxWidth, ClockwiseTopRightBottomLeft.same(padding), marginX1, marginX2);
    }

    public SheetBlock1(Sheet sheet, LineBreakStrategy maxWidth, ClockwiseTopRightBottomLeft padding, double marginX1, double marginX2) {
        this.sheet = sheet;
        this.maxWidth = Objects.requireNonNull(maxWidth);
        this.padding = padding;
        this.marginX1 = marginX1;
        this.marginX2 = marginX2;
    }

    public String toString() {
        return this.sheet.toString();
    }

    public HorizontalAlignment getCellAlignment() {
        if (this.stripes.size() != 1) {
            return HorizontalAlignment.LEFT;
        }
        Stripe simple = this.stripes.get(0);
        if (simple instanceof StripeSimple) {
            return ((StripeSimple)simple).getCellAlignment();
        }
        return HorizontalAlignment.LEFT;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.sheet.getHorizontalAlignment();
    }

    private void initMap(StringBounder stringBounder) {
        Class<?> currentCaller = stringBounder.getClass();
        if (this.lastCaller == currentCaller) {
            return;
        }
        this.lastCaller = currentCaller;
        this.stripes = new ArrayList<Stripe>();
        for (Stripe stripe : this.sheet) {
            this.stripes.addAll(new Fission(stripe, this.maxWidth).getSplitted(stringBounder));
        }
        this.positions = new LinkedHashMap<Atom, Position>();
        this.widths = new LinkedHashMap<Stripe, Double>();
        this.heights = new LinkedHashMap<Stripe, Double>();
        this.minMax = MinMax.getEmpty(true);
        double y = 0.0;
        for (Stripe stripe : this.stripes) {
            if (stripe.getAtoms().size() == 0) continue;
            Sea sea = new Sea(stringBounder);
            for (Atom atom : stripe.getAtoms()) {
                sea.add(atom);
            }
            sea.doAlign();
            if (stringBounder.matchesProperty("TIKZ")) {
                sea.doAlignTikz();
            }
            sea.translateMinYto(y);
            double d = sea.getWidth();
            this.widths.put(stripe, d);
            this.minMax = sea.update(this.minMax);
            double height = sea.getHeight();
            this.heights.put(stripe, height);
            y += height;
            if (stringBounder.matchesProperty("TIKZ")) {
                sea.doAlignTikzBaseline();
            }
            sea.exportAllPositions(this.positions);
        }
        double maxWidth = 0.0;
        for (Double d : this.widths.values()) {
            if (!(d > maxWidth)) continue;
            maxWidth = d;
        }
        for (Map.Entry entry : this.widths.entrySet()) {
            Stripe key;
            int coef;
            double diff = maxWidth - (Double)entry.getValue();
            if (!(diff > 0.0) || (coef = this.getCoef(key = (Stripe)entry.getKey())) <= 0) continue;
            for (Atom atom : key.getAtoms()) {
                Position pos = this.positions.get(atom);
                this.positions.put(atom, pos.translateX(diff / (double)coef));
            }
        }
    }

    private int getCoef(Stripe key) {
        if (key instanceof StripeSimple) {
            return this.getCoef(((StripeSimple)key).getCellAlignment());
        }
        return this.getCoef(this.sheet.getHorizontalAlignment());
    }

    private int getCoef(HorizontalAlignment alignment) {
        if (alignment == null) {
            return 0;
        }
        switch (alignment) {
            case CENTER: {
                return 2;
            }
            case RIGHT: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        this.initMap(stringBounder);
        return this.minMax.getDimension().delta(this.padding.getBottom() + this.padding.getTop());
    }

    @Override
    public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
        return null;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.initMap(ug.getStringBounder());
        if (this.padding.getLeft() > 0.0 || this.padding.getTop() > 0.0) {
            ug = ug.apply(new UTranslate(this.padding.getLeft(), this.padding.getTop()));
        }
        for (Stripe stripe : this.stripes) {
            for (Atom atom : stripe.getAtoms()) {
                Position position = this.positions.get(atom);
                atom.drawU(position.translate(ug));
            }
        }
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.marginX1;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth() + this.marginX2;
    }

    public final double getMinimumWidth() {
        return this.minimumWidth;
    }

    @Override
    public List<Neutron> getNeutrons() {
        throw new UnsupportedOperationException();
    }
}

