/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.g2d;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontContext;
import net.sourceforge.plantuml.klimt.font.UFontImpl;
import net.sourceforge.plantuml.klimt.geom.EnsureVisible;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.utils.Log;

public class DriverTextAsPathG2d
implements UDriver<UText, Graphics2D> {
    private final EnsureVisible visible;
    private final StringBounder stringBounder;

    public DriverTextAsPathG2d(EnsureVisible visible, StringBounder stringBounder) {
        this.visible = visible;
        this.stringBounder = stringBounder;
    }

    private static void printFont() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        int j = fontNames.length;
        int i = 0;
        while (i < j) {
            int i2 = i++;
            Log.info(() -> "Available fonts: " + fontNames[i2]);
        }
    }

    @Override
    public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        int ypos;
        XColor extended;
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        UFont font = fontConfiguration.getFont();
        String text = shape.getText();
        XDimension2D dim = this.stringBounder.calculateDimension(font, text);
        double height = Math.max(10.0, dim.getHeight());
        double width = dim.getWidth();
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR) && (extended = fontConfiguration.getExtendedColor().toColor(mapper)) != null) {
            g2d.setColor(extended.toAwtColor());
            g2d.setBackground(extended.toAwtColor());
            g2d.fill(new Rectangle2D.Double(x, y - height + 1.5, width, height));
        }
        this.visible.ensureVisible(x, y - height + 1.5);
        this.visible.ensureVisible(x + width, y + 1.5);
        g2d.setFont(UFontImpl.getUnderlayingFont(font, text));
        g2d.setColor(fontConfiguration.getColor().toColor(mapper).toAwtColor());
        TextLayout t = UFontContext.G2D.createTextLayout(font, text);
        g2d.translate(x, y);
        g2d.fill(t.getOutline(null));
        g2d.translate(-x, -y);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            HColor extended2 = fontConfiguration.getExtendedColor();
            if (extended2 != null) {
                g2d.setColor(extended2.toColor(mapper).toAwtColor());
            }
            ypos = (int)(y + 2.5);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
            g2d.setStroke(new BasicStroke());
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            int ypos2 = (int)(y + 2.5) - 1;
            HColor extended3 = fontConfiguration.getExtendedColor();
            if (extended3 != null) {
                g2d.setColor(extended3.toColor(mapper).toAwtColor());
            }
            int i = (int)x;
            while ((double)i < x + width - 5.0) {
                g2d.drawLine(i, ypos2 - 0, i + 3, ypos2 + 1);
                g2d.drawLine(i + 3, ypos2 + 1, i + 6, ypos2 - 0);
                i += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            FontMetrics fm = g2d.getFontMetrics(UFontImpl.getUnderlayingFont(font, text));
            ypos = (int)(y - (double)fm.getDescent() - 0.5);
            HColor extended4 = fontConfiguration.getExtendedColor();
            if (extended4 != null) {
                g2d.setColor(extended4.toColor(mapper).toAwtColor());
            }
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
            g2d.setStroke(new BasicStroke());
        }
    }
}

