/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.font;

import java.awt.Font;
import java.util.Objects;
import net.sourceforge.plantuml.klimt.font.FontStack;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontContext;
import net.sourceforge.plantuml.teavm.TeaVM;

public final class UFontImpl
implements UFont {
    private final FontStack fontStack;
    private final int style;
    private final int size;

    public static Font getUnderlayingFont(UFont font, String text) {
        return ((UFontImpl)font).getUnderlayingFont(text);
    }

    UFontImpl(FontStack fontStack, int style, int size) {
        this.fontStack = fontStack;
        this.style = style;
        this.size = size;
    }

    public Font getUnderlayingFont(String text) {
        return this.fontStack.getFont(text, this.style, this.size);
    }

    @Override
    public UFont withSize(float size) {
        return new UFontImpl(this.fontStack, this.style, (int)size);
    }

    @Override
    public UFont withStyle(int style) {
        return new UFontImpl(this.fontStack, style, this.size);
    }

    @Override
    public UFont bold() {
        return this.withStyle(1);
    }

    @Override
    public UFont italic() {
        return this.withStyle(2);
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public double getSize2D() {
        return this.size;
    }

    @Override
    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    @Override
    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    @Override
    public String getFamily(String text, UFontContext context) {
        if (TeaVM.isTeaVM()) {
            String fullDefinition = this.fontStack.getFullDefinition();
            if ("monospaced".equalsIgnoreCase(fullDefinition)) {
                return "monospace";
            }
            return fullDefinition.replace('\"', '\'').replaceAll("(?i)sansserif", "sans-serif");
        }
        if (context == UFontContext.EPS) {
            return this.getUnderlayingFont(text).getPSName();
        }
        if (context == UFontContext.SVG) {
            String result = this.fontStack.getFullDefinition().replace('\"', '\'');
            result = result.replaceAll("(?i)sansserif", "sans-serif");
            return result;
        }
        throw new IllegalArgumentException();
    }

    private String getPortableFontName() {
        Font font = this.getUnderlayingFont(null);
        String name = font.getFontName();
        if (font.isBold() && font.isItalic()) {
            return name.endsWith(".bolditalic") ? name : name + ".bolditalic";
        }
        if (font.isBold()) {
            return name.endsWith(".bold") ? name : name + ".bold";
        }
        if (font.isItalic()) {
            return name.endsWith(".italic") ? name : name + ".italic";
        }
        return name.endsWith(".plain") ? name : name + ".plain";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPortableFontName());
        sb.append("/");
        sb.append(this.getSize());
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.fontStack, this.style, this.size);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UFontImpl)) {
            return false;
        }
        UFontImpl other = (UFontImpl)obj;
        return Objects.equals(this.fontStack, other.fontStack) && this.style == other.style && this.size == other.size;
    }
}

