/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import java.util.Objects;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.ImgValign;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UImage;

public class TileImage
extends AbstractTextBlock
implements TextBlock {
    private final PortableImage image;
    private final int vspace;

    public TileImage(PortableImage image, ImgValign valign, int vspace) {
        this.image = Objects.requireNonNull(image);
        this.vspace = vspace;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.image.getWidth(), this.image.getHeight() + 2 * this.vspace);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(UTranslate.dy(this.vspace)).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
    }
}

