/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.sprite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.sprite.ColorPalette4096;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.klimt.sprite.SpriteColor;

public class SpriteColorBuilder4096 {
    private static final ColorPalette4096 COLOR_PALETTE = new ColorPalette4096();

    public static Sprite buildSprite(List<String> strings) {
        SpriteColor result = new SpriteColor(strings.get(0).length() / 2, strings.size());
        for (int col = 0; col < result.getWidth(); ++col) {
            for (int line = 0; line < result.getHeight(); ++line) {
                if (col * 2 >= strings.get(line).length()) continue;
                String encodedColor = strings.get(line).toString().substring(col * 2, col * 2 + 2);
                XColor rgb = COLOR_PALETTE.getColorFor(encodedColor);
                result.setColor(col, line, rgb.getRGB() & 0xFFFFFF);
            }
        }
        return result;
    }

    public static List<String> encodeImage(PortableImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        ArrayList<String> result = new ArrayList<String>();
        for (int y = 0; y < height; ++y) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < width; ++x) {
                int rgb = img.getRGB(x, y) & 0xFFFFFF;
                String encodedColor = COLOR_PALETTE.getStringFor(XColor.from(rgb));
                sb.append(encodedColor);
            }
            result.add(sb.toString());
        }
        return Collections.unmodifiableList(result);
    }
}

