/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nio;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.sourceforge.plantuml.nio.InputFile;
import net.sourceforge.plantuml.nio.NFolder;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;

public class NFolderRegular
implements NFolder {
    private final Path dir;

    public NFolderRegular(Path dir) {
        this.dir = Objects.requireNonNull(dir);
    }

    @Override
    public InputFile getInputFile(Path nameOrPath) throws IOException {
        if (nameOrPath.isAbsolute()) {
            SFile result = SFile.fromFile(nameOrPath.toFile());
            if (result.canRead()) {
                return result;
            }
        } else {
            SFile file;
            SFile result = SFile.fromFile(this.dir.resolve(nameOrPath).toFile());
            if (result.canRead()) {
                return result;
            }
            for (SFile d : SecurityUtils.getPath("plantuml.include.path")) {
                assert (d.isDirectory());
                file = d.file(nameOrPath.toString());
                if (!file.canRead()) continue;
                return file.getCanonicalFile();
            }
            for (SFile d : SecurityUtils.getPath("java.class.path")) {
                assert (d.isDirectory());
                file = d.file(nameOrPath.toString());
                if (!file.canRead()) continue;
                return file.getCanonicalFile();
            }
        }
        return null;
    }

    @Override
    public NFolder getSubfolder(Path nameOrPath) throws IOException {
        Path sub = this.dir.resolve(nameOrPath).normalize();
        return new NFolderRegular(sub);
    }

    public String toString() {
        return "NFolderRegular[" + String.valueOf(this.dir) + "]";
    }
}

