/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.sourceforge.plantuml.nio.InputFile;
import net.sourceforge.plantuml.nio.InputFileStdlib;
import net.sourceforge.plantuml.nio.InputFileUrl;
import net.sourceforge.plantuml.nio.NFolder;
import net.sourceforge.plantuml.nio.NFolderRegular;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.teavm.TeaVM;
import net.sourceforge.plantuml.teavm.browser.TeaVmScriptLoader;
import org.teavm.jso.JSObject;

public class PathSystem {
    private final NFolder currentFolder;

    public static PathSystem fetch() {
        if (TeaVM.isTeaVM()) {
            return new PathSystem(null);
        }
        return new PathSystem(new NFolderRegular(Paths.get("", new String[0])));
    }

    public InputStream getTeaVMInputStream(String path) {
        String full = path.substring(1, path.length() - 1).toLowerCase();
        String libname = full.substring(0, full.indexOf(47));
        String filepath = full.substring(libname.length() + 1);
        TeaVmScriptLoader.loadOnceSync(libname + ".min.js");
        JSObject data = TeaVmScriptLoader.getRaw(libname, filepath);
        if (data == null) {
            return null;
        }
        String content = TeaVmScriptLoader.joinLines(data);
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    private PathSystem(NFolder currentFolder) {
        this.currentFolder = currentFolder;
    }

    public PathSystem changeCurrentDirectory(Path newCurrentDir) throws IOException {
        if (TeaVM.isTeaVM()) {
            return this;
        }
        if (newCurrentDir == null) {
            return this;
        }
        NFolder folder = this.currentFolder.getSubfolder(newCurrentDir);
        return new PathSystem(folder);
    }

    public PathSystem changeCurrentDirectory(NFolder newCurrentDir) {
        if (TeaVM.isTeaVM()) {
            return this;
        }
        return new PathSystem(newCurrentDir);
    }

    public PathSystem changeCurrentDirectory(SFile newCurrentDir) throws IOException {
        if (TeaVM.isTeaVM()) {
            return this;
        }
        if (newCurrentDir == null) {
            return this;
        }
        return this.changeCurrentDirectory(newCurrentDir.toPath());
    }

    public PathSystem withCurrentDir(NFolder parentFile) {
        if (TeaVM.isTeaVM()) {
            return this;
        }
        return new PathSystem(parentFile);
    }

    public NFolder getCurrentDir() {
        return this.currentFolder;
    }

    public InputFile getFile(String filename, String suffix) throws IOException {
        return this.getInputFile(filename);
    }

    public String toString() {
        return this.currentFolder.toString();
    }

    public InputFile getInputFile(String path) throws IOException {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            SURL url = SURL.create(path);
            if (url == null) {
                throw new IOException("Cannot open URL " + path);
            }
            return new InputFileUrl(url);
        }
        if (path.startsWith("<") && path.endsWith(">")) {
            String full = path.substring(1, path.length() - 1).toLowerCase();
            String libname = full.substring(0, full.indexOf(47));
            String filepath = full.substring(libname.length() + 1);
            return new InputFileStdlib(Stdlib.retrieve(libname), Paths.get(filepath, new String[0]));
        }
        if (path.startsWith("::")) {
            Path target;
            SFile result;
            String rel = path.substring(2);
            if (rel.startsWith("/")) {
                rel = rel.substring(1);
            }
            if ((result = SFile.fromFile((target = Paths.get("", new String[0]).toAbsolutePath().resolve(rel).normalize()).toFile())).isFileOk()) {
                return result;
            }
            return null;
        }
        if (path.startsWith("~/")) {
            String home = System.getProperty("user.home");
            Path homePath = Paths.get(home, new String[0]).resolve(path.substring(2)).normalize();
            SFile result = SFile.fromFile(homePath.toFile());
            if (result.isFileOk()) {
                return result;
            }
            return null;
        }
        return this.currentFolder.getInputFile(Paths.get(path, new String[0]));
    }

    public static void main(String[] args) {
        System.out.println(PathSystem.fetch());
    }

    public void addImportFile(SFile file) {
    }
}

