/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.klimt.UAntiAliasing;
import net.sourceforge.plantuml.klimt.awt.XColor;

public class PngFlashcoder {
    private final List<BufferedImage> flashcodes;

    public PngFlashcoder(List<BufferedImage> flashcodes) {
        this.flashcodes = flashcodes;
    }

    public BufferedImage processImage(BufferedImage im, XColor background) {
        if (this.flashcodes != null) {
            im = this.addImage(im, background);
        }
        return im;
    }

    private BufferedImage addImage(BufferedImage im, XColor background) {
        double width = Math.max(im.getWidth(), PngFlashcoder.getWidth(this.flashcodes));
        double height = im.getHeight() + PngFlashcoder.getHeight(this.flashcodes);
        BufferedImage newIm = new BufferedImage((int)width, (int)height, 1);
        Graphics2D g2d = newIm.createGraphics();
        UAntiAliasing.ANTI_ALIASING_OFF.apply(g2d);
        g2d.setColor(background.toAwtColor());
        g2d.fillRect(0, 0, newIm.getWidth(), newIm.getHeight());
        g2d.drawImage(im, null, 0, 0);
        int x = 0;
        for (BufferedImage f : this.flashcodes) {
            g2d.drawImage(f, null, x, im.getHeight());
            x += f.getWidth();
        }
        g2d.dispose();
        return newIm;
    }

    public static int getHeight(List<BufferedImage> flashcodes) {
        int result = 0;
        for (BufferedImage im : flashcodes) {
            result = Math.max(result, im.getWidth());
        }
        return result;
    }

    public static int getWidth(List<BufferedImage> flashcodes) {
        int result = 0;
        for (BufferedImage im : flashcodes) {
            result += im.getWidth();
        }
        return result;
    }
}

