/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.nio.InputFile;
import net.sourceforge.plantuml.preproc.DiagramExtractor;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.ReadFilterMergeLines;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.StartUtils;

public class DiagramDetector {
    public static ReadLine extractFromUrl(SURL url, StringLocated s, String uid, Charset charset) throws IOException {
        ReadLine raw = DiagramDetector.newReadLineFromUrl(url, s, charset);
        if (DiagramDetector.containsStartDiagram(raw)) {
            ReadLine raw1 = DiagramDetector.newReadLineFromUrl(url, s, charset);
            return new DiagramExtractor(raw1, uid);
        }
        return null;
    }

    public static ReadLine extractFromBytes(byte[] puml, String description) throws IOException {
        ReadLine raw = DiagramDetector.newReadLineFromInputStream(new ByteArrayInputStream(puml), description);
        if (DiagramDetector.containsStartDiagram(raw)) {
            ReadLine raw1 = DiagramDetector.newReadLineFromInputStream(new ByteArrayInputStream(puml), description);
            return new DiagramExtractor(raw1, null);
        }
        return null;
    }

    public static ReadLine extractFromFile(InputFile f2, String description) throws IOException {
        ReadLine raw = DiagramDetector.newReadLineFromInputStream(f2.newInputStream(), description);
        if (DiagramDetector.containsStartDiagram(raw)) {
            ReadLine raw1 = DiagramDetector.newReadLineFromInputStream(f2.newInputStream(), description);
            return new DiagramExtractor(raw1, null);
        }
        return null;
    }

    private static ReadLine newReadLineFromInputStream(InputStream is, String description) {
        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        ReadLine raw = ReadLineReader.create(isr, description);
        return DiagramDetector.uncommentAndMerge(raw);
    }

    private static ReadLine newReadLineFromUrl(SURL url, StringLocated s, Charset charset) {
        InputStream tmp = url.openStream();
        if (tmp == null) {
            return new ReadLineSimple(s, "Cannot connect");
        }
        InputStreamReader isr = new InputStreamReader(tmp, charset);
        ReadLine raw = ReadLineReader.create(isr, url.toString());
        return DiagramDetector.uncommentAndMerge(raw);
    }

    private static ReadLine uncommentAndMerge(ReadLine reader) {
        ReadLine raw = new ReadFilterMergeLines().applyFilter(reader);
        return new UncommentReadLine(raw);
    }

    private static boolean containsStartDiagram(ReadLine r) throws IOException {
        try {
            StringLocated s = null;
            while ((s = r.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(s.getString())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        return false;
    }
}

