/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.time.LocalDate;
import java.util.Iterator;
import net.sourceforge.plantuml.project.GanttDiagram;

public class DaysAsDates
implements Iterable<LocalDate> {
    private final LocalDate date1;
    private final LocalDate date2;

    public DaysAsDates(LocalDate date1, LocalDate date2) {
        this.date1 = date1;
        this.date2 = date2;
    }

    public String toString() {
        return "{ " + String.valueOf(this.date1) + " , " + String.valueOf(this.date2) + " }";
    }

    public DaysAsDates(GanttDiagram gantt, LocalDate date1, int count) {
        this.date1 = date1;
        LocalDate tmp = date1;
        while (count > 0) {
            if (gantt.isOpen(tmp)) {
                --count;
            }
            tmp = tmp.plusDays(1L);
        }
        this.date2 = tmp;
    }

    @Override
    public Iterator<LocalDate> iterator() {
        return new MyIterator(this.date1);
    }

    class MyIterator
    implements Iterator<LocalDate> {
        private LocalDate current;

        public MyIterator(LocalDate current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current.compareTo(DaysAsDates.this.date2) <= 0;
        }

        @Override
        public LocalDate next() {
            LocalDate result = this.current;
            this.current = this.current.plusDays(1L);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

