/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core;

import net.sourceforge.plantuml.project.GanttConstraintMode;
import net.sourceforge.plantuml.project.core.AbstractTask;
import net.sourceforge.plantuml.project.core.Moment;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstantUtils;
import net.sourceforge.plantuml.project.time.TimePoint;

public class TaskInstant {
    private final Moment task;
    private final TaskAttribute attribute;
    private final int delta;
    private final GanttConstraintMode mode;
    private final PiecewiseConstant calendar;

    public TaskInstant(Moment task, TaskAttribute attribute) {
        this(task, attribute, 0, GanttConstraintMode.IGNORE_CALENDAR, null);
    }

    private TaskInstant(Moment task, TaskAttribute attribute, int delta, GanttConstraintMode mode, PiecewiseConstant calendar) {
        this.task = task;
        this.attribute = attribute;
        this.delta = delta;
        this.mode = mode;
        this.calendar = calendar;
        if (attribute != TaskAttribute.START && attribute != TaskAttribute.END) {
            throw new IllegalArgumentException();
        }
    }

    public TaskInstant withDelta(int newDelta, GanttConstraintMode mode, PiecewiseConstant calendar) {
        return new TaskInstant(this.task, this.attribute, newDelta, mode, calendar);
    }

    private TimePoint manageDelta(TimePoint value) {
        int i;
        if (this.delta > 0) {
            for (i = 0; i < this.delta; ++i) {
                if (this.mode == GanttConstraintMode.DO_NOT_COUNT_CLOSE_DAY) {
                    int tmp = 0;
                    while (PiecewiseConstantUtils.isZeroOnDay(this.calendar, value.toDay()) && tmp++ < 1000) {
                        value = value.increment();
                    }
                }
                value = value.increment();
            }
        }
        if (this.delta < 0) {
            for (i = 0; i < -this.delta; ++i) {
                value = value.decrement();
            }
        }
        return value;
    }

    public TimePoint getInstantPrecise() {
        if (this.attribute == TaskAttribute.START) {
            return this.manageDelta(this.task.getStart());
        }
        if (this.attribute == TaskAttribute.END) {
            return this.manageDelta(this.task.getEnd());
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return this.attribute.toString() + " of " + String.valueOf(this.task);
    }

    public final Moment getMoment() {
        return this.task;
    }

    public final boolean isTask() {
        return this.task instanceof AbstractTask;
    }

    public final TaskAttribute getAttribute() {
        return this.attribute;
    }

    public boolean sameRowAs(TaskInstant dest) {
        AbstractTask t2;
        AbstractTask t1;
        return this.isTask() && dest.isTask() && ((t1 = (AbstractTask)this.getMoment()) == (t2 = (AbstractTask)dest.getMoment()).getRow() || t2 == t1.getRow());
    }
}

