/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.data;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.project.OpenClose;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstant;
import net.sourceforge.plantuml.project.time.TimePoint;

public class DayCalendarData {
    private final OpenClose openClose = new OpenClose();
    private final Map<TimePoint, String> nameDays = new HashMap<TimePoint, String>();
    private final Map<TimePoint, HColor> colorDaysToday = new HashMap<TimePoint, HColor>();
    private final Map<TimePoint, HColor> colorDaysInternal = new HashMap<TimePoint, HColor>();
    private final Map<DayOfWeek, HColor> colorDaysOfWeek = new HashMap<DayOfWeek, HColor>();
    private final Set<LocalDate> verticalSeparatorBefore = new HashSet<LocalDate>();
    private final Map<String, OpenClose> openCloseForTask = new HashMap<String, OpenClose>();

    public boolean isOpen(LocalDate day) {
        return this.openClose.getLoadAtDUMMY(day) > 0;
    }

    public boolean isOpen(TimePoint instant) {
        return this.openClose.getLoadAtDUMMY(instant.toDay()) > 0;
    }

    public HColor getDayColor(TimePoint day) {
        HColor color = this.colorDaysToday.get(day);
        if (color == null) {
            color = this.colorDaysInternal.get(day);
        }
        return color;
    }

    public HColor getDayOfWeekColor(DayOfWeek dayOfWeek) {
        return this.colorDaysOfWeek.get(dayOfWeek);
    }

    public String getDayName(TimePoint day) {
        return this.nameDays.get(day);
    }

    public OpenClose getOpenClose() {
        return this.openClose;
    }

    public Collection<TimePoint> getColorDays() {
        return this.colorDaysInternal.keySet();
    }

    public Map<TimePoint, String> getNameDays() {
        return Collections.unmodifiableMap(this.nameDays);
    }

    public boolean hasSeparatorBefore(LocalDate day) {
        return this.verticalSeparatorBefore.contains(day);
    }

    public void addSeparatorBefore(LocalDate day) {
        this.verticalSeparatorBefore.add(day);
    }

    public void putNameDay(TimePoint day, String name) {
        this.nameDays.put(day, name);
    }

    public void putColorDayToday(TimePoint day, HColor color) {
        this.colorDaysToday.put(day, color);
    }

    public void putColorDay(TimePoint day, HColor color) {
        this.colorDaysInternal.put(day, color);
    }

    public void putColorDayOfWeek(DayOfWeek dow, HColor color) {
        this.colorDaysOfWeek.put(dow, color);
    }

    public OpenClose getOpenCloseForTask(String task) {
        return this.openCloseForTask.computeIfAbsent(task, k -> new OpenClose());
    }

    public PiecewiseConstant getDefaultPlan() {
        return this.openClose.asPiecewiseConstant();
    }
}

