/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.LabelStrategy;
import net.sourceforge.plantuml.project.core.GArrowType;
import net.sourceforge.plantuml.project.core.GSide;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.data.TaskDrawRegistryData;
import net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class TaskDrawDiamond
extends AbstractTaskDraw {
    public TaskDrawDiamond(HColorSet colorSet, TimeScale timeScale, Real y, String prettyDisplay, TimePoint start, Task task, TaskDrawRegistryData toTaskDraw, StyleBuilder styleBuilder, ISkinParam skinParam) {
        super(colorSet, timeScale, y, prettyDisplay, start, task, toTaskDraw, styleBuilder, skinParam);
    }

    @Override
    StyleSignature getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.milestone);
    }

    private double getYNotePosition(StringBounder stringBounder) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        return margin.getTop() + this.getShapeHeight(stringBounder) + margin.getBottom();
    }

    @Override
    public double getHeightMax(StringBounder stringBounder) {
        if (this.note == null) {
            return this.getFullHeightTask(stringBounder);
        }
        return this.getYNotePosition(stringBounder) + this.getOpaleNote().calculateDimension(stringBounder).getHeight();
    }

    @Override
    protected double getShapeHeight(StringBounder stringBounder) {
        TextBlock title = this.getTitle();
        XDimension2D titleDim = title.calculateDimension(stringBounder);
        return Math.max(titleDim.getHeight(), this.getDiamondHeight());
    }

    private double getDiamondHeight() {
        int result = (int)this.getFontConfiguration().getFont().getSize2D();
        if (result % 2 == 1) {
            --result;
        }
        return result;
    }

    @Override
    public final void drawTitle(UGraphic ug, LabelStrategy labelStrategy, double colTitles, double colBars) {
        double x;
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        ClockwiseTopRightBottomLeft padding = style.getPadding();
        TextBlock title = this.getTitle();
        ug = ug.apply(UTranslate.dy(margin.getTop()));
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D titleDim = title.calculateDimension(stringBounder);
        double h = (this.getShapeHeight(stringBounder) - titleDim.getHeight()) / 2.0;
        if (labelStrategy.titleInFirstColumn()) {
            x = labelStrategy.rightAligned() ? colTitles - titleDim.getWidth() - margin.getRight() : margin.getLeft();
        } else if (labelStrategy.titleInLastColumn()) {
            x = colBars + margin.getLeft();
        } else {
            double x1 = this.timeScale.getPosition(this.start);
            double x2 = this.timeScale.getPosition(this.start) + this.timeScale.getWidth(this.start);
            double width = this.getDiamondHeight();
            double delta = x2 - x1 - width;
            x = x2 - delta / 2.0 + padding.getLeft();
        }
        title.drawU(ug.apply(new UTranslate(x, h)));
    }

    @Override
    protected TextBlock getTitle() {
        return Display.getWithNewlines(this.getPragma(), this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    @Override
    public void drawU(UGraphic ug) {
        double x1 = this.timeScale.getPosition(this.start);
        this.drawNote(ug.apply(new UTranslate(x1, this.getYNotePosition(ug.getStringBounder()))));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        String displayString = this.getTask().getDisplayString();
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        ug = ug.apply(UTranslate.dy(margin.getTop()));
        ug = ug.apply(UTranslate.dx(x1));
        if (displayString == null) {
            double x2 = this.timeScale.getPosition(this.start) + this.timeScale.getWidth(this.start);
            double width = this.getDiamondHeight();
            double delta = x2 - x1 - width;
            ug = ug.apply(UTranslate.dx(delta / 2.0));
            this.drawShape(this.applyColors(ug));
        } else {
            TextBlock draw = Display.getWithNewlines(this.getPragma(), displayString).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            draw.drawU(ug);
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private UGraphic applyColors(UGraphic ug) {
        CenterBorderColor col = this.getColors();
        if (col != null && col.isOk()) {
            return col.apply(ug);
        }
        return ug.apply(this.getLineColor()).apply(this.getBackgroundColor().bg());
    }

    private void drawShape(UGraphic ug) {
        ug.draw(this.getDiamond());
    }

    @Override
    public FingerPrint getFingerPrintNote(StringBounder stringBounder) {
        return null;
    }

    @Override
    public FingerPrint getFingerPrint(StringBounder stringBounder) {
        double h = this.getFullHeightTask(stringBounder);
        double startPos = this.timeScale.getPosition(this.start);
        return new FingerPrint(startPos, this.getY(stringBounder).getCurrentValue(), startPos + h, this.getY(stringBounder).getCurrentValue() + h);
    }

    private UShape getDiamond() {
        double h = this.getDiamondHeight();
        UPolygon result = new UPolygon();
        result.addPoint(h / 2.0, 0.0);
        result.addPoint(h, h / 2.0);
        result.addPoint(h / 2.0, h);
        result.addPoint(0.0, h / 2.0);
        return result;
    }

    @Override
    public double getX(StringBounder stringBounder, GSide side, GArrowType arrowType) {
        double x = side == GSide.LEFT ? this.timeScale.getPosition(this.start) : (side == GSide.RIGHT ? this.timeScale.getPosition(this.start) + this.timeScale.getWidth(this.start) : (this.timeScale.getPosition(this.start) + this.timeScale.getPosition(this.start) + this.timeScale.getWidth(this.start)) / 2.0);
        if (arrowType == GArrowType.OUTGOING) {
            double width = this.getDiamondHeight();
            if (side == GSide.LEFT) {
                x += width / 2.0;
            } else if (side == GSide.RIGHT) {
                x -= width / 2.0;
            }
        }
        return x;
    }

    @Override
    public double getY(StringBounder stringBounder, GSide side) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double y1 = margin.getTop() + this.getY(stringBounder).getCurrentValue();
        double y2 = y1 + this.getShapeHeight(stringBounder);
        String displayString = this.getTask().getDisplayString();
        if (displayString == null) {
            return y1 + this.getDiamondHeight() / 2.0;
        }
        return (y1 + y2) / 2.0;
    }
}

