/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw.header;

import java.time.LocalDate;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimeScaleConfigData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.data.WeekConfigData;
import net.sourceforge.plantuml.project.draw.header.TimeHeader;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderDaily;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderMonthly;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderQuarterly;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderSimple;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderWeekly;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderYearly;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;
import net.sourceforge.plantuml.project.timescale.TimeScaleDaily;
import net.sourceforge.plantuml.project.timescale.TimeScaleDailyHideClosed;
import net.sourceforge.plantuml.project.timescale.TimeScaleWink;

public class TimeHeaderFactory {
    private final TimeBoundsData timeBounds;
    private final DayCalendarData dayCalendar;
    private final TimelineStyleData timelineStyle;
    private final TimeScaleConfigData scaleConfig;
    private final WeekConfigData weekConfig;

    public TimeHeaderFactory(WeekConfigData weekConfig, DayCalendarData dayCalendar, TimeBoundsData timeBounds, TimeScaleConfigData scaleConfig, TimelineStyleData timelineStyle) {
        this.weekConfig = weekConfig;
        this.timeBounds = timeBounds;
        this.dayCalendar = dayCalendar;
        this.scaleConfig = scaleConfig;
        this.timelineStyle = timelineStyle;
    }

    public TimeHeader createTimeHeader() {
        if (this.timeBounds.getMinDay().equals(TimePoint.epoch())) {
            return new TimeHeaderSimple(this.createSimpleScale(), this.weekConfig, this.dayCalendar, this.timeBounds, this.scaleConfig, this.timelineStyle);
        }
        switch (this.scaleConfig.getPrintScale()) {
            case DAILY: {
                return new TimeHeaderDaily(this.createDailyScale(), this.weekConfig, this.dayCalendar, this.timeBounds, this.scaleConfig, this.timelineStyle);
            }
            case WEEKLY: {
                return new TimeHeaderWeekly(this.createCompressedScale(), this.weekConfig, this.dayCalendar, this.timeBounds, this.scaleConfig, this.timelineStyle);
            }
            case MONTHLY: {
                return new TimeHeaderMonthly(this.createCompressedScale(), this.weekConfig, this.dayCalendar, this.timeBounds, this.scaleConfig, this.timelineStyle);
            }
            case QUARTERLY: {
                return new TimeHeaderQuarterly(this.createCompressedScale(), this.weekConfig, this.dayCalendar, this.timeBounds, this.scaleConfig, this.timelineStyle);
            }
            case YEARLY: {
                return new TimeHeaderYearly(this.createCompressedScale(), this.weekConfig, this.dayCalendar, this.timeBounds, this.scaleConfig, this.timelineStyle);
            }
        }
        throw new IllegalStateException("Unsupported print scale: " + String.valueOf((Object)this.scaleConfig.getPrintScale()));
    }

    private TimeScale createSimpleScale() {
        return new TimeScaleWink(this.getCellWidth(), this.getEffectiveScale(), this.scaleConfig.getPrintScale());
    }

    private TimeScale createDailyScale() {
        if (this.scaleConfig.isHideClosed()) {
            return new TimeScaleDailyHideClosed(this.getCellWidth(), this.getStart(), this.getEffectiveScale(), this.dayCalendar.getOpenClose());
        }
        return new TimeScaleDaily(this.getCellWidth(), this.getStart(), this.getEffectiveScale(), this.getPrintStart());
    }

    private TimeScale createCompressedScale() {
        return new TimeScaleCompressed(this.getCellWidth(), this.getStart(), this.getEffectiveScale(), this.getPrintStart());
    }

    private TimePoint getStart() {
        return TimePoint.ofStartOfDay(this.timeBounds.getMinDay());
    }

    private LocalDate getPrintStart() {
        return this.timeBounds.getPrintStart();
    }

    private double getEffectiveScale() {
        return this.scaleConfig.getEffectiveScale();
    }

    private double getCellWidth() {
        return this.timelineStyle.getCellWidth();
    }
}

