/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw.header;

import java.time.LocalDate;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimeScaleConfigData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.data.WeekConfigData;
import net.sourceforge.plantuml.project.draw.header.TimeHeader;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.SName;

class TimeHeaderSimple
extends TimeHeader {
    private int delta = 0;

    public TimeHeaderSimple(TimeScale timeScale, WeekConfigData weekConfigData, DayCalendarData dayCalendar, TimeBoundsData timeBounds, TimeScaleConfigData scaleConfig, TimelineStyleData timelineStyle) {
        super(timeScale, weekConfigData, dayCalendar, timeBounds, scaleConfig, timelineStyle);
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeDay();
        return h + 6.0;
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeDay();
        return h + 6.0;
    }

    private double getHeaderNameDayHeight() {
        return 0.0;
    }

    private TimePoint increment(TimePoint day) {
        if (this.delta == 0) {
            this.initDelta(day);
        }
        for (int i = 0; i < this.delta; ++i) {
            day = day.increment(this.scaleConfig.getPrintScale());
        }
        return day;
    }

    private LocalDate increment(LocalDate day) {
        if (this.delta == 0) {
            this.initDelta(day);
        }
        for (int i = 0; i < this.delta; ++i) {
            day = this.increment(day, this.scaleConfig.getPrintScale());
        }
        return day;
    }

    private LocalDate increment(LocalDate day, PrintScale printScale) {
        if (printScale == PrintScale.WEEKLY) {
            return day.plusDays(7L);
        }
        return day.plusDays(1L);
    }

    private void initDelta(LocalDate day) {
        if (this.scaleConfig.getPrintScale() == PrintScale.DAILY) {
            double x1 = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(day));
            do {
                ++this.delta;
                day = day.plusDays(1L);
            } while (this.getTimeScale().getPosition(TimePoint.ofStartOfDay(day)) < x1 + 16.0);
        } else {
            this.delta = 1;
        }
    }

    private void initDelta(TimePoint day) {
        if (this.scaleConfig.getPrintScale() == PrintScale.DAILY) {
            double x1 = this.getTimeScale().getPosition(day);
            do {
                ++this.delta;
                day = day.increment();
            } while (this.getTimeScale().getPosition(day) < x1 + 16.0);
        } else {
            this.delta = 1;
        }
    }

    private void drawSmallVlinesDay(UGraphic ug, double totalHeightWithoutFooter) {
        ug = ug.apply(this.getLineColor());
        ug = ug.apply(UTranslate.dy(6.0));
        ULine vbar = ULine.vline(totalHeightWithoutFooter + 2.0);
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay().plusDays(1L)) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = this.getTimeScale().getPosition(wink);
            ug.apply(UTranslate.dx(x1)).draw(vbar);
            day = this.increment(day);
        }
    }

    private void drawSimpleDayCounter(UGraphic ug) {
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay().plusDays(1L)) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            int value = this.scaleConfig.getPrintScale() == PrintScale.WEEKLY ? wink.getAbsoluteDayNum() / 7 + 1 : wink.getAbsoluteDayNum() + 1;
            UFont font = this.timelineStyle.getFont(SName.day);
            FontConfiguration fontConfiguration = this.getFontConfiguration(font, false, this.openFontColor());
            TextBlock num = Display.getWithNewlines(this.getPragma(), "" + value).create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = this.getTimeScale().getPosition(wink);
            double x2 = this.scaleConfig.getPrintScale() == PrintScale.WEEKLY ? this.getTimeScale().getPosition(wink.addDays(6)) + this.getTimeScale().getWidth(wink.addDays(6)) : this.getTimeScale().getPosition(this.increment(wink));
            double width = num.calculateDimension(ug.getStringBounder()).getWidth();
            double delta = x2 - x1 - width;
            if (wink.compareTo(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L))) < 0) {
                num.drawU(ug.apply(UTranslate.dx(x1 + delta / 2.0)));
            }
            day = this.increment(day);
        }
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawSmallVlinesDay(ug, totalHeightWithoutFooter);
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.drawSimpleDayCounter(ug);
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawSimpleDayCounter(ug);
    }

    protected final void drawTextsBackground(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight(ug.getStringBounder());
        TimeHeader.Pending pending = null;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = this.getTimeScale().getPosition(wink);
            double x2 = this.getTimeScale().getPosition(wink) + this.getTimeScale().getWidth(wink);
            HColor back = this.getColor(wink);
            if (back == null) {
                if (pending != null) {
                    pending.draw(ug, height);
                }
                pending = null;
            } else {
                if (pending != null && !pending.color.equals(back)) {
                    pending.draw(ug, height);
                    pending = null;
                }
                if (pending == null) {
                    pending = new TimeHeader.Pending(back, x1, x2);
                } else {
                    pending.x2 = x2;
                }
            }
            day = day.plusDays(1L);
        }
    }
}

