/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class ComplementDuration
implements Something<GanttDiagram> {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexConcat(new RegexLeaf(4, "COMPLEMENT" + suffix, "(\\d+)[%s]+(hour|day|week|month)s?(?:[%s]+and[%s]+(\\d+)[%s]+(hour|day|week|month)s?)?"));
    }

    @Override
    public Failable<Load> getMe(GanttDiagram system, RegexResult arg, String suffix) {
        String prefix = "COMPLEMENT" + suffix;
        int firstValue = Integer.parseInt(arg.get(prefix, 0));
        String firstUnit = arg.get(prefix, 1);
        int[] firstDaysAndHours = this.toDaysAndHours(system, firstValue, firstUnit);
        int[] secondDaysAndHours = new int[]{0, 0};
        String secondValue = arg.get(prefix, 2);
        if (secondValue != null) {
            int value = Integer.parseInt(secondValue);
            String unit = arg.get(prefix, 3);
            secondDaysAndHours = this.toDaysAndHours(system, value, unit);
        }
        int totalDays = firstDaysAndHours[0] + secondDaysAndHours[0];
        int totalHours = firstDaysAndHours[1] + secondDaysAndHours[1];
        return Failable.ok(Load.ofDaysAndHours(totalDays, totalHours));
    }

    private int[] toDaysAndHours(GanttDiagram system, int value, String unit) {
        switch (unit.charAt(0)) {
            case 'H': 
            case 'h': {
                return new int[]{0, value};
            }
            case 'D': 
            case 'd': {
                return new int[]{value, 0};
            }
            case 'W': 
            case 'w': {
                return new int[]{value * system.daysInWeek(), 0};
            }
            case 'M': 
            case 'm': {
                return new int[]{value * system.daysInMonth(), 0};
            }
        }
        throw new IllegalArgumentException("unknown time unit: " + unit);
    }
}

