/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.time.LocalDate;
import net.sourceforge.plantuml.project.DaysAsDates;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.DayPattern;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.project.lang.Words;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;

public class ComplementIntervals
implements Something<GanttDiagram> {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexOr(this.toRegexB(suffix), this.toRegexE(suffix));
    }

    private IRegex toRegexB(String suffix) {
        DayPattern dayPattern1 = new DayPattern("1");
        DayPattern dayPattern2 = new DayPattern("2");
        return new RegexConcat(dayPattern1.toRegex(), Words.exactly("to"), Words.zeroOrMore("the"), RegexLeaf.spaceOneOrMore(), dayPattern2.toRegex());
    }

    private IRegex toRegexE(String suffix) {
        return new RegexConcat(new RegexLeaf("[dD]\\+"), new RegexLeaf(1, "ECOUNT1" + suffix, "([\\d]+)"), Words.exactly("to"), Words.zeroOrMore("the"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("[dD]\\+"), new RegexLeaf(1, "ECOUNT2" + suffix, "([\\d]+)"));
    }

    @Override
    public Failable<DaysAsDates> getMe(GanttDiagram project, RegexResult arg, String suffix) {
        LocalDate d1 = new DayPattern("1").getDay(arg);
        if (d1 != null) {
            LocalDate d2 = new DayPattern("2").getDay(arg);
            return Failable.ok(new DaysAsDates(d1, d2));
        }
        if (arg.get("ECOUNT1" + suffix, 0) != null) {
            return Failable.ok(this.resultE(project, arg, suffix));
        }
        throw new IllegalStateException();
    }

    private DaysAsDates resultE(GanttDiagram project, RegexResult arg, String suffix) {
        int day1 = Integer.parseInt(arg.get("ECOUNT1" + suffix, 0));
        TimePoint date1 = project.getMinTimePoint().addDays(day1);
        int day2 = Integer.parseInt(arg.get("ECOUNT2" + suffix, 0));
        TimePoint date2 = project.getMinTimePoint().addDays(day2);
        return new DaysAsDates(date1.toDay(), date2.toDay());
    }
}

