/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm.math;

import java.time.LocalDateTime;
import net.sourceforge.plantuml.project.ngm.math.AbstractPiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.Fraction;
import net.sourceforge.plantuml.project.ngm.math.Segment;
import net.sourceforge.plantuml.project.ngm.math.TimeDirection;

public final class PiecewiseConstantTimeWindow
extends AbstractPiecewiseConstant {
    private final LocalDateTime offBefore;
    private final LocalDateTime offAfter;

    public PiecewiseConstantTimeWindow(LocalDateTime offBefore, LocalDateTime offAfter) {
        this.offBefore = offBefore;
        this.offAfter = offAfter;
        if (!this.offBefore.isBefore(this.offAfter)) {
            throw new IllegalArgumentException("offAfter must be after offBefore");
        }
    }

    @Override
    public Segment segmentAt(LocalDateTime instant, TimeDirection direction) {
        if (direction == TimeDirection.FORWARD) {
            return this.segmentAtForward(instant);
        }
        return this.segmentAtBackward(instant);
    }

    private Segment segmentAtForward(LocalDateTime instant) {
        if (instant.isBefore(this.offBefore)) {
            return Segment.forward(instant, this.offBefore, Fraction.ZERO);
        }
        if (!instant.isBefore(this.offAfter)) {
            return Segment.forward(instant, LocalDateTime.MAX, Fraction.ZERO);
        }
        return Segment.forward(instant, this.offAfter, Fraction.ONE);
    }

    private Segment segmentAtBackward(LocalDateTime instant) {
        if (instant.isAfter(this.offAfter)) {
            return Segment.backward(instant, this.offAfter, Fraction.ZERO);
        }
        if (!instant.isAfter(this.offBefore)) {
            return Segment.backward(instant, LocalDateTime.MIN, Fraction.ZERO);
        }
        return Segment.backward(instant, this.offBefore, Fraction.ONE);
    }
}

