/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.solver;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.PValue;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.ngm.NGMAllocation;
import net.sourceforge.plantuml.project.ngm.NGMTask;
import net.sourceforge.plantuml.project.ngm.NGMTotalEffort;
import net.sourceforge.plantuml.project.time.TimePoint;

public class Solver {
    private final Map<TaskAttribute, PValue> values = new LinkedHashMap<TaskAttribute, PValue>();

    public final void setData(TaskAttribute attribute, PValue value) {
        TimePoint previousInstant;
        if (value instanceof TimePoint && !value.toString().endsWith("T00:00")) {
            throw new IllegalArgumentException(value.toString());
        }
        PValue previous = this.values.remove((Object)attribute);
        if (previous != null && attribute == TaskAttribute.START && (previousInstant = (TimePoint)previous).compareTo((TimePoint)value) > 0) {
            value = previous;
        }
        this.values.put(attribute, value);
        if (this.values.size() > 2) {
            this.removeFirstElement();
        }
        assert (this.values.size() <= 2);
    }

    private void removeFirstElement() {
        Iterator<Map.Entry<TaskAttribute, PValue>> it = this.values.entrySet().iterator();
        it.next();
        it.remove();
    }

    public final PValue getData(NGMAllocation allocation, TaskAttribute attribute) {
        PValue result = this.values.get((Object)attribute);
        if (result == null) {
            if (attribute == TaskAttribute.END) {
                return this.computeEnd(allocation);
            }
            if (attribute == TaskAttribute.START) {
                return this.computeStart(allocation);
            }
            return Load.ofDays(1);
        }
        return result;
    }

    private TimePoint computeEnd(NGMAllocation allocation) {
        TimePoint start = (TimePoint)this.values.get((Object)TaskAttribute.START);
        NGMTotalEffort fullLoad = ((Load)this.values.get((Object)TaskAttribute.LOAD)).getEffort();
        NGMTask task = NGMTask.withFixedTotalEffort(allocation, start.toLocalDateTime(), fullLoad);
        LocalDateTime result = task.getEnd();
        return TimePoint.of(result);
    }

    private TimePoint computeStart(NGMAllocation allocation) {
        TimePoint end = (TimePoint)this.values.get((Object)TaskAttribute.END);
        NGMTotalEffort fullLoad = ((Load)this.values.get((Object)TaskAttribute.LOAD)).getEffort();
        NGMTask task = NGMTask.withFixedTotalEffort(allocation, end.toLocalDateTime(), fullLoad);
        task.setEnd(end.toLocalDateTime());
        LocalDateTime result = task.getStart();
        return TimePoint.of(result);
    }
}

