/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.time;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.temporal.WeekFields;
import java.util.Locale;
import net.sourceforge.plantuml.project.PValue;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.time.MonthUtils;
import net.sourceforge.plantuml.project.time.WeekNumberStrategy;
import net.sourceforge.plantuml.project.time.YearMonthUtils;

public class TimePoint
implements Comparable<TimePoint>,
PValue {
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    private final LocalDateTime utcDateTime;

    public static LocalDate epoch() {
        return Instant.EPOCH.atZone(ZoneOffset.UTC).toLocalDate();
    }

    public static TimePoint ofStartOfDay(int year, String month, int dayOfMonth) {
        return new TimePoint(LocalDateTime.of(year, MonthUtils.fromString(month), dayOfMonth, 0, 0));
    }

    public static TimePoint of(LocalDateTime time) {
        return new TimePoint(time);
    }

    public static TimePoint ofStartOfDay(LocalDate day) {
        return new TimePoint(day.atStartOfDay());
    }

    public static TimePoint ofStartOfDay(int year, int month, int dayOfMonth) {
        return new TimePoint(LocalDateTime.of(year, month, dayOfMonth, 0, 0));
    }

    public static TimePoint ofEndOfDayMinusOneSecond(LocalDate day) {
        return TimePoint.ofStartOfDay(day.plusDays(1L)).minusOneSecond();
    }

    public TimePoint ofEndOfDay() {
        return new TimePoint(this.utcDateTime.toLocalDate().plusDays(1L).atStartOfDay().minusSeconds(1L));
    }

    public static TimePoint create(long ms) {
        return new TimePoint(LocalDateTime.ofInstant(Instant.ofEpochMilli(ms), ZoneOffset.UTC));
    }

    public static TimePoint nowUtc1() {
        return new TimePoint(LocalDateTime.now(ZoneOffset.UTC));
    }

    public static TimePoint todayUtcAtMidnight() {
        return new TimePoint(LocalDate.now(ZoneOffset.UTC).atStartOfDay());
    }

    private TimePoint(LocalDateTime utcDateTime) {
        this.utcDateTime = utcDateTime;
    }

    public LocalDateTime toLocalDateTime() {
        return this.utcDateTime;
    }

    public String toStringShort(Locale locale) {
        return YearMonthUtils.shortName(this.monthYear(), locale) + " " + this.getDayOfMonth();
    }

    public int getWeekOfYear(WeekNumberStrategy strategy) {
        WeekFields wf = WeekFields.of(strategy.getFirstDayOfWeek(), strategy.getMinimalDaysInFirstWeek());
        return this.utcDateTime.toLocalDate().get(wf.weekOfYear());
    }

    public TimePoint increment() {
        return this.addDays(1);
    }

    public TimePoint decrement() {
        return this.addDays(-1);
    }

    public TimePoint addDays(int nday) {
        return new TimePoint(this.utcDateTime.toLocalDate().plusDays(nday).atStartOfDay());
    }

    public final int getAbsoluteDayNum() {
        return (int)Math.floorDiv(this.getMillis(), 86400000L);
    }

    public final long getMillis() {
        return this.utcDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public int year() {
        return this.monthYear().getYear();
    }

    public String toString() {
        return this.utcDateTime.toString();
    }

    public int hashCode() {
        return this.utcDateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != TimePoint.class) {
            return false;
        }
        TimePoint other = (TimePoint)obj;
        return this.utcDateTime.equals(other.utcDateTime);
    }

    @Override
    public int compareTo(TimePoint other) {
        return this.utcDateTime.compareTo(other.utcDateTime);
    }

    public final int getDayOfMonth() {
        return this.utcDateTime.getDayOfMonth();
    }

    public Month month() {
        return this.utcDateTime.getMonth();
    }

    public YearMonth monthYear() {
        return YearMonth.from(this.utcDateTime);
    }

    public DayOfWeek toDayOfWeek() {
        return this.utcDateTime.getDayOfWeek();
    }

    public LocalDate toDay() {
        return this.utcDateTime.toLocalDate();
    }

    public static TimePoint min(TimePoint d1, TimePoint d2) {
        return d1.compareTo(d2) <= 0 ? d1 : d2;
    }

    public static TimePoint max(TimePoint d1, TimePoint d2) {
        return d1.compareTo(d2) >= 0 ? d1 : d2;
    }

    public TimePoint increment(PrintScale printScale) {
        if (printScale == PrintScale.WEEKLY) {
            return this.addDays(7);
        }
        return this.increment();
    }

    public TimePoint roundDayDown() {
        long ms = this.getMillis();
        long floored = Math.floorDiv(ms, 86400000L) * 86400000L;
        return TimePoint.create(floored);
    }

    public TimePoint roundDayUp() {
        long ms = this.getMillis();
        long ceiled = Math.floorDiv(ms + 86400000L - 1L, 86400000L) * 86400000L;
        return TimePoint.create(ceiled);
    }

    public TimePoint minusOneSecond() {
        return new TimePoint(this.utcDateTime.minusSeconds(1L));
    }

    public TimePoint plusOneSecond() {
        return new TimePoint(this.utcDateTime.plusSeconds(1L));
    }

    public TimePoint floorToDay() {
        return new TimePoint(this.utcDateTime.toLocalDate().atStartOfDay());
    }
}

