/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public class TimeScaleWink
implements TimeScale {
    private final double cellWidth;
    private final PrintScale printScale;

    public TimeScaleWink(double size, double scale, PrintScale printScale) {
        this.cellWidth = size * scale;
        this.printScale = printScale;
    }

    @Override
    public double getPosition(TimePoint instant) {
        long wink = instant.getMillis();
        return (double)wink * this.cellWidth / 8.64E7;
    }

    @Override
    public double getWidth(TimePoint instant) {
        return this.cellWidth;
    }

    @Override
    public boolean isBreaking(TimePoint instant) {
        if (this.printScale == PrintScale.WEEKLY) {
            long num = instant.getMillis() / 86400000L;
            return num % 7L == 6L;
        }
        return true;
    }
}

