/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontFactory;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.SaltDictionary;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.Terminator;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementTabBar;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;

public class ElementFactoryTab
extends AbstractElementFactoryComplex {
    public ElementFactoryTab(DataSource dataSource, SaltDictionary dictionary) {
        super(dataSource, dictionary);
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        String header = (String)((Terminated)this.getDataSource().next()).getElement();
        assert (header.startsWith("{/"));
        UFont font = UFontFactory.byDefault(12);
        ElementTabBar result = new ElementTabBar(font, this.getDictionary());
        while (!this.getDataSource().peek(0).getElement().equals("}")) {
            Terminated t = (Terminated)this.getDataSource().next();
            result.addTab((String)t.getElement());
            if (t.getTerminator() != Terminator.NEWLINE) continue;
            result.setVertical(true);
        }
        Terminated next = (Terminated)this.getDataSource().next();
        return new Terminated<Element>(result, next.getTerminator());
    }

    @Override
    public boolean ready() {
        String text = this.getDataSource().peek(0).getElement();
        return text.equals("{/");
    }
}

