/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public enum VisibilityModifier {
    PRIVATE_FIELD('\ueefb', ColorParam.iconPrivate, null),
    PROTECTED_FIELD('\ueefa', ColorParam.iconProtected, null),
    PACKAGE_PRIVATE_FIELD('\ueef9', ColorParam.iconPackage, null),
    PUBLIC_FIELD('\ueef8', ColorParam.iconPublic, null),
    PRIVATE_METHOD('\ueef7', ColorParam.iconPrivate, ColorParam.iconPrivateBackground),
    PROTECTED_METHOD('\ueef6', ColorParam.iconProtected, ColorParam.iconProtectedBackground),
    PACKAGE_PRIVATE_METHOD('\ueef5', ColorParam.iconPackage, ColorParam.iconPackageBackground),
    PUBLIC_METHOD('\ueef4', ColorParam.iconPublic, ColorParam.iconPublicBackground),
    IE_MANDATORY('\ueef3', ColorParam.iconIEMandatory, ColorParam.iconIEMandatory);

    private final ColorParam foregroundParam;
    private final ColorParam backgroundParam;
    private final char unicode;

    public static String regexForVisibilityCharacterInClassName() {
        return "[-#+~]";
    }

    private VisibilityModifier(char unicode, ColorParam foreground, ColorParam background) {
        this.foregroundParam = foreground;
        this.backgroundParam = background;
        this.unicode = unicode;
    }

    public UDrawable getUDrawable(final int size, final HColor foregroundColor, final HColor backgoundColor) {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                VisibilityModifier.this.drawWithGroup(ug, size, foregroundColor, backgoundColor, 0.0, 0.0);
            }
        };
    }

    public TextBlock getUBlock(final int size, final HColor foregroundColor, final HColor backgoundColor, final boolean withInvisibleRectanble) {
        return new AbstractTextBlock(){

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(size + 1, size + 1);
            }

            @Override
            public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
                return null;
            }

            @Override
            public void drawU(UGraphic ug) {
                if (withInvisibleRectanble) {
                    ug.apply(HColors.none()).draw(URectangle.build(size * 2, size));
                }
                VisibilityModifier.this.drawWithGroup(ug, size, foregroundColor, backgoundColor, 0.0, 0.0);
            }
        };
    }

    private void drawWithGroup(UGraphic ug, int size, HColor foregroundColor, HColor backgoundColor, double x, double y) {
        UGroup group = new UGroup();
        group.put(UGroupType.DATA_VISIBILITY_MODIFIER, this.name());
        ug.startGroup(group);
        this.drawInternal(ug, size, foregroundColor, backgoundColor, x, y);
        ug.closeGroup();
    }

    private void drawInternal(UGraphic ug, int size, HColor foregroundColor, HColor backgoundColor, double x, double y) {
        ug = backgoundColor == null ? ug.apply(HColors.none().bg()) : ug.apply(backgoundColor.bg());
        ug = ug.apply(foregroundColor);
        size = VisibilityModifier.ensureEven(size);
        switch (this) {
            case PACKAGE_PRIVATE_FIELD: {
                this.drawTriangle(ug, false, size, x, y);
                break;
            }
            case PRIVATE_FIELD: {
                this.drawSquare(ug, false, size, x, y);
                break;
            }
            case PROTECTED_FIELD: {
                this.drawDiamond(ug, false, size, x, y);
                break;
            }
            case PUBLIC_FIELD: {
                this.drawCircle(ug, false, size, x, y);
                break;
            }
            case PACKAGE_PRIVATE_METHOD: {
                this.drawTriangle(ug, true, size, x, y);
                break;
            }
            case PRIVATE_METHOD: {
                this.drawSquare(ug, true, size, x, y);
                break;
            }
            case PROTECTED_METHOD: {
                this.drawDiamond(ug, true, size, x, y);
                break;
            }
            case PUBLIC_METHOD: {
                this.drawCircle(ug, true, size, x, y);
                break;
            }
            case IE_MANDATORY: {
                this.drawCircle(ug, true, size, x, y);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void drawSquare(UGraphic ug, boolean filled, int size, double x, double y) {
        ug.apply(new UTranslate(x + 2.0, y + 2.0)).draw(URectangle.build(size - 4, size - 4));
    }

    private void drawCircle(UGraphic ug, boolean filled, int size, double x, double y) {
        ug.apply(new UTranslate(x + 2.0, y + 2.0)).draw(UEllipse.build(size - 4, size - 4));
    }

    private static int ensureEven(int n) {
        if (n % 2 == 1) {
            --n;
        }
        return n;
    }

    private void drawDiamond(UGraphic ug, boolean filled, int size, double x, double y) {
        UPolygon poly = new UPolygon();
        poly.addPoint((double)(size -= 2) / 2.0, 0.0);
        poly.addPoint(size, (double)size / 2.0);
        poly.addPoint((double)size / 2.0, size);
        poly.addPoint(0.0, (double)size / 2.0);
        ug.apply(new UTranslate(x + 1.0, y)).draw(poly);
    }

    private void drawTriangle(UGraphic ug, boolean filled, int size, double x, double y) {
        UPolygon poly = new UPolygon();
        poly.addPoint((double)(size -= 2) / 2.0, 1.0);
        poly.addPoint(0.0, size - 1);
        poly.addPoint(size, size - 1);
        ug.apply(new UTranslate(x + 1.0, y)).draw(poly);
    }

    public static boolean isVisibilityCharacter(CharSequence s) {
        if (s.length() <= 2) {
            return false;
        }
        char c = s.charAt(0);
        if (s.charAt(1) == c) {
            return false;
        }
        if (c == '-') {
            return true;
        }
        if (c == '#') {
            return true;
        }
        if (c == '+') {
            return true;
        }
        if (c == '~') {
            return true;
        }
        return c == '*';
    }

    public static VisibilityModifier getByUnicode(char c) {
        for (VisibilityModifier modifier : VisibilityModifier.values()) {
            if (modifier.unicode != c) continue;
            return modifier;
        }
        return null;
    }

    public static String replaceVisibilityModifierByUnicodeChar(String s, boolean isField) {
        VisibilityModifier modifier = VisibilityModifier.getVisibilityModifier(s, isField);
        if (modifier == null) {
            return s;
        }
        return modifier.unicode + s.substring(1);
    }

    public static VisibilityModifier getVisibilityModifier(CharSequence s, boolean isField) {
        if (s.length() <= 2) {
            return null;
        }
        char c = s.charAt(0);
        if (s.charAt(1) == c) {
            return null;
        }
        if (isField) {
            return VisibilityModifier.getVisibilityModifierForField(c);
        }
        return VisibilityModifier.getVisibilityModifierForMethod(c);
    }

    private static VisibilityModifier getVisibilityModifierForField(char c) {
        if (c == '-') {
            return PRIVATE_FIELD;
        }
        if (c == '#') {
            return PROTECTED_FIELD;
        }
        if (c == '+') {
            return PUBLIC_FIELD;
        }
        if (c == '~') {
            return PACKAGE_PRIVATE_FIELD;
        }
        if (c == '*') {
            return IE_MANDATORY;
        }
        return null;
    }

    private static VisibilityModifier getVisibilityModifierForMethod(char c) {
        if (c == '-') {
            return PRIVATE_METHOD;
        }
        if (c == '#') {
            return PROTECTED_METHOD;
        }
        if (c == '+') {
            return PUBLIC_METHOD;
        }
        if (c == '~') {
            return PACKAGE_PRIVATE_METHOD;
        }
        if (c == '*') {
            return IE_MANDATORY;
        }
        return null;
    }

    public final ColorParam getForeground() {
        return this.foregroundParam;
    }

    public final ColorParam getBackground() {
        return this.backgroundParam;
    }

    public String getXmiVisibility() {
        if (this == PUBLIC_FIELD || this == PUBLIC_METHOD) {
            return "public";
        }
        if (this == PRIVATE_FIELD || this == PRIVATE_METHOD) {
            return "private";
        }
        if (this == PROTECTED_FIELD || this == PROTECTED_METHOD) {
            return "protected";
        }
        if (this == PACKAGE_PRIVATE_FIELD || this == PACKAGE_PRIVATE_METHOD) {
            return "package";
        }
        throw new IllegalStateException();
    }

    public boolean isField() {
        return this == PUBLIC_FIELD || this == PRIVATE_FIELD || this == PROTECTED_FIELD || this == PACKAGE_PRIVATE_FIELD;
    }

    public StyleSignatureBasic getStyleSignature() {
        if (this == IE_MANDATORY) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.visibilityIcon, SName.IEMandatory);
        }
        if (this == PUBLIC_FIELD || this == PUBLIC_METHOD) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.visibilityIcon, SName.public_);
        }
        if (this == PRIVATE_FIELD || this == PRIVATE_METHOD) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.visibilityIcon, SName.private_);
        }
        if (this == PROTECTED_FIELD || this == PROTECTED_METHOD) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.visibilityIcon, SName.protected_);
        }
        if (this == PACKAGE_PRIVATE_FIELD || this == PACKAGE_PRIVATE_METHOD) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.visibilityIcon, SName.package_);
        }
        throw new IllegalStateException();
    }
}

