/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stereo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;

public class Stereogroup {
    private static final String KEY = "STEREOGROUP";
    private String definition;
    private static final Pattern pattern = Pattern.compile("<<([^<>]+)>>");

    public static IRegex optionalStereogroup() {
        String regex = "(<<[^<>]+>>(?:[%s]*<<[^<>]+>>)*)";
        return new RegexOptional((IRegex)new RegexLeaf(1, KEY, "(<<[^<>]+>>(?:[%s]*<<[^<>]+>>)*)"));
    }

    public static Stereogroup build(RegexResult arg) {
        String full = arg.get(KEY, 0);
        return new Stereogroup(full);
    }

    public static Stereogroup build(String full) {
        return new Stereogroup(full);
    }

    private Stereogroup(String definition) {
        this.definition = definition;
    }

    public Stereotype buildStereotype() {
        if (this.definition == null) {
            return null;
        }
        return Stereotype.build(this.definition);
    }

    public BoxStyle getBoxStyle() {
        for (String label : this.getLabels()) {
            BoxStyle tmp = BoxStyle.fromString(label);
            if (tmp == BoxStyle.PLAIN) continue;
            return tmp;
        }
        return BoxStyle.PLAIN;
    }

    public List<String> getLabels() {
        if (this.definition == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(this.definition);
        while (matcher.find()) {
            result.add(matcher.group(1).trim());
        }
        return Collections.unmodifiableList(result);
    }

    public Colors getColors(HColorSet colorSet) throws NoSuchColorException {
        for (String label : this.getLabels()) {
            if (!label.startsWith("#")) continue;
            return new Colors(label, colorSet, ColorType.BACK);
        }
        return Colors.empty();
    }
}

