/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sudoku;

import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.atmp.SvgOption;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.eps.EpsStrategy;
import net.sourceforge.plantuml.klimt.drawing.eps.UGraphicEps;
import net.sourceforge.plantuml.klimt.drawing.g2d.UGraphicG2d;
import net.sourceforge.plantuml.klimt.drawing.svg.UGraphicSvg;
import net.sourceforge.plantuml.klimt.drawing.tikz.UGraphicTikz;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontFactory;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.sudoku.ISudoku;

public class GraphicsSudoku {
    private final ISudoku sudoku;
    private final UFont numberFont = UFontFactory.sansSerif(20).bold();
    private final UFont font = UFontFactory.sansSerif(11);
    final StringBounder stringBounder = FileFormat.PNG.getDefaultStringBounder();
    private final int xOffset = 5;
    private final int yOffset = 5;
    private final int cellWidth = 30;
    private final int cellHeight = 32;
    private final int numberxOffset = 10;
    private final int numberyOffset = 5;
    private final int textTotalHeight = 50;
    private final int boldWidth = 3;
    private final int sudoHeight = 301;
    private final int sudoWidth = 283;

    public GraphicsSudoku(ISudoku sudoku) {
        this.sudoku = sudoku;
    }

    public ImageData writeImageEps(OutputStream os) throws IOException {
        UGraphicEps ug = new UGraphicEps(HColors.WHITE, ColorMapper.IDENTITY, FileFormat.EPS_TEXT.getDefaultStringBounder(), EpsStrategy.WITH_MACRO_AND_TEXT);
        this.drawInternal(ug);
        os.write(ug.getEPSCode().getBytes());
        return ImageDataSimple.ok();
    }

    public ImageData writeImageLatex(OutputStream os, FileFormat fileFormat) throws IOException {
        UGraphicTikz ug = new UGraphicTikz(HColors.WHITE, ColorMapper.IDENTITY, FileFormat.LATEX.getDefaultStringBounder(), 1.0, fileFormat == FileFormat.LATEX, null);
        this.drawInternal(ug);
        ug.writeToStream(os, null, -1);
        return ImageDataSimple.ok();
    }

    public ImageData writeImageSvg(OutputStream os) throws IOException {
        SvgOption option = SvgOption.basic().withBackcolor(HColors.WHITE);
        UGraphicSvg ug = UGraphicSvg.build(option, false, 0L, FileFormat.SVG.getDefaultStringBounder());
        this.drawInternal(ug);
        ug.writeToStream(os, null, -1);
        return ImageDataSimple.ok();
    }

    public ImageData writeImagePng(OutputStream os) throws IOException {
        EmptyImageBuilder builder = new EmptyImageBuilder(null, 283, 351, XColor.WHITE, this.stringBounder);
        PortableImage im = builder.getPortableImage();
        Graphics2D g3d = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(HColors.WHITE, ColorMapper.IDENTITY, this.stringBounder, g3d, 1.0, FileFormat.PNG);
        this.drawInternal(ug);
        g3d.dispose();
        PngIO.write(im, ColorMapper.IDENTITY, os, null, 96);
        return new ImageDataSimple(im.getWidth(), im.getHeight());
    }

    public void drawInternal(UGraphic ug) {
        int w;
        boolean bold;
        int i;
        ug = ug.apply(new UTranslate(5.0, 5.0));
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                int num = this.sudoku.getGiven(x, y);
                if (num <= 0) continue;
                TextBlock text = Display.create("" + num).create(FontConfiguration.blackBlueTrue(this.numberFont), HorizontalAlignment.CENTER, new SpriteContainerEmpty());
                text.drawU(ug.apply(new UTranslate(10 + x * 30, 5 + y * 32)));
            }
        }
        ug = ug.apply(HColors.BLACK.bg()).apply(HColors.none());
        for (i = 0; i < 10; ++i) {
            bold = i % 3 == 0;
            w = bold ? 3 : 1;
            ug.apply(UTranslate.dy(i * 32)).draw(URectangle.build(273.0, w));
        }
        for (i = 0; i < 10; ++i) {
            bold = i % 3 == 0;
            w = bold ? 3 : 1;
            ug.apply(UTranslate.dx(i * 30)).draw(URectangle.build(w, 291.0));
        }
        ug = ug.apply(UTranslate.dy(301.0));
        ArrayList<Object> texts = new ArrayList<Object>();
        texts.add("https://plantuml.com");
        texts.add("Seed " + Long.toString(this.sudoku.getSeed(), 36));
        texts.add("Difficulty " + this.sudoku.getRatting());
        TextBlock textBlock = Display.create(texts).create(FontConfiguration.blackBlueTrue(this.font), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        textBlock.drawU(ug);
    }
}

