/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.List;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPosition;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.Together;
import net.sourceforge.plantuml.cruise.XNode;
import net.sourceforge.plantuml.klimt.Shadowable;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.RectangleArea;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Kal;
import net.sourceforge.plantuml.svek.LineOfSegments;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.PortGeometry;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import net.sourceforge.plantuml.svek.image.EntityImagePort;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.utils.Direction;

public class SvekNode
implements XNode {
    private final ShapeType type;
    private XDimension2D dimImage;
    private final String uid;
    private final int color;
    private double minX;
    private double minY;
    private Margins shield;
    private final EntityPosition entityPosition;
    private final IEntityImage image;
    private final StringBounder stringBounder;
    private Cluster cluster;
    private final Entity leaf;
    private Shadowable polygon;

    public EntityPosition getEntityPosition() {
        return this.entityPosition;
    }

    public final Cluster getCluster() {
        return this.cluster;
    }

    public final void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String toString() {
        return super.toString() + " " + String.valueOf(this.image) + " " + String.valueOf((Object)this.type);
    }

    public final Together getTogether() {
        if (this.leaf == null) {
            return null;
        }
        return this.leaf.getTogether();
    }

    SvekNode(Entity ent, IEntityImage image, ColorSequence colorSequence, StringBounder stringBounder) {
        this.stringBounder = stringBounder;
        this.entityPosition = ent.getEntityPosition();
        this.image = image;
        this.type = image.getShapeType();
        this.color = colorSequence.getValue();
        this.uid = String.format("sh%04d", this.color);
        this.leaf = ent;
    }

    private XDimension2D getDimImage() {
        if (this.dimImage == null) {
            this.dimImage = this.image.calculateDimension(this.stringBounder);
        }
        return this.dimImage;
    }

    public final ShapeType getType() {
        return this.type;
    }

    public final double getWidth() {
        return this.getDimImage().getWidth();
    }

    public final double getHeight() {
        return this.getDimImage().getHeight();
    }

    public void appendShape(StringBuilder sb, StringBounder stringBounder) {
        if (this.type == ShapeType.RECTANGLE_HTML_FOR_PORTS) {
            this.appendLabelHtmlSpecialForLink(sb, stringBounder);
            SvekUtils.println(sb);
            return;
        }
        if (this.type == ShapeType.RECTANGLE_PORT) {
            this.appendLabelHtmlSpecialForPort(sb, stringBounder);
            SvekUtils.println(sb);
            return;
        }
        if (this.type == ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE) {
            this.appendHtml(sb);
            SvekUtils.println(sb);
            return;
        }
        if (this.type == ShapeType.RECTANGLE && this.isShielded()) {
            this.appendHtml(sb);
            SvekUtils.println(sb);
            return;
        }
        sb.append(this.uid);
        sb.append(" [");
        this.appendShapeInternal(sb);
        sb.append(",");
        sb.append("label=\"\"");
        sb.append(",");
        sb.append("width=" + SvekUtils.pixelToInches(this.getWidth()));
        sb.append(",");
        sb.append("height=" + SvekUtils.pixelToInches(this.getHeight()));
        sb.append(",");
        sb.append("color=\"" + XColor.toHexRGBColor(this.color) + "\"");
        sb.append("];");
        SvekUtils.println(sb);
    }

    private double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        if (this.image instanceof EntityImagePort) {
            EntityImagePort im = (EntityImagePort)this.image;
            return im.getMaxWidthFromLabelForEntryExit(stringBounder);
        }
        if (this.image instanceof EntityImageStateBorder) {
            EntityImageStateBorder im = (EntityImageStateBorder)this.image;
            return im.getMaxWidthFromLabelForEntryExit(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private void appendLabelHtmlSpecialForPort(StringBuilder sb, StringBounder stringBounder) {
        int width1 = (int)this.getWidth();
        int width2 = (int)this.getMaxWidthFromLabelForEntryExit(stringBounder);
        if (width2 > 40) {
            this.appendLabelHtmlSpecialForPortHtml(sb, stringBounder, width2 - 40);
        } else {
            this.appendLabelHtmlSpecialForPortBasic(sb, stringBounder);
        }
    }

    private void appendLabelHtmlSpecialForPortHtml(StringBuilder sb, StringBounder stringBounder, int fullWidth) {
        if (fullWidth < 10) {
            fullWidth = 10;
        }
        sb.append(this.uid);
        sb.append(" [");
        sb.append("shape=plaintext");
        sb.append(",");
        sb.append("label=<");
        sb.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        sb.append("<TR><TD WIDTH=\"" + fullWidth + "\" HEIGHT=\"1\" COLSPAN=\"3\"></TD></TR>");
        sb.append("<TR><TD></TD><TD FIXEDSIZE=\"TRUE\" PORT=\"P\"  BORDER=\"1\" COLOR=\"" + XColor.toHexRGBColor(this.color) + "\" WIDTH=\"" + (int)this.getWidth() + "\" HEIGHT=\"" + (int)this.getHeight() + "\"></TD><TD></TD></TR>");
        sb.append("<TR><TD WIDTH=\"" + fullWidth + "\" HEIGHT=\"1\" COLSPAN=\"3\"></TD></TR>");
        sb.append("</TABLE>");
        sb.append(">];");
    }

    private void appendLabelHtmlSpecialForPortBasic(StringBuilder sb, StringBounder stringBounder) {
        sb.append(this.uid);
        sb.append(" [");
        sb.append("shape=rect");
        sb.append(",");
        sb.append("label=\"\"");
        sb.append(",");
        sb.append("width=" + SvekUtils.pixelToInches(this.getWidth()));
        sb.append(",");
        sb.append("height=" + SvekUtils.pixelToInches(this.getHeight()));
        sb.append(",");
        sb.append("color=\"" + XColor.toHexRGBColor(this.color) + "\"");
        sb.append("];");
    }

    private Margins shield() {
        if (this.shield == null) {
            this.shield = this.image.getShield(this.stringBounder);
            if (!this.shield.isZero() && this.type != ShapeType.RECTANGLE && this.type != ShapeType.RECTANGLE_HTML_FOR_PORTS && this.type != ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE) {
                throw new IllegalStateException();
            }
        }
        return this.shield;
    }

    private void appendHtml(StringBuilder sb) {
        sb.append(this.uid);
        sb.append(" [");
        sb.append("shape=plaintext,");
        sb.append("label=<");
        this.appendLabelHtml(sb);
        sb.append(">");
        sb.append("];");
        SvekUtils.println(sb);
    }

    private void appendLabelHtml(StringBuilder sb) {
        sb.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        sb.append("<TR>");
        this.appendTd(sb);
        this.appendTd(sb, 1.0, this.shield().getY1());
        this.appendTd(sb);
        sb.append("</TR>");
        sb.append("<TR>");
        this.appendTd(sb, this.shield().getX1(), 1.0);
        sb.append("<TD BGCOLOR=\"" + XColor.toHexRGBColor(this.color) + "\"");
        sb.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + this.getWidth() + "\" HEIGHT=\"" + this.getHeight() + "\"");
        sb.append(" PORT=\"h\">");
        sb.append("</TD>");
        this.appendTd(sb, this.shield().getX2(), 1.0);
        sb.append("</TR>");
        sb.append("<TR>");
        this.appendTd(sb);
        this.appendTd(sb, 1.0, this.shield().getY2());
        this.appendTd(sb);
        sb.append("</TR>");
        sb.append("</TABLE>");
    }

    private void appendLabelHtmlSpecialForLink(StringBuilder sb, StringBounder stringBounder) {
        Ports ports = ((WithPorts)((Object)this.image)).getPorts(stringBounder);
        sb.append(this.uid);
        sb.append(" [");
        sb.append("shape=plaintext,");
        sb.append("label=<");
        sb.append("<TABLE BGCOLOR=\"" + XColor.toHexRGBColor(this.color) + "\" BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        int sum = 0;
        for (PortGeometry geom : ports.getAllPortGeometry()) {
            String portId = geom.getId();
            int missing = (int)(geom.getPosition() - (double)sum);
            sum += missing;
            this.appendTr(sb, null, missing);
            int intHeight = (int)geom.getHeight();
            this.appendTr(sb, portId, intHeight);
            sum += intHeight;
        }
        double diff = this.getHeight() - (double)sum;
        this.appendTr(sb, null, (int)diff);
        sb.append("</TABLE>");
        sb.append(">");
        sb.append("];");
        SvekUtils.println(sb);
    }

    private void appendTr(StringBuilder sb, String portId, int height) {
        if (height <= 0) {
            return;
        }
        sb.append("<TR>");
        sb.append("<TD ");
        sb.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + this.getWidth() + "\" HEIGHT=\"" + height + "\"");
        if (portId != null) {
            sb.append(" PORT=\"" + portId + "\"");
        }
        sb.append(">");
        sb.append("</TD>");
        sb.append("</TR>");
    }

    private void appendTd(StringBuilder sb, double w, double h) {
        sb.append("<TD");
        sb.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + w + "\" HEIGHT=\"" + h + "\"");
        sb.append(">");
        sb.append("</TD>");
    }

    private void appendTd(StringBuilder sb) {
        sb.append("<TD>");
        sb.append("</TD>");
    }

    private void appendShapeInternal(StringBuilder sb) {
        if (this.type == ShapeType.RECTANGLE && this.isShielded()) {
            throw new UnsupportedOperationException();
        }
        if (this.type == ShapeType.RECTANGLE || this.type == ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE || this.type == ShapeType.FOLDER) {
            sb.append("shape=rect");
        } else {
            if (this.type == ShapeType.RECTANGLE_HTML_FOR_PORTS) {
                throw new UnsupportedOperationException();
            }
            if (this.type == ShapeType.OCTAGON) {
                sb.append("shape=octagon");
            } else if (this.type == ShapeType.HEXAGON) {
                sb.append("shape=hexagon");
            } else if (this.type == ShapeType.DIAMOND) {
                sb.append("shape=diamond");
            } else if (this.type == ShapeType.CIRCLE) {
                sb.append("shape=circle");
            } else if (this.type == ShapeType.OVAL) {
                sb.append("shape=ellipse");
            } else if (this.type == ShapeType.ROUND_RECTANGLE) {
                sb.append("shape=rect,style=rounded");
            } else {
                throw new IllegalStateException(this.type.toString());
            }
        }
    }

    public final String getUid() {
        if (this.uid == null) {
            throw new IllegalStateException();
        }
        return this.uid;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public IEntityImage getImage() {
        return this.image;
    }

    @Override
    public XPoint2D getPosition() {
        return new XPoint2D(this.minX, this.minY);
    }

    @Override
    public XDimension2D getSize() {
        return this.getDimImage();
    }

    public RectangleArea getRectangleArea() {
        return new RectangleArea(this.minX, this.minY, this.minX + this.getWidth(), this.minY + this.getHeight());
    }

    public boolean isShielded() {
        for (Link link : this.leaf.getDiagram().getLinks()) {
            if ((this.leaf != link.getEntity1() || !link.hasKal1()) && (this.leaf != link.getEntity2() || !link.hasKal2())) continue;
            return true;
        }
        return !this.shield().isZero();
    }

    public void resetMove() {
        this.minX = 0.0;
        this.minY = 0.0;
    }

    @Override
    public void moveDelta(double deltaX, double deltaY) {
        this.minX += deltaX;
        this.minY += deltaY;
    }

    @Override
    public boolean isHidden() {
        return this.image.isHidden();
    }

    public void setPolygon(double minX, double minY, List<XPoint2D> points) {
        this.polygon = new UPolygon(points).translate(-minX, -minY);
    }

    public Shadowable getPolygon() {
        return this.polygon;
    }

    public XPoint2D getPoint2D(double x, double y) {
        return new XPoint2D(this.minX + x, this.minY + y);
    }

    public double getOverscanX(StringBounder stringBounder) {
        return this.image.getOverscanX(stringBounder);
    }

    public void addImpact(double angle) {
        ((EntityImageLollipopInterface)this.image).addImpact(angle);
    }

    public void drawKals(UGraphic ug) {
        if (!(this.leaf instanceof Entity)) {
            return;
        }
        this.drawList(ug, this.leaf.getKals(Direction.DOWN));
        this.drawList(ug, this.leaf.getKals(Direction.UP));
        this.drawList(ug, this.leaf.getKals(Direction.LEFT));
        this.drawList(ug, this.leaf.getKals(Direction.RIGHT));
    }

    public void fixOverlap() {
        if (!(this.leaf instanceof Entity)) {
            return;
        }
        this.fixHoverlap(this.leaf.getKals(Direction.DOWN));
        this.fixHoverlap(this.leaf.getKals(Direction.UP));
    }

    private void fixHoverlap(List<Kal> list) {
        LineOfSegments los = new LineOfSegments();
        for (Kal kal : list) {
            los.addSegment(kal.getX1(), kal.getX2());
        }
        double[] res = los.solveOverlaps();
        for (int i = 0; i < list.size(); ++i) {
            Kal kal = list.get(i);
            double diff = res[i] - kal.getX1();
            kal.moveX(diff);
        }
    }

    private void drawList(UGraphic ug, List<Kal> list) {
        for (Kal kal : list) {
            kal.drawU(ug);
        }
    }

    public MagneticBorder getMagneticBorder() {
        return new MagneticBorder(){

            @Override
            public UTranslate getForceAt(StringBounder stringBounder, XPoint2D position) {
                MagneticBorder orig = SvekNode.this.image.getMagneticBorder();
                return orig.getForceAt(stringBounder, position.move(-SvekNode.this.minX, -SvekNode.this.minY));
            }
        };
    }

    public final CharSequence getBestMatch(CharSequence candidate) {
        return this.leaf.getBestMatch(candidate);
    }
}

