/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm;

import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.geom.USegment;
import net.sourceforge.plantuml.klimt.geom.USegmentType;
import net.sourceforge.plantuml.teavm.DriverRectangleTeaVM;
import net.sourceforge.plantuml.teavm.SvgGraphicsTeaVM;

public class DriverPathTeaVM
implements UDriver<UPath, SvgGraphicsTeaVM> {
    private final ClipContainer clipContainer;

    public DriverPathTeaVM(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UPath path, double x, double y, ColorMapper mapper, UParam param, SvgGraphicsTeaVM svg) {
        DriverRectangleTeaVM.applyFillColor(svg, mapper, param);
        DriverRectangleTeaVM.applyStrokeColor(svg, mapper, param);
        svg.setStrokeWidth(param.getStroke().getThickness());
        StringBuilder pathData = new StringBuilder();
        for (USegment seg : path) {
            USegmentType type = seg.getSegmentType();
            double[] coord = seg.getCoord();
            if (type == USegmentType.SEG_MOVETO) {
                pathData.append("M").append(this.format(coord[0] + x)).append(",").append(this.format(coord[1] + y)).append(" ");
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                pathData.append("L").append(this.format(coord[0] + x)).append(",").append(this.format(coord[1] + y)).append(" ");
                continue;
            }
            if (type == USegmentType.SEG_QUADTO) {
                pathData.append("Q").append(this.format(coord[0] + x)).append(",").append(this.format(coord[1] + y)).append(" ").append(this.format(coord[2] + x)).append(",").append(this.format(coord[3] + y)).append(" ");
                continue;
            }
            if (type == USegmentType.SEG_CUBICTO) {
                pathData.append("C").append(this.format(coord[0] + x)).append(",").append(this.format(coord[1] + y)).append(" ").append(this.format(coord[2] + x)).append(",").append(this.format(coord[3] + y)).append(" ").append(this.format(coord[4] + x)).append(",").append(this.format(coord[5] + y)).append(" ");
                continue;
            }
            if (type == USegmentType.SEG_ARCTO) {
                pathData.append("A").append(this.format(coord[0])).append(",").append(this.format(coord[1])).append(" ").append(this.format(coord[2])).append(" ").append(coord[3] == 0.0 ? "0" : "1").append(" ").append(coord[4] == 0.0 ? "0" : "1").append(" ").append(this.format(coord[5] + x)).append(",").append(this.format(coord[6] + y)).append(" ");
                continue;
            }
            if (type != USegmentType.SEG_CLOSE) continue;
            pathData.append("Z ");
        }
        svg.drawPath(pathData.toString().trim());
    }

    private String format(double value) {
        if (value == (double)((int)value)) {
            return String.valueOf((int)value);
        }
        return String.format("%.2f", value).replace(',', '.');
    }
}

