/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.teavm.SvgGraphicsTeaVM;

public class DriverTextTeaVM
implements UDriver<UText, SvgGraphicsTeaVM> {
    private final ClipContainer clipContainer;

    public DriverTextTeaVM(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphicsTeaVM svg) {
        HColor back;
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        if (fontConfiguration.getColor().isTransparent()) {
            return;
        }
        UFont font = fontConfiguration.getFont();
        String color = fontConfiguration.getColor().toSvg(mapper);
        svg.setFillColor(color);
        String fontFamily = font.getFamily(null, null);
        int fontSize = font.getSize();
        String fontWeight = null;
        if (fontConfiguration.containsStyle(FontStyle.BOLD) || font.isBold()) {
            fontWeight = "bold";
        }
        String fontStyle = null;
        if (fontConfiguration.containsStyle(FontStyle.ITALIC) || font.isItalic()) {
            fontStyle = "italic";
        }
        ExtraLines extraLines = new ExtraLines();
        StringBuilder decorations = new StringBuilder();
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE) && fontConfiguration.getUnderlineStroke().getThickness() > 0.0) {
            if (fontConfiguration.getExtendedColor() == null) {
                decorations.append("underline ");
            } else {
                extraLines.add(fontConfiguration.getExtendedColor(), font.getSize2D() / 14.0);
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            if (fontConfiguration.getExtendedColor() == null) {
                decorations.append("line-through ");
            } else {
                extraLines.add(fontConfiguration.getExtendedColor(), -font.getSize2D() / 4.0);
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            decorations.append("wavy underline ");
        }
        String textDecoration = decorations.length() > 0 ? decorations.toString().trim() : null;
        String backColor = null;
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR) && (back = fontConfiguration.getExtendedColor()) != null && !(back instanceof HColorGradient)) {
            backColor = back.toRGB(mapper);
        }
        svg.drawText(shape.getText(), x, y, fontFamily, fontSize, fontWeight, fontStyle, textDecoration, backColor);
        double width = SvgGraphicsTeaVM.getTextWidth(shape.getText(), fontFamily, fontSize);
        extraLines.drawAll(x, y, width, font, mapper, svg);
    }

    static class ExtraLines {
        private final List<HColor> colors = new ArrayList<HColor>();
        private final List<Double> deltaYs = new ArrayList<Double>();

        ExtraLines() {
        }

        void add(HColor color, double deltaY) {
            this.colors.add(color);
            this.deltaYs.add(deltaY);
        }

        void drawAll(double x, double y, double width, UFont font, ColorMapper mapper, SvgGraphicsTeaVM svg) {
            for (int i = 0; i < this.colors.size(); ++i) {
                svg.setStrokeColor(this.colors.get(i).toSvg(mapper));
                svg.setStrokeWidth(font.getSize2D() / 28.0);
                svg.drawLine(x, y + this.deltaYs.get(i), x + width, y + this.deltaYs.get(i));
            }
        }
    }
}

