/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.xmi.XmiClassDiagramArgo;
import net.sourceforge.plantuml.xmi.XmiClassDiagramCustom;
import net.sourceforge.plantuml.xmi.XmiClassDiagramScript;
import net.sourceforge.plantuml.xmi.XmiClassDiagramStandard;
import net.sourceforge.plantuml.xmi.XmiClassDiagramStar;
import net.sourceforge.plantuml.xmi.XmiCucaDiagramCustom;
import net.sourceforge.plantuml.xmi.XmiDescriptionDiagramCustom;
import net.sourceforge.plantuml.xmi.XmiDescriptionDiagramScript;
import net.sourceforge.plantuml.xmi.XmiDescriptionDiagramStandard;
import net.sourceforge.plantuml.xmi.XmiStateDiagram;
import net.sourceforge.plantuml.xmi.XmiStateDiagramCustom;
import net.sourceforge.plantuml.xmi.XmlDiagramTransformer;

public final class CucaDiagramXmiMaker {
    private final CucaDiagram diagram;
    private final FileFormat fileFormat;

    public CucaDiagramXmiMaker(CucaDiagram diagram, FileFormat fileFormat) throws IOException {
        this.diagram = diagram;
        this.fileFormat = fileFormat;
    }

    public static String getModel(UmlDiagram classDiagram) {
        return "model1";
    }

    public void createFiles(OutputStream fos) throws IOException {
        try {
            XmlDiagramTransformer xmi;
            if (this.diagram instanceof StateDiagram) {
                xmi = this.createStateDiagram();
            } else if (this.diagram instanceof DescriptionDiagram) {
                xmi = this.createDescriptionDiagram();
            } else if (this.diagram instanceof ClassDiagram) {
                xmi = this.createClassDiagram();
            } else {
                throw new UnsupportedOperationException("Diagram type " + String.valueOf((Object)this.diagram.getUmlDiagramType()) + " is not supported in XMI");
            }
            xmi.transformerXml(fos);
        }
        catch (ParserConfigurationException e) {
            Log.error(e.toString());
            Logme.error(e);
            throw new IOException(e.toString());
        }
        catch (TransformerException e) {
            Log.error(e.toString());
            Logme.error(e);
            throw new IOException(e.toString());
        }
    }

    private XmlDiagramTransformer createStateDiagram() throws ParserConfigurationException {
        if (this.fileFormat == FileFormat.XMI_CUSTOM) {
            return new XmiCucaDiagramCustom<XmiStateDiagramCustom>(XmiStateDiagramCustom.class, this.diagram);
        }
        return new XmiStateDiagram((StateDiagram)this.diagram);
    }

    private XmlDiagramTransformer createClassDiagram() throws ParserConfigurationException {
        if (this.fileFormat == FileFormat.XMI_STANDARD) {
            return new XmiClassDiagramStandard((ClassDiagram)this.diagram);
        }
        if (this.fileFormat == FileFormat.XMI_ARGO) {
            return new XmiClassDiagramArgo((ClassDiagram)this.diagram);
        }
        if (this.fileFormat == FileFormat.XMI_SCRIPT) {
            return new XmiClassDiagramScript((ClassDiagram)this.diagram);
        }
        if (this.fileFormat == FileFormat.XMI_STAR) {
            return new XmiClassDiagramStar((ClassDiagram)this.diagram);
        }
        if (this.fileFormat == FileFormat.XMI_CUSTOM) {
            return new XmiCucaDiagramCustom<XmiClassDiagramCustom>(XmiClassDiagramCustom.class, this.diagram);
        }
        throw new UnsupportedOperationException();
    }

    private XmlDiagramTransformer createDescriptionDiagram() throws ParserConfigurationException {
        if (this.fileFormat == FileFormat.XMI_SCRIPT) {
            return new XmiDescriptionDiagramScript((DescriptionDiagram)this.diagram);
        }
        if (this.fileFormat == FileFormat.XMI_CUSTOM) {
            return new XmiCucaDiagramCustom<XmiDescriptionDiagramCustom>(XmiDescriptionDiagramCustom.class, this.diagram);
        }
        return new XmiDescriptionDiagramStandard((DescriptionDiagram)this.diagram);
    }
}

