# _build_config.py.in is converted into _build_config.py during the meson build process.

from __future__ import annotations


def build_config() -> dict[str, str]:
    """
    Return a dictionary containing build configuration settings.

    All dictionary keys and values are strings, for example ``False`` is
    returned as ``"False"``.

        .. versionadded:: 1.1.0
    """
    return dict(
        # Python settings
        python_version="3.12",
        python_install_dir=r"/data/data/com.termux/files/usr/lib/python3/dist-packages/",
        python_path=r"/home/runner/.termux-build/python3.12-crossenv-prefix-bionic-aarch64/cross/bin/python",

        # Package versions
        contourpy_version="1.3.3",
        meson_version="1.10.0",
        mesonpy_version="0.15.0",
        pybind11_version="3.0.1",

        # Misc meson settings
        meson_backend="ninja",
        build_dir=r"/home/runner/.termux-build/python-contourpy/build/lib/contourpy/util",
        source_dir=r"/home/runner/.termux-build/python-contourpy/src/lib/contourpy/util",
        cross_build="True",

        # Build options
        build_options=r"-Dprefix=/data/data/com.termux/files/usr -Dincludedir=include -Dlibdir=lib -Dbuildtype=release -Dstrip=True -Db_ndebug=if-release -Db_vscrt=md --cross-file=/home/runner/.termux-build/python-contourpy/tmp/meson-crossfile-aarch64.txt --cross-file=/home/runner/.termux-build/python-contourpy/tmp/wheel-cross-file.txt --native-file=/home/runner/.termux-build/python-contourpy/build/meson-python-native-file.ini",
        buildtype="release",
        cpp_std="c++17",
        debug="False",
        optimization="3",
        vsenv="False",
        b_ndebug="if-release",
        b_vscrt="from_buildtype",

        # C++ compiler
        compiler_name="clang",
        compiler_version="21.0.0",
        linker_id="ld.lld",
        compile_command="aarch64-linux-android-clang++",

        # Host machine
        host_cpu="aarch64",
        host_cpu_family="aarch64",
        host_cpu_endian="little",
        host_cpu_system="android",

        # Build machine, same as host machine if not a cross_build
        build_cpu="x86_64",
        build_cpu_family="x86_64",
        build_cpu_endian="little",
        build_cpu_system="linux",
    )
