
use builtin;
use str;

set edit:completion:arg-completer[tinymist] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'tinymist'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'tinymist'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand probe 'Probe existence (Nop run)'
            cand lsp 'Run language server'
            cand dap 'Run debug adapter'
            cand trace-lsp 'Run language server for tracing some typst program'
            cand query 'Run language query'
            cand preview 'Run preview server'
            cand compile 'Run compile command like `typst-cli compile`'
            cand completion 'Generate completion script to stdout'
            cand generate-script 'Generate build script for compilation'
            cand doc 'Run documents'
            cand task 'Run tasks'
            cand cov 'Execute a document and collect coverage'
            cand test 'Test a document and give summary'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tinymist;probe'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tinymist;lsp'= {
            cand --mirror 'Mirror the stdin to the file'
            cand --replay 'Replay input from the file'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;dap'= {
            cand --mirror 'Mirror the stdin to the file'
            cand --replay 'Replay input from the file'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;trace-lsp'= {
            cand --rpc-kind 'rpc-kind'
            cand --mirror 'Mirror the stdin to the file'
            cand --replay 'Replay input from the file'
            cand --root 'Configure the project root (for absolute paths)'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --pdf-standard 'Specify the PDF standards that Typst will enforce conformance with'
            cand --ppi 'Specify the PPI (pixels per inch) to use for PNG export'
            cand --features 'Enable in-development features that may be changed or removed at any time'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --creation-timestamp 'Configure the document''s creation date formatted as a UNIX timestamp (in seconds)'
            cand --cert 'Specify the path to CA certificate file for network access, especially for downloading typst packages'
            cand --persist 'persist'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand --no-pdf-tags 'By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;query'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand lsif 'Get the lsif for a specific package'
            cand packageDocs 'Get the documentation for a specific package'
            cand checkPackage 'Check a specific package'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tinymist;query;lsif'= {
            cand --root 'Configure the project root (for absolute paths)'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --pdf-standard 'Specify the PDF standards that Typst will enforce conformance with'
            cand --ppi 'Specify the PPI (pixels per inch) to use for PNG export'
            cand --features 'Enable in-development features that may be changed or removed at any time'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --creation-timestamp 'Configure the document''s creation date formatted as a UNIX timestamp (in seconds)'
            cand --cert 'Specify the path to CA certificate file for network access, especially for downloading typst packages'
            cand --path 'The path of the package to request lsif for'
            cand --id 'The package of the package to request lsif for'
            cand -o 'The output path for the requested lsif'
            cand --output 'The output path for the requested lsif'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand --no-pdf-tags 'By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;query;packageDocs'= {
            cand --root 'Configure the project root (for absolute paths)'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --pdf-standard 'Specify the PDF standards that Typst will enforce conformance with'
            cand --ppi 'Specify the PPI (pixels per inch) to use for PNG export'
            cand --features 'Enable in-development features that may be changed or removed at any time'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --creation-timestamp 'Configure the document''s creation date formatted as a UNIX timestamp (in seconds)'
            cand --cert 'Specify the path to CA certificate file for network access, especially for downloading typst packages'
            cand --path 'The path of the package to request docs for'
            cand --id 'The package of the package to request docs for'
            cand -o 'The output path for the requested docs'
            cand --output 'The output path for the requested docs'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand --no-pdf-tags 'By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;query;checkPackage'= {
            cand --root 'Configure the project root (for absolute paths)'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --pdf-standard 'Specify the PDF standards that Typst will enforce conformance with'
            cand --ppi 'Specify the PPI (pixels per inch) to use for PNG export'
            cand --features 'Enable in-development features that may be changed or removed at any time'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --creation-timestamp 'Configure the document''s creation date formatted as a UNIX timestamp (in seconds)'
            cand --cert 'Specify the path to CA certificate file for network access, especially for downloading typst packages'
            cand --path 'The path of the package to request docs for'
            cand --id 'The package of the package to request docs for'
            cand -o 'The output path for the requested docs'
            cand --output 'The output path for the requested docs'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand --no-pdf-tags 'By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;query;help'= {
            cand lsif 'Get the lsif for a specific package'
            cand packageDocs 'Get the documentation for a specific package'
            cand checkPackage 'Check a specific package'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tinymist;query;help;lsif'= {
        }
        &'tinymist;query;help;packageDocs'= {
        }
        &'tinymist;query;help;checkPackage'= {
        }
        &'tinymist;query;help;help'= {
        }
        &'tinymist;preview'= {
            cand --preview-mode 'Configure the preview mode'
            cand --partial-rendering 'Only render visible part of the document'
            cand --invert-colors 'Configure the way to invert colors of the preview'
            cand --refresh-style 'Used by lsp for controlling the preview refresh style'
            cand --root 'Configure the project root (for absolute paths)'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --pdf-standard 'Specify the PDF standards that Typst will enforce conformance with'
            cand --ppi 'Specify the PPI (pixels per inch) to use for PNG export'
            cand --features 'Enable in-development features that may be changed or removed at any time'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --creation-timestamp 'Configure the document''s creation date formatted as a UNIX timestamp (in seconds)'
            cand --cert 'Specify the path to CA certificate file for network access, especially for downloading typst packages'
            cand --task-id 'Used by lsp for identifying the task'
            cand --data-plane-host 'Configure the data plane server address'
            cand --control-plane-host 'Configure the control plane server address'
            cand --host '(Deprecated) Configure (File) Host address for the preview server'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand --no-pdf-tags 'By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF'
            cand --not-primary 'Let it not be the primary instance'
            cand --open 'Open the preview in the browser after compilation. If `--no-open` is set, this flag will be ignored'
            cand --no-open 'Don''t open the preview in the browser after compilation. If `--open` is set as well, this flag will win'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;compile'= {
            cand --name 'Give a task name to the document'
            cand --root 'Configure the project root (for absolute paths). If the path is relative, it will be resolved relative to the current working directory (PWD)'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --when 'Configure when to run the task'
            cand -f 'Specify the format of the output file, inferred from the extension by default'
            cand --format 'Specify the format of the output file, inferred from the extension by default'
            cand --pages 'Specify which pages to export. When unspecified, all pages are exported'
            cand --pdf-standard 'Specify the PDF standards that Typst will enforce conformance with'
            cand --ppi 'Specify the PPI (pixels per inch) to use for PNG export'
            cand --lockfile 'Specify the path to the lock file. If the path is set, the lockfile will be saved (--save-lock)'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand --no-pdf-tags 'By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF'
            cand --save-lock 'Save the compilation arguments to the lock file. If `--lockfile` is not set, the lock file will be saved in the cwd'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;completion'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tinymist;generate-script'= {
            cand -o 'The path to the output script'
            cand --output 'The path to the output script'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tinymist;doc'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand new 'Declare a document (project input)'
            cand configure 'Configure document priority in workspace'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tinymist;doc;new'= {
            cand --name 'Give a task name to the document'
            cand --root 'Configure the project root (for absolute paths). If the path is relative, it will be resolved relative to the current working directory (PWD)'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;doc;configure'= {
            cand --name 'Give a task name to the document'
            cand --priority 'Set the unsigned priority of these task (lower numbers are higher priority)'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tinymist;doc;help'= {
            cand new 'Declare a document (project input)'
            cand configure 'Configure document priority in workspace'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tinymist;doc;help;new'= {
        }
        &'tinymist;doc;help;configure'= {
        }
        &'tinymist;doc;help;help'= {
        }
        &'tinymist;task'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand preview 'Declare a preview task'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tinymist;task;preview'= {
            cand --name 'Give a task name to the document'
            cand --root 'Configure the project root (for absolute paths). If the path is relative, it will be resolved relative to the current working directory (PWD)'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --task 'Name a task'
            cand --when 'When to run the task'
            cand --preview-mode 'Configure the preview mode'
            cand --partial-rendering 'Only render visible part of the document'
            cand --invert-colors 'Configure the way to invert colors of the preview'
            cand --refresh-style 'Used by lsp for controlling the preview refresh style'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;task;help'= {
            cand preview 'Declare a preview task'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tinymist;task;help;preview'= {
        }
        &'tinymist;task;help;help'= {
        }
        &'tinymist;cov'= {
            cand --root 'Configure the project root (for absolute paths)'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --pdf-standard 'Specify the PDF standards that Typst will enforce conformance with'
            cand --ppi 'Specify the PPI (pixels per inch) to use for PNG export'
            cand --features 'Enable in-development features that may be changed or removed at any time'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --creation-timestamp 'Configure the document''s creation date formatted as a UNIX timestamp (in seconds)'
            cand --cert 'Specify the path to CA certificate file for network access, especially for downloading typst packages'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand --no-pdf-tags 'By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;test'= {
            cand --root 'Configure the project root (for absolute paths)'
            cand --font-path 'Add additional directories that are recursively searched for fonts'
            cand --package-path 'Specify a custom path to local packages, defaults to system-dependent location'
            cand --package-cache-path 'Specify a custom path to package cache, defaults to system-dependent location'
            cand --pdf-standard 'Specify the PDF standards that Typst will enforce conformance with'
            cand --ppi 'Specify the PPI (pixels per inch) to use for PNG export'
            cand --features 'Enable in-development features that may be changed or removed at any time'
            cand --input 'Add a string key-value pair visible through `sys.inputs`'
            cand --creation-timestamp 'Configure the document''s creation date formatted as a UNIX timestamp (in seconds)'
            cand --cert 'Specify the path to CA certificate file for network access, especially for downloading typst packages'
            cand --print-coverage 'Style of printing coverage'
            cand --ignore-system-fonts 'Ensure system fonts won''t be searched, unless explicitly included via `--font-path`'
            cand --no-pdf-tags 'By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF'
            cand --update 'Whether to update the reference images'
            cand --coverage 'Whether to collect coverage'
            cand --watch 'Whether to run in watch mode'
            cand --dashboard 'Whether to render the dashboard'
            cand --no-dashboard 'Whether not to render the dashboard'
            cand --verbose 'Whether to log verbose information'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'tinymist;help'= {
            cand probe 'Probe existence (Nop run)'
            cand lsp 'Run language server'
            cand dap 'Run debug adapter'
            cand trace-lsp 'Run language server for tracing some typst program'
            cand query 'Run language query'
            cand preview 'Run preview server'
            cand compile 'Run compile command like `typst-cli compile`'
            cand completion 'Generate completion script to stdout'
            cand generate-script 'Generate build script for compilation'
            cand doc 'Run documents'
            cand task 'Run tasks'
            cand cov 'Execute a document and collect coverage'
            cand test 'Test a document and give summary'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tinymist;help;probe'= {
        }
        &'tinymist;help;lsp'= {
        }
        &'tinymist;help;dap'= {
        }
        &'tinymist;help;trace-lsp'= {
        }
        &'tinymist;help;query'= {
            cand lsif 'Get the lsif for a specific package'
            cand packageDocs 'Get the documentation for a specific package'
            cand checkPackage 'Check a specific package'
        }
        &'tinymist;help;query;lsif'= {
        }
        &'tinymist;help;query;packageDocs'= {
        }
        &'tinymist;help;query;checkPackage'= {
        }
        &'tinymist;help;preview'= {
        }
        &'tinymist;help;compile'= {
        }
        &'tinymist;help;completion'= {
        }
        &'tinymist;help;generate-script'= {
        }
        &'tinymist;help;doc'= {
            cand new 'Declare a document (project input)'
            cand configure 'Configure document priority in workspace'
        }
        &'tinymist;help;doc;new'= {
        }
        &'tinymist;help;doc;configure'= {
        }
        &'tinymist;help;task'= {
            cand preview 'Declare a preview task'
        }
        &'tinymist;help;task;preview'= {
        }
        &'tinymist;help;cov'= {
        }
        &'tinymist;help;test'= {
        }
        &'tinymist;help;help'= {
        }
    ]
    $completions[$command]
}
