module completions {

  # An integrated language service for Typst.
  export extern tinymist [
    --help(-h)                # Print help
    --version(-V)             # Print version
  ]

  # Probe existence (Nop run)
  export extern "tinymist probe" [
    --help(-h)                # Print help
  ]

  # Run language server
  export extern "tinymist lsp" [
    --mirror: string          # Mirror the stdin to the file
    --replay: string          # Replay input from the file
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --help(-h)                # Print help (see more with '--help')
  ]

  # Run debug adapter
  export extern "tinymist dap" [
    --mirror: string          # Mirror the stdin to the file
    --replay: string          # Replay input from the file
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --help(-h)                # Print help (see more with '--help')
  ]

  def "nu-complete tinymist trace-lsp standard" [] {
    [ "1.4" "1.5" "1.6" "1.7" "2.0" "a-1b" "a-1a" "a-2b" "a-2u" "a-2a" "a-3b" "a-3u" "a-3a" "a-4" "a-4f" "a-4e" "ua-1" ]
  }

  def "nu-complete tinymist trace-lsp features" [] {
    [ "html" "a11y-extras" ]
  }

  # Run language server for tracing some typst program
  export extern "tinymist trace-lsp" [
    --persist
    --rpc-kind: string
    --mirror: string          # Mirror the stdin to the file
    --replay: string          # Replay input from the file
    --root: path              # Configure the project root (for absolute paths)
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --pdf-standard: string@"nu-complete tinymist trace-lsp standard" # Specify the PDF standards that Typst will enforce conformance with
    --no-pdf-tags             # By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF
    --ppi: string             # Specify the PPI (pixels per inch) to use for PNG export
    --features: string@"nu-complete tinymist trace-lsp features" # Enable in-development features that may be changed or removed at any time
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --creation-timestamp: string # Configure the document's creation date formatted as a UNIX timestamp (in seconds)
    --cert: path              # Specify the path to CA certificate file for network access, especially for downloading typst packages
    --help(-h)                # Print help (see more with '--help')
    input?: string            # Specify the path to input Typst file. If the path is relative, it will be resolved relative to the current working directory (PWD)
  ]

  # Run language query
  export extern "tinymist query" [
    --help(-h)                # Print help
  ]

  def "nu-complete tinymist query lsif standard" [] {
    [ "1.4" "1.5" "1.6" "1.7" "2.0" "a-1b" "a-1a" "a-2b" "a-2u" "a-2a" "a-3b" "a-3u" "a-3a" "a-4" "a-4f" "a-4e" "ua-1" ]
  }

  def "nu-complete tinymist query lsif features" [] {
    [ "html" "a11y-extras" ]
  }

  # Get the lsif for a specific package
  export extern "tinymist query lsif" [
    --root: path              # Configure the project root (for absolute paths)
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --pdf-standard: string@"nu-complete tinymist query lsif standard" # Specify the PDF standards that Typst will enforce conformance with
    --no-pdf-tags             # By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF
    --ppi: string             # Specify the PPI (pixels per inch) to use for PNG export
    --features: string@"nu-complete tinymist query lsif features" # Enable in-development features that may be changed or removed at any time
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --creation-timestamp: string # Configure the document's creation date formatted as a UNIX timestamp (in seconds)
    --cert: path              # Specify the path to CA certificate file for network access, especially for downloading typst packages
    --path: string            # The path of the package to request lsif for
    --id: string              # The package of the package to request lsif for
    --output(-o): string      # The output path for the requested lsif
    --help(-h)                # Print help (see more with '--help')
    input?: string            # Specify the path to input Typst file. If the path is relative, it will be resolved relative to the current working directory (PWD)
  ]

  def "nu-complete tinymist query packageDocs standard" [] {
    [ "1.4" "1.5" "1.6" "1.7" "2.0" "a-1b" "a-1a" "a-2b" "a-2u" "a-2a" "a-3b" "a-3u" "a-3a" "a-4" "a-4f" "a-4e" "ua-1" ]
  }

  def "nu-complete tinymist query packageDocs features" [] {
    [ "html" "a11y-extras" ]
  }

  # Get the documentation for a specific package
  export extern "tinymist query packageDocs" [
    --root: path              # Configure the project root (for absolute paths)
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --pdf-standard: string@"nu-complete tinymist query packageDocs standard" # Specify the PDF standards that Typst will enforce conformance with
    --no-pdf-tags             # By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF
    --ppi: string             # Specify the PPI (pixels per inch) to use for PNG export
    --features: string@"nu-complete tinymist query packageDocs features" # Enable in-development features that may be changed or removed at any time
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --creation-timestamp: string # Configure the document's creation date formatted as a UNIX timestamp (in seconds)
    --cert: path              # Specify the path to CA certificate file for network access, especially for downloading typst packages
    --path: string            # The path of the package to request docs for
    --id: string              # The package of the package to request docs for
    --output(-o): string      # The output path for the requested docs
    --help(-h)                # Print help (see more with '--help')
    input?: string            # Specify the path to input Typst file. If the path is relative, it will be resolved relative to the current working directory (PWD)
  ]

  def "nu-complete tinymist query checkPackage standard" [] {
    [ "1.4" "1.5" "1.6" "1.7" "2.0" "a-1b" "a-1a" "a-2b" "a-2u" "a-2a" "a-3b" "a-3u" "a-3a" "a-4" "a-4f" "a-4e" "ua-1" ]
  }

  def "nu-complete tinymist query checkPackage features" [] {
    [ "html" "a11y-extras" ]
  }

  # Check a specific package
  export extern "tinymist query checkPackage" [
    --root: path              # Configure the project root (for absolute paths)
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --pdf-standard: string@"nu-complete tinymist query checkPackage standard" # Specify the PDF standards that Typst will enforce conformance with
    --no-pdf-tags             # By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF
    --ppi: string             # Specify the PPI (pixels per inch) to use for PNG export
    --features: string@"nu-complete tinymist query checkPackage features" # Enable in-development features that may be changed or removed at any time
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --creation-timestamp: string # Configure the document's creation date formatted as a UNIX timestamp (in seconds)
    --cert: path              # Specify the path to CA certificate file for network access, especially for downloading typst packages
    --path: string            # The path of the package to request docs for
    --id: string              # The package of the package to request docs for
    --output(-o): string      # The output path for the requested docs
    --help(-h)                # Print help (see more with '--help')
    input?: string            # Specify the path to input Typst file. If the path is relative, it will be resolved relative to the current working directory (PWD)
  ]

  # Print this message or the help of the given subcommand(s)
  export extern "tinymist query help" [
  ]

  # Get the lsif for a specific package
  export extern "tinymist query help lsif" [
  ]

  # Get the documentation for a specific package
  export extern "tinymist query help packageDocs" [
  ]

  # Check a specific package
  export extern "tinymist query help checkPackage" [
  ]

  # Print this message or the help of the given subcommand(s)
  export extern "tinymist query help help" [
  ]

  def "nu-complete tinymist preview preview_mode" [] {
    [ "document" "slide" ]
  }

  def "nu-complete tinymist preview enable_partial_rendering" [] {
    [ "true" "false" ]
  }

  def "nu-complete tinymist preview refresh_style" [] {
    [ "on-save" "on-type" ]
  }

  def "nu-complete tinymist preview standard" [] {
    [ "1.4" "1.5" "1.6" "1.7" "2.0" "a-1b" "a-1a" "a-2b" "a-2u" "a-2a" "a-3b" "a-3u" "a-3a" "a-4" "a-4f" "a-4e" "ua-1" ]
  }

  def "nu-complete tinymist preview features" [] {
    [ "html" "a11y-extras" ]
  }

  # Run preview server
  export extern "tinymist preview" [
    --preview-mode: string@"nu-complete tinymist preview preview_mode" # Configure the preview mode
    --partial-rendering: string@"nu-complete tinymist preview enable_partial_rendering" # Only render visible part of the document
    --invert-colors: string   # Configure the way to invert colors of the preview
    --refresh-style: string@"nu-complete tinymist preview refresh_style" # Used by lsp for controlling the preview refresh style
    --root: path              # Configure the project root (for absolute paths)
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --pdf-standard: string@"nu-complete tinymist preview standard" # Specify the PDF standards that Typst will enforce conformance with
    --no-pdf-tags             # By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF
    --ppi: string             # Specify the PPI (pixels per inch) to use for PNG export
    --features: string@"nu-complete tinymist preview features" # Enable in-development features that may be changed or removed at any time
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --creation-timestamp: string # Configure the document's creation date formatted as a UNIX timestamp (in seconds)
    --cert: path              # Specify the path to CA certificate file for network access, especially for downloading typst packages
    --task-id: string         # Used by lsp for identifying the task
    --data-plane-host: string # Configure the data plane server address
    --control-plane-host: string # Configure the control plane server address
    --host: string            # (Deprecated) Configure (File) Host address for the preview server
    --not-primary             # Let it not be the primary instance
    --open                    # Open the preview in the browser after compilation. If `--no-open` is set, this flag will be ignored
    --no-open                 # Don't open the preview in the browser after compilation. If `--open` is set as well, this flag will win
    --help(-h)                # Print help (see more with '--help')
    input?: string            # Specify the path to input Typst file. If the path is relative, it will be resolved relative to the current working directory (PWD)
  ]

  def "nu-complete tinymist compile when" [] {
    [ "never" "onSave" "onType" "onDocumentHasTitle" "script" ]
  }

  def "nu-complete tinymist compile format" [] {
    [ "pdf" "png" "svg" "html" ]
  }

  def "nu-complete tinymist compile standard" [] {
    [ "1.4" "1.5" "1.6" "1.7" "2.0" "a-1b" "a-1a" "a-2b" "a-2u" "a-2a" "a-3b" "a-3u" "a-3a" "a-4" "a-4f" "a-4e" "ua-1" ]
  }

  # Run compile command like `typst-cli compile`
  export extern "tinymist compile" [
    --name: string            # Give a task name to the document
    --root: string            # Configure the project root (for absolute paths). If the path is relative, it will be resolved relative to the current working directory (PWD)
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --when: string@"nu-complete tinymist compile when" # Configure when to run the task
    --format(-f): string@"nu-complete tinymist compile format" # Specify the format of the output file, inferred from the extension by default
    --pages: string           # Specify which pages to export. When unspecified, all pages are exported
    --pdf-standard: string@"nu-complete tinymist compile standard" # Specify the PDF standards that Typst will enforce conformance with
    --no-pdf-tags             # By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF
    --ppi: string             # Specify the PPI (pixels per inch) to use for PNG export
    --save-lock               # Save the compilation arguments to the lock file. If `--lockfile` is not set, the lock file will be saved in the cwd
    --lockfile: path          # Specify the path to the lock file. If the path is set, the lockfile will be saved (--save-lock)
    --help(-h)                # Print help (see more with '--help')
    input: path               # Specify the path to input Typst file
    output?: path             # Provide the path to output file (PDF, PNG, SVG, or HTML). Use `-` to write output to stdout
  ]

  def "nu-complete tinymist completion shell" [] {
    [ "bash" "elvish" "fig" "fish" "powershell" "zsh" "nushell" ]
  }

  # Generate completion script to stdout
  export extern "tinymist completion" [
    --help(-h)                # Print help
    shell?: string@"nu-complete tinymist completion shell" # The shell to generate the completion script for. If not provided, it will be inferred from the environment
  ]

  def "nu-complete tinymist generate-script shell" [] {
    [ "bash" "elvish" "fig" "fish" "powershell" "zsh" "nushell" ]
  }

  # Generate build script for compilation
  export extern "tinymist generate-script" [
    --output(-o): string      # The path to the output script
    --help(-h)                # Print help
    shell?: string@"nu-complete tinymist generate-script shell" # The shell to generate the completion script for. If not provided, it will be inferred from the environment
  ]

  # Run documents
  export extern "tinymist doc" [
    --help(-h)                # Print help
  ]

  # Declare a document (project input)
  export extern "tinymist doc new" [
    --name: string            # Give a task name to the document
    --root: string            # Configure the project root (for absolute paths). If the path is relative, it will be resolved relative to the current working directory (PWD)
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --help(-h)                # Print help (see more with '--help')
    input: path               # Specify the path to input Typst file
  ]

  # Configure document priority in workspace
  export extern "tinymist doc configure" [
    --name: string            # Give a task name to the document
    --priority: string        # Set the unsigned priority of these task (lower numbers are higher priority)
    --help(-h)                # Print help
    input: path               # Specify the path to input Typst file
  ]

  # Print this message or the help of the given subcommand(s)
  export extern "tinymist doc help" [
  ]

  # Declare a document (project input)
  export extern "tinymist doc help new" [
  ]

  # Configure document priority in workspace
  export extern "tinymist doc help configure" [
  ]

  # Print this message or the help of the given subcommand(s)
  export extern "tinymist doc help help" [
  ]

  # Run tasks
  export extern "tinymist task" [
    --help(-h)                # Print help
  ]

  def "nu-complete tinymist task preview when" [] {
    [ "never" "onSave" "onType" "onDocumentHasTitle" "script" ]
  }

  def "nu-complete tinymist task preview preview_mode" [] {
    [ "document" "slide" ]
  }

  def "nu-complete tinymist task preview enable_partial_rendering" [] {
    [ "true" "false" ]
  }

  def "nu-complete tinymist task preview refresh_style" [] {
    [ "on-save" "on-type" ]
  }

  # Declare a preview task
  export extern "tinymist task preview" [
    --name: string            # Give a task name to the document
    --root: string            # Configure the project root (for absolute paths). If the path is relative, it will be resolved relative to the current working directory (PWD)
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --task: string            # Name a task
    --when: string@"nu-complete tinymist task preview when" # When to run the task
    --preview-mode: string@"nu-complete tinymist task preview preview_mode" # Configure the preview mode
    --partial-rendering: string@"nu-complete tinymist task preview enable_partial_rendering" # Only render visible part of the document
    --invert-colors: string   # Configure the way to invert colors of the preview
    --refresh-style: string@"nu-complete tinymist task preview refresh_style" # Used by lsp for controlling the preview refresh style
    --help(-h)                # Print help (see more with '--help')
    input: path               # Specify the path to input Typst file
  ]

  # Print this message or the help of the given subcommand(s)
  export extern "tinymist task help" [
  ]

  # Declare a preview task
  export extern "tinymist task help preview" [
  ]

  # Print this message or the help of the given subcommand(s)
  export extern "tinymist task help help" [
  ]

  def "nu-complete tinymist cov standard" [] {
    [ "1.4" "1.5" "1.6" "1.7" "2.0" "a-1b" "a-1a" "a-2b" "a-2u" "a-2a" "a-3b" "a-3u" "a-3a" "a-4" "a-4f" "a-4e" "ua-1" ]
  }

  def "nu-complete tinymist cov features" [] {
    [ "html" "a11y-extras" ]
  }

  # Execute a document and collect coverage
  export extern "tinymist cov" [
    --root: path              # Configure the project root (for absolute paths)
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --pdf-standard: string@"nu-complete tinymist cov standard" # Specify the PDF standards that Typst will enforce conformance with
    --no-pdf-tags             # By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF
    --ppi: string             # Specify the PPI (pixels per inch) to use for PNG export
    --features: string@"nu-complete tinymist cov features" # Enable in-development features that may be changed or removed at any time
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --creation-timestamp: string # Configure the document's creation date formatted as a UNIX timestamp (in seconds)
    --cert: path              # Specify the path to CA certificate file for network access, especially for downloading typst packages
    --help(-h)                # Print help (see more with '--help')
    input?: string            # Specify the path to input Typst file. If the path is relative, it will be resolved relative to the current working directory (PWD)
  ]

  def "nu-complete tinymist test standard" [] {
    [ "1.4" "1.5" "1.6" "1.7" "2.0" "a-1b" "a-1a" "a-2b" "a-2u" "a-2a" "a-3b" "a-3u" "a-3a" "a-4" "a-4f" "a-4e" "ua-1" ]
  }

  def "nu-complete tinymist test features" [] {
    [ "html" "a11y-extras" ]
  }

  def "nu-complete tinymist test print_coverage" [] {
    [ "never" "short" "full" ]
  }

  # Test a document and give summary
  export extern "tinymist test" [
    --root: path              # Configure the project root (for absolute paths)
    --font-path: path         # Add additional directories that are recursively searched for fonts
    --ignore-system-fonts     # Ensure system fonts won't be searched, unless explicitly included via `--font-path`
    --package-path: path      # Specify a custom path to local packages, defaults to system-dependent location
    --package-cache-path: path # Specify a custom path to package cache, defaults to system-dependent location
    --pdf-standard: string@"nu-complete tinymist test standard" # Specify the PDF standards that Typst will enforce conformance with
    --no-pdf-tags             # By default, even when not producing a `PDF/UA-1` document, a tagged PDF document is written to provide a baseline of accessibility. In some circumstances (for example when trying to reduce the size of a document) it can be desirable to disable tagged PDF
    --ppi: string             # Specify the PPI (pixels per inch) to use for PNG export
    --features: string@"nu-complete tinymist test features" # Enable in-development features that may be changed or removed at any time
    --input: string           # Add a string key-value pair visible through `sys.inputs`
    --creation-timestamp: string # Configure the document's creation date formatted as a UNIX timestamp (in seconds)
    --cert: path              # Specify the path to CA certificate file for network access, especially for downloading typst packages
    --update                  # Whether to update the reference images
    --coverage                # Whether to collect coverage
    --print-coverage: string@"nu-complete tinymist test print_coverage" # Style of printing coverage
    --watch                   # Whether to run in watch mode
    --dashboard               # Whether to render the dashboard
    --no-dashboard            # Whether not to render the dashboard
    --verbose                 # Whether to log verbose information
    --help(-h)                # Print help (see more with '--help')
    input?: string            # Specify the path to input Typst file. If the path is relative, it will be resolved relative to the current working directory (PWD)
  ]

  # Print this message or the help of the given subcommand(s)
  export extern "tinymist help" [
  ]

  # Probe existence (Nop run)
  export extern "tinymist help probe" [
  ]

  # Run language server
  export extern "tinymist help lsp" [
  ]

  # Run debug adapter
  export extern "tinymist help dap" [
  ]

  # Run language server for tracing some typst program
  export extern "tinymist help trace-lsp" [
  ]

  # Run language query
  export extern "tinymist help query" [
  ]

  # Get the lsif for a specific package
  export extern "tinymist help query lsif" [
  ]

  # Get the documentation for a specific package
  export extern "tinymist help query packageDocs" [
  ]

  # Check a specific package
  export extern "tinymist help query checkPackage" [
  ]

  # Run preview server
  export extern "tinymist help preview" [
  ]

  # Run compile command like `typst-cli compile`
  export extern "tinymist help compile" [
  ]

  # Generate completion script to stdout
  export extern "tinymist help completion" [
  ]

  # Generate build script for compilation
  export extern "tinymist help generate-script" [
  ]

  # Run documents
  export extern "tinymist help doc" [
  ]

  # Declare a document (project input)
  export extern "tinymist help doc new" [
  ]

  # Configure document priority in workspace
  export extern "tinymist help doc configure" [
  ]

  # Run tasks
  export extern "tinymist help task" [
  ]

  # Declare a preview task
  export extern "tinymist help task preview" [
  ]

  # Execute a document and collect coverage
  export extern "tinymist help cov" [
  ]

  # Test a document and give summary
  export extern "tinymist help test" [
  ]

  # Print this message or the help of the given subcommand(s)
  export extern "tinymist help help" [
  ]

}

export use completions *
